"use strict";
// Encode SVG PathData
// http://www.w3.org/TR/SVG/paths.html#PathDataBNF
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var stream_1 = require("stream");
var SVGPathData_1 = require("./SVGPathData");
// Private consts : Char groups
var WSP = " ";
var SVGPathDataEncoder = (function (_super) {
    __extends(SVGPathDataEncoder, _super);
    function SVGPathDataEncoder() {
        return _super.call(this, { objectMode: true, writableObjectMode: true, readableObjectMode: false }) || this;
    }
    // Read method
    SVGPathDataEncoder.prototype._transform = function (commands, encoding, done) {
        var str = "";
        var i;
        var j;
        if (!Array.isArray(commands)) {
            commands = [commands];
        }
        for (i = 0, j = commands.length; i < j; i++) {
            var command = commands[i];
            if (command.type === SVGPathData_1.SVGPathData.CLOSE_PATH) {
                str += "z";
            }
            else if (command.type === SVGPathData_1.SVGPathData.HORIZ_LINE_TO) {
                str += (command.relative ? "h" : "H") +
                    command.x;
            }
            else if (command.type === SVGPathData_1.SVGPathData.VERT_LINE_TO) {
                str += (command.relative ? "v" : "V") +
                    command.y;
            }
            else if (command.type === SVGPathData_1.SVGPathData.MOVE_TO) {
                str += (command.relative ? "m" : "M") +
                    command.x + WSP + command.y;
            }
            else if (command.type === SVGPathData_1.SVGPathData.LINE_TO) {
                str += (command.relative ? "l" : "L") +
                    command.x + WSP + command.y;
            }
            else if (command.type === SVGPathData_1.SVGPathData.CURVE_TO) {
                str += (command.relative ? "c" : "C") +
                    command.x1 + WSP + command.y1 +
                    WSP + command.x2 + WSP + command.y2 +
                    WSP + command.x + WSP + command.y;
            }
            else if (command.type === SVGPathData_1.SVGPathData.SMOOTH_CURVE_TO) {
                str += (command.relative ? "s" : "S") +
                    command.x2 + WSP + command.y2 +
                    WSP + command.x + WSP + command.y;
            }
            else if (command.type === SVGPathData_1.SVGPathData.QUAD_TO) {
                str += (command.relative ? "q" : "Q") +
                    command.x1 + WSP + command.y1 +
                    WSP + command.x + WSP + command.y;
            }
            else if (command.type === SVGPathData_1.SVGPathData.SMOOTH_QUAD_TO) {
                str += (command.relative ? "t" : "T") +
                    command.x + WSP + command.y;
            }
            else if (command.type === SVGPathData_1.SVGPathData.ARC) {
                str += (command.relative ? "a" : "A") +
                    command.rX + WSP + command.rY +
                    WSP + command.xRot +
                    WSP + (+command.lArcFlag) + WSP + (+command.sweepFlag) +
                    WSP + command.x + WSP + command.y;
            }
            else {
                // Unknown command
                this.emit("error", new Error("Unexpected command type \"" + command.type + "\" at index " + i + "."));
            }
        }
        this.push(new Buffer(str, "utf8"));
        done();
    };
    return SVGPathDataEncoder;
}(stream_1.Transform));
exports.SVGPathDataEncoder = SVGPathDataEncoder;
//# sourceMappingURL=SVGPathDataEncoder.js.map