/**
 * Copyright (c) 2017-present, Wonday (@wonday.org)
 * All rights reserved.
 *
 * This source code is licensed under the MIT-style license found in the
 * LICENSE file in the root directory of this source tree.
 */

#if __has_include(<React/RCTAssert.h>)
#import <React/RCTEventDispatcher.h>
#import <React/UIView+React.h>
#else
#import "RCTEventDispatcher.h"
#import "UIView+React.h"
#endif


@class RCTEventDispatcher;

@interface WPdfView : UIView

@property(nonatomic, strong) NSString *path;
@property(nonatomic) int page;
@property(nonatomic) BOOL horizontal;
@property(nonatomic) BOOL fitWidth;
@property(nonatomic) int spacing;
@property(nonatomic, strong) NSString *password;


@property(nonatomic, copy) RCTBubblingEventBlock onChange;

- (void)loadPdf;
- (void)updateBounds;
- (void)scrollViewWillBeginDragging:(UIScrollView *)scrollView;
- (void)scrollViewWillEndDragging:(CGPoint)velocity targetContentOffset:(inout CGPoint *)targetContentOffset;
- (void)scrollViewDidScroll:(UIScrollView *)scrollView;
- (void)scrollViewDidEndDecelerating:(UIScrollView *)scrollView;

@end
