"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = y[op[0] & 2 ? "return" : op[0] ? "throw" : "next"]) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [0, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var debug = require('debug')('environment');
require("isomorphic-fetch");
var jwt = require("jsonwebtoken");
var constants_1 = require("./constants");
var graphql_request_1 = require("graphql-request");
var chalk_1 = require("chalk");
var getProxyAgent_1 = require("./utils/getProxyAgent");
var Cluster = /** @class */ (function () {
    function Cluster(out, name, baseUrl, clusterSecret, local, shared, isPrivate, workspaceSlug) {
        if (local === void 0) { local = true; }
        if (shared === void 0) { shared = false; }
        if (isPrivate === void 0) { isPrivate = false; }
        this.out = out;
        this.name = name;
        // All `baseUrl` extension points in this class
        // adds a trailing slash. Here we remove it from
        // the passed `baseUrl` in order to avoid double
        // slashes.
        this.baseUrl = baseUrl.replace(/\/$/, '');
        this.clusterSecret = clusterSecret;
        this.local = local;
        this.shared = shared;
        this.isPrivate = isPrivate;
        this.workspaceSlug = workspaceSlug;
        this.hasOldDeployEndpoint = false;
    }
    Cluster.prototype.getToken = function (serviceName, workspaceSlug, stageName) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                // public clusters just take the token
                if (this.name === 'shared-public-demo') {
                    return [2 /*return*/, ''];
                }
                if (this.shared || this.isPrivate) {
                    return [2 /*return*/, this.generateClusterToken(serviceName, workspaceSlug, stageName)];
                }
                else {
                    return [2 /*return*/, this.getLocalToken()];
                }
                return [2 /*return*/];
            });
        });
    };
    Cluster.prototype.getLocalToken = function () {
        if (!this.clusterSecret && !process.env.PRISMA_MANAGEMENT_API_SECRET) {
            return null;
        }
        if (!this.cachedToken) {
            var grants = [{ target: "*/*", action: '*' }];
            var secret = process.env.PRISMA_MANAGEMENT_API_SECRET || this.clusterSecret;
            try {
                var algorithm = process.env.PRISMA_MANAGEMENT_API_SECRET
                    ? 'HS256'
                    : 'RS256';
                this.cachedToken = jwt.sign({ grants: grants }, secret, {
                    expiresIn: '5y',
                    algorithm: algorithm,
                });
            }
            catch (e) {
                throw new Error("Could not generate token for cluster " + chalk_1.default.bold(this.getDeployEndpoint()) + ". Did you provide the env var PRISMA_MANAGEMENT_API_SECRET?\nOriginal error: " + e.message);
            }
        }
        return this.cachedToken;
    };
    Object.defineProperty(Cluster.prototype, "cloudClient", {
        get: function () {
            return new graphql_request_1.GraphQLClient(constants_1.cloudApiEndpoint, {
                headers: {
                    Authorization: "Bearer " + this.clusterSecret,
                },
                agent: getProxyAgent_1.getProxyAgent(constants_1.cloudApiEndpoint),
            });
        },
        enumerable: true,
        configurable: true
    });
    Cluster.prototype.generateClusterToken = function (serviceName, workspaceSlug, stageName) {
        if (workspaceSlug === void 0) { workspaceSlug = this.workspaceSlug || '*'; }
        return __awaiter(this, void 0, void 0, function () {
            var query, clusterToken;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        query = "\n      mutation ($input: GenerateClusterTokenRequest!) {\n        generateClusterToken(input: $input) {\n          clusterToken\n        }\n      }\n    ";
                        return [4 /*yield*/, this.cloudClient.request(query, {
                                input: {
                                    workspaceSlug: workspaceSlug,
                                    clusterName: this.name,
                                    serviceName: serviceName,
                                    stageName: stageName,
                                },
                            })];
                    case 1:
                        clusterToken = (_a.sent()).generateClusterToken.clusterToken;
                        return [2 /*return*/, clusterToken];
                }
            });
        });
    };
    Cluster.prototype.getApiEndpoint = function (service, stage, workspaceSlug) {
        if (!this.shared && service === 'default' && stage === 'default') {
            return this.baseUrl;
        }
        if (!this.shared && stage === 'default') {
            return this.baseUrl + "/" + service;
        }
        if (this.isPrivate || this.local) {
            return this.baseUrl + "/" + service + "/" + stage;
        }
        var workspaceString = workspaceSlug ? workspaceSlug + "/" : '';
        return this.baseUrl + "/" + workspaceString + service + "/" + stage;
    };
    Cluster.prototype.getWSEndpoint = function (service, stage, workspaceSlug) {
        return this.getApiEndpoint(service, stage, workspaceSlug).replace(/^http/, 'ws');
    };
    Cluster.prototype.getImportEndpoint = function (service, stage, workspaceSlug) {
        return this.getApiEndpoint(service, stage, workspaceSlug) + "/import";
    };
    Cluster.prototype.getExportEndpoint = function (service, stage, workspaceSlug) {
        return this.getApiEndpoint(service, stage, workspaceSlug) + "/export";
    };
    Cluster.prototype.getDeployEndpoint = function () {
        return this.baseUrl + "/" + (this.hasOldDeployEndpoint ? 'cluster' : 'management');
    };
    Cluster.prototype.isOnline = function () {
        return __awaiter(this, void 0, void 0, function () {
            var version;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.getVersion()];
                    case 1:
                        version = _a.sent();
                        return [2 /*return*/, Boolean(version)];
                }
            });
        });
    };
    Cluster.prototype.getVersion = function () {
        return __awaiter(this, void 0, void 0, function () {
            var result, res, data, errors, e_1, result, res, data, errors, e_2;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        _a.trys.push([0, 3, , 4]);
                        return [4 /*yield*/, this.request("{\n        serverInfo {\n          version\n        }\n      }")];
                    case 1:
                        result = _a.sent();
                        return [4 /*yield*/, result.json()];
                    case 2:
                        res = _a.sent();
                        data = res.data, errors = res.errors;
                        if (errors &&
                            errors[0].code === 3016 &&
                            errors[0].message.includes('management@default')) {
                            this.hasOldDeployEndpoint = true;
                            return [2 /*return*/, this.getVersion()];
                        }
                        if (data && data.serverInfo) {
                            return [2 /*return*/, data.serverInfo.version];
                        }
                        return [3 /*break*/, 4];
                    case 3:
                        e_1 = _a.sent();
                        debug(e_1);
                        return [3 /*break*/, 4];
                    case 4:
                        _a.trys.push([4, 7, , 8]);
                        return [4 /*yield*/, this.request("{\n        clusterInfo {\n          version\n        }\n      }")];
                    case 5:
                        result = _a.sent();
                        return [4 /*yield*/, result.json()];
                    case 6:
                        res = _a.sent();
                        data = res.data, errors = res.errors;
                        return [2 /*return*/, data.clusterInfo.version];
                    case 7:
                        e_2 = _a.sent();
                        debug(e_2);
                        return [3 /*break*/, 8];
                    case 8: return [2 /*return*/, null];
                }
            });
        });
    };
    Cluster.prototype.request = function (query) {
        return fetch(this.getDeployEndpoint(), {
            method: 'post',
            headers: {
                'Content-Type': 'application/json',
            },
            body: JSON.stringify({
                query: query,
            }),
            agent: getProxyAgent_1.getProxyAgent(this.getDeployEndpoint()),
        });
    };
    Cluster.prototype.needsAuth = function () {
        return __awaiter(this, void 0, void 0, function () {
            var result, e_3;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        _a.trys.push([0, 2, , 3]);
                        return [4 /*yield*/, this.request("{\n        listProjects {\n          name\n        }\n      }")];
                    case 1:
                        result = _a.sent();
                        return [2 /*return*/, true];
                    case 2:
                        e_3 = _a.sent();
                        return [2 /*return*/, false];
                    case 3: return [2 /*return*/];
                }
            });
        });
    };
    Cluster.prototype.toJSON = function () {
        return {
            name: this.name,
            baseUrl: this.baseUrl,
            local: this.local,
            clusterSecret: this.clusterSecret,
            shared: this.shared,
            isPrivate: this.isPrivate,
            workspaceSlug: this.workspaceSlug,
        };
    };
    return Cluster;
}());
exports.Cluster = Cluster;
//# sourceMappingURL=Cluster.js.map