"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = y[op[0] & 2 ? "return" : op[0] ? "throw" : "next"]) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [0, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var _this = this;
Object.defineProperty(exports, "__esModule", { value: true });
var Introspector_1 = require("../../Introspector");
var pg_1 = require("pg");
var connectionDetails_1 = require("./connectionDetails");
function introspect() {
    return new Introspector_1.Introspector(connectionDetails_1.connectionDetails).introspect('DatabaseIntrospector');
}
function testSchema(sql) {
    return __awaiter(this, void 0, void 0, function () {
        var client, _a;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0:
                    client = new pg_1.Client(connectionDetails_1.connectionDetails);
                    return [4 /*yield*/, client.connect()];
                case 1:
                    _b.sent();
                    return [4 /*yield*/, client.query('DROP SCHEMA IF EXISTS DatabaseIntrospector cascade;')];
                case 2:
                    _b.sent();
                    return [4 /*yield*/, client.query('CREATE SCHEMA DatabaseIntrospector;')];
                case 3:
                    _b.sent();
                    return [4 /*yield*/, client.query('SET search_path TO DatabaseIntrospector;')];
                case 4:
                    _b.sent();
                    return [4 /*yield*/, client.query(sql)];
                case 5:
                    _b.sent();
                    _a = expect;
                    return [4 /*yield*/, introspect()];
                case 6:
                    _a.apply(void 0, [_b.sent()]).toMatchSnapshot();
                    return [4 /*yield*/, client.end()];
                case 7:
                    _b.sent();
                    return [2 /*return*/];
            }
        });
    });
}
describe('Introspector', function () {
    test('text columns', function () { return __awaiter(_this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, testSchema("CREATE TABLE \"Strings\" (\n      \"pk\" varchar(55) NOT NULL PRIMARY KEY,\n      \"a\" char(1) DEFAULT NULL UNIQUE,\n      \"aa\" char(1) NOT NULL UNIQUE,\n      \"b\" varchar(255) DEFAULT NULL,\n      \"c\" text DEFAULT 'abc',\n      \"cc\" text DEFAULT 'abc' NOT NULL,\n      \"d\" char(1) NOT NULL,\n      \"e\" varchar(255) NOT NULL,\n      \"f\" text NOT NULL,\n      \"g\" uuid DEFAULT NULL,\n      \"h\" uuid NOT NULL,\n      constraint foo unique(b)\n      );")];
                case 1:
                    _a.sent();
                    return [2 /*return*/];
            }
        });
    }); });
    test('int columns', function () { return __awaiter(_this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, testSchema("CREATE TABLE \"Ints\" (\n      \"a\" smallint DEFAULT 3,\n      \"b\" integer DEFAULT NULL,\n      \"c\" bigint DEFAULT NULL,\n      \"d\" smallint NOT NULL,\n      \"e\" integer NOT NULL,\n      \"f\" bigint NOT NULL\n      );")];
                case 1:
                    _a.sent();
                    return [2 /*return*/];
            }
        });
    }); });
    test('float columns', function () { return __awaiter(_this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, testSchema("CREATE TABLE \"Floats\" (\n      \"a\" real DEFAULT 3.4,\n      \"b\" double precision DEFAULT NULL,\n      \"c\" float4 DEFAULT NULL,\n      \"d\" float8 DEFAULT NULL,\n      \"e\" real NOT NULL,\n      \"f\" double precision NOT NULL,\n      \"g\" float4 NOT NULL,\n      \"h\" float8 NOT NULL,\n      \"i\" numeric DEFAULT NULL,\n      \"j\" numeric NOT NULL\n      );")];
                case 1:
                    _a.sent();
                    return [2 /*return*/];
            }
        });
    }); });
    test('boolean columns', function () { return __awaiter(_this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, testSchema("CREATE TABLE \"Booleans\" (\n      \"a\" boolean DEFAULT NULL,\n      \"b\" boolean NOT NULL\n      );")];
                case 1:
                    _a.sent();
                    return [2 /*return*/];
            }
        });
    }); });
    test('DateTime columns', function () { return __awaiter(_this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, testSchema("CREATE TABLE \"Booleans\" (\n      \"a\" timestamp DEFAULT NULL,\n      \"b\" timestamp NOT NULL,\n      \"c\" timestamp NOT NULL DEFAULT now()\n      );")];
                case 1:
                    _a.sent();
                    return [2 /*return*/];
            }
        });
    }); });
    test('Json columns', function () { return __awaiter(_this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, testSchema("CREATE TABLE \"Booleans\" (\n      \"a\" json DEFAULT NULL,\n      \"b\" json NOT NULL\n      );")];
                case 1:
                    _a.sent();
                    return [2 /*return*/];
            }
        });
    }); });
    test('Unmapped columns', function () { return __awaiter(_this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, testSchema("CREATE TABLE \"Unmapped\" (\n      \"a\" jsonb,\n      \"c\" tsvector,\n      \"d\" date[]\n      );")];
                case 1:
                    _a.sent();
                    return [2 /*return*/];
            }
        });
    }); });
});
//# sourceMappingURL=scalars.test.js.map