"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = y[op[0] & 2 ? "return" : op[0] ? "throw" : "next"]) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [0, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var _this = this;
Object.defineProperty(exports, "__esModule", { value: true });
var Introspector_1 = require("../../Introspector");
var pg_1 = require("pg");
var connectionDetails_1 = require("./connectionDetails");
function introspect() {
    return new Introspector_1.Introspector(connectionDetails_1.connectionDetails).introspect('DatabaseIntrospector');
}
function testSchema(sql) {
    return __awaiter(this, void 0, void 0, function () {
        var client, _a;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0:
                    client = new pg_1.Client(connectionDetails_1.connectionDetails);
                    return [4 /*yield*/, client.connect()];
                case 1:
                    _b.sent();
                    return [4 /*yield*/, client.query('DROP SCHEMA IF EXISTS DatabaseIntrospector cascade;')];
                case 2:
                    _b.sent();
                    return [4 /*yield*/, client.query('CREATE SCHEMA DatabaseIntrospector;')];
                case 3:
                    _b.sent();
                    return [4 /*yield*/, client.query('SET search_path TO DatabaseIntrospector;')];
                case 4:
                    _b.sent();
                    return [4 /*yield*/, client.query(sql)];
                case 5:
                    _b.sent();
                    _a = expect;
                    return [4 /*yield*/, introspect()];
                case 6:
                    _a.apply(void 0, [_b.sent()]).toMatchSnapshot();
                    return [4 /*yield*/, client.end()];
                case 7:
                    _b.sent();
                    return [2 /*return*/];
            }
        });
    });
}
describe('Introspector', function () {
    test('large example database', function () { return __awaiter(_this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: 
                // See http://www.postgresqltutorial.com/postgresql-sample-database/
                return [4 /*yield*/, testSchema("--\n    -- NOTE:\n    --\n    -- File paths need to be edited. Search for $$PATH$$ and\n    -- replace it with the path to the directory containing\n    -- the extracted data files.\n    --\n    --\n    -- PostgreSQL database dump\n    --\n    \n    SET statement_timeout = 0;\n    SET client_encoding = 'UTF8';\n    SET standard_conforming_strings = on;\n    SET check_function_bodies = false;\n    SET client_min_messages = warning;\n    \n    \n    \n    CREATE TYPE mpaa_rating AS ENUM (\n        'G',\n        'PG',\n        'PG-13',\n        'R',\n        'NC-17'\n    );\n    \n    \n    \n    --\n    -- Name: year; Type: DOMAIN; Schema: DatabaseIntrospector; Owner: postgres\n    --\n    \n    CREATE DOMAIN year AS integer\n      CONSTRAINT year_check CHECK (((VALUE >= 1901) AND (VALUE <= 2155)));\n    \n    \n    \n    --\n    -- Name: _group_concat(text, text); Type: FUNCTION; Schema: DatabaseIntrospector; Owner: postgres\n    --\n    \n    CREATE FUNCTION _group_concat(text, text) RETURNS text\n        LANGUAGE sql IMMUTABLE\n        AS $_$\n    SELECT CASE\n      WHEN $2 IS NULL THEN $1\n      WHEN $1 IS NULL THEN $2\n      ELSE $1 || ', ' || $2\n    END\n    $_$;\n    \n    \n    \n    --\n    -- Name: film_in_stock(integer, integer); Type: FUNCTION; Schema: DatabaseIntrospector; Owner: postgres\n    --\n    \n    CREATE FUNCTION film_in_stock(p_film_id integer, p_store_id integer, OUT p_film_count integer) RETURNS SETOF integer\n        LANGUAGE sql\n        AS $_$\n         SELECT inventory_id\n         FROM inventory\n         WHERE film_id = $1\n         AND store_id = $2\n         AND inventory_in_stock(inventory_id);\n    $_$;\n    \n    \n    \n    --\n    -- Name: film_not_in_stock(integer, integer); Type: FUNCTION; Schema: DatabaseIntrospector; Owner: postgres\n    --\n    \n    CREATE FUNCTION film_not_in_stock(p_film_id integer, p_store_id integer, OUT p_film_count integer) RETURNS SETOF integer\n        LANGUAGE sql\n        AS $_$\n        SELECT inventory_id\n        FROM inventory\n        WHERE film_id = $1\n        AND store_id = $2\n        AND NOT inventory_in_stock(inventory_id);\n    $_$;\n    \n    \n    \n    --\n    -- Name: get_customer_balance(integer, timestamp without time zone); Type: FUNCTION; Schema: DatabaseIntrospector; Owner: postgres\n    --\n    \n    CREATE FUNCTION get_customer_balance(p_customer_id integer, p_effective_date timestamp without time zone) RETURNS numeric\n        LANGUAGE plpgsql\n        AS $$\n           --#OK, WE NEED TO CALCULATE THE CURRENT BALANCE GIVEN A CUSTOMER_ID AND A DATE\n           --#THAT WE WANT THE BALANCE TO BE EFFECTIVE FOR. THE BALANCE IS:\n           --#   1) RENTAL FEES FOR ALL PREVIOUS RENTALS\n           --#   2) ONE DOLLAR FOR EVERY DAY THE PREVIOUS RENTALS ARE OVERDUE\n           --#   3) IF A FILM IS MORE THAN RENTAL_DURATION * 2 OVERDUE, CHARGE THE REPLACEMENT_COST\n           --#   4) SUBTRACT ALL PAYMENTS MADE BEFORE THE DATE SPECIFIED\n    DECLARE\n        v_rentfees DECIMAL(5,2); --#FEES PAID TO RENT THE VIDEOS INITIALLY\n        v_overfees INTEGER;      --#LATE FEES FOR PRIOR RENTALS\n        v_payments DECIMAL(5,2); --#SUM OF PAYMENTS MADE PREVIOUSLY\n    BEGIN\n        SELECT COALESCE(SUM(film.rental_rate),0) INTO v_rentfees\n        FROM film, inventory, rental\n        WHERE film.film_id = inventory.film_id\n          AND inventory.inventory_id = rental.inventory_id\n          AND rental.rental_date <= p_effective_date\n          AND rental.customer_id = p_customer_id;\n    \n        SELECT COALESCE(SUM(IF((rental.return_date - rental.rental_date) > (film.rental_duration * '1 day'::interval),\n            ((rental.return_date - rental.rental_date) - (film.rental_duration * '1 day'::interval)),0)),0) INTO v_overfees\n        FROM rental, inventory, film\n        WHERE film.film_id = inventory.film_id\n          AND inventory.inventory_id = rental.inventory_id\n          AND rental.rental_date <= p_effective_date\n          AND rental.customer_id = p_customer_id;\n    \n        SELECT COALESCE(SUM(payment.amount),0) INTO v_payments\n        FROM payment\n        WHERE payment.payment_date <= p_effective_date\n        AND payment.customer_id = p_customer_id;\n    \n        RETURN v_rentfees + v_overfees - v_payments;\n    END\n    $$;\n    \n    \n    \n    --\n    -- Name: inventory_held_by_customer(integer); Type: FUNCTION; Schema: DatabaseIntrospector; Owner: postgres\n    --\n    \n    CREATE FUNCTION inventory_held_by_customer(p_inventory_id integer) RETURNS integer\n        LANGUAGE plpgsql\n        AS $$\n    DECLARE\n        v_customer_id INTEGER;\n    BEGIN\n    \n      SELECT customer_id INTO v_customer_id\n      FROM rental\n      WHERE return_date IS NULL\n      AND inventory_id = p_inventory_id;\n    \n      RETURN v_customer_id;\n    END $$;\n    \n    \n    \n    --\n    -- Name: inventory_in_stock(integer); Type: FUNCTION; Schema: DatabaseIntrospector; Owner: postgres\n    --\n    \n    CREATE FUNCTION inventory_in_stock(p_inventory_id integer) RETURNS boolean\n        LANGUAGE plpgsql\n        AS $$\n    DECLARE\n        v_rentals INTEGER;\n        v_out     INTEGER;\n    BEGIN\n        -- AN ITEM IS IN-STOCK IF THERE ARE EITHER NO ROWS IN THE rental TABLE\n        -- FOR THE ITEM OR ALL ROWS HAVE return_date POPULATED\n    \n        SELECT count(*) INTO v_rentals\n        FROM rental\n        WHERE inventory_id = p_inventory_id;\n    \n        IF v_rentals = 0 THEN\n          RETURN TRUE;\n        END IF;\n    \n        SELECT COUNT(rental_id) INTO v_out\n        FROM inventory LEFT JOIN rental USING(inventory_id)\n        WHERE inventory.inventory_id = p_inventory_id\n        AND rental.return_date IS NULL;\n    \n        IF v_out > 0 THEN\n          RETURN FALSE;\n        ELSE\n          RETURN TRUE;\n        END IF;\n    END $$;\n    \n    \n    --\n    -- Name: last_day(timestamp without time zone); Type: FUNCTION; Schema: DatabaseIntrospector; Owner: postgres\n    --\n    \n    CREATE FUNCTION last_day(timestamp without time zone) RETURNS date\n        LANGUAGE sql IMMUTABLE STRICT\n        AS $_$\n      SELECT CASE\n        WHEN EXTRACT(MONTH FROM $1) = 12 THEN\n          (((EXTRACT(YEAR FROM $1) + 1) operator(pg_catalog.||) '-01-01')::date - INTERVAL '1 day')::date\n        ELSE\n          ((EXTRACT(YEAR FROM $1) operator(pg_catalog.||) '-' operator(pg_catalog.||) (EXTRACT(MONTH FROM $1) + 1) operator(pg_catalog.||) '-01')::date - INTERVAL '1 day')::date\n        END\n    $_$;\n    \n    \n    --\n    -- Name: last_updated(); Type: FUNCTION; Schema: DatabaseIntrospector; Owner: postgres\n    --\n    \n    CREATE FUNCTION last_updated() RETURNS trigger\n        LANGUAGE plpgsql\n        AS $$\n    BEGIN\n        NEW.last_update = CURRENT_TIMESTAMP;\n        RETURN NEW;\n    END $$;\n    \n    \n    --\n    -- Name: customer_customer_id_seq; Type: SEQUENCE; Schema: DatabaseIntrospector; Owner: postgres\n    --\n    \n    CREATE SEQUENCE customer_customer_id_seq\n        START WITH 1\n        INCREMENT BY 1\n        NO MINVALUE\n        NO MAXVALUE\n        CACHE 1;\n    \n    \n    SET default_tablespace = '';\n    \n    SET default_with_oids = false;\n    \n    --\n    -- Name: customer; Type: TABLE; Schema: DatabaseIntrospector; Owner: postgres; Tablespace: \n    --\n    \n    CREATE TABLE customer (\n        customer_id integer DEFAULT nextval('customer_customer_id_seq'::regclass) NOT NULL,\n        store_id smallint NOT NULL,\n        first_name character varying(45) NOT NULL,\n        last_name character varying(45) NOT NULL,\n        email character varying(50),\n        address_id smallint NOT NULL,\n        activebool boolean DEFAULT true NOT NULL,\n        create_date date DEFAULT ('now'::text)::date NOT NULL,\n        last_update timestamp without time zone DEFAULT now(),\n        active integer\n    );\n    \n    \n    --\n    -- Name: rewards_report(integer, numeric); Type: FUNCTION; Schema: DatabaseIntrospector; Owner: postgres\n    --\n    \n    CREATE FUNCTION rewards_report(min_monthly_purchases integer, min_dollar_amount_purchased numeric) RETURNS SETOF customer\n        LANGUAGE plpgsql SECURITY DEFINER\n        AS $_$\n    DECLARE\n        last_month_start DATE;\n        last_month_end DATE;\n    rr RECORD;\n    tmpSQL TEXT;\n    BEGIN\n    \n        /* Some sanity checks... */\n        IF min_monthly_purchases = 0 THEN\n            RAISE EXCEPTION 'Minimum monthly purchases parameter must be > 0';\n        END IF;\n        IF min_dollar_amount_purchased = 0.00 THEN\n            RAISE EXCEPTION 'Minimum monthly dollar amount purchased parameter must be > $0.00';\n        END IF;\n    \n        last_month_start := CURRENT_DATE - '3 month'::interval;\n        last_month_start := to_date((extract(YEAR FROM last_month_start) || '-' || extract(MONTH FROM last_month_start) || '-01'),'YYYY-MM-DD');\n        last_month_end := LAST_DAY(last_month_start);\n    \n        /*\n        Create a temporary storage area for Customer IDs.\n        */\n        CREATE TEMPORARY TABLE tmpCustomer (customer_id INTEGER NOT NULL PRIMARY KEY);\n    \n        /*\n        Find all customers meeting the monthly purchase requirements\n        */\n    \n        tmpSQL := 'INSERT INTO tmpCustomer (customer_id)\n            SELECT p.customer_id\n            FROM payment AS p\n            WHERE DATE(p.payment_date) BETWEEN '||quote_literal(last_month_start) ||' AND '|| quote_literal(last_month_end) || '\n            GROUP BY customer_id\n            HAVING SUM(p.amount) > '|| min_dollar_amount_purchased || '\n            AND COUNT(customer_id) > ' ||min_monthly_purchases ;\n    \n        EXECUTE tmpSQL;\n    \n        /*\n        Output ALL customer information of matching rewardees.\n        Customize output as needed.\n        */\n        FOR rr IN EXECUTE 'SELECT c.* FROM tmpCustomer AS t INNER JOIN customer AS c ON t.customer_id = c.customer_id' LOOP\n            RETURN NEXT rr;\n        END LOOP;\n    \n        /* Clean up */\n        tmpSQL := 'DROP TABLE tmpCustomer';\n        EXECUTE tmpSQL;\n    \n    RETURN;\n    END\n    $_$;\n    \n    \n    --\n    -- Name: group_concat(text); Type: AGGREGATE; Schema: DatabaseIntrospector; Owner: postgres\n    --\n    \n    CREATE AGGREGATE group_concat(text) (\n        SFUNC = _group_concat,\n        STYPE = text\n    );\n    \n    \n    --\n    -- Name: actor_actor_id_seq; Type: SEQUENCE; Schema: DatabaseIntrospector; Owner: postgres\n    --\n    \n    CREATE SEQUENCE actor_actor_id_seq\n        START WITH 1\n        INCREMENT BY 1\n        NO MINVALUE\n        NO MAXVALUE\n        CACHE 1;\n    \n    \n    --\n    -- Name: actor; Type: TABLE; Schema: DatabaseIntrospector; Owner: postgres; Tablespace: \n    --\n    \n    CREATE TABLE actor (\n        actor_id integer DEFAULT nextval('actor_actor_id_seq'::regclass) NOT NULL,\n        first_name character varying(45) NOT NULL,\n        last_name character varying(45) NOT NULL,\n        last_update timestamp without time zone DEFAULT now() NOT NULL\n    );\n    \n    \n    --\n    -- Name: category_category_id_seq; Type: SEQUENCE; Schema: DatabaseIntrospector; Owner: postgres\n    --\n    \n    CREATE SEQUENCE category_category_id_seq\n        START WITH 1\n        INCREMENT BY 1\n        NO MINVALUE\n        NO MAXVALUE\n        CACHE 1;\n    \n    \n    --\n    -- Name: category; Type: TABLE; Schema: DatabaseIntrospector; Owner: postgres; Tablespace: \n    --\n    \n    CREATE TABLE category (\n        category_id integer DEFAULT nextval('category_category_id_seq'::regclass) NOT NULL,\n        name character varying(25) NOT NULL,\n        last_update timestamp without time zone DEFAULT now() NOT NULL\n    );\n    \n    \n    --\n    -- Name: film_film_id_seq; Type: SEQUENCE; Schema: DatabaseIntrospector; Owner: postgres\n    --\n    \n    CREATE SEQUENCE film_film_id_seq\n        START WITH 1\n        INCREMENT BY 1\n        NO MINVALUE\n        NO MAXVALUE\n        CACHE 1;\n    \n    \n    --\n    -- Name: film; Type: TABLE; Schema: DatabaseIntrospector; Owner: postgres; Tablespace: \n    --\n    \n    CREATE TABLE film (\n        film_id integer DEFAULT nextval('film_film_id_seq'::regclass) NOT NULL,\n        title character varying(255) NOT NULL,\n        description text,\n        release_year year,\n        language_id smallint NOT NULL,\n        rental_duration smallint DEFAULT 3 NOT NULL,\n        rental_rate numeric(4,2) DEFAULT 4.99 NOT NULL,\n        length smallint,\n        replacement_cost numeric(5,2) DEFAULT 19.99 NOT NULL,\n        rating mpaa_rating DEFAULT 'G'::mpaa_rating,\n        last_update timestamp without time zone DEFAULT now() NOT NULL,\n        special_features text[],\n        fulltext tsvector NOT NULL\n    );\n    \n    \n    --\n    -- Name: film_actor; Type: TABLE; Schema: DatabaseIntrospector; Owner: postgres; Tablespace: \n    --\n    \n    CREATE TABLE film_actor (\n        actor_id smallint NOT NULL,\n        film_id smallint NOT NULL,\n        last_update timestamp without time zone DEFAULT now() NOT NULL\n    );\n    \n    \n    --\n    -- Name: film_category; Type: TABLE; Schema: DatabaseIntrospector; Owner: postgres; Tablespace: \n    --\n    \n    CREATE TABLE film_category (\n        film_id smallint NOT NULL,\n        category_id smallint NOT NULL,\n        last_update timestamp without time zone DEFAULT now() NOT NULL\n    );\n    \n    \n    --\n    -- Name: actor_info; Type: VIEW; Schema: DatabaseIntrospector; Owner: postgres\n    --\n    \n    CREATE VIEW actor_info AS\n        SELECT a.actor_id, a.first_name, a.last_name, group_concat(DISTINCT (((c.name)::text || ': '::text) || (SELECT group_concat((f.title)::text) AS group_concat FROM ((film f JOIN film_category fc ON ((f.film_id = fc.film_id))) JOIN film_actor fa ON ((f.film_id = fa.film_id))) WHERE ((fc.category_id = c.category_id) AND (fa.actor_id = a.actor_id)) GROUP BY fa.actor_id))) AS film_info FROM (((actor a LEFT JOIN film_actor fa ON ((a.actor_id = fa.actor_id))) LEFT JOIN film_category fc ON ((fa.film_id = fc.film_id))) LEFT JOIN category c ON ((fc.category_id = c.category_id))) GROUP BY a.actor_id, a.first_name, a.last_name;\n    \n    \n    --\n    -- Name: address_address_id_seq; Type: SEQUENCE; Schema: DatabaseIntrospector; Owner: postgres\n    --\n    \n    CREATE SEQUENCE address_address_id_seq\n        START WITH 1\n        INCREMENT BY 1\n        NO MINVALUE\n        NO MAXVALUE\n        CACHE 1;\n    \n    \n    --\n    -- Name: address; Type: TABLE; Schema: DatabaseIntrospector; Owner: postgres; Tablespace: \n    --\n    \n    CREATE TABLE address (\n        address_id integer DEFAULT nextval('address_address_id_seq'::regclass) NOT NULL,\n        address character varying(50) NOT NULL,\n        address2 character varying(50),\n        district character varying(20) NOT NULL,\n        city_id smallint NOT NULL,\n        postal_code character varying(10),\n        phone character varying(20) NOT NULL,\n        last_update timestamp without time zone DEFAULT now() NOT NULL\n    );\n    \n    \n    --\n    -- Name: city_city_id_seq; Type: SEQUENCE; Schema: DatabaseIntrospector; Owner: postgres\n    --\n    \n    CREATE SEQUENCE city_city_id_seq\n        START WITH 1\n        INCREMENT BY 1\n        NO MINVALUE\n        NO MAXVALUE\n        CACHE 1;\n    \n    \n    --\n    -- Name: city; Type: TABLE; Schema: DatabaseIntrospector; Owner: postgres; Tablespace: \n    --\n    \n    CREATE TABLE city (\n        city_id integer DEFAULT nextval('city_city_id_seq'::regclass) NOT NULL,\n        city character varying(50) NOT NULL,\n        country_id smallint NOT NULL,\n        last_update timestamp without time zone DEFAULT now() NOT NULL\n    );\n    \n    \n    --\n    -- Name: country_country_id_seq; Type: SEQUENCE; Schema: DatabaseIntrospector; Owner: postgres\n    --\n    \n    CREATE SEQUENCE country_country_id_seq\n        START WITH 1\n        INCREMENT BY 1\n        NO MINVALUE\n        NO MAXVALUE\n        CACHE 1;\n    \n    \n    --\n    -- Name: country; Type: TABLE; Schema: DatabaseIntrospector; Owner: postgres; Tablespace: \n    --\n    \n    CREATE TABLE country (\n        country_id integer DEFAULT nextval('country_country_id_seq'::regclass) NOT NULL,\n        country character varying(50) NOT NULL,\n        last_update timestamp without time zone DEFAULT now() NOT NULL\n    );\n    \n    \n    --\n    -- Name: customer_list; Type: VIEW; Schema: DatabaseIntrospector; Owner: postgres\n    --\n    \n    CREATE VIEW customer_list AS\n        SELECT cu.customer_id AS id, (((cu.first_name)::text || ' '::text) || (cu.last_name)::text) AS name, a.address, a.postal_code AS \"zip code\", a.phone, city.city, country.country, CASE WHEN cu.activebool THEN 'active'::text ELSE ''::text END AS notes, cu.store_id AS sid FROM (((customer cu JOIN address a ON ((cu.address_id = a.address_id))) JOIN city ON ((a.city_id = city.city_id))) JOIN country ON ((city.country_id = country.country_id)));\n    \n    \n    --\n    -- Name: film_list; Type: VIEW; Schema: DatabaseIntrospector; Owner: postgres\n    --\n    \n    CREATE VIEW film_list AS\n        SELECT film.film_id AS fid, film.title, film.description, category.name AS category, film.rental_rate AS price, film.length, film.rating, group_concat((((actor.first_name)::text || ' '::text) || (actor.last_name)::text)) AS actors FROM ((((category LEFT JOIN film_category ON ((category.category_id = film_category.category_id))) LEFT JOIN film ON ((film_category.film_id = film.film_id))) JOIN film_actor ON ((film.film_id = film_actor.film_id))) JOIN actor ON ((film_actor.actor_id = actor.actor_id))) GROUP BY film.film_id, film.title, film.description, category.name, film.rental_rate, film.length, film.rating;\n    \n    \n    --\n    -- Name: inventory_inventory_id_seq; Type: SEQUENCE; Schema: DatabaseIntrospector; Owner: postgres\n    --\n    \n    CREATE SEQUENCE inventory_inventory_id_seq\n        START WITH 1\n        INCREMENT BY 1\n        NO MINVALUE\n        NO MAXVALUE\n        CACHE 1;\n    \n    \n    \n    --\n    -- Name: inventory; Type: TABLE; Schema: DatabaseIntrospector; Owner: postgres; Tablespace: \n    --\n    \n    CREATE TABLE inventory (\n        inventory_id integer DEFAULT nextval('inventory_inventory_id_seq'::regclass) NOT NULL,\n        film_id smallint NOT NULL,\n        store_id smallint NOT NULL,\n        last_update timestamp without time zone DEFAULT now() NOT NULL\n    );\n    \n    \n    --\n    -- Name: language_language_id_seq; Type: SEQUENCE; Schema: DatabaseIntrospector; Owner: postgres\n    --\n    \n    CREATE SEQUENCE language_language_id_seq\n        START WITH 1\n        INCREMENT BY 1\n        NO MINVALUE\n        NO MAXVALUE\n        CACHE 1;\n    \n    \n    --\n    -- Name: language; Type: TABLE; Schema: DatabaseIntrospector; Owner: postgres; Tablespace: \n    --\n    \n    CREATE TABLE language (\n        language_id integer DEFAULT nextval('language_language_id_seq'::regclass) NOT NULL,\n        name character(20) NOT NULL,\n        last_update timestamp without time zone DEFAULT now() NOT NULL\n    );\n    \n    \n    --\n    -- Name: nicer_but_slower_film_list; Type: VIEW; Schema: DatabaseIntrospector; Owner: postgres\n    --\n    \n    CREATE VIEW nicer_but_slower_film_list AS\n        SELECT film.film_id AS fid, film.title, film.description, category.name AS category, film.rental_rate AS price, film.length, film.rating, group_concat((((upper(\"substring\"((actor.first_name)::text, 1, 1)) || lower(\"substring\"((actor.first_name)::text, 2))) || upper(\"substring\"((actor.last_name)::text, 1, 1))) || lower(\"substring\"((actor.last_name)::text, 2)))) AS actors FROM ((((category LEFT JOIN film_category ON ((category.category_id = film_category.category_id))) LEFT JOIN film ON ((film_category.film_id = film.film_id))) JOIN film_actor ON ((film.film_id = film_actor.film_id))) JOIN actor ON ((film_actor.actor_id = actor.actor_id))) GROUP BY film.film_id, film.title, film.description, category.name, film.rental_rate, film.length, film.rating;\n    \n    \n    --\n    -- Name: payment_payment_id_seq; Type: SEQUENCE; Schema: DatabaseIntrospector; Owner: postgres\n    --\n    \n    CREATE SEQUENCE payment_payment_id_seq\n        START WITH 1\n        INCREMENT BY 1\n        NO MINVALUE\n        NO MAXVALUE\n        CACHE 1;\n    \n    \n    --\n    -- Name: payment; Type: TABLE; Schema: DatabaseIntrospector; Owner: postgres; Tablespace: \n    --\n    \n    CREATE TABLE payment (\n        payment_id integer DEFAULT nextval('payment_payment_id_seq'::regclass) NOT NULL,\n        customer_id smallint NOT NULL,\n        staff_id smallint NOT NULL,\n        rental_id integer NOT NULL,\n        amount numeric(5,2) NOT NULL,\n        payment_date timestamp without time zone NOT NULL\n    );\n    \n    \n    --\n    -- Name: rental_rental_id_seq; Type: SEQUENCE; Schema: DatabaseIntrospector; Owner: postgres\n    --\n    \n    CREATE SEQUENCE rental_rental_id_seq\n        START WITH 1\n        INCREMENT BY 1\n        NO MINVALUE\n        NO MAXVALUE\n        CACHE 1;\n    \n    \n    --\n    -- Name: rental; Type: TABLE; Schema: DatabaseIntrospector; Owner: postgres; Tablespace: \n    --\n    \n    CREATE TABLE rental (\n        rental_id integer DEFAULT nextval('rental_rental_id_seq'::regclass) NOT NULL,\n        rental_date timestamp without time zone NOT NULL,\n        inventory_id integer NOT NULL,\n        customer_id smallint NOT NULL,\n        return_date timestamp without time zone,\n        staff_id smallint NOT NULL,\n        last_update timestamp without time zone DEFAULT now() NOT NULL\n    );\n    \n    \n    --\n    -- Name: sales_by_film_category; Type: VIEW; Schema: DatabaseIntrospector; Owner: postgres\n    --\n    \n    CREATE VIEW sales_by_film_category AS\n        SELECT c.name AS category, sum(p.amount) AS total_sales FROM (((((payment p JOIN rental r ON ((p.rental_id = r.rental_id))) JOIN inventory i ON ((r.inventory_id = i.inventory_id))) JOIN film f ON ((i.film_id = f.film_id))) JOIN film_category fc ON ((f.film_id = fc.film_id))) JOIN category c ON ((fc.category_id = c.category_id))) GROUP BY c.name ORDER BY sum(p.amount) DESC;\n    \n    \n    --\n    -- Name: staff_staff_id_seq; Type: SEQUENCE; Schema: DatabaseIntrospector; Owner: postgres\n    --\n    \n    CREATE SEQUENCE staff_staff_id_seq\n        START WITH 1\n        INCREMENT BY 1\n        NO MINVALUE\n        NO MAXVALUE\n        CACHE 1;\n    \n    \n    --\n    -- Name: staff; Type: TABLE; Schema: DatabaseIntrospector; Owner: postgres; Tablespace: \n    --\n    \n    CREATE TABLE staff (\n        staff_id integer DEFAULT nextval('staff_staff_id_seq'::regclass) NOT NULL,\n        first_name character varying(45) NOT NULL,\n        last_name character varying(45) NOT NULL,\n        address_id smallint NOT NULL,\n        email character varying(50),\n        store_id smallint NOT NULL,\n        active boolean DEFAULT true NOT NULL,\n        username character varying(16) NOT NULL,\n        password character varying(40),\n        last_update timestamp without time zone DEFAULT now() NOT NULL,\n        picture bytea\n    );\n    \n    \n    --\n    -- Name: store_store_id_seq; Type: SEQUENCE; Schema: DatabaseIntrospector; Owner: postgres\n    --\n    \n    CREATE SEQUENCE store_store_id_seq\n        START WITH 1\n        INCREMENT BY 1\n        NO MINVALUE\n        NO MAXVALUE\n        CACHE 1;\n    \n    \n    --\n    -- Name: store; Type: TABLE; Schema: DatabaseIntrospector; Owner: postgres; Tablespace: \n    --\n    \n    CREATE TABLE store (\n        store_id integer DEFAULT nextval('store_store_id_seq'::regclass) NOT NULL,\n        manager_staff_id smallint NOT NULL,\n        address_id smallint NOT NULL,\n        last_update timestamp without time zone DEFAULT now() NOT NULL\n    );\n    \n    \n    --\n    -- Name: sales_by_store; Type: VIEW; Schema: DatabaseIntrospector; Owner: postgres\n    --\n    \n    CREATE VIEW sales_by_store AS\n        SELECT (((c.city)::text || ','::text) || (cy.country)::text) AS store, (((m.first_name)::text || ' '::text) || (m.last_name)::text) AS manager, sum(p.amount) AS total_sales FROM (((((((payment p JOIN rental r ON ((p.rental_id = r.rental_id))) JOIN inventory i ON ((r.inventory_id = i.inventory_id))) JOIN store s ON ((i.store_id = s.store_id))) JOIN address a ON ((s.address_id = a.address_id))) JOIN city c ON ((a.city_id = c.city_id))) JOIN country cy ON ((c.country_id = cy.country_id))) JOIN staff m ON ((s.manager_staff_id = m.staff_id))) GROUP BY cy.country, c.city, s.store_id, m.first_name, m.last_name ORDER BY cy.country, c.city;\n    \n    \n    --\n    -- Name: staff_list; Type: VIEW; Schema: DatabaseIntrospector; Owner: postgres\n    --\n    \n    CREATE VIEW staff_list AS\n        SELECT s.staff_id AS id, (((s.first_name)::text || ' '::text) || (s.last_name)::text) AS name, a.address, a.postal_code AS \"zip code\", a.phone, city.city, country.country, s.store_id AS sid FROM (((staff s JOIN address a ON ((s.address_id = a.address_id))) JOIN city ON ((a.city_id = city.city_id))) JOIN country ON ((city.country_id = country.country_id)));\n    \n    \n    -- Omitted data copy\n    \n    --\n    -- Name: actor_pkey; Type: CONSTRAINT; Schema: DatabaseIntrospector; Owner: postgres; Tablespace: \n    --\n    \n    ALTER TABLE ONLY actor\n        ADD CONSTRAINT actor_pkey PRIMARY KEY (actor_id);\n    \n    \n    --\n    -- Name: address_pkey; Type: CONSTRAINT; Schema: DatabaseIntrospector; Owner: postgres; Tablespace: \n    --\n    \n    ALTER TABLE ONLY address\n        ADD CONSTRAINT address_pkey PRIMARY KEY (address_id);\n    \n    \n    --\n    -- Name: category_pkey; Type: CONSTRAINT; Schema: DatabaseIntrospector; Owner: postgres; Tablespace: \n    --\n    \n    ALTER TABLE ONLY category\n        ADD CONSTRAINT category_pkey PRIMARY KEY (category_id);\n    \n    \n    --\n    -- Name: city_pkey; Type: CONSTRAINT; Schema: DatabaseIntrospector; Owner: postgres; Tablespace: \n    --\n    \n    ALTER TABLE ONLY city\n        ADD CONSTRAINT city_pkey PRIMARY KEY (city_id);\n    \n    \n    --\n    -- Name: country_pkey; Type: CONSTRAINT; Schema: DatabaseIntrospector; Owner: postgres; Tablespace: \n    --\n    \n    ALTER TABLE ONLY country\n        ADD CONSTRAINT country_pkey PRIMARY KEY (country_id);\n    \n    \n    --\n    -- Name: customer_pkey; Type: CONSTRAINT; Schema: DatabaseIntrospector; Owner: postgres; Tablespace: \n    --\n    \n    ALTER TABLE ONLY customer\n        ADD CONSTRAINT customer_pkey PRIMARY KEY (customer_id);\n    \n    \n    --\n    -- Name: film_actor_pkey; Type: CONSTRAINT; Schema: DatabaseIntrospector; Owner: postgres; Tablespace: \n    --\n    \n    ALTER TABLE ONLY film_actor\n        ADD CONSTRAINT film_actor_pkey PRIMARY KEY (actor_id, film_id);\n    \n    \n    --\n    -- Name: film_category_pkey; Type: CONSTRAINT; Schema: DatabaseIntrospector; Owner: postgres; Tablespace: \n    --\n    \n    ALTER TABLE ONLY film_category\n        ADD CONSTRAINT film_category_pkey PRIMARY KEY (film_id, category_id);\n    \n    \n    --\n    -- Name: film_pkey; Type: CONSTRAINT; Schema: DatabaseIntrospector; Owner: postgres; Tablespace: \n    --\n    \n    ALTER TABLE ONLY film\n        ADD CONSTRAINT film_pkey PRIMARY KEY (film_id);\n    \n    \n    --\n    -- Name: inventory_pkey; Type: CONSTRAINT; Schema: DatabaseIntrospector; Owner: postgres; Tablespace: \n    --\n    \n    ALTER TABLE ONLY inventory\n        ADD CONSTRAINT inventory_pkey PRIMARY KEY (inventory_id);\n    \n    \n    --\n    -- Name: language_pkey; Type: CONSTRAINT; Schema: DatabaseIntrospector; Owner: postgres; Tablespace: \n    --\n    \n    ALTER TABLE ONLY language\n        ADD CONSTRAINT language_pkey PRIMARY KEY (language_id);\n    \n    \n    --\n    -- Name: payment_pkey; Type: CONSTRAINT; Schema: DatabaseIntrospector; Owner: postgres; Tablespace: \n    --\n    \n    ALTER TABLE ONLY payment\n        ADD CONSTRAINT payment_pkey PRIMARY KEY (payment_id);\n    \n    \n    --\n    -- Name: rental_pkey; Type: CONSTRAINT; Schema: DatabaseIntrospector; Owner: postgres; Tablespace: \n    --\n    \n    ALTER TABLE ONLY rental\n        ADD CONSTRAINT rental_pkey PRIMARY KEY (rental_id);\n    \n    \n    --\n    -- Name: staff_pkey; Type: CONSTRAINT; Schema: DatabaseIntrospector; Owner: postgres; Tablespace: \n    --\n    \n    ALTER TABLE ONLY staff\n        ADD CONSTRAINT staff_pkey PRIMARY KEY (staff_id);\n    \n    \n    --\n    -- Name: store_pkey; Type: CONSTRAINT; Schema: DatabaseIntrospector; Owner: postgres; Tablespace: \n    --\n    \n    ALTER TABLE ONLY store\n        ADD CONSTRAINT store_pkey PRIMARY KEY (store_id);\n    \n    \n    --\n    -- Name: film_fulltext_idx; Type: INDEX; Schema: DatabaseIntrospector; Owner: postgres; Tablespace: \n    --\n    \n    CREATE INDEX film_fulltext_idx ON film USING gist (fulltext);\n    \n    \n    --\n    -- Name: idx_actor_last_name; Type: INDEX; Schema: DatabaseIntrospector; Owner: postgres; Tablespace: \n    --\n    \n    CREATE INDEX idx_actor_last_name ON actor USING btree (last_name);\n    \n    \n    --\n    -- Name: idx_fk_address_id; Type: INDEX; Schema: DatabaseIntrospector; Owner: postgres; Tablespace: \n    --\n    \n    CREATE INDEX idx_fk_address_id ON customer USING btree (address_id);\n    \n    \n    --\n    -- Name: idx_fk_city_id; Type: INDEX; Schema: DatabaseIntrospector; Owner: postgres; Tablespace: \n    --\n    \n    CREATE INDEX idx_fk_city_id ON address USING btree (city_id);\n    \n    \n    --\n    -- Name: idx_fk_country_id; Type: INDEX; Schema: DatabaseIntrospector; Owner: postgres; Tablespace: \n    --\n    \n    CREATE INDEX idx_fk_country_id ON city USING btree (country_id);\n    \n    \n    --\n    -- Name: idx_fk_customer_id; Type: INDEX; Schema: DatabaseIntrospector; Owner: postgres; Tablespace: \n    --\n    \n    CREATE INDEX idx_fk_customer_id ON payment USING btree (customer_id);\n    \n    \n    --\n    -- Name: idx_fk_film_id; Type: INDEX; Schema: DatabaseIntrospector; Owner: postgres; Tablespace: \n    --\n    \n    CREATE INDEX idx_fk_film_id ON film_actor USING btree (film_id);\n    \n    \n    --\n    -- Name: idx_fk_inventory_id; Type: INDEX; Schema: DatabaseIntrospector; Owner: postgres; Tablespace: \n    --\n    \n    CREATE INDEX idx_fk_inventory_id ON rental USING btree (inventory_id);\n    \n    \n    --\n    -- Name: idx_fk_language_id; Type: INDEX; Schema: DatabaseIntrospector; Owner: postgres; Tablespace: \n    --\n    \n    CREATE INDEX idx_fk_language_id ON film USING btree (language_id);\n    \n    \n    --\n    -- Name: idx_fk_rental_id; Type: INDEX; Schema: DatabaseIntrospector; Owner: postgres; Tablespace: \n    --\n    \n    CREATE INDEX idx_fk_rental_id ON payment USING btree (rental_id);\n    \n    \n    --\n    -- Name: idx_fk_staff_id; Type: INDEX; Schema: DatabaseIntrospector; Owner: postgres; Tablespace: \n    --\n    \n    CREATE INDEX idx_fk_staff_id ON payment USING btree (staff_id);\n    \n    \n    --\n    -- Name: idx_fk_store_id; Type: INDEX; Schema: DatabaseIntrospector; Owner: postgres; Tablespace: \n    --\n    \n    CREATE INDEX idx_fk_store_id ON customer USING btree (store_id);\n    \n    \n    --\n    -- Name: idx_last_name; Type: INDEX; Schema: DatabaseIntrospector; Owner: postgres; Tablespace: \n    --\n    \n    CREATE INDEX idx_last_name ON customer USING btree (last_name);\n    \n    \n    --\n    -- Name: idx_store_id_film_id; Type: INDEX; Schema: DatabaseIntrospector; Owner: postgres; Tablespace: \n    --\n    \n    CREATE INDEX idx_store_id_film_id ON inventory USING btree (store_id, film_id);\n    \n    \n    --\n    -- Name: idx_title; Type: INDEX; Schema: DatabaseIntrospector; Owner: postgres; Tablespace: \n    --\n    \n    CREATE INDEX idx_title ON film USING btree (title);\n    \n    \n    --\n    -- Name: idx_unq_manager_staff_id; Type: INDEX; Schema: DatabaseIntrospector; Owner: postgres; Tablespace: \n    --\n    \n    CREATE UNIQUE INDEX idx_unq_manager_staff_id ON store USING btree (manager_staff_id);\n    \n    \n    --\n    -- Name: idx_unq_rental_rental_date_inventory_id_customer_id; Type: INDEX; Schema: DatabaseIntrospector; Owner: postgres; Tablespace: \n    --\n    \n    CREATE UNIQUE INDEX idx_unq_rental_rental_date_inventory_id_customer_id ON rental USING btree (rental_date, inventory_id, customer_id);\n    \n    \n    --\n    -- Name: film_fulltext_trigger; Type: TRIGGER; Schema: DatabaseIntrospector; Owner: postgres\n    --\n    \n    CREATE TRIGGER film_fulltext_trigger BEFORE INSERT OR UPDATE ON film FOR EACH ROW EXECUTE PROCEDURE tsvector_update_trigger('fulltext', 'pg_catalog.english', 'title', 'description');\n    \n    \n    --\n    -- Name: last_updated; Type: TRIGGER; Schema: DatabaseIntrospector; Owner: postgres\n    --\n    \n    CREATE TRIGGER last_updated BEFORE UPDATE ON actor FOR EACH ROW EXECUTE PROCEDURE last_updated();\n    \n    \n    --\n    -- Name: last_updated; Type: TRIGGER; Schema: DatabaseIntrospector; Owner: postgres\n    --\n    \n    CREATE TRIGGER last_updated BEFORE UPDATE ON address FOR EACH ROW EXECUTE PROCEDURE last_updated();\n    \n    \n    --\n    -- Name: last_updated; Type: TRIGGER; Schema: DatabaseIntrospector; Owner: postgres\n    --\n    \n    CREATE TRIGGER last_updated BEFORE UPDATE ON category FOR EACH ROW EXECUTE PROCEDURE last_updated();\n    \n    \n    --\n    -- Name: last_updated; Type: TRIGGER; Schema: DatabaseIntrospector; Owner: postgres\n    --\n    \n    CREATE TRIGGER last_updated BEFORE UPDATE ON city FOR EACH ROW EXECUTE PROCEDURE last_updated();\n    \n    \n    --\n    -- Name: last_updated; Type: TRIGGER; Schema: DatabaseIntrospector; Owner: postgres\n    --\n    \n    CREATE TRIGGER last_updated BEFORE UPDATE ON country FOR EACH ROW EXECUTE PROCEDURE last_updated();\n    \n    \n    --\n    -- Name: last_updated; Type: TRIGGER; Schema: DatabaseIntrospector; Owner: postgres\n    --\n    \n    CREATE TRIGGER last_updated BEFORE UPDATE ON customer FOR EACH ROW EXECUTE PROCEDURE last_updated();\n    \n    \n    --\n    -- Name: last_updated; Type: TRIGGER; Schema: DatabaseIntrospector; Owner: postgres\n    --\n    \n    CREATE TRIGGER last_updated BEFORE UPDATE ON film FOR EACH ROW EXECUTE PROCEDURE last_updated();\n    \n    \n    --\n    -- Name: last_updated; Type: TRIGGER; Schema: DatabaseIntrospector; Owner: postgres\n    --\n    \n    CREATE TRIGGER last_updated BEFORE UPDATE ON film_actor FOR EACH ROW EXECUTE PROCEDURE last_updated();\n    \n    \n    --\n    -- Name: last_updated; Type: TRIGGER; Schema: DatabaseIntrospector; Owner: postgres\n    --\n    \n    CREATE TRIGGER last_updated BEFORE UPDATE ON film_category FOR EACH ROW EXECUTE PROCEDURE last_updated();\n    \n    \n    --\n    -- Name: last_updated; Type: TRIGGER; Schema: DatabaseIntrospector; Owner: postgres\n    --\n    \n    CREATE TRIGGER last_updated BEFORE UPDATE ON inventory FOR EACH ROW EXECUTE PROCEDURE last_updated();\n    \n    \n    --\n    -- Name: last_updated; Type: TRIGGER; Schema: DatabaseIntrospector; Owner: postgres\n    --\n    \n    CREATE TRIGGER last_updated BEFORE UPDATE ON language FOR EACH ROW EXECUTE PROCEDURE last_updated();\n    \n    \n    --\n    -- Name: last_updated; Type: TRIGGER; Schema: DatabaseIntrospector; Owner: postgres\n    --\n    \n    CREATE TRIGGER last_updated BEFORE UPDATE ON rental FOR EACH ROW EXECUTE PROCEDURE last_updated();\n    \n    \n    --\n    -- Name: last_updated; Type: TRIGGER; Schema: DatabaseIntrospector; Owner: postgres\n    --\n    \n    CREATE TRIGGER last_updated BEFORE UPDATE ON staff FOR EACH ROW EXECUTE PROCEDURE last_updated();\n    \n    \n    --\n    -- Name: last_updated; Type: TRIGGER; Schema: DatabaseIntrospector; Owner: postgres\n    --\n    \n    CREATE TRIGGER last_updated BEFORE UPDATE ON store FOR EACH ROW EXECUTE PROCEDURE last_updated();\n    \n    \n    --\n    -- Name: customer_address_id_fkey; Type: FK CONSTRAINT; Schema: DatabaseIntrospector; Owner: postgres\n    --\n    \n    ALTER TABLE ONLY customer\n        ADD CONSTRAINT customer_address_id_fkey FOREIGN KEY (address_id) REFERENCES address(address_id) ON UPDATE CASCADE ON DELETE RESTRICT;\n    \n    \n    --\n    -- Name: film_actor_actor_id_fkey; Type: FK CONSTRAINT; Schema: DatabaseIntrospector; Owner: postgres\n    --\n    \n    ALTER TABLE ONLY film_actor\n        ADD CONSTRAINT film_actor_actor_id_fkey FOREIGN KEY (actor_id) REFERENCES actor(actor_id) ON UPDATE CASCADE ON DELETE RESTRICT;\n    \n    \n    --\n    -- Name: film_actor_film_id_fkey; Type: FK CONSTRAINT; Schema: DatabaseIntrospector; Owner: postgres\n    --\n    \n    ALTER TABLE ONLY film_actor\n        ADD CONSTRAINT film_actor_film_id_fkey FOREIGN KEY (film_id) REFERENCES film(film_id) ON UPDATE CASCADE ON DELETE RESTRICT;\n    \n    \n    --\n    -- Name: film_category_category_id_fkey; Type: FK CONSTRAINT; Schema: DatabaseIntrospector; Owner: postgres\n    --\n    \n    ALTER TABLE ONLY film_category\n        ADD CONSTRAINT film_category_category_id_fkey FOREIGN KEY (category_id) REFERENCES category(category_id) ON UPDATE CASCADE ON DELETE RESTRICT;\n    \n    \n    --\n    -- Name: film_category_film_id_fkey; Type: FK CONSTRAINT; Schema: DatabaseIntrospector; Owner: postgres\n    --\n    \n    ALTER TABLE ONLY film_category\n        ADD CONSTRAINT film_category_film_id_fkey FOREIGN KEY (film_id) REFERENCES film(film_id) ON UPDATE CASCADE ON DELETE RESTRICT;\n    \n    \n    --\n    -- Name: film_language_id_fkey; Type: FK CONSTRAINT; Schema: DatabaseIntrospector; Owner: postgres\n    --\n    \n    ALTER TABLE ONLY film\n        ADD CONSTRAINT film_language_id_fkey FOREIGN KEY (language_id) REFERENCES language(language_id) ON UPDATE CASCADE ON DELETE RESTRICT;\n    \n    \n    --\n    -- Name: fk_address_city; Type: FK CONSTRAINT; Schema: DatabaseIntrospector; Owner: postgres\n    --\n    \n    ALTER TABLE ONLY address\n        ADD CONSTRAINT fk_address_city FOREIGN KEY (city_id) REFERENCES city(city_id);\n    \n    \n    --\n    -- Name: fk_city; Type: FK CONSTRAINT; Schema: DatabaseIntrospector; Owner: postgres\n    --\n    \n    ALTER TABLE ONLY city\n        ADD CONSTRAINT fk_city FOREIGN KEY (country_id) REFERENCES country(country_id);\n    \n    \n    --\n    -- Name: inventory_film_id_fkey; Type: FK CONSTRAINT; Schema: DatabaseIntrospector; Owner: postgres\n    --\n    \n    ALTER TABLE ONLY inventory\n        ADD CONSTRAINT inventory_film_id_fkey FOREIGN KEY (film_id) REFERENCES film(film_id) ON UPDATE CASCADE ON DELETE RESTRICT;\n    \n    \n    --\n    -- Name: payment_customer_id_fkey; Type: FK CONSTRAINT; Schema: DatabaseIntrospector; Owner: postgres\n    --\n    \n    ALTER TABLE ONLY payment\n        ADD CONSTRAINT payment_customer_id_fkey FOREIGN KEY (customer_id) REFERENCES customer(customer_id) ON UPDATE CASCADE ON DELETE RESTRICT;\n    \n    \n    --\n    -- Name: payment_rental_id_fkey; Type: FK CONSTRAINT; Schema: DatabaseIntrospector; Owner: postgres\n    --\n    \n    ALTER TABLE ONLY payment\n        ADD CONSTRAINT payment_rental_id_fkey FOREIGN KEY (rental_id) REFERENCES rental(rental_id) ON UPDATE CASCADE ON DELETE SET NULL;\n    \n    \n    --\n    -- Name: payment_staff_id_fkey; Type: FK CONSTRAINT; Schema: DatabaseIntrospector; Owner: postgres\n    --\n    \n    ALTER TABLE ONLY payment\n        ADD CONSTRAINT payment_staff_id_fkey FOREIGN KEY (staff_id) REFERENCES staff(staff_id) ON UPDATE CASCADE ON DELETE RESTRICT;\n    \n    \n    --\n    -- Name: rental_customer_id_fkey; Type: FK CONSTRAINT; Schema: DatabaseIntrospector; Owner: postgres\n    --\n    \n    ALTER TABLE ONLY rental\n        ADD CONSTRAINT rental_customer_id_fkey FOREIGN KEY (customer_id) REFERENCES customer(customer_id) ON UPDATE CASCADE ON DELETE RESTRICT;\n    \n    \n    --\n    -- Name: rental_inventory_id_fkey; Type: FK CONSTRAINT; Schema: DatabaseIntrospector; Owner: postgres\n    --\n    \n    ALTER TABLE ONLY rental\n        ADD CONSTRAINT rental_inventory_id_fkey FOREIGN KEY (inventory_id) REFERENCES inventory(inventory_id) ON UPDATE CASCADE ON DELETE RESTRICT;\n    \n    \n    --\n    -- Name: rental_staff_id_key; Type: FK CONSTRAINT; Schema: DatabaseIntrospector; Owner: postgres\n    --\n    \n    ALTER TABLE ONLY rental\n        ADD CONSTRAINT rental_staff_id_key FOREIGN KEY (staff_id) REFERENCES staff(staff_id);\n    \n    \n    --\n    -- Name: staff_address_id_fkey; Type: FK CONSTRAINT; Schema: DatabaseIntrospector; Owner: postgres\n    --\n    \n    ALTER TABLE ONLY staff\n        ADD CONSTRAINT staff_address_id_fkey FOREIGN KEY (address_id) REFERENCES address(address_id) ON UPDATE CASCADE ON DELETE RESTRICT;\n    \n    \n    --\n    -- Name: store_address_id_fkey; Type: FK CONSTRAINT; Schema: DatabaseIntrospector; Owner: postgres\n    --\n    \n    ALTER TABLE ONLY store\n        ADD CONSTRAINT store_address_id_fkey FOREIGN KEY (address_id) REFERENCES address(address_id) ON UPDATE CASCADE ON DELETE RESTRICT;\n    \n    \n    --\n    -- Name: store_manager_staff_id_fkey; Type: FK CONSTRAINT; Schema: DatabaseIntrospector; Owner: postgres\n    --\n    \n    ALTER TABLE ONLY store\n        ADD CONSTRAINT store_manager_staff_id_fkey FOREIGN KEY (manager_staff_id) REFERENCES staff(staff_id) ON UPDATE CASCADE ON DELETE RESTRICT;\n    \n    \n    \n    --\n    -- PostgreSQL database dump complete\n    --\n    \n    ")];
                case 1:
                    // See http://www.postgresqltutorial.com/postgresql-sample-database/
                    _a.sent();
                    return [2 /*return*/];
            }
        });
    }); });
});
//# sourceMappingURL=largeSchema.test.js.map