"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = y[op[0] & 2 ? "return" : op[0] ? "throw" : "next"]) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [0, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var _ = require("lodash");
var pg_1 = require("pg");
var PostgresConnector = /** @class */ (function () {
    function PostgresConnector(connectionDetails) {
        var _this = this;
        this.client = new pg_1.Client(connectionDetails);
        this.connectionPromise = this.client.connect();
        // auto disconnect. end waits for queries to succeed
        setTimeout(function () {
            _this.client.end();
        }, 3000);
    }
    PostgresConnector.prototype.queryRelations = function (schemaName) {
        return __awaiter(this, void 0, void 0, function () {
            var res;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.client.query("\nSELECT\n    tc.table_schema, tc.constraint_name, tc.table_name, kcu.column_name, \n    ccu.table_schema AS foreign_table_schema,\n    ccu.table_name AS foreign_table_name,\n    ccu.column_name AS foreign_column_name \nFROM \n    information_schema.table_constraints AS tc \n    JOIN information_schema.key_column_usage AS kcu\n      ON tc.constraint_name = kcu.constraint_name\n    JOIN information_schema.constraint_column_usage AS ccu\n      ON ccu.constraint_name = tc.constraint_name\nWHERE constraint_type = 'FOREIGN KEY' AND tc.table_schema = $1::text;", [schemaName.toLowerCase()])];
                    case 1:
                        res = _a.sent();
                        return [2 /*return*/, res.rows];
                }
            });
        });
    };
    // Queries all columns of all tables in given schema and returns them grouped by table_name
    PostgresConnector.prototype.queryTables = function (schemaName) {
        return __awaiter(this, void 0, void 0, function () {
            var res;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.client.query("\n      SELECT *, (SELECT EXISTS(\n        SELECT *\n        FROM information_schema.table_constraints AS tc \n        JOIN information_schema.key_column_usage AS kcu\n          ON tc.constraint_name = kcu.constraint_name\n        WHERE constraint_type = 'UNIQUE' \n        AND tc.table_schema = $1::text\n        AND tc.table_name = c.table_name\n        AND kcu.column_name = c.column_name)) as is_unique\n      FROM  information_schema.columns c\n      WHERE table_schema = $1::text\n      ", [schemaName.toLowerCase()])];
                    case 1:
                        res = _a.sent();
                        return [2 /*return*/, _.groupBy(res.rows, 'table_name')];
                }
            });
        });
    };
    PostgresConnector.prototype.queryPrimaryKeys = function (schemaName) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/, this.client.query("\n      SELECT tc.table_name, kc.column_name\n      FROM information_schema.table_constraints tc\n      JOIN information_schema.key_column_usage kc \n        ON kc.table_name = tc.table_name \n        AND kc.table_schema = tc.table_schema\n        AND kc.constraint_name = tc.constraint_name\n      WHERE tc.constraint_type = 'PRIMARY KEY'\n      AND tc.table_schema = $1::text\n      AND kc.ordinal_position IS NOT NULL\n      ORDER BY tc.table_name, kc.position_in_unique_constraint;\n      ", [schemaName.toLowerCase()]).then(function (keys) {
                        var grouped = _.groupBy(keys.rows, 'table_name');
                        return _.map(grouped, function (pks, key) {
                            return {
                                tableName: key,
                                fields: pks.map(function (x) { return x.column_name; })
                            };
                        });
                    })];
            });
        });
    };
    PostgresConnector.prototype.querySchemas = function () {
        return __awaiter(this, void 0, void 0, function () {
            var res;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.client.query("select schema_name from information_schema.schemata WHERE schema_name NOT LIKE 'pg_%' AND schema_name NOT LIKE 'information_schema';")];
                    case 1:
                        res = _a.sent();
                        return [2 /*return*/, res.rows.map(function (x) { return x.schema_name; })];
                }
            });
        });
    };
    PostgresConnector.prototype.extractRelation = function (table, column, relations) {
        var candidate = relations.find(function (relation) {
            return relation.table_name === table && relation.column_name === column;
        });
        if (candidate) {
            return {
                table: candidate.foreign_table_name,
            };
        }
        else {
            return null;
        }
    };
    PostgresConnector.prototype.listSchemas = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.connectionPromise];
                    case 1:
                        _a.sent();
                        return [4 /*yield*/, this.querySchemas()];
                    case 2: return [2 /*return*/, _a.sent()];
                }
            });
        });
    };
    PostgresConnector.prototype.listTables = function (schemaName) {
        return __awaiter(this, void 0, void 0, function () {
            var _this = this;
            var _a, relations, tables, primaryKeys, withColumns;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0: return [4 /*yield*/, this.connectionPromise];
                    case 1:
                        _b.sent();
                        return [4 /*yield*/, Promise.all([
                                this.queryRelations(schemaName),
                                this.queryTables(schemaName),
                                this.queryPrimaryKeys(schemaName)
                            ])];
                    case 2:
                        _a = _b.sent(), relations = _a[0], tables = _a[1], primaryKeys = _a[2];
                        withColumns = _.map(tables, function (originalColumns, key) {
                            var tablePrimaryKey = primaryKeys.find(function (pk) { return pk.tableName === key; }) || null;
                            var columns = _.map(originalColumns, function (column) {
                                // Ignore compound keys for now
                                var isPk = Boolean(tablePrimaryKey
                                    && tablePrimaryKey.fields.length == 1
                                    && Boolean(tablePrimaryKey.fields.includes(column.column_name)));
                                var _a = _this.toTypeIdentifier(column.data_type, column.column_name, isPk), typeIdentifier = _a.typeIdentifier, comment = _a.comment, error = _a.error;
                                var relation = _this.extractRelation(column.table_name, column.column_name, relations);
                                var col = {
                                    isUnique: column.is_unique || isPk,
                                    isPrimaryKey: isPk,
                                    defaultValue: _this.parseDefaultValue(column.column_default),
                                    name: column.column_name,
                                    type: column.data_type,
                                    typeIdentifier: typeIdentifier,
                                    comment: comment,
                                    relation: relation,
                                    nullable: column.is_nullable === 'YES',
                                };
                                return col;
                            }).filter(function (x) { return x != null; });
                            // todo: relation table if 2 foreign keys. Also: No id field? + no other column that has NOT NULL and no default
                            var sortedColumns = _.sortBy(columns.filter(function (c) { return !c.isPrimaryKey; }), function (x) { return x.name; });
                            var primaryKeyCol = columns.find(function (c) { return c.isPrimaryKey; });
                            if (primaryKeyCol) {
                                sortedColumns.unshift(primaryKeyCol);
                            }
                            var isJunctionTable = sortedColumns.length === 2 &&
                                sortedColumns.every(function (x) { return x.relation != null; });
                            return {
                                name: key,
                                columns: sortedColumns,
                                isJunctionTable: isJunctionTable,
                            };
                        });
                        return [2 /*return*/, _.sortBy(withColumns, function (x) { return x.name; })];
                }
            });
        });
    };
    PostgresConnector.prototype.parseDefaultValue = function (string) {
        if (string == null) {
            return null;
        }
        if (string.includes("nextval('")) {
            return '[AUTO INCREMENT]';
        }
        if (string.includes('now()') || string.includes("'now'::text")) {
            return null;
        }
        if (string.includes('::')) {
            var candidate = string.split('::')[0];
            var withoutSuffix = candidate.endsWith("'")
                ? candidate.substring(0, candidate.length - 1)
                : candidate;
            var withoutPrefix = withoutSuffix.startsWith("'")
                ? withoutSuffix.substring(1, withoutSuffix.length)
                : withoutSuffix;
            if (withoutPrefix === "NULL") {
                return null;
            }
            return withoutPrefix;
        }
        return string;
    };
    PostgresConnector.prototype.toTypeIdentifier = function (type, field, isPrimaryKey) {
        if (isPrimaryKey &&
            (type === 'character' ||
                type === 'character varying' ||
                type === 'text' ||
                type == 'uuid')) {
            return { typeIdentifier: 'ID', comment: null, error: null };
        }
        if (type === 'uuid') {
            return { typeIdentifier: 'String', comment: null, error: null };
        }
        if (type === 'character') {
            return { typeIdentifier: 'String', comment: null, error: null };
        }
        if (type === 'character varying') {
            return { typeIdentifier: 'String', comment: null, error: null };
        }
        if (type === 'text') {
            return { typeIdentifier: 'String', comment: null, error: null };
        }
        if (type === 'smallint') {
            return { typeIdentifier: 'Int', comment: null, error: null };
        }
        if (type === 'integer') {
            return { typeIdentifier: 'Int', comment: null, error: null };
        }
        if (type === 'bigint') {
            return { typeIdentifier: 'Int', comment: null, error: null };
        }
        if (type === 'real') {
            return { typeIdentifier: 'Float', comment: null, error: null };
        }
        if (type === 'double precision') {
            return { typeIdentifier: 'Float', comment: null, error: null };
        }
        if (type === 'numeric') {
            return { typeIdentifier: 'Float', comment: null, error: null };
        }
        if (type === 'boolean') {
            return { typeIdentifier: 'Boolean', comment: null, error: null };
        }
        if (type === 'timestamp without time zone') {
            return { typeIdentifier: 'DateTime', comment: null, error: null };
        }
        if (type === 'timestamp with time zone') {
            return { typeIdentifier: 'DateTime', comment: null, error: null };
        }
        if (type === 'timestamp') {
            return { typeIdentifier: 'DateTime', comment: null, error: null };
        }
        if (type === 'json') {
            return { typeIdentifier: 'Json', comment: null, error: null };
        }
        if (type === 'date') {
            return { typeIdentifier: 'DateTime', comment: null, error: null };
        }
        return {
            typeIdentifier: null,
            comment: "Type '" + type + "' is not yet supported.",
            error: "Not able to handle type '" + type + "'",
        };
    };
    return PostgresConnector;
}());
exports.PostgresConnector = PostgresConnector;
//# sourceMappingURL=PostgresConnector.js.map