import { Table, TypeIdentifier, PrimaryKey, PostgresConnectionDetails } from '../types/common';
import * as _ from 'lodash';
export declare class PostgresConnector {
    client: any;
    connectionPromise: any;
    constructor(connectionDetails: PostgresConnectionDetails);
    queryRelations(schemaName: string): Promise<any>;
    queryTables(schemaName: string): Promise<_.Dictionary<any[]>>;
    queryPrimaryKeys(schemaName: string): Promise<PrimaryKey[]>;
    querySchemas(): Promise<any>;
    extractRelation(table: any, column: any, relations: any): {
        table: any;
    } | null;
    listSchemas(): Promise<string[]>;
    listTables(schemaName: string): Promise<Table[]>;
    parseDefaultValue(string: any): any;
    toTypeIdentifier(type: string, field: string, isPrimaryKey: boolean): {
        typeIdentifier: TypeIdentifier | null;
        comment: string | null;
        error: string | null;
    };
}
