import { Output, Client, Config } from 'prisma-cli-engine';
import { Cluster, Environment } from 'prisma-yml';
export interface GetEndpointParams {
    folderName: string;
}
export declare type DatabaseType = 'postgres' | 'mysql';
export interface DatabaseCredentials {
    type: DatabaseType;
    host: string;
    port: number;
    user: string;
    password: string;
    database?: string;
    alreadyData?: boolean;
    schema?: string;
    ssl?: boolean;
}
export interface GetEndpointResult {
    endpoint: string;
    cluster: Cluster | undefined;
    workspace: string | undefined;
    service: string;
    stage: string;
    localClusterRunning: boolean;
    database?: DatabaseCredentials;
    dockerComposeYml: string;
    datamodel: string;
    newDatabase: boolean;
    managementSecret?: string;
    writeDockerComposeYml: boolean;
}
export interface HandleChoiceInput {
    choice: string;
    loggedIn: boolean;
    folderName: string;
    localClusterRunning: boolean;
    clusters?: Cluster[];
}
export declare class EndpointDialog {
    out: Output;
    client: Client;
    env: Environment;
    config: Config;
    constructor(out: Output, client: Client, env: Environment, config: Config);
    getEndpoint(): Promise<GetEndpointResult>;
    encodeName(name: any): any;
    decodeName(name: any): any;
    printDatabaseConfig(credentials: DatabaseCredentials): any;
    printDatabaseService(type: DatabaseType): string;
    handleChoice({choice, loggedIn, folderName, localClusterRunning, clusters}: HandleChoiceInput): Promise<GetEndpointResult>;
    replaceLocalDockerHost(credentials: DatabaseCredentials): {
        host: any;
        type: DatabaseType;
        port: number;
        user: string;
        password: string;
        database?: string | undefined;
        alreadyData?: boolean | undefined;
        schema?: string | undefined;
        ssl?: boolean | undefined;
    };
    getDatabase(introspection?: boolean): Promise<DatabaseCredentials>;
    private getClusterAndWorkspaceFromChoice(choice);
    private getCloudClusters();
    private projectExists(cluster, name, stage, workspace);
    private listFiles();
    private isClusterOnline(endpoint);
    private getClusterQuestion(fromScratch, hasDockerComposeYml, clusters);
    private getClusterName(c);
    private getClusterChoice;
    private getDemoCluster();
    private askForDemoCluster();
    private getClusterDescription(c);
    private askForDatabaseType(introspect?);
    private convertChoices(choices);
    private askForStage(defaultName);
    private askForService(defaultName);
    private customEndpointSelector();
    private askForExistingData();
    private ask({message, defaultValue, key, validate, required, inputType});
    private getSillyName();
    private getPublicName();
}
