"use strict";
var __assign = (this && this.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = y[op[0] & 2 ? "return" : op[0] ? "throw" : "next"]) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [0, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var prisma_yml_1 = require("prisma-yml");
var childProcess = require("child_process");
var path = require("path");
var fs = require("fs-extra");
var chalk_1 = require("chalk");
var lodash_1 = require("lodash");
var getProcessForPort_1 = require("./getProcessForPort");
var getbin_1 = require("../deploy/getbin");
var semver = require("semver");
var spawn_1 = require("../../spawn");
var Raven = require("raven");
var debug = require('debug')('Docker');
var portfinder = require("portfinder");
var util_1 = require("../../util");
var crypto_1 = require("../../utils/crypto");
var constants_1 = require("./constants");
var Docker = /** @class */ (function () {
    function Docker(out, config, env, clusterName) {
        this.ymlPath = path.join(__dirname, 'docker/docker-compose.yml');
        this.frameworkYmlPath = path.join(__dirname, 'docker/framework-docker-compose.yml');
        this.envPath = path.join(__dirname, 'docker/env');
        this.frameworkEnvPath = path.join(__dirname, 'docker/oldenv');
        this.out = out;
        this.config = config;
        this.env = env;
        this.cluster = env.clusterByName(clusterName);
        this.clusterName = clusterName;
        if (this.cluster) {
            env.setActiveCluster(this.cluster);
        }
    }
    Object.defineProperty(Docker.prototype, "hostName", {
        get: function () {
            if (this.cluster) {
                // extract hostname: http://localhost:4466 -> localhost
                var regex = /^(?:https?:\/\/)?(?:[^@\n]+@)?(?:www\.)?([^:\/\n]+)/im;
                return this.cluster.baseUrl.match(regex)[1];
            }
            if (process.env.GRAPHCOOL_HOST) {
                return process.env.GRAPHCOOL_HOST;
            }
            if (process.env.DOCKER_HOST) {
                var ipRegex = /(\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3})/;
                var match = ipRegex.exec(process.env.DOCKER_HOST);
                if (match) {
                    return match[1];
                }
            }
            return 'localhost';
        },
        enumerable: true,
        configurable: true
    });
    Docker.prototype.init = function () {
        return __awaiter(this, void 0, void 0, function () {
            var port, endpoint, sliced, defaultVars, useHigherPort, nextDBPort;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        port = null;
                        if (this.cluster) {
                            endpoint = this.cluster.getDeployEndpoint();
                            sliced = endpoint.slice(endpoint.lastIndexOf(':') + 1);
                            port = sliced.slice(0, sliced.indexOf('/'));
                        }
                        defaultVars = this.getDockerEnvVars();
                        if (!!port) return [3 /*break*/, 5];
                        if (!(this.hostName.includes('localhost') ||
                            this.hostName.includes('127.0.0.1'))) return [3 /*break*/, 4];
                        return [4 /*yield*/, portfinder.getPortPromise({ port: constants_1.defaultPort })];
                    case 1:
                        port = _a.sent();
                        if (!(port > constants_1.defaultPort)) return [3 /*break*/, 3];
                        return [4 /*yield*/, this.askForHigherPort(String(constants_1.defaultPort), port)];
                    case 2:
                        useHigherPort = _a.sent();
                        if (!useHigherPort) {
                            port = constants_1.defaultPort;
                        }
                        _a.label = 3;
                    case 3: return [3 /*break*/, 5];
                    case 4:
                        port = constants_1.defaultPort;
                        _a.label = 5;
                    case 5: return [4 /*yield*/, this.setEnvVars(port, String(constants_1.defaultDBPort))];
                    case 6:
                        _a.sent();
                        return [4 /*yield*/, this.ps()];
                    case 7:
                        _a.sent();
                        this.psResult = this.stdout;
                        if (!(this.hostName.includes('localhost') ||
                            this.hostName.includes('127.0.0.1'))) return [3 /*break*/, 10];
                        return [4 /*yield*/, portfinder.getPortPromise({
                                port: constants_1.defaultDBPort,
                            })];
                    case 8:
                        nextDBPort = _a.sent();
                        if (!(nextDBPort > constants_1.defaultDBPort)) return [3 /*break*/, 10];
                        if (!!this.psResult.includes(":" + constants_1.defaultDBPort + "->")) return [3 /*break*/, 10];
                        return [4 /*yield*/, this.askIfDBPortShouldBeUnblocked(String(constants_1.defaultDBPort))];
                    case 9:
                        _a.sent();
                        _a.label = 10;
                    case 10: return [2 /*return*/];
                }
            });
        });
    };
    Docker.prototype.saveCluster = function () {
        var cluster = new prisma_yml_1.Cluster(this.out, this.clusterName, "http://" + this.hostName + ":" + this.envVars.PORT, this.privateKey);
        debug('Saving cluster', cluster);
        this.env.addCluster(cluster);
        this.env.saveGlobalRC();
        return cluster;
    };
    /**
     * returns true, if higher port should be used
     * @param port original port
     * @param higherPort alternative port
     */
    Docker.prototype.askIfDBPortShouldBeUnblocked = function (port) {
        return __awaiter(this, void 0, void 0, function () {
            var processForPort, question, confirmation, processName, instruction;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        processForPort = getProcessForPort_1.getProcessForPort(port);
                        if (!(processForPort &&
                            processForPort.command &&
                            processForPort.command.includes('docker'))) return [3 /*break*/, 4];
                        this.out.action.pause();
                        question = {
                            name: 'confirmation',
                            type: 'list',
                            message: "Port " + port + ", that is needed for the DB to be locally accessible, is already in use by " + getProcessForPort_1.printProcess(processForPort) + ". What do you want to do?",
                            choices: [
                                {
                                    value: 'stop',
                                    name: "Stop container running on " + port,
                                },
                                {
                                    value: 'cancel',
                                    name: 'Do not continue',
                                },
                            ],
                            pageSize: 8,
                        };
                        return [4 /*yield*/, this.out.prompt(question)];
                    case 1:
                        confirmation = (_a.sent()).confirmation;
                        if (!(confirmation === 'stop')) return [3 /*break*/, 3];
                        return [4 /*yield*/, this.stopContainersBlockingPort(port, true, true)];
                    case 2:
                        _a.sent();
                        this.out.action.resume();
                        return [2 /*return*/];
                    case 3:
                        if (confirmation === 'next') {
                            this.out.action.resume();
                            return [2 /*return*/];
                        }
                        if (confirmation === 'cancel') {
                            this.out.exit(0);
                        }
                        return [3 /*break*/, 5];
                    case 4:
                        processName = processForPort && processForPort.command
                            ? " (" + getProcessForPort_1.printProcess(processForPort) + ")"
                            : '';
                        instruction = processForPort && processForPort.processId
                            ? "You can kill the process by running " + chalk_1.default.bold.green("kill " + processForPort.processId)
                            : "You can find the process id by running " + chalk_1.default.bold.green("lsof -i:" + port + " -P -t -sTCP:LISTEN");
                        throw new Error("Port " + port + ", which is used for binding the database, is already in use by a process" + processName + " that could not be stopped by docker-compose.\nPlease close the process by hand. " + instruction);
                    case 5: return [2 /*return*/];
                }
            });
        });
    };
    /**
     * returns true, if higher port should be used
     * @param port original port
     * @param higherPort alternative port
     */
    Docker.prototype.askForHigherPort = function (port, higherPort) {
        return __awaiter(this, void 0, void 0, function () {
            var processForPort, question, confirmation;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        processForPort = getProcessForPort_1.getProcessForPort(port);
                        if (!processForPort) return [3 /*break*/, 4];
                        question = {
                            name: 'confirmation',
                            type: 'list',
                            message: "Port " + port + " is already in use by " + processForPort + ". What do you want to do?",
                            choices: [
                                {
                                    value: 'stop',
                                    name: "Stop container running on " + port,
                                },
                                {
                                    value: 'next',
                                    name: "Use port " + higherPort,
                                },
                                {
                                    value: 'cancel',
                                    name: 'Do not continue',
                                },
                            ],
                            pageSize: 8,
                        };
                        return [4 /*yield*/, this.out.prompt(question)];
                    case 1:
                        confirmation = (_a.sent()).confirmation;
                        if (!(confirmation === 'stop')) return [3 /*break*/, 3];
                        return [4 /*yield*/, this.stopContainersBlockingPort(port)];
                    case 2:
                        _a.sent();
                        return [2 /*return*/, false];
                    case 3:
                        if (confirmation === 'next') {
                            return [2 /*return*/, true];
                        }
                        if (confirmation === 'cancel') {
                            this.out.exit(0);
                        }
                        _a.label = 4;
                    case 4: return [4 /*yield*/, Raven.captureException(new Error('Port is blocked, but could not find blocking process'))];
                    case 5:
                        _a.sent();
                        return [2 /*return*/, true];
                }
            });
        });
    };
    Docker.prototype.up = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/, this.run('up', '-d', '--remove-orphans')];
            });
        });
    };
    Docker.prototype.ps = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                if (this.psResult) {
                    this.stdout = this.psResult;
                    return [2 /*return*/, this];
                }
                return [2 /*return*/, this.run('ps')];
            });
        });
    };
    Docker.prototype.start = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.init()];
                    case 1:
                        _a.sent();
                        return [2 /*return*/, this.run('start')];
                }
            });
        });
    };
    Docker.prototype.stop = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.init()];
                    case 1:
                        _a.sent();
                        return [2 /*return*/, this.run('stop')];
                }
            });
        });
    };
    Docker.prototype.restart = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.init()];
                    case 1:
                        _a.sent();
                        return [2 /*return*/, this.run('restart')];
                }
            });
        });
    };
    Docker.prototype.pull = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.init()];
                    case 1:
                        _a.sent();
                        return [2 /*return*/, this.run('pull')];
                }
            });
        });
    };
    Docker.prototype.kill = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/, this.run('kill')];
            });
        });
    };
    Docker.prototype.down = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/, this.run('down', '--remove-orphans', '-v', '--rmi', 'local')];
            });
        });
    };
    Docker.prototype.logs = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.init()];
                    case 1:
                        _a.sent();
                        return [2 /*return*/, this.run('logs')];
                }
            });
        });
    };
    Docker.prototype.nuke = function () {
        return __awaiter(this, void 0, void 0, function () {
            var port, endpoint, sliced, before_1, used, before;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (!this.cluster) return [3 /*break*/, 4];
                        endpoint = this.cluster.getDeployEndpoint();
                        sliced = endpoint.slice(endpoint.lastIndexOf(':') + 1);
                        port = sliced.slice(0, sliced.indexOf('/'));
                        return [4 /*yield*/, this.setEnvVars(port, String(constants_1.defaultDBPort))];
                    case 1:
                        _a.sent();
                        before_1 = Date.now();
                        this.out.action.start('Nuking local cluster');
                        return [4 /*yield*/, this.kill()];
                    case 2:
                        _a.sent();
                        return [4 /*yield*/, this.down()];
                    case 3:
                        _a.sent();
                        this.out.action.stop(util_1.prettyTime(Date.now() - before_1));
                        _a.label = 4;
                    case 4:
                        used = getProcessForPort_1.getProcessForPort(constants_1.defaultPort);
                        if (used) {
                            this.stopContainersBlockingPort(String(constants_1.defaultPort), true);
                        }
                        before = Date.now();
                        this.out.action.start('Booting fresh local development cluster');
                        return [4 /*yield*/, this.setEnvVars(String(constants_1.defaultPort), String(constants_1.defaultDBPort))];
                    case 5:
                        _a.sent();
                        return [4 /*yield*/, this.run('up', '-d', '--remove-orphans')];
                    case 6:
                        _a.sent();
                        this.out.action.stop(util_1.prettyTime(Date.now() - before));
                        return [2 /*return*/, this];
                }
            });
        });
    };
    Docker.prototype.getDockerEnvVars = function (db) {
        if (db === void 0) { db = true; }
        var file = fs.readFileSync(db ? this.envPath : this.frameworkEnvPath, 'utf-8');
        return this.parseEnv(file);
    };
    Docker.prototype.parseEnv = function (src) {
        var _this = this;
        var regex = /^\s*export\s*([a-zA-Z0-9\.\-_]+)\s*=(.*)?\s*/;
        var variableSyntax = new RegExp('\\${([ ~:a-zA-Z0-9._\'",\\-\\/\\(\\)]+?)}', 'g');
        var vars = src
            .toString()
            .split(/\r\n|\r|\n/g)
            .reduce(function (acc, line) {
            if (line.trim().startsWith('#')) {
                return acc;
            }
            var match = line.match(regex);
            if (!match) {
                return acc;
            }
            var key = match[1];
            var value = match[2] || '';
            var length = value ? value.length : 0;
            if (length > 0 && value.startsWith('"') && value.endsWith('"')) {
                value = value.replace(/\\n/gm, '\n');
            }
            value = value.replace(/(^['"]|['"]$)/g, '').trim();
            return __assign({}, acc, (_a = {}, _a[key] = value, _a));
            var _a;
        }, {});
        return lodash_1.mapValues(vars, function (value, key) {
            var match = variableSyntax.exec(value);
            if (match) {
                var varName = match[1];
                if (vars[varName]) {
                    var newValue = value.slice(0, match.index) +
                        vars[varName] +
                        value.slice(match.index + match[0].length);
                    return newValue;
                }
                else {
                    _this.out.warn("No variable for env var " + key + " and value " + match[0] + " found");
                }
            }
            return value;
        });
    };
    Docker.prototype.setEnvVars = function (port, dbPort) {
        return __awaiter(this, void 0, void 0, function () {
            var defaultVars, customVars;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        defaultVars = this.getDockerEnvVars();
                        customVars = {
                            PORT: port,
                            SCHEMA_MANAGER_ENDPOINT: "http://prisma-database:" + port + "/cluster/schema",
                            CLUSTER_ADDRESS: "http://" + this.hostName + ":" + port,
                            DB_PORT: dbPort,
                        };
                        this.envVars = __assign({}, process.env, defaultVars, customVars);
                        if (!(this.cluster ? this.cluster.local : true)) return [3 /*break*/, 2];
                        return [4 /*yield*/, this.setKeyPair()];
                    case 1:
                        _a.sent();
                        _a.label = 2;
                    case 2: return [2 /*return*/];
                }
            });
        });
    };
    Docker.prototype.setKeyPair = function () {
        return __awaiter(this, void 0, void 0, function () {
            var pair;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, crypto_1.createRsaKeyPair()];
                    case 1:
                        pair = _a.sent();
                        if (!this.envVars) {
                            this.envVars = {};
                        }
                        this.envVars.CLUSTER_PUBLIC_KEY = pair.public;
                        this.privateKey = pair.private;
                        debug(pair);
                        return [2 /*return*/];
                }
            });
        });
    };
    Docker.prototype.stopContainersBlockingPort = function (port, nuke, kill) {
        if (nuke === void 0) { nuke = false; }
        if (kill === void 0) { kill = false; }
        return __awaiter(this, void 0, void 0, function () {
            var output, containers, regex, blockingContainer, nameStart_1, error, defaultVars, FUNCTIONS_PORT, customVars, e_1, relatedContainers, containerNames;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        output = childProcess.execSync('docker ps').toString();
                        containers = this.parsePs(output);
                        regex = /\d+\.\d+\.\d+\.\d+:(\d+)->/;
                        blockingContainer = containers.find(function (c) {
                            var match = c.PORTS.match(regex);
                            return (match && match[1] === port) || false;
                        });
                        if (!blockingContainer) return [3 /*break*/, 10];
                        nameStart_1 = blockingContainer.NAMES.split('_')[0];
                        error = void 0;
                        if (!!kill) return [3 /*break*/, 7];
                        _a.label = 1;
                    case 1:
                        _a.trys.push([1, 6, , 7]);
                        if (!nameStart_1.startsWith('localdatabase')) return [3 /*break*/, 3];
                        this.setEnvVars(port, String(constants_1.defaultDBPort));
                        return [4 /*yield*/, this.nukeContainers(nameStart_1, true)];
                    case 2:
                        _a.sent();
                        return [3 /*break*/, 5];
                    case 3:
                        if (!nameStart_1.startsWith('local')) return [3 /*break*/, 5];
                        defaultVars = this.getDockerEnvVars(false);
                        FUNCTIONS_PORT = '60050';
                        customVars = {
                            PORT: String(port),
                            FUNCTIONS_PORT: FUNCTIONS_PORT,
                            FUNCTION_ENDPOINT_INTERNAL: "http://localfaas:" + FUNCTIONS_PORT,
                            FUNCTION_ENDPOINT_EXTERNAL: "http://" + this.hostName + ":" + FUNCTIONS_PORT,
                            CLUSTER_ADDRESS: "http://" + this.hostName + ":" + port,
                        };
                        this.envVars = __assign({}, process.env, defaultVars, customVars);
                        return [4 /*yield*/, this.nukeContainers(nameStart_1, false)];
                    case 4:
                        _a.sent();
                        _a.label = 5;
                    case 5: return [3 /*break*/, 7];
                    case 6:
                        e_1 = _a.sent();
                        error = e_1;
                        return [3 /*break*/, 7];
                    case 7:
                        if (!(error || kill)) return [3 /*break*/, 9];
                        relatedContainers = containers.filter(function (c) { return c.NAMES.split('_')[0] === nameStart_1; });
                        containerNames = relatedContainers.map(function (c) { return c.NAMES; });
                        return [4 /*yield*/, spawn_1.spawn('docker', [nuke ? 'kill' : 'stop'].concat(containerNames))];
                    case 8:
                        _a.sent();
                        _a.label = 9;
                    case 9:
                        this.out.log('');
                        return [3 /*break*/, 11];
                    case 10: throw new Error("Could not find container blocking port " + port + ". Please stop it by hand using " + chalk_1.default.bold.green('docker kill'));
                    case 11: return [2 /*return*/];
                }
            });
        });
    };
    Docker.prototype.nukeContainers = function (name, isDB) {
        if (isDB === void 0) { isDB = false; }
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.kill()];
                    case 1:
                        _a.sent();
                        return [4 /*yield*/, this.down()];
                    case 2:
                        _a.sent();
                        return [2 /*return*/];
                }
            });
        });
    };
    Docker.prototype.parsePs = function (output) {
        if (!output) {
            return [];
        }
        var lines = output.trim().split('\n');
        if (lines.length < 2) {
            return [];
        }
        var headers = {};
        var start = 0;
        lines[0].replace(/([A-Z\s]+?)($|\s{2,})/g, function (all, name, space, index) {
            headers[name] = {
                start: index,
                end: index + all.length,
            };
            // check if this header is at the end of the line
            if (space.length === 0) {
                headers[name].end = undefined;
            }
            return name + ' ';
        });
        var entries = [];
        for (var i = 1; i < lines.length; i++) {
            var entry = {};
            for (var key in headers) {
                if (headers.hasOwnProperty(key)) {
                    entry[key] = lines[i]
                        .substring(headers[key].start, headers[key].end)
                        .trim();
                }
            }
            entries.push(entry);
        }
        return entries;
    };
    Docker.prototype.run = function () {
        var argv = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            argv[_i] = arguments[_i];
        }
        return __awaiter(this, void 0, void 0, function () {
            var bin, defaultArgs, args, output;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.getBin()];
                    case 1:
                        bin = _a.sent();
                        defaultArgs = [
                            '-p',
                            JSON.stringify(this.clusterName),
                            '--file',
                            this.ymlPath,
                            '--project-directory',
                            this.config.cwd,
                        ];
                        args = defaultArgs.concat(argv);
                        // this.out.log(chalk.dim(`$ docker-compose ${argv.join(' ')}\n`))
                        debug({ bin: bin, args: args });
                        return [4 /*yield*/, spawn_1.spawn(bin, args, {
                                env: this.envVars,
                                cwd: this.config.cwd,
                            })];
                    case 2:
                        output = _a.sent();
                        debug(output);
                        this.stdout = output;
                        return [2 /*return*/, this];
                }
            });
        });
    };
    Docker.prototype.getBin = function () {
        return __awaiter(this, void 0, void 0, function () {
            var bin, output, regex, match, version, greater;
            return __generator(this, function (_a) {
                bin = getbin_1.getBinPath('docker-compose');
                if (!bin) {
                    throw new Error("Please install docker-compose in order to run \"prisma local\".\nLearn more here: https://docs.docker.com/compose/install/");
                }
                try {
                    output = childProcess.execSync('docker-compose -v').toString();
                }
                catch (e) {
                    throw new Error("Please install docker-compose 1.13.0 or greater in order to run \"prisma local\".\nLearn more here: https://docs.docker.com/compose/install/");
                }
                regex = /.*?(\d{1,2}\.\d{1,2}\.\d{1,2}),?/;
                match = output.match(regex);
                if (match && match[1]) {
                    version = match[1];
                    greater = semver.gt(version, '1.13.0');
                    if (!greater) {
                        throw new Error("Your docker-compose version " + version + " is too old. Please update to the latest docker-compose https://github.com/docker/compose/releases");
                    }
                }
                return [2 /*return*/, bin];
            });
        });
    };
    Docker.prototype.format = function (data) {
        return data
            .toString()
            .trim()
            .split(/\n/)
            .map(function (l) { return chalk_1.default.blue('docker') + "   " + l; })
            .join('\n');
    };
    return Docker;
}());
exports.default = Docker;
//# sourceMappingURL=Docker.js.map