import { Client, Output, Config } from 'prisma-cli-engine';
export interface Files {
    lists: string[];
    nodes: string[];
    relations: string[];
}
export interface State {
    lists: number;
    nodes: number;
    relations: number;
}
export declare class Importer {
    importPath: string;
    importDir: string;
    client: Client;
    types: string;
    out: Output;
    statePath: string;
    config: Config;
    isDir: boolean;
    constructor(importPath: string, types: string, client: Client, out: Output, config: Config);
    saveState(state: any): void;
    getState(): State;
    getNumber(fileName: string): number;
    unzip(): void;
    checkForErrors(result: any): void;
    upload(serviceName: string, stage: string, token?: string, workspaceSlug?: string): Promise<void>;
    validateFiles(files: Files): void;
    getFiles(): Files;
}
