"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = y[op[0] & 2 ? "return" : op[0] ? "throw" : "next"]) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [0, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var graphql_1 = require("graphql");
var lodash_1 = require("lodash");
var typesOrder = ['model', 'rest'];
var descriptions = {
    model: "Model Types",
    rest: "Other Types",
};
function fetchAndPrintSchema(client, serviceName, stageName, token) {
    return __awaiter(this, void 0, void 0, function () {
        var introspection, schema, sdl, document, groupedDefinitions, sortedDefinitions, newSdl, newDocument, countOffset, charOffset, header;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, client.introspect(serviceName, stageName, token)];
                case 1:
                    introspection = _a.sent();
                    schema = graphql_1.buildClientSchema(introspection);
                    sdl = graphql_1.printSchema(schema);
                    document = graphql_1.parse(sdl);
                    groupedDefinitions = lodash_1.groupBy(document.definitions, classifyDefinition);
                    sortedDefinitions = [];
                    typesOrder.map(function (type) {
                        var definitions = groupedDefinitions[type];
                        sortedDefinitions = sortedDefinitions.concat(definitions);
                    });
                    newSdl = graphql_1.print({
                        kind: graphql_1.Kind.DOCUMENT,
                        definitions: sortedDefinitions,
                    });
                    newDocument = graphql_1.parse(newSdl);
                    countOffset = 0;
                    charOffset = 0;
                    typesOrder.forEach(function (type, index) {
                        if (!groupedDefinitions[type]) {
                            return;
                        }
                        var definitionCount = groupedDefinitions[type].length;
                        var definitions = newDocument.definitions.slice(countOffset, definitionCount);
                        var start = definitions[0].loc.start;
                        var comment = (index > 0 ? '\n' : '') + "#\n# " + descriptions[type] + "\n#\n\n";
                        newSdl =
                            newSdl.slice(0, start + charOffset) +
                                comment +
                                newSdl.slice(start + charOffset);
                        charOffset += comment.length;
                        countOffset += definitionCount;
                    });
                    header = "# THIS FILE HAS BEEN AUTO-GENERATED BY \"PRISMA DEPLOY\"\n# DO NOT EDIT THIS FILE DIRECTLY\n\n";
                    return [2 /*return*/, header + newSdl];
            }
        });
    });
}
exports.fetchAndPrintSchema = fetchAndPrintSchema;
function classifyDefinition(def) {
    if (def.kind === 'ObjectTypeDefinition' &&
        def.interfaces &&
        def.interfaces.length > 0 &&
        def.interfaces[0].name.value === 'Node') {
        return 'model';
    }
    return 'rest';
}
//# sourceMappingURL=printSchema.js.map