import { Command, Flags } from 'prisma-cli-engine';
export default class Deploy extends Command {
    static topic: string;
    static description: string;
    static group: string;
    static allowAnyFlags: boolean;
    static help: string;
    static flags: Flags;
    private deploying;
    private showedHooks;
    private loggedIn;
    run(): Promise<void>;
    private getSillyName();
    private getPublicName();
    private localUp();
    private projectExists(cluster, name, stage, workspace);
    private addProject(cluster, name, stage, workspace);
    private deploy(stageName, serviceName, cluster, completeClusterName, force, dryRun, projectNew, workspace);
    private printHooks();
    private getProgress(applied, of);
    private seed(cluster, projectNew, serviceName, stageName, workspace);
    /**
     * Returns true if there was a change
     */
    private generateSchema(cluster, serviceName, stageName);
    private printResult(payload, force);
    private printEndpoints(cluster, serviceName, stageName, workspace?);
    private getCloudClusters();
    private clusterSelection(loggedIn);
    private getLocalClusterChoices();
    private getLoggedInChoices();
    private convertChoices(choices);
    private getPublicChoices();
}
export declare function isValidProjectName(projectName: string): boolean;
