"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var yamlParser = require("yaml-ast-parser");
/**
 * Comments out the current entry of a specific key in a yaml document and creates a new value next to it
 * @param key key in yaml document to comment out
 * @param newValue new value to add in the document
 */
function replaceYamlValue(input, key, newValue) {
    var ast = yamlParser.safeLoad(input);
    var position = getPosition(ast, key);
    var newEntry = key + ": " + newValue + "\n";
    if (!position) {
        return input + '\n' + newEntry;
    }
    return (input.slice(0, position.start) +
        '#' +
        input.slice(position.start, position.end) +
        newEntry +
        input.slice(position.end));
}
exports.replaceYamlValue = replaceYamlValue;
function getPosition(ast, key) {
    var mapping = ast.mappings.find(function (m) { return m.key.value === key; });
    if (!mapping) {
        return undefined;
    }
    return {
        start: mapping.startPosition,
        end: mapping.endPosition + 1,
    };
}
function commentOut(input, keys) {
    var output = input;
    for (var _i = 0, keys_1 = keys; _i < keys_1.length; _i++) {
        var key = keys_1[_i];
        var ast = yamlParser.safeLoad(output);
        var position = getPosition(ast, key);
        if (position) {
            output =
                output.slice(0, position.start) + '#' + output.slice(position.start);
        }
    }
    return output;
}
function migrateToEndpoint(input, endpoint) {
    var output = commentOut(input, ['service', 'stage', 'cluster']);
    return replaceYamlValue(output, 'endpoint', endpoint);
}
exports.migrateToEndpoint = migrateToEndpoint;
//# sourceMappingURL=yamlComment.js.map