"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var constants_1 = require("../constants");
var url_1 = require("url");
function getClusterName(origin) {
    if (constants_1.clusterEndpointMapReverse[origin]) {
        return constants_1.clusterEndpointMapReverse[origin];
    }
    if (origin.endsWith('prisma.sh')) {
        return origin.split('_')[0].replace(/https?:\/\//, '');
    }
    if (isLocal(origin)) {
        return 'local';
    }
    return 'default';
}
var getWorkspaceFromPrivateOrigin = function (origin) {
    return origin.split('_')[1].split('.')[0];
};
var isLocal = function (origin) {
    return origin.includes('localhost') || origin.includes('127.0.0.1');
};
function parseEndpoint(endpoint) {
    var url = new url_1.URL(endpoint);
    var splittedPath = url.pathname.split('/');
    var shared = url.origin.includes('eu1.prisma') || url.origin.includes('us1.prisma');
    var local = isLocal(url.origin);
    var isPrivate = !shared && !local && url.origin.includes('prisma.sh');
    // assuming, that the pathname always starts with a leading /, we always can ignore the first element of the split array
    var service = splittedPath.length > 3 ? splittedPath[2] : splittedPath[1] || 'default';
    var stage = splittedPath.length > 3 ? splittedPath[3] : splittedPath[2] || 'default';
    var workspaceSlug = splittedPath.length > 3 ? splittedPath[1] : undefined;
    if (isPrivate && !workspaceSlug) {
        workspaceSlug = getWorkspaceFromPrivateOrigin(url.origin);
    }
    return {
        clusterBaseUrl: url.origin,
        service: service,
        stage: stage,
        local: local,
        isPrivate: isPrivate,
        shared: shared,
        workspaceSlug: workspaceSlug,
        clusterName: getClusterName(url.origin),
    };
}
exports.parseEndpoint = parseEndpoint;
//# sourceMappingURL=parseEndpoint.js.map