
// A reusable array, to avoid allocating new arrays during multiplication.
// in column-major order:
const scratch = [
    /*m11*/0, /*m12*/0, /*m13*/0, /*m14*/0,
    /*m21*/0, /*m22*/0, /*m23*/0, /*m24*/0,
    /*m31*/0, /*m32*/0, /*m33*/0, /*m34*/0,
    /*m41*/0, /*m42*/0, /*m43*/0, /*m44*/0 ]

export
function multiplyAndApply(A, B, target) {

    //XXX: Are the following calculations faster hard coded (current), or as a loop?

    scratch[0]  = (A.m11 * B.m11) + (A.m21 * B.m12) + (A.m31 * B.m13) + (A.m41 * B.m14)
    scratch[4]  = (A.m11 * B.m21) + (A.m21 * B.m22) + (A.m31 * B.m23) + (A.m41 * B.m24)
    scratch[8]  = (A.m11 * B.m31) + (A.m21 * B.m32) + (A.m31 * B.m33) + (A.m41 * B.m34)
    scratch[12] = (A.m11 * B.m41) + (A.m21 * B.m42) + (A.m31 * B.m43) + (A.m41 * B.m44)

    scratch[1]  = (A.m12 * B.m11) + (A.m22 * B.m12) + (A.m32 * B.m13) + (A.m42 * B.m14)
    scratch[5]  = (A.m12 * B.m21) + (A.m22 * B.m22) + (A.m32 * B.m23) + (A.m42 * B.m24)
    scratch[9]  = (A.m12 * B.m31) + (A.m22 * B.m32) + (A.m32 * B.m33) + (A.m42 * B.m34)
    scratch[13] = (A.m12 * B.m41) + (A.m22 * B.m42) + (A.m32 * B.m43) + (A.m42 * B.m44)

    scratch[2]  = (A.m13 * B.m11) + (A.m23 * B.m12) + (A.m33 * B.m13) + (A.m43 * B.m14)
    scratch[6]  = (A.m13 * B.m21) + (A.m23 * B.m22) + (A.m33 * B.m23) + (A.m43 * B.m24)
    scratch[10] = (A.m13 * B.m31) + (A.m23 * B.m32) + (A.m33 * B.m33) + (A.m43 * B.m34)
    scratch[14] = (A.m13 * B.m41) + (A.m23 * B.m42) + (A.m33 * B.m43) + (A.m43 * B.m44)

    scratch[3]  = (A.m14 * B.m11) + (A.m24 * B.m12) + (A.m34 * B.m13) + (A.m44 * B.m14)
    scratch[7]  = (A.m14 * B.m21) + (A.m24 * B.m22) + (A.m34 * B.m23) + (A.m44 * B.m24)
    scratch[11] = (A.m14 * B.m31) + (A.m24 * B.m32) + (A.m34 * B.m33) + (A.m44 * B.m34)
    scratch[15] = (A.m14 * B.m41) + (A.m24 * B.m42) + (A.m34 * B.m43) + (A.m44 * B.m44)

    applyArrayValuesToDOMMatrix(scratch, target)
}

export
function applyArrayValuesToDOMMatrix(array, matrix) {
    const length = array.length

    if (length === 6) {
        matrix.m11 = array[0]
        matrix.m12 = array[1]
        matrix.m21 = array[2]
        matrix.m22 = array[3]
        matrix.m41 = array[4]
        matrix.m42 = array[5]
    }
    else if (length === 16) {
        matrix.m11 = array[0]
        matrix.m12 = array[1]
        matrix.m13 = array[2]
        matrix.m14 = array[3]
        matrix.m21 = array[4]
        matrix.m22 = array[5]
        matrix.m23 = array[6]
        matrix.m24 = array[7]
        matrix.m31 = array[8]
        matrix.m32 = array[9]
        matrix.m33 = array[10]
        matrix.m34 = array[11]
        matrix.m41 = array[12]
        matrix.m42 = array[13]
        matrix.m43 = array[14]
        matrix.m44 = array[15]
    }
}

export
function rotateAxisAngleArray(x, y, z, angle) {
    var sin = Math.sin;
    var cos = Math.cos;
    var pow = Math.pow;

    const halfAngle = degreesToRadians(angle/2)

    // TODO: should we provide a 6-item array here to signify 2D when the
    // rotation is about the Z axis (for example when calling rotateSelf)?
    // TODO: Performance can be improved by first detecting when x, y, or z of
    // the axis are zero or 1, and using a pre-simplified version of the
    // folowing math based on that condition.
    // TODO: Performance can be improved by using different equations (use trig
    // identities to find alternate formulas).
    return [
        1-2*(y*y + z*z)*pow(sin(halfAngle), 2),                           2*(x*y*pow(sin(halfAngle), 2) + z*sin(halfAngle)*cos(halfAngle)), 2*(x*z*pow(sin(halfAngle), 2) - y*sin(halfAngle)*cos(halfAngle)), 0,
        2*(x*y*pow(sin(halfAngle), 2) - z*sin(halfAngle)*cos(halfAngle)), 1-2*(x*x + z*z)*pow(sin(halfAngle), 2),                           2*(y*z*pow(sin(halfAngle), 2) + x*sin(halfAngle)*cos(halfAngle)), 0,
        2*(x*z*pow(sin(halfAngle), 2) + y*sin(halfAngle)*cos(halfAngle)), 2*(y*z*pow(sin(halfAngle), 2) - x*sin(halfAngle)*cos(halfAngle)), 1-2*(x*x + y*y)*pow(sin(halfAngle), 2),                           0,
        0,                                                                0,                                                                0,                                                                1 ]
}

function degreesToRadians(degrees) {
    return Math.PI/180 * degrees
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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