let privatesMap
const _ = function (o) {
    if (!privatesMap) {
        privatesMap = new WeakMap
        let privates = {}
        privatesMap.set(o, privates)
        return privates
    }
    else {
        let privates = privatesMap.get(o)

        if (privates === undefined) {
            privates = {}
            privatesMap.set(o, privates)
        }

        return privates
    }
}

export
var DOMPointReadOnly = function DOMPointReadOnly(x,y,z,w) {
    if (arguments.length === 1) {
        if (!isDOMPointInit(x))
            { throw new TypeError('Expected an object with x, y, z, and w properties') }

        _(this).x = x.x
        _(this).y = x.y
        _(this).z = x.z
        _(this).w = x.w
    }
    else if (arguments.length === 4)  {
        _(this).x = x || 0
        _(this).y = y || 0
        _(this).z = z || 0
        _(this).w = w || 0
    }
    else {
        throw new TypeError('Expected 1 or 4 arguments')
    }
};

var prototypeAccessors = { x: {},y: {},z: {},w: {} };

prototypeAccessors.x.get = function () { return _(this).x };
prototypeAccessors.y.get = function () { return _(this).y };
prototypeAccessors.z.get = function () { return _(this).z };
prototypeAccessors.w.get = function () { return _(this).w };

DOMPointReadOnly.prototype.matrixTransform = function matrixTransform (matrix) {
    let result = new this.constructor(this)
    // TODO
    //const x
    //const y
    //const z
    //const w

    return result
};

DOMPointReadOnly.fromPoint = function fromPoint (other) {
    return new this(other)
};

Object.defineProperties( DOMPointReadOnly.prototype, prototypeAccessors );

export
var DOMPoint = (function (DOMPointReadOnly) {
    function DOMPoint () {
        DOMPointReadOnly.apply(this, arguments);
    }

    if ( DOMPointReadOnly ) DOMPoint.__proto__ = DOMPointReadOnly;
    DOMPoint.prototype = Object.create( DOMPointReadOnly && DOMPointReadOnly.prototype );
    DOMPoint.prototype.constructor = DOMPoint;

    var prototypeAccessors$1 = { x: {},y: {},z: {},w: {} };

    prototypeAccessors$1.x.set = function (value) { _(this).x = value };
    prototypeAccessors$1.y.set = function (value) { _(this).y = value };
    prototypeAccessors$1.z.set = function (value) { _(this).z = value };
    prototypeAccessors$1.w.set = function (value) { _(this).w = value };

    Object.defineProperties( DOMPoint.prototype, prototypeAccessors$1 );

    return DOMPoint;
}(DOMPointReadOnly));

export default DOMPoint

function isDOMPointInit(o) {
    if (typeof o != 'object') { return false }

    if (
        'x' in o &&
        'y' in o &&
        'z' in o &&
        'w' in o
    ) { return true }

    return false
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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