'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.default = undefined;
exports.initDOMMatrixReadOnly = initDOMMatrixReadOnly;

var _DOMMatrix = require('./DOMMatrix');

var _DOMMatrix2 = _interopRequireDefault(_DOMMatrix);

var _utilities = require('./utilities');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// This matrix is represented internally in row-major format so that it is easy
// to look at visually. In a pair of coordinates (as in "m23") the first number
// is the column and the second is the row (so "m23" means column 2 row 3).
const identity = [
/*m11*/1, /*m21*/0, /*m31*/0, /*m41*/0,
/*m12*/0, /*m22*/1, /*m32*/0, /*m42*/0,
/*m13*/0, /*m23*/0, /*m33*/1, /*m43*/0,
/*m14*/0, /*m24*/0, /*m34*/0, /*m44*/1];

var DOMMatrixReadOnly = null;

function initDOMMatrixReadOnly() {
    if (DOMMatrixReadOnly) {
        return;
    }

    exports.default = DOMMatrixReadOnly = function () {
        function DOMMatrixReadOnly(numberSequence) {
            if (numberSequence === void 0) numberSequence = [];

            if (!(this instanceof _DOMMatrix2.default)) {
                throw new TypeError("DOMMatrixReadOnly can't be instantiated directly. Use DOMMatrix instead.");
            }

            var length = numberSequence.length;

            if (length === undefined || !(length === 6 || length === 16)) {
                throw new TypeError('DOMMatrix constructor argument "numberSequence" must be an array-like with 6 or 16 numbers.');
            }

            this._matrix = new Float64Array(identity);
            this._isIdentity = true;
            this._is2D = length === 6 ? true : false;

            (0, _utilities.applyArrayValuesToDOMMatrix)(numberSequence, this);
        }

        var prototypeAccessors = { is2D: {}, isIdentity: {}, a: {}, b: {}, c: {}, d: {}, e: {}, f: {}, m11: {}, m12: {}, m13: {}, m14: {}, m21: {}, m22: {}, m23: {}, m24: {}, m31: {}, m32: {}, m33: {}, m34: {}, m41: {}, m42: {}, m43: {}, m44: {} };

        // Immutable transform methods -------------------------------------------

        DOMMatrixReadOnly.prototype.translate = function translate(tx, ty, tz) {
            if (tz === void 0) tz = 0;

            return new _DOMMatrix2.default(this).translateSelf(tx, ty, tz);
        };

        DOMMatrixReadOnly.prototype.scale = function scale(scale$1, originX, originY) {
            if (originX === void 0) originX = 0;
            if (originY === void 0) originY = 0;

            return new _DOMMatrix2.default(this).scaleSelf(scale$1, originX, originY);
        };

        DOMMatrixReadOnly.prototype.scale3d = function scale3d(scale, originX, originY, originZ) {
            if (originX === void 0) originX = 0;
            if (originY === void 0) originY = 0;
            if (originZ === void 0) originZ = 0;

            return new _DOMMatrix2.default(this).scale3dSelf(scale, originX, originY, originZ);
        };

        DOMMatrixReadOnly.prototype.scaleNonUniform = function scaleNonUniform(scaleX, scaleY, scaleZ, originX, originY, originZ) {
            if (scaleY === void 0) scaleY = 1;
            if (scaleZ === void 0) scaleZ = 1;
            if (originX === void 0) originX = 0;
            if (originY === void 0) originY = 0;
            if (originZ === void 0) originZ = 0;

            return new _DOMMatrix2.default(this).scaleNonUniformSelf(scaleX, scaleY, scaleZ, originX, originY, originZ);
        };

        DOMMatrixReadOnly.prototype.rotate = function rotate(angle, originX, originY) {
            if (originX === void 0) originX = 0;
            if (originY === void 0) originY = 0;

            return new _DOMMatrix2.default(this).rotateSelf(angle, originX, originY);
        };

        // TODO
        DOMMatrixReadOnly.prototype.rotateFromVector = function rotateFromVector(x, y) {
            throw new Error('rotateFromVector is not implemented yet.');
        };

        DOMMatrixReadOnly.prototype.rotateAxisAngle = function rotateAxisAngle(x, y, z, angle) {
            return new _DOMMatrix2.default(this).rotateAxisAngleSelf(x, y, z, angle);
        };

        DOMMatrixReadOnly.prototype.skewX = function skewX(sx) {
            throw new Error('skewX is not implemented yet.');
        };
        DOMMatrixReadOnly.prototype.skewY = function skewY(sy) {
            throw new Error('skewY is not implemented yet.');
        };

        DOMMatrixReadOnly.prototype.multiply = function multiply(other) {
            return new _DOMMatrix2.default(this).multiplySelf(other);
        };

        DOMMatrixReadOnly.prototype.flipX = function flipX() {
            throw new Error('flipX is not implemented yet.');
        };
        DOMMatrixReadOnly.prototype.flipY = function flipY() {
            throw new Error('flipY is not implemented yet.');
        };
        DOMMatrixReadOnly.prototype.inverse = function inverse() {
            throw new Error('inverse is not implemented yet.');
        };

        DOMMatrixReadOnly.prototype.transformPoint = function transformPoint( /*optional DOMPointInit*/point) {
            throw new Error('transformPoint is not implemented yet.');
        };

        DOMMatrixReadOnly.prototype.toFloat32Array = function toFloat32Array() {
            return Float32Array.from(this._matrix);
        };
        DOMMatrixReadOnly.prototype.toFloat64Array = function toFloat64Array() {
            return Float64Array.from(this._matrix);
        };

        //stringifier() {} // What's this?

        prototypeAccessors.is2D.get = function () {
            return this._is2D;
        };

        /*
         * TODO: make sure this matches the spec.
         * TODO: Instead of calculating here, perhaps calculate and set
         * this._isIdentity in other operations, and simply return the internal one
         * here.
         */
        prototypeAccessors.isIdentity.get = function () {
            var this$1 = this;

            for (var i = 0, len = this._matrix.length; i < len; i += 1) {
                if (this$1._matrix[i] != identity[i]) {
                    return this$1._isIdentity = false;
                }
            }

            return this._isIdentity = true;
        };

        prototypeAccessors.a.get = function () {
            return this.m11;
        };
        prototypeAccessors.b.get = function () {
            return this.m12;
        };
        prototypeAccessors.c.get = function () {
            return this.m21;
        };
        prototypeAccessors.d.get = function () {
            return this.m22;
        };
        prototypeAccessors.e.get = function () {
            return this.m41;
        };
        prototypeAccessors.f.get = function () {
            return this.m42;
        };

        prototypeAccessors.m11.get = function () {
            return this._matrix[0];
        };
        prototypeAccessors.m12.get = function () {
            return this._matrix[4];
        };
        prototypeAccessors.m13.get = function () {
            return this._matrix[8];
        };
        prototypeAccessors.m14.get = function () {
            return this._matrix[12];
        };

        prototypeAccessors.m21.get = function () {
            return this._matrix[1];
        };
        prototypeAccessors.m22.get = function () {
            return this._matrix[5];
        };
        prototypeAccessors.m23.get = function () {
            return this._matrix[9];
        };
        prototypeAccessors.m24.get = function () {
            return this._matrix[13];
        };

        prototypeAccessors.m31.get = function () {
            return this._matrix[2];
        };
        prototypeAccessors.m32.get = function () {
            return this._matrix[6];
        };
        prototypeAccessors.m33.get = function () {
            return this._matrix[10];
        };
        prototypeAccessors.m34.get = function () {
            return this._matrix[14];
        };

        prototypeAccessors.m41.get = function () {
            return this._matrix[3];
        };
        prototypeAccessors.m42.get = function () {
            return this._matrix[7];
        };
        prototypeAccessors.m43.get = function () {
            return this._matrix[11];
        };
        prototypeAccessors.m44.get = function () {
            return this._matrix[15];
        };

        Object.defineProperties(DOMMatrixReadOnly.prototype, prototypeAccessors);

        return DOMMatrixReadOnly;
    }();
}

initDOMMatrixReadOnly();

// export default as a "live binding", not a static default.
exports.default = DOMMatrixReadOnly;
//# sourceMappingURL=DOMMatrixReadOnly.js.map