"use strict";

exports.__esModule = true;
exports.default = void 0;

var _helperPluginUtils = require("@babel/helper-plugin-utils");

var _core = require("@babel/core");

var _default = (0, _helperPluginUtils.declare)(function (api, options) {
  api.assertVersion(7);
  var loose = options.loose,
      assumeArray = options.assumeArray;

  if (loose === true && assumeArray === true) {
    throw new Error("The loose and assumeArray options cannot be used together in @babel/plugin-transform-for-of");
  }

  if (assumeArray) {
    return {
      visitor: {
        ForOfStatement: function ForOfStatement(path) {
          var scope = path.scope;
          var _path$node = path.node,
              left = _path$node.left,
              right = _path$node.right,
              body = _path$node.body;
          var i = scope.generateUidIdentifier("i");
          var array = scope.maybeGenerateMemoised(right, true);
          var inits = [_core.types.variableDeclarator(i, _core.types.numericLiteral(0))];

          if (array) {
            inits.push(_core.types.variableDeclarator(array, right));
          } else {
            array = right;
          }

          var item = _core.types.memberExpression(_core.types.cloneNode(array), _core.types.cloneNode(i), true);

          var assignment;

          if (_core.types.isVariableDeclaration(left)) {
            assignment = left;
            assignment.declarations[0].init = item;
          } else {
            assignment = _core.types.expressionStatement(_core.types.assignmentExpression("=", left, item));
          }

          var block = _core.types.toBlock(body);

          block.body.unshift(assignment);
          path.replaceWith(_core.types.forStatement(_core.types.variableDeclaration("let", inits), _core.types.binaryExpression("<", _core.types.cloneNode(i), _core.types.memberExpression(_core.types.cloneNode(array), _core.types.identifier("length"))), _core.types.updateExpression("++", _core.types.cloneNode(i)), block));
        }
      }
    };
  }

  var pushComputedProps = loose ? pushComputedPropsLoose : pushComputedPropsSpec;
  var buildForOfArray = (0, _core.template)("\n    for (var KEY = 0; KEY < ARR.length; KEY++) BODY;\n  ");
  var buildForOfLoose = (0, _core.template)("\n    for (var LOOP_OBJECT = OBJECT,\n             IS_ARRAY = Array.isArray(LOOP_OBJECT),\n             INDEX = 0,\n             LOOP_OBJECT = IS_ARRAY ? LOOP_OBJECT : LOOP_OBJECT[Symbol.iterator]();;) {\n      INTERMEDIATE;\n      if (IS_ARRAY) {\n        if (INDEX >= LOOP_OBJECT.length) break;\n        ID = LOOP_OBJECT[INDEX++];\n      } else {\n        INDEX = LOOP_OBJECT.next();\n        if (INDEX.done) break;\n        ID = INDEX.value;\n      }\n    }\n  ");
  var buildForOf = (0, _core.template)("\n    var ITERATOR_COMPLETION = true;\n    var ITERATOR_HAD_ERROR_KEY = false;\n    var ITERATOR_ERROR_KEY = undefined;\n    try {\n      for (var ITERATOR_KEY = OBJECT[Symbol.iterator](), STEP_KEY; !(ITERATOR_COMPLETION = (STEP_KEY = ITERATOR_KEY.next()).done); ITERATOR_COMPLETION = true) {\n      }\n    } catch (err) {\n      ITERATOR_HAD_ERROR_KEY = true;\n      ITERATOR_ERROR_KEY = err;\n    } finally {\n      try {\n        if (!ITERATOR_COMPLETION && ITERATOR_KEY.return != null) {\n          ITERATOR_KEY.return();\n        }\n      } finally {\n        if (ITERATOR_HAD_ERROR_KEY) {\n          throw ITERATOR_ERROR_KEY;\n        }\n      }\n    }\n  ");

  function _ForOfStatementArray(path) {
    var node = path.node,
        scope = path.scope;
    var nodes = [];
    var right = node.right;

    if (!_core.types.isIdentifier(right) || !scope.hasBinding(right.name)) {
      var uid = scope.generateUid("arr");
      nodes.push(_core.types.variableDeclaration("var", [_core.types.variableDeclarator(_core.types.identifier(uid), right)]));
      right = _core.types.identifier(uid);
    }

    var iterationKey = scope.generateUidIdentifier("i");
    var loop = buildForOfArray({
      BODY: node.body,
      KEY: iterationKey,
      ARR: right
    });

    _core.types.inherits(loop, node);

    _core.types.ensureBlock(loop);

    var iterationValue = _core.types.memberExpression(_core.types.cloneNode(right), _core.types.cloneNode(iterationKey), true);

    var left = node.left;

    if (_core.types.isVariableDeclaration(left)) {
      left.declarations[0].init = iterationValue;
      loop.body.body.unshift(left);
    } else {
      loop.body.body.unshift(_core.types.expressionStatement(_core.types.assignmentExpression("=", left, iterationValue)));
    }

    if (path.parentPath.isLabeledStatement()) {
      loop = _core.types.labeledStatement(path.parentPath.node.label, loop);
    }

    nodes.push(loop);
    return nodes;
  }

  function replaceWithArray(path) {
    if (path.parentPath.isLabeledStatement()) {
      path.parentPath.replaceWithMultiple(_ForOfStatementArray(path));
    } else {
      path.replaceWithMultiple(_ForOfStatementArray(path));
    }
  }

  return {
    visitor: {
      ForOfStatement: function ForOfStatement(path, state) {
        var right = path.get("right");

        if (right.isArrayExpression() || right.isGenericType("Array") || _core.types.isArrayTypeAnnotation(right.getTypeAnnotation())) {
          replaceWithArray(path);
          return;
        }

        var node = path.node;
        var build = pushComputedProps(path, state);
        var declar = build.declar;
        var loop = build.loop;
        var block = loop.body;
        path.ensureBlock();

        if (declar) {
          block.body.push(declar);
        }

        block.body = block.body.concat(node.body.body);

        _core.types.inherits(loop, node);

        _core.types.inherits(loop.body, node.body);

        if (build.replaceParent) {
          path.parentPath.replaceWithMultiple(build.node);
          path.remove();
        } else {
          path.replaceWithMultiple(build.node);
        }
      }
    }
  };

  function pushComputedPropsLoose(path, file) {
    var node = path.node,
        scope = path.scope,
        parent = path.parent;
    var left = node.left;
    var declar, id, intermediate;

    if (_core.types.isIdentifier(left) || _core.types.isPattern(left) || _core.types.isMemberExpression(left)) {
      id = left;
      intermediate = null;
    } else if (_core.types.isVariableDeclaration(left)) {
      id = scope.generateUidIdentifier("ref");
      declar = _core.types.variableDeclaration(left.kind, [_core.types.variableDeclarator(left.declarations[0].id, _core.types.identifier(id.name))]);
      intermediate = _core.types.variableDeclaration("var", [_core.types.variableDeclarator(_core.types.identifier(id.name))]);
    } else {
      throw file.buildCodeFrameError(left, "Unknown node type " + left.type + " in ForStatement");
    }

    var iteratorKey = scope.generateUidIdentifier("iterator");
    var isArrayKey = scope.generateUidIdentifier("isArray");
    var loop = buildForOfLoose({
      LOOP_OBJECT: iteratorKey,
      IS_ARRAY: isArrayKey,
      OBJECT: node.right,
      INDEX: scope.generateUidIdentifier("i"),
      ID: id,
      INTERMEDIATE: intermediate
    });

    var isLabeledParent = _core.types.isLabeledStatement(parent);

    var labeled;

    if (isLabeledParent) {
      labeled = _core.types.labeledStatement(parent.label, loop);
    }

    return {
      replaceParent: isLabeledParent,
      declar: declar,
      node: labeled || loop,
      loop: loop
    };
  }

  function pushComputedPropsSpec(path, file) {
    var node = path.node,
        scope = path.scope,
        parent = path.parent;
    var left = node.left;
    var declar;
    var stepKey = scope.generateUid("step");

    var stepValue = _core.types.memberExpression(_core.types.identifier(stepKey), _core.types.identifier("value"));

    if (_core.types.isIdentifier(left) || _core.types.isPattern(left) || _core.types.isMemberExpression(left)) {
      declar = _core.types.expressionStatement(_core.types.assignmentExpression("=", left, stepValue));
    } else if (_core.types.isVariableDeclaration(left)) {
      declar = _core.types.variableDeclaration(left.kind, [_core.types.variableDeclarator(left.declarations[0].id, stepValue)]);
    } else {
      throw file.buildCodeFrameError(left, "Unknown node type " + left.type + " in ForStatement");
    }

    var template = buildForOf({
      ITERATOR_HAD_ERROR_KEY: scope.generateUidIdentifier("didIteratorError"),
      ITERATOR_COMPLETION: scope.generateUidIdentifier("iteratorNormalCompletion"),
      ITERATOR_ERROR_KEY: scope.generateUidIdentifier("iteratorError"),
      ITERATOR_KEY: scope.generateUidIdentifier("iterator"),
      STEP_KEY: _core.types.identifier(stepKey),
      OBJECT: node.right
    });

    var isLabeledParent = _core.types.isLabeledStatement(parent);

    var tryBody = template[3].block.body;
    var loop = tryBody[0];

    if (isLabeledParent) {
      tryBody[0] = _core.types.labeledStatement(parent.label, loop);
    }

    return {
      replaceParent: isLabeledParent,
      declar: declar,
      loop: loop,
      node: template
    };
  }
});

exports.default = _default;