/*
 *   Copyright 2013 Lukas Jirkovsky
 *
 *   This file is part of Počasí v krajích.
 *
 *   Počasí v krajích is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, version 3 of the License.
 *
 *   Počasí v krajích is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with Počasí v krajích.  If not, see <http://www.gnu.org/licenses/>.
 */

package cz.jirkovsky.lukas.chmupocasi;

import android.app.Activity;
import android.app.Dialog;
import android.app.DialogFragment;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.TextView;

import cz.jirkovsky.lukas.chmupocasi.R;

/**
 * An "about application" dialog.
 */
@SuppressWarnings("WeakerAccess")
public class AboutDialog extends DialogFragment {
    @Override
    public void onCreate(Bundle savedInstanceState) {
        setCancelable(true);
        super.onCreate(savedInstanceState);
    }

    @Override
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog dialog = super.onCreateDialog(savedInstanceState);
        // disable the title for dialog
        dialog.getWindow().requestFeature(Window.FEATURE_NO_TITLE);
        return dialog;
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.about_dialog, container);
        TextView versionView = (TextView) view.findViewById(R.id.versionView);
        Activity activity = getActivity();
        if (activity != null) {
            try {
                versionView.setText(getString(R.string.about_version, activity.getPackageManager().getPackageInfo(getActivity().getPackageName(), 0).versionName));
            } catch (PackageManager.NameNotFoundException e) {
                //
            }
        }
        return view;
    }
}
