/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.bouncycastle.asn1;

import java.io.IOException;
import java.math.BigInteger;
import org.gudy.bouncycastle.asn1.ASN1Object;
import org.gudy.bouncycastle.asn1.ASN1OctetString;
import org.gudy.bouncycastle.asn1.ASN1TaggedObject;
import org.gudy.bouncycastle.asn1.DERObject;
import org.gudy.bouncycastle.asn1.DEROutputStream;

public class DEREnumerated
extends ASN1Object {
    byte[] bytes;

    public static DEREnumerated getInstance(Object obj) {
        if (obj == null || obj instanceof DEREnumerated) {
            return (DEREnumerated)obj;
        }
        if (obj instanceof ASN1OctetString) {
            return new DEREnumerated(((ASN1OctetString)obj).getOctets());
        }
        if (obj instanceof ASN1TaggedObject) {
            return DEREnumerated.getInstance(((ASN1TaggedObject)obj).getObject());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static DEREnumerated getInstance(ASN1TaggedObject obj, boolean explicit) {
        return DEREnumerated.getInstance(obj.getObject());
    }

    public DEREnumerated(int value) {
        this.bytes = BigInteger.valueOf(value).toByteArray();
    }

    public DEREnumerated(BigInteger value) {
        this.bytes = value.toByteArray();
    }

    public DEREnumerated(byte[] bytes) {
        this.bytes = bytes;
    }

    public BigInteger getValue() {
        return new BigInteger(this.bytes);
    }

    @Override
    void encode(DEROutputStream out) throws IOException {
        out.writeEncoded(10, this.bytes);
    }

    @Override
    boolean asn1Equals(DERObject o) {
        if (!(o instanceof DEREnumerated)) {
            return false;
        }
        DEREnumerated other = (DEREnumerated)o;
        if (this.bytes.length != other.bytes.length) {
            return false;
        }
        int i = 0;
        while (i != this.bytes.length) {
            if (this.bytes[i] != other.bytes[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return this.getValue().hashCode();
    }
}

