/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.torrent;

import java.util.ArrayList;
import java.util.Arrays;
import org.gudy.azureus2.core3.category.Category;
import org.gudy.azureus2.core3.category.CategoryManager;
import org.gudy.azureus2.core3.category.CategoryManagerListener;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.plugins.torrent.TorrentAttributeEvent;
import org.gudy.azureus2.plugins.utils.StaticUtilities;
import org.gudy.azureus2.pluginsimpl.local.torrent.BaseTorrentAttributeImpl;

public class TorrentAttributeCategoryImpl
extends BaseTorrentAttributeImpl {
    protected TorrentAttributeCategoryImpl() {
        CategoryManager.addCategoryManagerListener(new CategoryManagerListener(){

            @Override
            public void categoryAdded(final Category category) {
                TorrentAttributeEvent ev = new TorrentAttributeEvent(){

                    @Override
                    public int getType() {
                        return 1;
                    }

                    @Override
                    public TorrentAttribute getAttribute() {
                        return TorrentAttributeCategoryImpl.this;
                    }

                    @Override
                    public Object getData() {
                        return category.getName();
                    }
                };
                TorrentAttributeCategoryImpl.this.notifyListeners(ev);
            }

            @Override
            public void categoryChanged(Category category) {
            }

            @Override
            public void categoryRemoved(final Category category) {
                TorrentAttributeEvent ev = new TorrentAttributeEvent(){

                    @Override
                    public int getType() {
                        return 2;
                    }

                    @Override
                    public TorrentAttribute getAttribute() {
                        return TorrentAttributeCategoryImpl.this;
                    }

                    @Override
                    public Object getData() {
                        return category.getName();
                    }
                };
                TorrentAttributeCategoryImpl.this.notifyListeners(ev);
            }
        });
    }

    @Override
    public String getName() {
        return "Category";
    }

    @Override
    public String[] getDefinedValues() {
        Category[] categories = CategoryManager.getCategories();
        ArrayList<String> v = new ArrayList<String>();
        int i = 0;
        while (i < categories.length) {
            Category cat = categories[i];
            if (cat.getType() == 0) {
                v.add(cat.getName());
            }
            ++i;
        }
        String[] res = new String[v.size()];
        v.toArray(res);
        Arrays.sort(res, StaticUtilities.getFormatters().getAlphanumericComparator(true));
        return res;
    }

    @Override
    public void addDefinedValue(String name) {
        CategoryManager.createCategory(name);
    }

    @Override
    public void removeDefinedValue(String name) {
        Category cat = CategoryManager.getCategory(name);
        if (cat != null) {
            CategoryManager.removeCategory(cat);
        }
    }
}

