/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.DelayedEvent;
import org.gudy.azureus2.core3.util.SystemTime;

public class FrequencyLimitedDispatcher {
    private AERunnable target;
    private final long min_millis;
    private long last_run;
    private DelayedEvent delay_event;

    public FrequencyLimitedDispatcher(AERunnable _target, int _min_frequency_millis) {
        this.target = _target;
        this.min_millis = _min_frequency_millis;
    }

    public void setSingleThreaded() {
        final AERunnable old_target = this.target;
        this.target = new AERunnable(){
            private boolean running;
            private boolean pending;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void runSupport() {
                boolean was_pending;
                1 var1_1 = this;
                synchronized (var1_1) {
                    if (this.running) {
                        this.pending = true;
                        return;
                    }
                    this.running = true;
                }
                try {
                    old_target.runSupport();
                }
                catch (Throwable throwable) {
                    boolean was_pending2;
                    1 var3_3 = this;
                    synchronized (var3_3) {
                        this.running = false;
                        was_pending2 = this.pending;
                        this.pending = false;
                    }
                    if (was_pending2) {
                        FrequencyLimitedDispatcher.this.dispatch();
                    }
                    throw throwable;
                }
                1 var3_4 = this;
                synchronized (var3_4) {
                    this.running = false;
                    was_pending = this.pending;
                    this.pending = false;
                }
                if (was_pending) {
                    FrequencyLimitedDispatcher.this.dispatch();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch() {
        long now = SystemTime.getMonotonousTime();
        boolean run_it = false;
        FrequencyLimitedDispatcher frequencyLimitedDispatcher = this;
        synchronized (frequencyLimitedDispatcher) {
            if (this.delay_event == null) {
                long delay = this.min_millis - (now - this.last_run);
                if (now < this.last_run || delay <= 0L) {
                    this.last_run = now;
                    run_it = true;
                } else {
                    this.delay_event = new DelayedEvent("FreqLimDisp", delay, new AERunnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void runSupport() {
                            long now = SystemTime.getMonotonousTime();
                            FrequencyLimitedDispatcher frequencyLimitedDispatcher = FrequencyLimitedDispatcher.this;
                            synchronized (frequencyLimitedDispatcher) {
                                FrequencyLimitedDispatcher.this.last_run = now;
                                FrequencyLimitedDispatcher.this.delay_event = null;
                            }
                            FrequencyLimitedDispatcher.this.target.run();
                        }
                    });
                }
            }
        }
        if (run_it) {
            this.target.run();
        }
    }
}

