/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.server.impl.tcp.blocking;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerException;
import org.gudy.azureus2.core3.tracker.server.impl.tcp.TRTrackerServerProcessorTCP;
import org.gudy.azureus2.core3.tracker.server.impl.tcp.TRTrackerServerTCP;
import org.gudy.azureus2.core3.util.AETemporaryFileHandler;

public class TRBlockingServerProcessor
extends TRTrackerServerProcessorTCP {
    protected static final int KEEP_ALIVE_SOCKET_TIMEOUT = 30000;
    private static final LogIDs LOGID = LogIDs.TRACKER;
    protected final Socket socket;
    protected int timeout_ticks = 1;
    protected String current_request;

    protected TRBlockingServerProcessor(TRTrackerServerTCP _server, Socket _socket) {
        super(_server);
        this.socket = _socket;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void runSupport() {
        keep_alive = this.getServer().isKeepAliveEnabled();
        try {
            try {
                is = new BufferedInputStream(this.socket.getInputStream());
                do {
                    this.setTaskState("entry");
                    try {
                        if (keep_alive) {
                            this.socket.setSoTimeout(30000);
                            this.setTimeoutsDisabled(true);
                        } else {
                            this.socket.setSoTimeout(5000);
                        }
                    }
                    catch (Throwable var3_5) {
                        // empty catch block
                    }
                    this.setTaskState("reading header");
                    try {
                        block68: {
                            block70: {
                                block69: {
                                    block67: {
                                        buffer = new byte[16384];
                                        header_pos = 0;
                                        while (header_pos < buffer.length) {
                                            len = is.read(buffer, header_pos, 1);
                                            if (len != 1) {
                                                throw new Exception("Premature end of stream reading header");
                                            }
                                            if (++header_pos >= 4 && buffer[header_pos - 4] == 13 && buffer[header_pos - 3] == 10 && buffer[header_pos - 2] == 13 && buffer[header_pos - 1] == 10) break;
                                        }
                                        header = new String(buffer, 0, header_pos, "ISO-8859-1");
                                        if (Logger.isEnabled()) {
                                            log_str = header;
                                            pos = log_str.indexOf("\r\n");
                                            if (pos != -1) {
                                                log_str = log_str.substring(0, pos);
                                            }
                                            Logger.log(new LogEvent(TRBlockingServerProcessor.LOGID, "Tracker Server: received header '" + log_str + "' from " + this.socket.getRemoteSocketAddress()));
                                        }
                                        post_is = null;
                                        post_file = null;
                                        head = false;
                                        if (!header.startsWith("GET ")) break block67;
                                        this.timeout_ticks = 1;
                                        lowercase_header = header.toLowerCase();
                                        url_start = 4;
                                        break block68;
                                    }
                                    if (!header.startsWith("HEAD ")) break block69;
                                    this.timeout_ticks = 1;
                                    lowercase_header = header.toLowerCase();
                                    url_start = 5;
                                    head = true;
                                    break block68;
                                }
                                if (!header.startsWith("POST ")) break block70;
                                this.timeout_ticks = TRTrackerServerTCP.PROCESSING_POST_MULTIPLIER;
                                if (this.timeout_ticks == 0) {
                                    this.setTimeoutsDisabled(true);
                                }
                                this.setTaskState("reading content");
                                lowercase_header = header.toLowerCase();
                                url_start = 5;
                                cl_str = this.getHeaderField(header, lowercase_header, "content-length:");
                                chunk_read = false;
                                if (cl_str == null) {
                                    transfer_encoding_str = this.getHeaderField(header, lowercase_header, "transfer-encoding: ");
                                    chunk_read = transfer_encoding_str != null && transfer_encoding_str.equalsIgnoreCase("chunked") != false;
                                    cl_str = "0";
                                }
                                content_length = Integer.parseInt(cl_str);
                                baos = null;
                                fos = null;
                                try {
                                    if (content_length <= 262144) {
                                        baos = new ByteArrayOutputStream();
                                        data_os = baos;
                                    } else {
                                        post_file = AETemporaryFileHandler.createTempFile();
                                        post_file.deleteOnExit();
                                        fos = new FileOutputStream(post_file);
                                        data_os = fos;
                                    }
                                    if (!chunk_read) ** GOTO lbl104
                                    do {
                                        chunkSize = -1;
                                        while (true) {
                                            if ((val = is.read()) == -1) {
                                                throw new TRTrackerServerException("premature end of input stream (chunksize)");
                                            }
                                            if (val == 10) break;
                                            if (val == 13) continue;
                                            chunkSize = chunkSize == -1 ? 0 : (chunkSize <<= 4);
                                            chunkSize += Character.digit(val, 16);
                                        }
                                        if (chunkSize == -1) {
                                            throw new TRTrackerServerException("invalid chunk size");
                                        }
                                        if (chunkSize != 0) ** GOTO lbl96
                                        v0 = bad = is.read() == -1 || is.read() == -1;
                                        if (!bad) ** GOTO lbl104
                                        throw new TRTrackerServerException("premature end of input stream (NoTerminatingChunk)");
lbl-1000:
                                        // 1 sources

                                        {
                                            len = is.read(buffer, 0, Math.min(chunkSize, buffer.length));
                                            if (len < 0) {
                                                throw new TRTrackerServerException("premature end of input stream");
                                            }
                                            data_os.write(buffer, 0, len);
                                            chunkSize -= len;
lbl96:
                                            // 2 sources

                                            ** while (chunkSize > 0)
                                        }
lbl97:
                                        // 1 sources

                                    } while (!(bad = is.read() == -1 || is.read() == -1));
                                    throw new TRTrackerServerException("premature end of input stream (NoChunkEndMarker)");
lbl-1000:
                                    // 1 sources

                                    {
                                        len = is.read(buffer, 0, Math.min(content_length, buffer.length));
                                        if (len < 0) {
                                            throw new TRTrackerServerException("premature end of input stream");
                                        }
                                        data_os.write(buffer, 0, len);
                                        content_length -= len;
lbl104:
                                        // 3 sources

                                        ** while (content_length > 0)
                                    }
lbl105:
                                    // 1 sources

                                    if (baos != null) {
                                        post_is = new ByteArrayInputStream(baos.toByteArray());
                                    }
                                    fos.close();
                                    fos = null;
                                    post_is = new BufferedInputStream(new FileInputStream(post_file), 262144);
                                }
                                finally {
                                    if (baos != null) {
                                        try {
                                            baos.close();
                                        }
                                        catch (Throwable var20_33) {}
                                    }
                                    if (fos != null) {
                                        try {
                                            fos.close();
                                        }
                                        catch (Throwable var20_34) {}
                                    }
                                    if (post_is == null && post_file != null) {
                                        post_file.delete();
                                    }
                                }
                            }
                            pos = header.indexOf(32);
                            if (pos == -1) {
                                throw new TRTrackerServerException("header doesn't have space in right place");
                            }
                            this.timeout_ticks = 1;
                            lowercase_header = header.toLowerCase();
                            url_start = pos + 1;
                        }
                        this.setTaskState("processing request");
                        this.current_request = header;
                        try {
                            if (post_is == null) {
                                post_is = new ByteArrayInputStream(new byte[0]);
                            }
                            if ((url_end = header.indexOf(" ", url_start)) == -1) {
                                throw new TRTrackerServerException("header doesn't have space in right place");
                            }
                            url = header.substring(url_start, url_end).trim();
                            nl_pos = header.indexOf("\r\n", url_end);
                            if (nl_pos == -1) {
                                throw new TRTrackerServerException("header doesn't have nl in right place");
                            }
                            http_ver = header.substring(url_end, nl_pos).trim();
                            con_str = this.getHeaderField(header, lowercase_header, "connection:");
                            if (con_str == null) {
                                if (http_ver.equalsIgnoreCase("HTTP/1.0")) {
                                    keep_alive = false;
                                }
                            } else if (con_str.equalsIgnoreCase("close")) {
                                keep_alive = false;
                            }
                            if (head) {
                                head_response = new ByteArrayOutputStream(4096);
                                if (!this.processRequest(header, lowercase_header, url, (InetSocketAddress)this.socket.getLocalSocketAddress(), (InetSocketAddress)this.socket.getRemoteSocketAddress(), false, keep_alive, post_is, head_response, null)) {
                                    keep_alive = false;
                                }
                                head_data = head_response.toByteArray();
                                header_length = head_data.length;
                                i = 3;
                                while (i < head_data.length) {
                                    if (head_data[i - 3] == 13 && head_data[i - 2] == 10 && head_data[i - 1] == 13 && head_data[i] == 10) {
                                        header_length = i + 1;
                                        break;
                                    }
                                    ++i;
                                }
                                this.setTaskState("writing head response");
                                this.socket.getOutputStream().write(head_data, 0, header_length);
                                this.socket.getOutputStream().flush();
                                continue;
                            }
                            if (this.processRequest(header, lowercase_header, url, (InetSocketAddress)this.socket.getLocalSocketAddress(), (InetSocketAddress)this.socket.getRemoteSocketAddress(), false, keep_alive, post_is, this.socket.getOutputStream(), null)) continue;
                            keep_alive = false;
                        }
                        finally {
                            if (post_is != null) {
                                post_is.close();
                            }
                            if (post_file != null) {
                                post_file.delete();
                            }
                        }
                    }
                    catch (Throwable e) {
                        keep_alive = false;
                    }
                } while (keep_alive);
            }
            catch (Throwable var2_3) {
                this.setTaskState("final socket close");
                try {
                    this.socket.close();
                }
                catch (Throwable var22_36) {}
            }
        }
        finally {
            this.setTaskState("final socket close");
            try {
                this.socket.close();
            }
            catch (Throwable var22_38) {}
        }
    }

    protected String getHeaderField(String header, String lc_header, String field) {
        int start = lc_header.indexOf(field);
        if (start == -1) {
            return null;
        }
        int end = header.indexOf("\r\n", start);
        if (end == -1) {
            return null;
        }
        return header.substring(start + field.length(), end).trim();
    }

    @Override
    public boolean isActive() {
        try {
            if (!this.socket.getKeepAlive()) {
                this.socket.setKeepAlive(true);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return !this.socket.isClosed();
    }

    @Override
    public void interruptTask() {
        try {
            if (!this.areTimeoutsDisabled()) {
                --this.timeout_ticks;
                if (this.timeout_ticks <= 0) {
                    System.out.println("Tracker task interrupted in state '" + this.getTaskState() + "' : processing time limit exceeded for " + this.socket.getInetAddress());
                    this.socket.close();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

