/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.server.impl;

import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPosition;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerException;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerPeer;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerPeerBase;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerTorrent;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerTorrentListener;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerTorrentPeerListener;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerTorrentStats;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerImpl;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerNATChecker;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerPeerImpl;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerSimplePeer;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerTorrentStatsImpl;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.HostNameToIPResolver;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.SystemTime;

public class TRTrackerServerTorrentImpl
implements TRTrackerServerTorrent {
    private static final LogIDs LOGID = LogIDs.TRACKER;
    public static final int MIN_CACHE_ENTRY_SIZE = 10;
    public static final int MAX_UPLOAD_BYTES_PER_SEC = 0x300000;
    public static final int MAX_DOWNLOAD_BYTES_PER_SEC = 0x300000;
    public static final boolean USE_LIGHTWEIGHT_SEEDS = true;
    public static final int MAX_IP_OVERRIDE_PEERS = 64;
    public static final byte COMPACT_MODE_NONE = 0;
    public static final byte COMPACT_MODE_NORMAL = 1;
    public static final byte COMPACT_MODE_AZ = 2;
    public static final byte COMPACT_MODE_AZ_2 = 3;
    public static final byte COMPACT_MODE_XML = 16;
    private static final int QUEUED_PEERS_MAX_SWARM_SIZE = 32;
    private static final int QUEUED_PEERS_MAX = 32;
    private static final int QUEUED_PEERS_ADD_MAX = 3;
    private final TRTrackerServerImpl server;
    private final HashWrapper hash;
    private Map<HashWrapper, TRTrackerServerPeerImpl> peer_map = new HashMap<HashWrapper, TRTrackerServerPeerImpl>();
    private Map<String, TRTrackerServerPeerImpl> peer_reuse_map = new HashMap<String, TRTrackerServerPeerImpl>();
    private List<TRTrackerServerPeerImpl> peer_list = new ArrayList<TRTrackerServerPeerImpl>();
    private int peer_list_hole_count;
    private boolean peer_list_compaction_suspended;
    private List biased_peers = null;
    private int min_biased_peers = 0;
    private final Map lightweight_seed_map = new HashMap();
    private int seed_count;
    private int removed_count;
    private int ip_override_count;
    private int bad_NAT_count;
    private final Random random = new Random(SystemTime.getCurrentTime());
    private long last_scrape_calc_time;
    private Map last_scrape;
    private final LinkedHashMap announce_cache = new LinkedHashMap();
    private final TRTrackerServerTorrentStatsImpl stats;
    private final List listeners = new ArrayList();
    private List peer_listeners;
    private boolean deleted;
    private boolean enabled;
    private boolean map_size_diff_reported;
    private boolean ip_override_limit_exceeded_reported;
    private byte duplicate_peer_checker_index = 0;
    private byte[] duplicate_peer_checker = new byte[0];
    private URL[] redirects;
    private boolean caching_enabled = true;
    private LinkedList queued_peers;
    protected final AEMonitor this_mon = new AEMonitor("TRTrackerServerTorrent");
    private List explicit_manual_biased_peers;
    private int explicit_next_peer;

    public TRTrackerServerTorrentImpl(TRTrackerServerImpl _server, HashWrapper _hash, boolean _enabled) {
        this.server = _server;
        this.hash = _hash;
        this.enabled = _enabled;
        this.stats = new TRTrackerServerTorrentStatsImpl(this);
    }

    @Override
    public void setEnabled(boolean _enabled) {
        this.enabled = _enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setMinBiasedPeers(int num) {
        this.min_biased_peers = num;
    }

    @Override
    public void importPeers(List peers) {
        try {
            this.this_mon.enter();
            if (this.peer_map.size() > 0) {
                System.out.println("TRTrackerServerTorrent: ignoring peer import as torrent already active");
                return;
            }
            int i = 0;
            while (i < peers.size()) {
                TRTrackerServerPeerImpl peer = TRTrackerServerPeerImpl.importPeer((Map)peers.get(i));
                if (peer != null) {
                    try {
                        String reuse_key = String.valueOf(new String(peer.getIPAsRead(), "ISO-8859-1")) + ":" + peer.getTCPPort();
                        this.peer_map.put(peer.getPeerId(), peer);
                        this.peer_list.add(peer);
                        this.peer_reuse_map.put(reuse_key, peer);
                        if (peer.isSeed()) {
                            ++this.seed_count;
                        }
                        if (peer.isBiased()) {
                            if (this.biased_peers == null) {
                                this.biased_peers = new ArrayList();
                            }
                            this.biased_peers.add(peer);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    public TRTrackerServerPeerImpl peerContact(String url_parameters, String event2, HashWrapper peer_id, int tcp_port, int udp_port, int http_port, byte crypto_level, byte az_ver, String original_address, String ip_address, boolean ip_override, boolean loopback, String tracker_key, long uploaded, long downloaded, long left, long interval_requested, int up_speed, DHTNetworkPosition network_position) throws TRTrackerServerException {
        if (!this.enabled) {
            throw new TRTrackerServerException("Torrent temporarily disabled");
        }
        if (!HostNameToIPResolver.isNonDNSName(ip_address)) {
            try {
                ip_address = HostNameToIPResolver.syncResolve(ip_address).getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        TRTrackerServerException deferred_failure = null;
        try {
            this.this_mon.enter();
            this.handleRedirects(url_parameters, ip_address, false);
            int event_type = 2;
            if (event2 != null && event2.length() > 2) {
                char c = event2.charAt(2);
                event_type = c == 'm' ? 3 : (c == 'o' ? 4 : 1);
            }
            long now = SystemTime.getCurrentTime();
            int tracker_key_hash_code = tracker_key == null ? 0 : tracker_key.hashCode();
            TRTrackerServerPeerImpl peer = this.peer_map.get(peer_id);
            boolean new_peer = false;
            boolean peer_already_removed = false;
            boolean already_completed = false;
            long last_contact_time = 0L;
            long ul_diff = 0L;
            long dl_diff = 0L;
            long le_diff = 0L;
            byte[] ip_address_bytes = ip_address.getBytes("ISO-8859-1");
            if (peer == null) {
                String reuse_key = String.valueOf(new String(ip_address_bytes, "ISO-8859-1")) + ":" + tcp_port;
                byte last_NAT_status = loopback ? (byte)3 : 0;
                new_peer = true;
                TRTrackerServerPeerImpl old_peer = this.peer_reuse_map.get(reuse_key);
                if (old_peer != null) {
                    if (ip_override && !old_peer.isIPOverride()) {
                        throw new TRTrackerServerException("IP Override denied (existing '" + reuse_key + "' is not override)");
                    }
                    last_contact_time = old_peer.getLastContactTime();
                    already_completed = old_peer.getDownloadCompleted();
                    this.removePeer(old_peer, 5, null);
                    this.lightweight_seed_map.remove(old_peer.getPeerId());
                } else {
                    lightweightSeed lws = (lightweightSeed)this.lightweight_seed_map.remove(peer_id);
                    if (lws != null) {
                        last_contact_time = lws.getLastContactTime();
                        ul_diff = uploaded - lws.getUploaded();
                        if (ul_diff < 0L) {
                            ul_diff = 0L;
                        }
                        last_NAT_status = lws.getNATStatus();
                    } else {
                        last_contact_time = now;
                    }
                }
                if (event_type != 4) {
                    boolean biased;
                    Set biased_peer_set = this.server.getBiasedPeers();
                    boolean bl = biased = biased_peer_set != null && biased_peer_set.contains(ip_address);
                    if (ip_override && this.ip_override_count >= 64 && !loopback && !biased) {
                        if (!this.ip_override_limit_exceeded_reported) {
                            this.ip_override_limit_exceeded_reported = true;
                            Debug.out("Too many ip-override peers for " + ByteFormatter.encodeString(this.hash.getBytes()));
                        }
                        return null;
                    }
                    peer = new TRTrackerServerPeerImpl(peer_id, tracker_key_hash_code, ip_address_bytes, ip_override, tcp_port, udp_port, http_port, crypto_level, az_ver, last_contact_time, already_completed, last_NAT_status, up_speed, network_position);
                    if (ip_override) {
                        if (biased && !biased_peer_set.contains(original_address)) {
                            throw new TRTrackerServerException("IP Override denied (you are " + original_address + ")");
                        }
                        ++this.ip_override_count;
                    }
                    this.peer_map.put(peer_id, peer);
                    this.peer_list.add(peer);
                    this.peer_reuse_map.put(reuse_key, peer);
                    if (biased) {
                        peer.setBiased(true);
                        if (this.biased_peers == null) {
                            this.biased_peers = new ArrayList();
                        }
                        this.biased_peers.add(peer);
                    }
                    if (this.queued_peers != null) {
                        if (this.peer_map.size() > 32) {
                            this.queued_peers = null;
                        } else {
                            Iterator it = this.queued_peers.iterator();
                            while (it.hasNext()) {
                                QueuedPeer qp = (QueuedPeer)it.next();
                                if (!qp.sameAs(peer)) continue;
                                it.remove();
                                break;
                            }
                        }
                    }
                }
            } else {
                int existing_tracker_key_hash_code = peer.getKeyHashCode();
                if (existing_tracker_key_hash_code != tracker_key_hash_code && this.server.isKeyEnabled()) {
                    throw new TRTrackerServerException("Unauthorised: key mismatch ");
                }
                if (ip_override) {
                    Set biased_peer_set;
                    if (peer.isBiased() && ((biased_peer_set = this.server.getBiasedPeers()) == null || !biased_peer_set.contains(original_address))) {
                        throw new TRTrackerServerException("IP Override denied (you are " + original_address + ")");
                    }
                    if (!peer.isIPOverride()) {
                        throw new TRTrackerServerException("IP Override denied (existing entry not override)");
                    }
                }
                already_completed = peer.getDownloadCompleted();
                last_contact_time = peer.getLastContactTime();
                if (event_type == 4) {
                    this.removePeer(peer, event_type, url_parameters);
                    peer_already_removed = true;
                } else {
                    byte[] old_ip = peer.getIPAsRead();
                    int old_port = peer.getTCPPort();
                    if (peer.update(ip_address_bytes, tcp_port, udp_port, http_port, crypto_level, az_ver, up_speed, network_position)) {
                        String old_key = String.valueOf(new String(old_ip, "ISO-8859-1")) + ":" + old_port;
                        String new_key = String.valueOf(new String(ip_address_bytes, "ISO-8859-1")) + ":" + tcp_port;
                        TRTrackerServerPeerImpl old_peer = this.peer_reuse_map.get(new_key);
                        if (old_peer != null) {
                            this.removePeer(old_peer, 5, null);
                        }
                        if (this.peer_reuse_map.remove(old_key) == null) {
                            Debug.out("TRTrackerServerTorrent: IP address change: '" + old_key + "' -> '" + new_key + "': old key not found");
                        }
                        this.peer_reuse_map.put(new_key, peer);
                    }
                }
            }
            long new_timeout = now + interval_requested * 1000L * 3L;
            if (peer != null) {
                long elapsed_time;
                peer.setTimeout(now, new_timeout);
                if (!new_peer) {
                    ul_diff = uploaded - peer.getUploaded();
                    dl_diff = downloaded - peer.getDownloaded();
                }
                if ((elapsed_time = now - last_contact_time) == 0L) {
                    elapsed_time = 25L;
                }
                long ul_rate = ul_diff * 1000L / elapsed_time;
                long dl_rate = dl_diff * 1000L / elapsed_time;
                if (ul_rate > 0x300000L) {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "TRTrackerPeer: peer " + peer.getIPRaw() + "/" + new String(peer.getPeerId().getHash()) + " reported an upload rate of " + ul_rate / 1024L + " KiB/s per second"));
                    }
                    ul_diff = 0L;
                }
                if (dl_rate > 0x300000L) {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "TRTrackerPeer: peer " + peer.getIPRaw() + "/" + new String(peer.getPeerId().getHash()) + " reported a download rate of " + dl_rate / 1024L + " KiB/s per second"));
                    }
                    dl_diff = 0L;
                }
                le_diff = event_type == 4 ? 0L : left - peer.getAmountLeft();
                boolean was_seed = new_peer ? false : peer.isSeed();
                peer.setStats(uploaded, downloaded, left);
                boolean is_seed = peer.isSeed();
                if (event_type != 4 && !was_seed && is_seed) {
                    ++this.seed_count;
                }
                if (!peer_already_removed) {
                    try {
                        this.peerEvent(peer, event_type, url_parameters);
                    }
                    catch (TRTrackerServerException e) {
                        deferred_failure = e;
                    }
                }
            }
            this.stats.addAnnounce(ul_diff, dl_diff, le_diff, peer != null && peer.isBiased());
            if (event_type == 3 && !already_completed) {
                peer.setDownloadCompleted();
                this.stats.addCompleted();
            }
            if (peer != null && peer.isSeed()) {
                int seed_limit = TRTrackerServerImpl.getSeedLimit();
                if (seed_limit != 0 && this.seed_count > seed_limit && !loopback) {
                    if (!peer_already_removed) {
                        this.removePeer(peer, 6, null);
                    }
                    throw new TRTrackerServerException("too many seeds");
                }
                int seed_retention = TRTrackerServerImpl.getMaxSeedRetention();
                if (seed_retention != 0 && this.seed_count > seed_retention) {
                    int to_remove = seed_retention / 20 + 1;
                    try {
                        this.peer_list_compaction_suspended = true;
                        int bad_nat_loop = TRTrackerServerNATChecker.getSingleton().isEnabled() ? 0 : 1;
                        while (bad_nat_loop < 2) {
                            int i = 0;
                            while (i < this.peer_list.size()) {
                                TRTrackerServerPeerImpl this_peer = this.peer_list.get(i);
                                if (this_peer != null && this_peer.isSeed() && !this_peer.isBiased()) {
                                    boolean bad_nat = this_peer.isNATStatusBad();
                                    if (bad_nat_loop == 0 && bad_nat || bad_nat_loop == 1) {
                                        this.lightweight_seed_map.put(this_peer.getPeerId(), new lightweightSeed(now, new_timeout, this_peer.getUploaded(), this_peer.getNATStatus()));
                                        this.removePeer(this_peer, i, 6, null);
                                        if (--to_remove == 0) break;
                                    }
                                }
                                ++i;
                            }
                            if (to_remove == 0) {
                                break;
                            }
                            ++bad_nat_loop;
                        }
                    }
                    finally {
                        this.peer_list_compaction_suspended = false;
                    }
                    this.checkForPeerListCompaction(false);
                }
            }
            if (deferred_failure != null) {
                if (peer != null && !peer_already_removed) {
                    this.removePeer(peer, 7, url_parameters);
                }
                throw deferred_failure;
            }
            TRTrackerServerPeerImpl tRTrackerServerPeerImpl = peer;
            return tRTrackerServerPeerImpl;
        }
        catch (UnsupportedEncodingException e) {
            throw new TRTrackerServerException("Encoding fails", e);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void peerQueued(String ip, int tcp_port, int udp_port, int http_port, byte crypto_level, byte az_ver, long timeout_secs, boolean seed) {
        if (this.peer_map.size() >= 32 || tcp_port == 0) {
            return;
        }
        try {
            this.this_mon.enter();
            Set biased_peer_set = this.server.getBiasedPeers();
            boolean biased = biased_peer_set != null && biased_peer_set.contains(ip);
            QueuedPeer new_qp = new QueuedPeer(ip, tcp_port, udp_port, http_port, crypto_level, az_ver, (int)timeout_secs, seed, biased);
            String reuse_key = String.valueOf(new_qp.getIP()) + ":" + tcp_port;
            if (this.peer_reuse_map.containsKey(reuse_key)) {
                return;
            }
            boolean add = true;
            if (this.queued_peers != null) {
                Iterator it = this.queued_peers.iterator();
                while (it.hasNext()) {
                    QueuedPeer qp = (QueuedPeer)it.next();
                    if (!qp.sameAs(new_qp)) continue;
                    it.remove();
                    this.queued_peers.add(new_qp);
                    return;
                }
                if (this.queued_peers.size() >= 32) {
                    QueuedPeer oldest = null;
                    for (QueuedPeer qp : this.queued_peers) {
                        if (qp.isBiased()) continue;
                        if (oldest == null) {
                            oldest = qp;
                            continue;
                        }
                        if (qp.getCreateTime() >= oldest.getCreateTime()) continue;
                        oldest = qp;
                    }
                    if (oldest == null) {
                        add = false;
                    } else {
                        this.queued_peers.remove(oldest);
                    }
                }
            } else {
                this.queued_peers = new LinkedList();
            }
            if (add) {
                this.queued_peers.addFirst(new_qp);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void remove(TRTrackerServerPeerBase peer) {
        try {
            this.this_mon.enter();
            if (peer instanceof TRTrackerServerPeerImpl) {
                int index;
                TRTrackerServerPeerImpl pi = (TRTrackerServerPeerImpl)peer;
                if (this.peer_map.containsKey(pi.getPeerId()) && (index = this.peer_list.indexOf(pi)) != -1) {
                    this.removePeer(pi, index, 7, null);
                }
            } else if (this.queued_peers != null) {
                this.queued_peers.remove(peer);
                if (this.queued_peers.size() == 0) {
                    this.queued_peers = null;
                }
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void removePeer(TRTrackerServerPeerImpl peer, int reason, String url_parameters) {
        this.removePeer(peer, -1, reason, url_parameters);
    }

    protected void removePeer(TRTrackerServerPeerImpl peer, int peer_list_index, int reason, String url_parameters) {
        try {
            TRTrackerServerPeerImpl o;
            this.this_mon.enter();
            if (peer.isIPOverride()) {
                --this.ip_override_count;
            }
            this.stats.removeLeft(peer.getAmountLeft());
            if (this.peer_map.size() != this.peer_reuse_map.size() && !this.map_size_diff_reported) {
                this.map_size_diff_reported = true;
                Debug.out("TRTrackerServerTorrent::removePeer: maps size different ( " + this.peer_map.size() + "/" + this.peer_reuse_map.size() + ")");
            }
            if ((o = this.peer_map.remove(peer.getPeerId())) == null) {
                Debug.out(" TRTrackerServerTorrent::removePeer: peer_map doesn't contain peer");
            } else {
                try {
                    this.peerEvent(peer, reason, url_parameters);
                }
                catch (TRTrackerServerException tRTrackerServerException) {
                    // empty catch block
                }
            }
            if (peer_list_index == -1) {
                int peer_index = this.peer_list.indexOf(peer);
                if (peer_index == -1) {
                    Debug.out(" TRTrackerServerTorrent::removePeer: peer_list doesn't contain peer");
                } else {
                    this.peer_list.set(peer_index, null);
                }
            } else if (this.peer_list.get(peer_list_index) == peer) {
                this.peer_list.set(peer_list_index, null);
            } else {
                Debug.out(" TRTrackerServerTorrent::removePeer: peer_list doesn't contain peer at index");
            }
            ++this.peer_list_hole_count;
            this.checkForPeerListCompaction(false);
            try {
                o = this.peer_reuse_map.remove(String.valueOf(new String(peer.getIPAsRead(), "ISO-8859-1")) + ":" + peer.getTCPPort());
                if (o == null) {
                    Debug.out(" TRTrackerServerTorrent::removePeer: peer_reuse_map doesn't contain peer");
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            if (this.biased_peers != null) {
                this.biased_peers.remove(peer);
            }
            if (peer.isSeed()) {
                --this.seed_count;
            }
            ++this.removed_count;
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void updateBiasedPeers(Set biased_peers_set) {
        try {
            this.this_mon.enter();
            Iterator<TRTrackerServerPeerImpl> it = this.peer_list.iterator();
            if (it.hasNext() && this.biased_peers == null) {
                this.biased_peers = new ArrayList();
            }
            while (it.hasNext()) {
                TRTrackerServerPeerImpl this_peer = it.next();
                if (this_peer == null) continue;
                boolean biased = biased_peers_set.contains(this_peer.getIPRaw());
                this_peer.setBiased(biased);
                if (biased) {
                    if (this.biased_peers.contains(this_peer)) continue;
                    this.biased_peers.add(this_peer);
                    continue;
                }
                this.biased_peers.remove(this_peer);
            }
            if (this.queued_peers != null) {
                for (QueuedPeer peer : this.queued_peers) {
                    peer.setBiased(biased_peers_set.contains(peer.getIP()));
                }
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public TRTrackerServerTorrent addLink(String link) {
        return this.server.addLink(link, this);
    }

    @Override
    public void removeLink(String link) {
        this.server.removeLink(link, this);
    }

    public Map exportAnnounceToMap(String ip_address, HashMap preprocess_map, TRTrackerServerPeerImpl requesting_peer, boolean include_seeds, int num_want, long interval, long min_interval, boolean no_peer_id, byte compact_mode, byte crypto_level, DHTNetworkPosition network_position) {
        try {
            HashMap<String, Object> peer;
            Map rep_peer;
            LinkedList rep_peers;
            boolean requester_is_biased;
            Set remove_ips;
            ArrayList<TRTrackerServerSimplePeer> explicit_biased_peers;
            ArrayList<TRTrackerServerPeerImpl> explicit_limited_peers;
            boolean add_to_cache;
            boolean send_peer_ids;
            boolean nat_warning;
            long now;
            block123: {
                int total_peers;
                block124: {
                    Set bp;
                    this.this_mon.enter();
                    now = SystemTime.getCurrentTime();
                    nat_warning = requesting_peer != null && requesting_peer.getNATStatus() == 4;
                    total_peers = this.peer_map.size();
                    int cache_millis = TRTrackerServerImpl.getAnnounceCachePeriod();
                    send_peer_ids = TRTrackerServerImpl.getSendPeerIds();
                    if (no_peer_id || compact_mode != 0) {
                        send_peer_ids = false;
                    }
                    add_to_cache = false;
                    int max_peers = TRTrackerServerImpl.getMaxPeersToSend();
                    if (num_want < 0) {
                        num_want = total_peers;
                    }
                    if (max_peers > 0 && num_want > max_peers) {
                        num_want = max_peers;
                    }
                    explicit_limited_peers = null;
                    explicit_biased_peers = null;
                    remove_ips = null;
                    if (requesting_peer != null && this.peer_listeners != null) {
                        int i = 0;
                        while (i < this.peer_listeners.size()) {
                            try {
                                Map reply = ((TRTrackerServerTorrentPeerListener)this.peer_listeners.get(i)).eventOccurred(this, requesting_peer, 8, null);
                                if (reply != null) {
                                    List biased_peers;
                                    List limited_peers = (List)reply.get("limited_peers");
                                    if (limited_peers != null) {
                                        if (explicit_limited_peers == null) {
                                            explicit_limited_peers = new ArrayList<TRTrackerServerPeerImpl>();
                                        }
                                        int j = 0;
                                        while (j < limited_peers.size()) {
                                            Map peer_map = (Map)limited_peers.get(j);
                                            String ip = (String)peer_map.get("ip");
                                            int port = ((Long)peer_map.get("port")).intValue();
                                            String reuse_key = String.valueOf(ip) + ":" + port;
                                            TRTrackerServerPeerImpl peer2 = this.peer_reuse_map.get(reuse_key);
                                            if (peer2 != null && !explicit_limited_peers.contains(peer2)) {
                                                explicit_limited_peers.add(peer2);
                                            }
                                            ++j;
                                        }
                                    }
                                    if ((biased_peers = (List)reply.get("biased_peers")) != null) {
                                        if (explicit_biased_peers == null) {
                                            explicit_biased_peers = new ArrayList<TRTrackerServerSimplePeer>();
                                        }
                                        int j = 0;
                                        while (j < biased_peers.size()) {
                                            Map peer_map = (Map)biased_peers.get(j);
                                            String ip = (String)peer_map.get("ip");
                                            int port = ((Long)peer_map.get("port")).intValue();
                                            String reuse_key = String.valueOf(ip) + ":" + port;
                                            TRTrackerServerSimplePeer peer3 = this.peer_reuse_map.get(reuse_key);
                                            if (peer3 == null) {
                                                peer3 = new temporaryBiasedSeed(ip, port);
                                            }
                                            if (!explicit_biased_peers.contains(peer3)) {
                                                explicit_biased_peers.add(peer3);
                                            }
                                            ++j;
                                        }
                                    }
                                    remove_ips = (Set)reply.get("remove_ips");
                                }
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                            ++i;
                        }
                    }
                    requester_is_biased = requesting_peer == null ? ((bp = this.server.getBiasedPeers()) == null ? false : bp.contains(ip_address)) : requesting_peer.isBiased();
                    if (this.caching_enabled && explicit_limited_peers == null && explicit_biased_peers == null && !requester_is_biased && remove_ips == null && !nat_warning && preprocess_map.size() == 0 && cache_millis > 0 && num_want >= 10 && total_peers >= TRTrackerServerImpl.getAnnounceCachePeerThreshold() && crypto_level != 2) {
                        announceCacheEntry entry;
                        network_position = null;
                        Iterator it = this.announce_cache.keySet().iterator();
                        while (it.hasNext()) {
                            Integer key = (Integer)it.next();
                            entry = (announceCacheEntry)this.announce_cache.get(key);
                            if (now - entry.getTime() <= (long)cache_millis) continue;
                            it.remove();
                        }
                        int i = num_want / 10;
                        while (i > num_want / 20) {
                            entry = (announceCacheEntry)this.announce_cache.get(new Integer(i));
                            if (entry != null) {
                                if (now - entry.getTime() > (long)cache_millis) {
                                    this.announce_cache.remove(new Integer(i));
                                } else if (entry.getSendPeerIds() == send_peer_ids && entry.getCompactMode() == compact_mode) {
                                    Map map = entry.getData();
                                    return map;
                                }
                            }
                            --i;
                        }
                        add_to_cache = true;
                    }
                    rep_peers = new LinkedList();
                    if (num_want <= 0 || explicit_limited_peers != null) break block123;
                    if (num_want < total_peers) break block124;
                    int i = 0;
                    while (i < this.peer_list.size()) {
                        block125: {
                            HashMap<String, Object> rep_peer2;
                            TRTrackerServerPeerImpl peer4;
                            block128: {
                                block127: {
                                    block126: {
                                        peer4 = this.peer_list.get(i);
                                        if (peer4 == null || peer4 == requesting_peer) break block125;
                                        if (now <= peer4.getTimeout()) break block126;
                                        this.removePeer(peer4, i, 5, null);
                                        break block125;
                                    }
                                    if (peer4.getTCPPort() == 0 || crypto_level == 0 && peer4.getCryptoLevel() == 2 || remove_ips != null && remove_ips.contains(new String(peer4.getIP())) || !include_seeds && peer4.isSeed()) break block125;
                                    rep_peer2 = new HashMap<String, Object>(3);
                                    if (send_peer_ids) {
                                        rep_peer2.put("peer id", peer4.getPeerId().getHash());
                                    }
                                    if (compact_mode == 0) break block127;
                                    byte[] peer_bytes = peer4.getIPAddressBytes();
                                    if (peer_bytes == null) break block125;
                                    rep_peer2.put("ip", peer_bytes);
                                    if (compact_mode >= 2) {
                                        rep_peer2.put("azver", new Long(peer4.getAZVer()));
                                        rep_peer2.put("azudp", new Long(peer4.getUDPPort()));
                                        if (peer4.isSeed()) {
                                            rep_peer2.put("azhttp", new Long(peer4.getHTTPPort()));
                                        }
                                        if (compact_mode >= 16) {
                                            rep_peer2.put("ip", peer4.getIPAsRead());
                                        } else {
                                            DHTNetworkPosition peer_pos;
                                            rep_peer2.put("azup", new Long(peer4.getUpSpeed()));
                                            if (peer4.isBiased()) {
                                                rep_peer2.put("azbiased", "");
                                            }
                                            if (network_position != null && (peer_pos = peer4.getNetworkPosition()) != null && network_position.getPositionType() == peer_pos.getPositionType()) {
                                                rep_peer2.put("azrtt", new Long((long)peer_pos.estimateRTT(network_position)));
                                            }
                                        }
                                    }
                                    break block128;
                                }
                                rep_peer2.put("ip", peer4.getIPAsRead());
                            }
                            rep_peer2.put("port", new Long(peer4.getTCPPort()));
                            if (crypto_level != 0) {
                                rep_peer2.put("crypto_flag", new Long(peer4.getCryptoLevel() == 2 ? 1 : 0));
                            }
                            if (peer4.isBiased()) {
                                rep_peers.addFirst(rep_peer2);
                            } else {
                                rep_peers.addLast(rep_peer2);
                            }
                        }
                        ++i;
                    }
                    break block123;
                }
                int peer_list_size = this.peer_list.size();
                if (this.duplicate_peer_checker.length < peer_list_size) {
                    this.duplicate_peer_checker = new byte[peer_list_size * 2];
                    this.duplicate_peer_checker_index = 1;
                } else if (this.duplicate_peer_checker.length > peer_list_size * 2) {
                    this.duplicate_peer_checker = new byte[3 * peer_list_size / 2];
                    this.duplicate_peer_checker_index = 1;
                } else {
                    this.duplicate_peer_checker_index = (byte)(this.duplicate_peer_checker_index + 1);
                    if (this.duplicate_peer_checker_index == 0) {
                        Arrays.fill(this.duplicate_peer_checker, (byte)0);
                        this.duplicate_peer_checker_index = 1;
                    }
                }
                boolean peer_removed = false;
                try {
                    this.peer_list_compaction_suspended = true;
                    int added = 0;
                    int bad_nat_loop = TRTrackerServerNATChecker.getSingleton().isEnabled() ? 0 : 1;
                    while (bad_nat_loop < 2) {
                        int limit = num_want * 2;
                        if (num_want * 3 > total_peers) {
                            ++limit;
                        }
                        int biased_peers_count = 0;
                        if (this.biased_peers != null) {
                            if (this.biased_peers.size() > 1) {
                                Object x = this.biased_peers.remove(0);
                                this.biased_peers.add(this.random.nextInt(this.biased_peers.size() + 1), x);
                            }
                            biased_peers_count = Math.min(this.min_biased_peers, this.biased_peers.size());
                        }
                        int i = 0;
                        while (i < limit && added < num_want) {
                            block131: {
                                HashMap<String, Object> rep_peer3;
                                TRTrackerServerPeerImpl peer5;
                                block134: {
                                    block133: {
                                        int peer_index;
                                        block132: {
                                            block130: {
                                                block129: {
                                                    if (bad_nat_loop != 1 || i >= biased_peers_count) break block129;
                                                    peer5 = (TRTrackerServerPeerImpl)this.biased_peers.get(i);
                                                    peer_index = -1;
                                                    break block130;
                                                }
                                                peer_index = this.random.nextInt(peer_list_size);
                                                peer5 = this.peer_list.get(peer_index);
                                                if (peer5 == null || peer5.isBiased()) break block131;
                                            }
                                            if (now <= peer5.getTimeout()) break block132;
                                            this.removePeer(peer5, 5, null);
                                            peer_removed = true;
                                            break block131;
                                        }
                                        if (requesting_peer == peer5 || peer5.getTCPPort() == 0 || crypto_level == 0 && peer5.getCryptoLevel() == 2 || remove_ips != null && remove_ips.contains(new String(peer5.getIP())) || !include_seeds && peer5.isSeed()) break block131;
                                        boolean bad_nat = peer5.isNATStatusBad();
                                        if ((bad_nat_loop != 0 || bad_nat) && bad_nat_loop != 1 || peer_index != -1 && this.duplicate_peer_checker[peer_index] == this.duplicate_peer_checker_index) break block131;
                                        if (peer_index != -1) {
                                            this.duplicate_peer_checker[peer_index] = this.duplicate_peer_checker_index;
                                        }
                                        ++added;
                                        rep_peer3 = new HashMap<String, Object>(3);
                                        if (send_peer_ids) {
                                            rep_peer3.put("peer id", peer5.getPeerId().getHash());
                                        }
                                        if (compact_mode == 0) break block133;
                                        byte[] peer_bytes = peer5.getIPAddressBytes();
                                        if (peer_bytes == null) break block131;
                                        rep_peer3.put("ip", peer_bytes);
                                        if (compact_mode >= 2) {
                                            rep_peer3.put("azver", new Long(peer5.getAZVer()));
                                            rep_peer3.put("azudp", new Long(peer5.getUDPPort()));
                                            if (peer5.isSeed()) {
                                                rep_peer3.put("azhttp", new Long(peer5.getHTTPPort()));
                                            }
                                            if (compact_mode >= 16) {
                                                rep_peer3.put("ip", peer5.getIPAsRead());
                                            } else {
                                                DHTNetworkPosition peer_pos;
                                                rep_peer3.put("azup", new Long(peer5.getUpSpeed()));
                                                if (peer5.isBiased()) {
                                                    rep_peer3.put("azbiased", "");
                                                }
                                                if (network_position != null && (peer_pos = peer5.getNetworkPosition()) != null && network_position.getPositionType() == peer_pos.getPositionType()) {
                                                    rep_peer3.put("azrtt", new Long((long)peer_pos.estimateRTT(network_position)));
                                                }
                                            }
                                        }
                                        break block134;
                                    }
                                    rep_peer3.put("ip", peer5.getIPAsRead());
                                }
                                rep_peer3.put("port", new Long(peer5.getTCPPort()));
                                if (crypto_level != 0) {
                                    rep_peer3.put("crypto_flag", new Long(peer5.getCryptoLevel() == 2 ? 1 : 0));
                                }
                                if (peer5.isBiased()) {
                                    rep_peers.addFirst(rep_peer3);
                                } else {
                                    rep_peers.addLast(rep_peer3);
                                }
                            }
                            ++i;
                        }
                        ++bad_nat_loop;
                    }
                }
                finally {
                    this.peer_list_compaction_suspended = false;
                    if (peer_removed) {
                        this.checkForPeerListCompaction(false);
                    }
                }
            }
            if (include_seeds && explicit_limited_peers == null && !send_peer_ids && this.seed_count < 3 && this.queued_peers != null) {
                Iterator it = this.queued_peers.iterator();
                ArrayList<QueuedPeer> added = new ArrayList<QueuedPeer>(3);
                while (it.hasNext() && num_want > rep_peers.size() && added.size() < 3) {
                    QueuedPeer peer6 = (QueuedPeer)it.next();
                    if (peer6.isTimedOut(now)) {
                        it.remove();
                        continue;
                    }
                    if (crypto_level == 0 && peer6.getCryptoLevel() == 2 || remove_ips != null && remove_ips.contains(peer6.getIP())) continue;
                    HashMap<String, Object> rep_peer4 = new HashMap<String, Object>(3);
                    if (compact_mode != 0) {
                        byte[] peer_bytes = peer6.getIPAddressBytes();
                        if (peer_bytes == null) continue;
                        rep_peer4.put("ip", peer_bytes);
                        if (compact_mode >= 2) {
                            rep_peer4.put("azver", new Long(peer6.getAZVer()));
                            rep_peer4.put("azudp", new Long(peer6.getUDPPort()));
                            if (peer6.isSeed()) {
                                rep_peer4.put("azhttp", new Long(peer6.getHTTPPort()));
                            }
                            if (compact_mode >= 16) {
                                rep_peer4.put("ip", peer6.getIPAsRead());
                            }
                        }
                    } else {
                        rep_peer4.put("ip", peer6.getIPAsRead());
                    }
                    rep_peer4.put("port", new Long(peer6.getTCPPort()));
                    if (crypto_level != 0) {
                        rep_peer4.put("crypto_flag", new Long(peer6.getCryptoLevel() == 2 ? 1 : 0));
                    }
                    rep_peers.addLast(rep_peer4);
                    added.add(peer6);
                    it.remove();
                }
                int i = 0;
                while (i < added.size()) {
                    this.queued_peers.add(added.get(i));
                    ++i;
                }
            }
            TreeMap<String, Object> root = new TreeMap<String, Object>();
            if (preprocess_map.size() > 0) {
                root.putAll(preprocess_map);
            }
            if (explicit_limited_peers != null) {
                int i = 0;
                while (i < explicit_limited_peers.size()) {
                    --num_want;
                    TRTrackerServerSimplePeer peer7 = (TRTrackerServerSimplePeer)explicit_limited_peers.get(i);
                    this.exportPeer(rep_peers, peer7, send_peer_ids, compact_mode, crypto_level, network_position);
                    ++i;
                }
            }
            if (explicit_biased_peers != null) {
                int i = 0;
                while (i < explicit_biased_peers.size()) {
                    --num_want;
                    TRTrackerServerSimplePeer peer8 = (TRTrackerServerSimplePeer)explicit_biased_peers.get(i);
                    this.exportPeer(rep_peers, peer8, send_peer_ids, compact_mode, crypto_level, network_position);
                    ++i;
                }
            }
            if (this.explicit_manual_biased_peers != null && requesting_peer != null && !requesting_peer.isSeed()) {
                Object[] explicit_peer = (Object[])this.explicit_manual_biased_peers.get(this.explicit_next_peer++);
                if (this.explicit_next_peer == this.explicit_manual_biased_peers.size()) {
                    this.explicit_next_peer = 0;
                }
                HashMap<String, Object> rep_peer5 = new HashMap<String, Object>(3);
                if (send_peer_ids) {
                    byte[] peer_id = new byte[20];
                    this.random.nextBytes(peer_id);
                    rep_peer5.put("peer id", peer_id);
                }
                if (compact_mode != 0) {
                    byte[] peer_bytes = (byte[])explicit_peer[1];
                    rep_peer5.put("ip", peer_bytes);
                    if (compact_mode >= 2) {
                        rep_peer5.put("azver", new Long(0L));
                        rep_peer5.put("azudp", new Long(0L));
                        rep_peer5.put("azup", new Long(0L));
                        rep_peer5.put("azbiased", "");
                    }
                } else {
                    rep_peer5.put("ip", ((String)explicit_peer[0]).getBytes());
                }
                rep_peer5.put("port", new Long(((Integer)explicit_peer[2]).intValue()));
                if (crypto_level != 0) {
                    rep_peer5.put("crypto_flag", new Long(0L));
                }
                rep_peers.addFirst(rep_peer5);
            }
            int num_peers_returned = rep_peers.size();
            Iterator it = rep_peers.iterator();
            if (compact_mode == 2) {
                byte[] compact_peers = new byte[num_peers_returned * 9];
                int index = 0;
                while (it.hasNext()) {
                    rep_peer = (Map)it.next();
                    byte[] ip = (byte[])rep_peer.get("ip");
                    int tcp_port = ((Long)rep_peer.get("port")).intValue();
                    int udp_port = ((Long)rep_peer.get("azudp")).intValue();
                    Long crypto_flag_l = (Long)rep_peer.get("crypto_flag");
                    byte crypto_flag = crypto_flag_l == null ? (byte)0 : crypto_flag_l.byteValue();
                    int pos = index * 9;
                    System.arraycopy(ip, 0, compact_peers, pos, 4);
                    pos += 4;
                    compact_peers[pos++] = (byte)(tcp_port >> 8);
                    compact_peers[pos++] = (byte)(tcp_port & 0xFF);
                    compact_peers[pos++] = (byte)(udp_port >> 8);
                    compact_peers[pos++] = (byte)(udp_port & 0xFF);
                    compact_peers[pos++] = crypto_flag;
                    ++index;
                }
                root.put("peers", compact_peers);
                root.put("azcompact", new Long(1L));
            } else if (compact_mode == 3) {
                ArrayList compact_peers = new ArrayList(num_peers_returned);
                while (it.hasNext()) {
                    Long rtt;
                    Long up_speed;
                    Long az_ver_l;
                    byte az_ver;
                    Long crypto_flag_l;
                    byte crypto_flag;
                    int http_port;
                    Long http_port_l;
                    Map rep_peer6 = (Map)it.next();
                    peer = new HashMap<String, Object>();
                    compact_peers.add(peer);
                    byte[] ip = (byte[])rep_peer6.get("ip");
                    peer.put("i", ip);
                    int tcp_port = ((Long)rep_peer6.get("port")).intValue();
                    peer.put("t", new byte[]{(byte)(tcp_port >> 8), (byte)(tcp_port & 0xFF)});
                    int udp_port = ((Long)rep_peer6.get("azudp")).intValue();
                    if (udp_port != 0) {
                        if (udp_port == tcp_port) {
                            peer.put("u", new byte[0]);
                        } else {
                            peer.put("u", new byte[]{(byte)(udp_port >> 8), (byte)(udp_port & 0xFF)});
                        }
                    }
                    if ((http_port_l = (Long)rep_peer6.get("azhttp")) != null && (http_port = http_port_l.intValue()) != 0) {
                        peer.put("h", new byte[]{(byte)(http_port >> 8), (byte)(http_port & 0xFF)});
                    }
                    byte by = crypto_flag = (crypto_flag_l = (Long)rep_peer6.get("crypto_flag")) == null ? (byte)0 : crypto_flag_l.byteValue();
                    if (crypto_flag != 0) {
                        peer.put("c", new byte[]{crypto_flag});
                    }
                    byte by2 = az_ver = (az_ver_l = (Long)rep_peer6.get("azver")) == null ? (byte)0 : az_ver_l.byteValue();
                    if (az_ver != 0) {
                        peer.put("v", new Long(az_ver));
                    }
                    if ((up_speed = (Long)rep_peer6.get("azup")) != null && up_speed != 0L) {
                        peer.put("s", up_speed);
                    }
                    if ((rtt = (Long)rep_peer6.get("azrtt")) != null) {
                        peer.put("r", rtt);
                    }
                    if (!rep_peer6.containsKey("azbiased")) continue;
                    peer.put("b", new Long(1L));
                }
                root.put("peers", compact_peers);
                root.put("azcompact", new Long(2L));
            } else if (compact_mode == 16) {
                ArrayList xml_peers = new ArrayList(num_peers_returned);
                while (it.hasNext()) {
                    int http_port;
                    Long http_port_l;
                    Map rep_peer7 = (Map)it.next();
                    peer = new HashMap();
                    xml_peers.add(peer);
                    peer.put("ip", rep_peer7.get("ip"));
                    peer.put("tcp", rep_peer7.get("port"));
                    int udp_port = ((Long)rep_peer7.get("azudp")).intValue();
                    if (udp_port != 0) {
                        peer.put("udp", new Long(udp_port));
                    }
                    if ((http_port_l = (Long)rep_peer7.get("azhttp")) == null || (http_port = http_port_l.intValue()) == 0) continue;
                    peer.put("http", new Long(http_port));
                }
                root.put("peers", xml_peers);
            } else {
                byte[] crypto_flags = null;
                if (crypto_level != 0) {
                    crypto_flags = new byte[num_peers_returned];
                }
                if (compact_mode == 1) {
                    byte[] compact_peers = new byte[num_peers_returned * 6];
                    int index = 0;
                    int num_ipv4 = 0;
                    int num_ipv6 = 0;
                    while (it.hasNext()) {
                        Map rep_peer8 = (Map)it.next();
                        byte[] ip = (byte[])rep_peer8.get("ip");
                        if (ip.length > 4) {
                            ++num_ipv6;
                        } else {
                            ++num_ipv4;
                            if (num_ipv6 == 0) {
                                int port = ((Long)rep_peer8.get("port")).intValue();
                                int pos = index * 6;
                                System.arraycopy(ip, 0, compact_peers, pos, 4);
                                pos += 4;
                                compact_peers[pos++] = (byte)(port >> 8);
                                compact_peers[pos++] = (byte)(port & 0xFF);
                            }
                        }
                        if (crypto_flags != null) {
                            Long crypto_flag = (Long)rep_peer8.remove("crypto_flag");
                            crypto_flags[index] = crypto_flag.byteValue();
                        }
                        ++index;
                    }
                    if (num_ipv6 > 0) {
                        byte[] compact_peers_v4 = new byte[num_ipv4 * 6];
                        byte[] compact_peers_v6 = new byte[num_ipv6 * 18];
                        it = rep_peers.iterator();
                        int v4_index = 0;
                        int v6_index = 0;
                        while (it.hasNext()) {
                            int pos;
                            Map rep_peer9 = (Map)it.next();
                            byte[] ip = (byte[])rep_peer9.get("ip");
                            int port = ((Long)rep_peer9.get("port")).intValue();
                            if (ip.length > 4) {
                                pos = v6_index * 18;
                                System.arraycopy(ip, 0, compact_peers_v6, pos, 16);
                                pos += 16;
                                compact_peers_v6[pos++] = (byte)(port >> 8);
                                compact_peers_v6[pos++] = (byte)(port & 0xFF);
                                ++v6_index;
                                continue;
                            }
                            pos = v4_index * 6;
                            System.arraycopy(ip, 0, compact_peers_v4, pos, 4);
                            pos += 4;
                            compact_peers_v4[pos++] = (byte)(port >> 8);
                            compact_peers_v4[pos++] = (byte)(port & 0xFF);
                            ++v4_index;
                        }
                        if (compact_peers_v4.length > 0) {
                            root.put("peers", compact_peers_v4);
                        }
                        if (compact_peers_v6.length > 0) {
                            root.put("peers6", compact_peers_v6);
                        }
                    } else {
                        root.put("peers", compact_peers);
                    }
                } else {
                    int index = 0;
                    while (it.hasNext()) {
                        rep_peer = (Map)it.next();
                        if (crypto_flags != null) {
                            Long crypto_flag = (Long)rep_peer.remove("crypto_flag");
                            crypto_flags[index] = crypto_flag.byteValue();
                        }
                        ++index;
                    }
                    root.put("peers", rep_peers);
                }
                if (crypto_flags != null) {
                    root.put("crypto_flags", crypto_flags);
                }
            }
            root.put("interval", new Long(interval));
            root.put("min interval", new Long(min_interval));
            if (nat_warning) {
                requesting_peer.setNATStatus((byte)5);
                root.put("warning message", ("Unable to connect to your incoming data port (" + requesting_peer.getIP() + ":" + requesting_peer.getTCPPort() + "). " + "This will result in slow downloads. Please check your firewall/router settings").getBytes());
            }
            root.put("complete", new Long(this.getSeedCountForScrape(requester_is_biased)));
            root.put("incomplete", new Long(this.getLeecherCount()));
            root.put("downloaded", new Long(this.stats.getCompletedCount()));
            if (add_to_cache) {
                this.announce_cache.put(new Integer((num_peers_returned + 9) / 10), new announceCacheEntry(root, send_peer_ids, compact_mode));
            }
            TreeMap<String, Object> treeMap = root;
            return treeMap;
        }
        finally {
            this.this_mon.exit();
        }
    }

    private void exportPeer(LinkedList rep_peers, TRTrackerServerSimplePeer peer, boolean send_peer_ids, byte compact_mode, byte crypto_level, DHTNetworkPosition network_position) {
        HashMap<String, Object> rep_peer = new HashMap<String, Object>(3);
        if (send_peer_ids) {
            rep_peer.put("peer id", peer.getPeerId().getHash());
        }
        if (compact_mode != 0) {
            byte[] peer_bytes = peer.getIPAddressBytes();
            if (peer_bytes == null) {
                return;
            }
            rep_peer.put("ip", peer_bytes);
            if (compact_mode >= 2) {
                rep_peer.put("azver", new Long(peer.getAZVer()));
                rep_peer.put("azudp", new Long(peer.getUDPPort()));
                if (peer.isSeed()) {
                    rep_peer.put("azhttp", new Long(peer.getHTTPPort()));
                }
                if (compact_mode >= 16) {
                    rep_peer.put("ip", peer.getIPAsRead());
                } else {
                    DHTNetworkPosition peer_pos;
                    rep_peer.put("azup", new Long(peer.getUpSpeed()));
                    if (peer.isBiased()) {
                        rep_peer.put("azbiased", "");
                    }
                    if (network_position != null && (peer_pos = peer.getNetworkPosition()) != null && network_position.getPositionType() == peer_pos.getPositionType()) {
                        rep_peer.put("azrtt", new Long((long)peer_pos.estimateRTT(network_position)));
                    }
                }
            }
        } else {
            rep_peer.put("ip", peer.getIPAsRead());
        }
        rep_peer.put("port", new Long(peer.getTCPPort()));
        if (crypto_level != 0) {
            rep_peer.put("crypto_flag", new Long(peer.getCryptoLevel() == 2 ? 1 : 0));
        }
        if (peer.isBiased()) {
            rep_peers.addFirst(rep_peer);
        } else {
            rep_peers.addLast(rep_peer);
        }
    }

    public Map exportScrapeToMap(String url_parameters, String ip_address, boolean allow_cache) throws TRTrackerServerException {
        try {
            this.this_mon.enter();
            this.handleRedirects(url_parameters, ip_address, true);
            this.stats.addScrape();
            long now = SystemTime.getCurrentTime();
            long diff = now - this.last_scrape_calc_time;
            if (allow_cache && this.last_scrape != null && diff < (long)TRTrackerServerImpl.getScrapeCachePeriod() && diff >= 0L) {
                Map map = this.last_scrape;
                return map;
            }
            this.last_scrape = new TreeMap();
            this.last_scrape_calc_time = now;
            Set bp = this.server.getBiasedPeers();
            boolean requester_is_biased = bp == null ? false : bp.contains(ip_address);
            this.last_scrape.put("complete", new Long(this.getSeedCountForScrape(requester_is_biased)));
            this.last_scrape.put("incomplete", new Long(this.getLeecherCount()));
            this.last_scrape.put("downloaded", new Long(this.stats.getCompletedCount()));
            Map map = this.last_scrape;
            return map;
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void checkTimeouts() {
        try {
            this.this_mon.enter();
            long now = SystemTime.getCurrentTime();
            int new_bad_NAT_count = 0;
            int new_seed_count = 0;
            try {
                this.peer_list_compaction_suspended = true;
                int i = 0;
                while (i < this.peer_list.size()) {
                    TRTrackerServerPeerImpl peer = this.peer_list.get(i);
                    if (peer != null) {
                        if (now > peer.getTimeout()) {
                            this.removePeer(peer, i, 5, null);
                        } else {
                            if (peer.isSeed()) {
                                ++new_seed_count;
                            }
                            if (peer.isNATStatusBad()) {
                                ++new_bad_NAT_count;
                            }
                        }
                    }
                    ++i;
                }
            }
            finally {
                this.peer_list_compaction_suspended = false;
            }
            this.bad_NAT_count = new_bad_NAT_count;
            this.seed_count = new_seed_count;
            if (this.removed_count > 1000) {
                this.removed_count = 0;
                this.checkForPeerListCompaction(true);
                HashMap<HashWrapper, TRTrackerServerPeerImpl> new_peer_map = new HashMap<HashWrapper, TRTrackerServerPeerImpl>(this.peer_map);
                HashMap<String, TRTrackerServerPeerImpl> new_peer_reuse_map = new HashMap<String, TRTrackerServerPeerImpl>(this.peer_reuse_map);
                this.peer_map = new_peer_map;
                this.peer_reuse_map = new_peer_reuse_map;
            } else {
                this.checkForPeerListCompaction(false);
            }
            Iterator it = this.lightweight_seed_map.values().iterator();
            while (it.hasNext()) {
                lightweightSeed lws = (lightweightSeed)it.next();
                if (now <= lws.getTimeout()) continue;
                it.remove();
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void checkForPeerListCompaction(boolean force) {
        if (this.peer_list_hole_count > 0 && !this.peer_list_compaction_suspended && (force || this.peer_list_hole_count > this.peer_map.size() / 10)) {
            ArrayList<TRTrackerServerPeerImpl> new_peer_list = new ArrayList<TRTrackerServerPeerImpl>(this.peer_list.size() - this.peer_list_hole_count / 2);
            int holes_found = 0;
            int i = 0;
            while (i < this.peer_list.size()) {
                TRTrackerServerPeerImpl obj = this.peer_list.get(i);
                if (obj == null) {
                    ++holes_found;
                } else {
                    new_peer_list.add(obj);
                }
                ++i;
            }
            if (holes_found != this.peer_list_hole_count) {
                Debug.out("TRTrackerTorrent:compactHoles: count mismatch");
            }
            this.peer_list = new_peer_list;
            this.peer_list_hole_count = 0;
        }
    }

    protected void updateXferStats(int bytes_in, int bytes_out) {
        this.stats.addXferStats(bytes_in, bytes_out);
    }

    @Override
    public TRTrackerServerTorrentStats getStats() {
        return this.stats;
    }

    protected int getPeerCount() {
        return this.peer_map.size() + this.lightweight_seed_map.size();
    }

    protected int getSeedCount() {
        if (this.seed_count < 0) {
            Debug.out("seed count negative");
        }
        return this.seed_count + this.lightweight_seed_map.size();
    }

    protected int getSeedCountForScrape(boolean requester_is_biased) {
        int queued;
        int seeds = this.getSeedCount();
        if (this.biased_peers != null && !requester_is_biased) {
            int bpc = 0;
            for (TRTrackerServerPeerImpl bp : this.biased_peers) {
                if (!bp.isSeed()) continue;
                --seeds;
                ++bpc;
            }
            if (seeds < 0) {
                seeds = 0;
            }
            if (bpc > 0) {
                ++seeds;
            }
        }
        if ((queued = this.getQueuedCount()) > 0) {
            ++seeds;
        }
        return seeds;
    }

    protected int getLeecherCount() {
        int res = this.peer_map.size() - this.seed_count;
        return res < 0 ? 0 : res;
    }

    @Override
    public TRTrackerServerPeer[] getPeers() {
        try {
            this.this_mon.enter();
            TRTrackerServerPeer[] res = new TRTrackerServerPeer[this.peer_map.size()];
            this.peer_map.values().toArray(res);
            TRTrackerServerPeer[] tRTrackerServerPeerArray = res;
            return tRTrackerServerPeerArray;
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected int getQueuedCount() {
        LinkedList l = this.queued_peers;
        if (l == null) {
            return 0;
        }
        return l.size();
    }

    @Override
    public TRTrackerServerPeerBase[] getQueuedPeers() {
        try {
            this.this_mon.enter();
            if (this.queued_peers == null) {
                TRTrackerServerPeerBase[] tRTrackerServerPeerBaseArray = new TRTrackerServerPeerBase[]{};
                return tRTrackerServerPeerBaseArray;
            }
            TRTrackerServerPeerBase[] res = new TRTrackerServerPeerBase[this.queued_peers.size()];
            this.queued_peers.toArray(res);
            TRTrackerServerPeerBase[] tRTrackerServerPeerBaseArray = res;
            return tRTrackerServerPeerBaseArray;
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public HashWrapper getHash() {
        return this.hash;
    }

    @Override
    public void addExplicitBiasedPeer(String ip, int port) {
        byte[] bytes = HostNameToIPResolver.hostAddressToBytes(ip);
        if (bytes != null) {
            try {
                this.this_mon.enter();
                if (this.explicit_manual_biased_peers == null) {
                    this.explicit_manual_biased_peers = new ArrayList();
                }
                this.explicit_manual_biased_peers.add(new Object[]{ip, bytes, new Integer(port)});
            }
            finally {
                this.this_mon.exit();
            }
        }
    }

    @Override
    public void setRedirects(URL[] urls) {
        try {
            this.this_mon.enter();
            this.redirects = urls;
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public URL[] getRedirects() {
        return this.redirects;
    }

    protected void handleRedirects(String url_parameters, String real_ip_address, boolean scrape) throws TRTrackerServerException {
        if (this.redirects != null) {
            if (url_parameters.contains("permredirect")) {
                Debug.out("redirect recursion");
                throw new TRTrackerServerException("redirection recursion not supported");
            }
            URL redirect = this.redirects[(real_ip_address.hashCode() & Integer.MAX_VALUE) % this.redirects.length];
            HashMap<String, String> headers = new HashMap<String, String>();
            String redirect_str = redirect.toString();
            if (scrape) {
                int pos = redirect_str.indexOf("/announce");
                if (pos == -1) {
                    return;
                }
                redirect_str = String.valueOf(redirect_str.substring(0, pos)) + "/scrape" + redirect_str.substring(pos + 9);
            }
            redirect_str = redirect_str.indexOf(63) == -1 ? String.valueOf(redirect_str) + "?" : String.valueOf(redirect_str) + "&";
            redirect_str = String.valueOf(redirect_str) + "permredirect=1";
            if (url_parameters.length() > 0) {
                redirect_str = String.valueOf(redirect_str) + "&" + url_parameters;
            }
            System.out.println("redirect -> " + redirect_str);
            headers.put("Location", redirect_str);
            throw new TRTrackerServerException(301, "Moved Permanently", headers);
        }
    }

    @Override
    public void addListener(TRTrackerServerTorrentListener l) {
        this.listeners.add(l);
        if (this.deleted) {
            l.deleted(this);
        }
    }

    @Override
    public void removeListener(TRTrackerServerTorrentListener l) {
        this.listeners.remove(l);
    }

    protected void peerEvent(TRTrackerServerPeer peer, int event2, String url_parameters) throws TRTrackerServerException {
        if (this.peer_listeners != null) {
            int i = 0;
            while (i < this.peer_listeners.size()) {
                try {
                    ((TRTrackerServerTorrentPeerListener)this.peer_listeners.get(i)).eventOccurred(this, peer, event2, url_parameters);
                }
                catch (TRTrackerServerException e) {
                    throw e;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
                ++i;
            }
        }
    }

    @Override
    public void addPeerListener(TRTrackerServerTorrentPeerListener l) {
        if (this.peer_listeners == null) {
            this.peer_listeners = new ArrayList();
        }
        this.peer_listeners.add(l);
    }

    @Override
    public void removePeerListener(TRTrackerServerTorrentPeerListener l) {
        if (this.peer_listeners != null) {
            this.peer_listeners.remove(l);
        }
    }

    @Override
    public void disableCaching() {
        this.caching_enabled = false;
    }

    public boolean isCachingEnabled() {
        return this.caching_enabled;
    }

    public int getBadNATPeerCount() {
        return this.bad_NAT_count;
    }

    protected void delete() {
        this.deleted = true;
        int i = 0;
        while (i < this.listeners.size()) {
            ((TRTrackerServerTorrentListener)this.listeners.get(i)).deleted(this);
            ++i;
        }
    }

    @Override
    public String getString() {
        String redirect;
        if (this.redirects == null) {
            redirect = "none";
        } else {
            redirect = "";
            int i = 0;
            while (i < this.redirects.length) {
                redirect = String.valueOf(redirect) + (i == 0 ? "" : ",") + this.redirects[i];
                ++i;
            }
        }
        return "seeds=" + this.getSeedCount() + ",leechers=" + this.getLeecherCount() + ", redirect=" + redirect;
    }

    protected static class QueuedPeer
    implements TRTrackerServerPeerBase {
        private static final byte FLAG_SEED = 1;
        private static final byte FLAG_BIASED = 2;
        private final short tcp_port;
        private final short udp_port;
        private final short http_port;
        private byte[] ip;
        private final byte crypto_level;
        private final byte az_ver;
        private int create_time_secs;
        private final int timeout_secs;
        private byte flags;

        protected QueuedPeer(String _ip_str, int _tcp_port, int _udp_port, int _http_port, byte _crypto_level, byte _az_ver, int _timeout_secs, boolean _seed, boolean _biased) {
            try {
                this.ip = _ip_str.getBytes("ISO-8859-1");
            }
            catch (UnsupportedEncodingException e) {
                Debug.printStackTrace(e);
            }
            this.tcp_port = (short)_tcp_port;
            this.udp_port = (short)_udp_port;
            this.http_port = (short)_http_port;
            this.crypto_level = _crypto_level;
            this.az_ver = _az_ver;
            this.setFlag((byte)1, _seed);
            this.setFlag((byte)2, _biased);
            this.create_time_secs = (int)(SystemTime.getCurrentTime() / 1000L);
            this.timeout_secs = _timeout_secs * 3;
        }

        protected boolean sameAs(TRTrackerServerPeerImpl peer) {
            return this.tcp_port == peer.getTCPPort() && Arrays.equals(this.ip, peer.getIPAsRead()) && this.isIPOverride() == peer.isIPOverride();
        }

        protected boolean sameAs(QueuedPeer other) {
            return this.tcp_port == other.tcp_port && Arrays.equals(this.ip, other.ip);
        }

        protected byte[] getIPAsRead() {
            return this.ip;
        }

        @Override
        public String getIP() {
            try {
                return new String(this.ip, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException e) {
                return new String(this.ip);
            }
        }

        protected boolean isSeed() {
            return this.getFlag((byte)1);
        }

        protected void setBiased(boolean _biased) {
            this.setFlag((byte)2, _biased);
        }

        protected boolean isBiased() {
            return this.getFlag((byte)2);
        }

        protected boolean isIPOverride() {
            return false;
        }

        protected void setFlag(byte flag, boolean value) {
            this.flags = value ? (byte)(this.flags | flag) : (byte)(this.flags & ~flag);
        }

        protected boolean getFlag(byte flag) {
            return (this.flags & flag) != 0;
        }

        protected byte[] getIPAddressBytes() {
            try {
                return HostNameToIPResolver.hostAddressToBytes(new String(this.ip, "ISO-8859-1"));
            }
            catch (UnsupportedEncodingException e) {
                Debug.printStackTrace(e);
                return null;
            }
        }

        @Override
        public int getTCPPort() {
            return this.tcp_port & 0xFFFF;
        }

        public int getUDPPort() {
            return this.udp_port & 0xFFFF;
        }

        @Override
        public int getHTTPPort() {
            return this.http_port & 0xFFFF;
        }

        protected byte getCryptoLevel() {
            return this.crypto_level;
        }

        protected byte getAZVer() {
            return this.az_ver;
        }

        protected int getCreateTime() {
            return this.create_time_secs;
        }

        protected boolean isTimedOut(long now_millis) {
            int now_secs = (int)(now_millis / 1000L);
            if (now_secs < this.create_time_secs) {
                this.create_time_secs = now_secs;
            }
            return this.create_time_secs + this.timeout_secs < now_secs;
        }

        @Override
        public int getSecsToLive() {
            int now_secs = (int)(SystemTime.getCurrentTime() / 1000L);
            if (now_secs < this.create_time_secs) {
                this.create_time_secs = now_secs;
            }
            return this.create_time_secs + this.timeout_secs - now_secs;
        }

        protected String getString() {
            return String.valueOf(new String(this.ip)) + ":" + this.getTCPPort() + "/" + this.getUDPPort() + "/" + this.getCryptoLevel();
        }
    }

    static class announceCacheEntry {
        protected final Map data;
        protected final boolean send_peer_ids;
        protected final byte compact_mode;
        protected final long time;

        protected announceCacheEntry(Map _data, boolean _send_peer_ids, byte _compact_mode) {
            this.data = _data;
            this.send_peer_ids = _send_peer_ids;
            this.compact_mode = _compact_mode;
            this.time = SystemTime.getCurrentTime();
        }

        protected boolean getSendPeerIds() {
            return this.send_peer_ids;
        }

        protected byte getCompactMode() {
            return this.compact_mode;
        }

        protected long getTime() {
            return this.time;
        }

        protected Map getData() {
            return this.data;
        }
    }

    protected static class lightweightSeed {
        final long timeout;
        final long last_contact_time;
        final long uploaded;
        final byte nat_status;

        protected lightweightSeed(long _now, long _timeout, long _uploaded, byte _nat_status) {
            this.last_contact_time = _now;
            this.timeout = _timeout;
            this.uploaded = _uploaded;
            this.nat_status = _nat_status;
        }

        protected long getTimeout() {
            return this.timeout;
        }

        protected long getLastContactTime() {
            return this.last_contact_time;
        }

        protected long getUploaded() {
            return this.uploaded;
        }

        protected byte getNATStatus() {
            return this.nat_status;
        }
    }

    private static class temporaryBiasedSeed
    implements TRTrackerServerSimplePeer {
        private final String ip;
        private final int tcp_port;
        private final HashWrapper peer_id;

        protected temporaryBiasedSeed(String _ip, int _tcp_port) {
            this.ip = _ip;
            this.tcp_port = _tcp_port;
            this.peer_id = new HashWrapper(RandomUtils.nextHash());
        }

        @Override
        public byte[] getIPAsRead() {
            try {
                return this.ip.getBytes("ISO-8859-1");
            }
            catch (Throwable e) {
                return this.ip.getBytes();
            }
        }

        @Override
        public byte[] getIPAddressBytes() {
            try {
                return InetAddress.getByName(this.ip).getAddress();
            }
            catch (Throwable e) {
                return null;
            }
        }

        @Override
        public HashWrapper getPeerId() {
            return this.peer_id;
        }

        @Override
        public int getTCPPort() {
            return this.tcp_port;
        }

        @Override
        public int getUDPPort() {
            return 0;
        }

        @Override
        public int getHTTPPort() {
            return 0;
        }

        @Override
        public boolean isSeed() {
            return true;
        }

        @Override
        public boolean isBiased() {
            return true;
        }

        @Override
        public byte getCryptoLevel() {
            return 0;
        }

        @Override
        public byte getAZVer() {
            return 0;
        }

        @Override
        public int getUpSpeed() {
            return 0;
        }

        @Override
        public DHTNetworkPosition getNetworkPosition() {
            return null;
        }
    }
}

