/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.security.impl;

import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.Authenticator;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.Socket;
import java.net.URL;
import java.security.Key;
import java.security.KeyStore;
import java.security.Permission;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.security.SECertificateListener;
import org.gudy.azureus2.core3.security.SEKeyDetails;
import org.gudy.azureus2.core3.security.SEPasswordListener;
import org.gudy.azureus2.core3.security.impl.SESecurityManagerBC;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.RandomUtils;

public class SESecurityManagerImpl {
    private static final LogIDs LOGID = LogIDs.NET;
    protected static final SESecurityManagerImpl singleton = new SESecurityManagerImpl();
    protected static String KEYSTORE_TYPE;
    private static boolean auto_install_certs;
    protected String keystore_name;
    protected String truststore_name;
    protected final List<SECertificateListener> certificate_listeners = new ArrayList<SECertificateListener>();
    protected final CopyOnWriteList password_listeners = new CopyOnWriteList();
    private static final ThreadLocal tls;
    protected final Map password_handlers = new HashMap();
    protected final Map certificate_handlers = new HashMap();
    protected boolean exit_vm_permitted = false;
    private AzureusSecurityManager my_sec_man;
    protected final AEMonitor this_mon = new AEMonitor("SESecurityManager");
    private boolean initialized = false;
    final List stoppable_threads = new ArrayList();
    private boolean hack_constructor_tried;
    private Constructor<TrustManager> hack_constructor;

    static {
        String[] types = new String[]{"JKS", "GKR", "BKS"};
        int i = 0;
        while (i < types.length) {
            try {
                KeyStore.getInstance(types[i]);
                KEYSTORE_TYPE = types[i];
                break;
            }
            catch (Throwable throwable) {
                ++i;
            }
        }
        if (KEYSTORE_TYPE == null) {
            KEYSTORE_TYPE = "JKS";
        }
        Logger.log(new LogEvent(LOGID, "Keystore type is " + KEYSTORE_TYPE));
        COConfigurationManager.addAndFireParameterListener("security.cert.auto.install", new ParameterListener(){

            @Override
            public void parameterChanged(String parameter_name) {
                auto_install_certs = COConfigurationManager.getBooleanParameter(parameter_name);
            }
        });
        tls = new ThreadLocal(){

            public Object initialValue() {
                return null;
            }
        };
    }

    public static SESecurityManagerImpl getSingleton() {
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialise() {
        SESecurityManagerImpl sESecurityManagerImpl = this;
        synchronized (sESecurityManagerImpl) {
            if (this.initialized) {
                return;
            }
            this.initialized = true;
        }
        this.keystore_name = FileUtil.getUserFile(".keystore").getAbsolutePath();
        this.truststore_name = FileUtil.getUserFile(".certs").getAbsolutePath();
        System.setProperty("javax.net.ssl.trustStore", this.truststore_name);
        System.setProperty("javax.net.ssl.trustStorePassword", "changeit");
        this.installAuthenticator();
        String[] providers = new String[]{"com.sun.net.ssl.internal.ssl.Provider", "org.metastatic.jessie.provider.Jessie", "org.gudy.bouncycastle.jce.provider.BouncyCastleProvider"};
        String provider2 = null;
        int i = 0;
        while (i < providers.length) {
            try {
                Class.forName(providers[i]).newInstance();
                provider2 = providers[i];
                break;
            }
            catch (Throwable throwable) {
                ++i;
            }
        }
        if (provider2 == null) {
            Debug.out("No SSL provider available");
        }
        try {
            SESecurityManagerBC.initialise();
        }
        catch (Throwable e) {
            Debug.out(e);
            Logger.log(new LogEvent(LOGID, 3, "Bouncy Castle not available"));
        }
        this.installSecurityManager();
        this.ensureStoreExists(this.keystore_name);
        this.ensureStoreExists(this.truststore_name);
        this.initEmptyTrustStore();
    }

    private void initEmptyTrustStore() {
        try {
            File cacerts;
            File target = new File(this.truststore_name);
            if (target.exists() && target.length() > 2048L) {
                return;
            }
            KeyStore keystore = this.getTrustStore();
            if (keystore.size() == 0 && (cacerts = new File(new File(new File(System.getProperty("java.home"), "lib"), "security"), "cacerts")).exists()) {
                FileUtil.copyFile(cacerts, target);
                try {
                    this.getTrustStore();
                }
                catch (Throwable e) {
                    target.delete();
                    this.ensureStoreExists(this.truststore_name);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean resetTrustStore(boolean test_only) {
        return this.resetTrustStore(test_only, false);
    }

    private boolean resetTrustStore(boolean test_only, boolean recovering) {
        File cacerts = new File(new File(new File(System.getProperty("java.home"), "lib"), "security"), "cacerts");
        if (!cacerts.exists()) {
            return false;
        }
        if (test_only) {
            return true;
        }
        File target = new File(this.truststore_name);
        if (target.exists() && !target.delete()) {
            Debug.out("Failed to delete " + target);
            return false;
        }
        if (!FileUtil.copyFile(cacerts, target)) {
            Debug.out("Failed to copy file from " + cacerts + " to " + target);
            return false;
        }
        try {
            this.getTrustStore(!recovering);
        }
        catch (Throwable e) {
            Debug.out(e);
            target.delete();
            this.ensureStoreExists(this.truststore_name);
            return false;
        }
        return true;
    }

    public String getKeystoreName() {
        return this.keystore_name;
    }

    public String getKeystorePassword() {
        return "changeit";
    }

    protected void installSecurityManager() {
        if (!Constants.isAndroid) {
            String prop = System.getProperty("azureus.security.manager.install", "1");
            if (prop.equals("0")) {
                Debug.outNoStack("Not installing security manager - disabled by system property");
                return;
            }
            try {
                SecurityManager old_sec_man = System.getSecurityManager();
                this.my_sec_man = new AzureusSecurityManager(old_sec_man);
                System.setSecurityManager(this.my_sec_man);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopThread(Thread t) {
        List list = this.stoppable_threads;
        synchronized (list) {
            this.stoppable_threads.add(Thread.currentThread());
        }
        try {
            t.stop();
        }
        catch (Throwable throwable) {
            List list2 = this.stoppable_threads;
            synchronized (list2) {
                this.stoppable_threads.remove(Thread.currentThread());
            }
            throw throwable;
        }
        List list3 = this.stoppable_threads;
        synchronized (list3) {
            this.stoppable_threads.remove(Thread.currentThread());
        }
    }

    public void exitVM(int status) {
        try {
            this.exit_vm_permitted = true;
            try {
                System.exit(status);
            }
            catch (Throwable throwable) {}
        }
        finally {
            this.exit_vm_permitted = false;
        }
    }

    public void installAuthenticator() {
        Authenticator.setDefault(new Authenticator(){
            protected final AEMonitor auth_mon = new AEMonitor("SESecurityManager:auth");

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                try {
                    PasswordAuthentication res;
                    this.auth_mon.enter();
                    PasswordAuthentication passwordAuthentication = res = SESecurityManagerImpl.this.getAuthentication(this.getRequestingPrompt(), this.getRequestingProtocol(), this.getRequestingHost(), this.getRequestingPort());
                    return passwordAuthentication;
                }
                finally {
                    this.auth_mon.exit();
                }
            }
        });
    }

    public PasswordAuthentication getAuthentication(String realm, String protocol, String host, int port) {
        try {
            URL tracker_url = new URL(String.valueOf(protocol) + "://" + host + ":" + port + "/");
            if (protocol.toLowerCase().startsWith("socks")) {
                PasswordAuthentication temp;
                SEPasswordListener thread_listener = (SEPasswordListener)tls.get();
                if (thread_listener != null && (temp = thread_listener.getAuthentication(realm, tracker_url)) != null) {
                    return temp;
                }
                String socks_user = COConfigurationManager.getStringParameter("Proxy.Username").trim();
                String socks_pw = COConfigurationManager.getStringParameter("Proxy.Password").trim();
                if (socks_user.equalsIgnoreCase("<none>")) {
                    return new PasswordAuthentication("", "".toCharArray());
                }
                if (socks_user.length() == 0) {
                    Logger.log(new LogAlert(false, 1, "Socks server is requesting authentication, please setup user and password in config"));
                }
                return new PasswordAuthentication(socks_user, socks_pw.toCharArray());
            }
            return this.getPasswordAuthentication(realm, tracker_url);
        }
        catch (MalformedURLException e) {
            Debug.printStackTrace(e);
            return null;
        }
    }

    protected boolean checkKeyStoreHasEntry() {
        File f = new File(this.keystore_name);
        if (!f.exists()) {
            Logger.logTextResource(new LogAlert(false, 3, "Security.keystore.empty"), new String[]{this.keystore_name});
            return false;
        }
        try {
            KeyStore key_store = this.loadKeyStore();
            Enumeration<String> enumx = key_store.aliases();
            if (!enumx.hasMoreElements()) {
                Logger.logTextResource(new LogAlert(false, 3, "Security.keystore.empty"), new String[]{this.keystore_name});
                return false;
            }
        }
        catch (Throwable e) {
            Logger.logTextResource(new LogAlert(false, 3, "Security.keystore.corrupt"), new String[]{this.keystore_name});
            return false;
        }
        return true;
    }

    protected boolean ensureStoreExists(String name) {
        try {
            this.this_mon.enter();
            KeyStore keystore = KeyStore.getInstance(KEYSTORE_TYPE);
            if (!new File(name).exists()) {
                keystore.load(null, null);
                FileOutputStream out = null;
                try {
                    out = new FileOutputStream(name);
                    keystore.store(out, "changeit".toCharArray());
                }
                finally {
                    if (out != null) {
                        out.close();
                    }
                }
                return true;
            }
            return false;
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return false;
        }
        finally {
            this.this_mon.exit();
        }
    }

    public KeyStore getKeyStore() throws Exception {
        return this.loadKeyStore();
    }

    public KeyStore getTrustStore() throws Exception {
        return this.getTrustStore(true);
    }

    public KeyStore getTrustStore(boolean attempt_recovery) throws Exception {
        KeyStore keystore;
        block12: {
            keystore = KeyStore.getInstance(KEYSTORE_TYPE);
            File tf_file = new File(this.truststore_name);
            try {
                if (!tf_file.exists()) {
                    keystore.load(null, null);
                    break block12;
                }
                FileInputStream in = null;
                try {
                    in = new FileInputStream(tf_file);
                    keystore.load(in, "changeit".toCharArray());
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
            catch (Throwable e) {
                if (attempt_recovery) {
                    Debug.out("Failed to load trust store - resetting", e);
                    try {
                        if (tf_file.exists()) {
                            File bad_file = new File(String.valueOf(tf_file.getAbsolutePath()) + ".bad");
                            bad_file.delete();
                            tf_file.renameTo(bad_file);
                        }
                    }
                    catch (Throwable f) {
                        Debug.out(f);
                    }
                    this.resetTrustStore(false, true);
                    return this.getTrustStore(false);
                }
                if (e instanceof Exception) {
                    throw (Exception)e;
                }
                throw new Exception(e);
            }
        }
        return keystore;
    }

    protected KeyStore loadKeyStore() throws Exception {
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
        return this.loadKeyStore(keyManagerFactory);
    }

    protected KeyStore loadKeyStore(KeyManagerFactory keyManagerFactory) throws Exception {
        KeyStore key_store = KeyStore.getInstance(KEYSTORE_TYPE);
        if (!new File(this.keystore_name).exists()) {
            key_store.load(null, null);
        } else {
            FileInputStream kis = null;
            try {
                kis = new FileInputStream(this.keystore_name);
                key_store.load(kis, "changeit".toCharArray());
            }
            finally {
                if (kis != null) {
                    ((InputStream)kis).close();
                }
            }
        }
        keyManagerFactory.init(key_store, "changeit".toCharArray());
        return key_store;
    }

    public SSLServerSocketFactory getSSLServerSocketFactory() throws Exception {
        if (!this.checkKeyStoreHasEntry()) {
            return null;
        }
        SSLContext context2 = SSLContext.getInstance("SSL");
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
        this.loadKeyStore(keyManagerFactory);
        context2.init(keyManagerFactory.getKeyManagers(), null, RandomUtils.SECURE_RANDOM);
        SSLServerSocketFactory factory = context2.getServerSocketFactory();
        return factory;
    }

    public SEKeyDetails getKeyDetails(String alias) throws Exception {
        KeyStore key_store = this.loadKeyStore();
        final Key key = key_store.getKey(alias, "changeit".toCharArray());
        if (key == null) {
            return null;
        }
        Certificate[] chain = key_store.getCertificateChain(alias);
        final X509Certificate[] res = new X509Certificate[chain.length];
        int i = 0;
        while (i < chain.length) {
            if (!(chain[i] instanceof X509Certificate)) {
                throw new Exception("Certificate chain must be comprised of X509Certificate entries");
            }
            res[i] = (X509Certificate)chain[i];
            ++i;
        }
        return new SEKeyDetails(){

            @Override
            public Key getKey() {
                return key;
            }

            @Override
            public X509Certificate[] getCertificateChain() {
                return res;
            }
        };
    }

    public Certificate createSelfSignedCertificate(String alias, String cert_dn, int strength) throws Exception {
        return SESecurityManagerBC.createSelfSignedCertificate(this, alias, cert_dn, strength);
    }

    public TrustManagerFactory getTrustManagerFactory() {
        try {
            this.this_mon.enter();
            KeyStore keystore = this.getTrustStore();
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(keystore);
            TrustManagerFactory trustManagerFactory = tmf;
            return trustManagerFactory;
        }
        catch (Throwable e) {
            Debug.out(e);
            return null;
        }
        finally {
            this.this_mon.exit();
        }
    }

    public SSLSocketFactory getSSLSocketFactory() {
        try {
            SSLSocketFactory factory;
            this.this_mon.enter();
            KeyStore keystore = this.getTrustStore();
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(keystore);
            SSLContext ctx = SSLContext.getInstance("SSL");
            ctx.init(null, tmf.getTrustManagers(), null);
            SSLSocketFactory sSLSocketFactory = factory = ctx.getSocketFactory();
            return sSLSocketFactory;
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            return sSLSocketFactory;
        }
        finally {
            this.this_mon.exit();
        }
    }

    public SSLSocketFactory installServerCertificates(URL https_url) {
        return this.installServerCertificates(https_url, false, false);
    }

    public TrustManager[] getAllTrustingTrustManager() {
        return this.getAllTrustingTrustManager(null);
    }

    public TrustManager[] getAllTrustingTrustManager(final X509TrustManager delegate) {
        try {
            this.this_mon.enter();
            TrustManager[] all_trusting_manager = null;
            if (!this.hack_constructor_tried) {
                this.hack_constructor_tried = true;
                try {
                    byte[] bytes = Base32.decode("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");
                    class HackClassLoader
                    extends ClassLoader {
                        HackClassLoader() {
                        }

                        public Class<TrustManager> loadClass(String name, byte[] bytes) {
                            Class<TrustManager> cla = this.defineClass(name, bytes, 0, bytes.length);
                            this.resolveClass(cla);
                            return cla;
                        }
                    }
                    Class<TrustManager> cla = new HackClassLoader().loadClass("org.gudy.azureus2.core3.security.impl.SETrustingManager", bytes);
                    this.hack_constructor = cla.getConstructor(X509TrustManager.class);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (this.hack_constructor != null) {
                try {
                    all_trusting_manager = new TrustManager[]{this.hack_constructor.newInstance(delegate)};
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (all_trusting_manager == null) {
                all_trusting_manager = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        if (delegate != null) {
                            return delegate.getAcceptedIssuers();
                        }
                        return null;
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                        if (delegate != null) {
                            delegate.checkClientTrusted(chain, authType);
                        }
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                        if (delegate != null) {
                            delegate.checkServerTrusted(chain, authType);
                        }
                    }
                }};
            }
            TrustManager[] trustManagerArray = all_trusting_manager;
            return trustManagerArray;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * Exception decompiling
     */
    private SSLSocketFactory installServerCertificates(URL https_url, boolean sni_hack, boolean dh_hack) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public SSLSocketFactory installServerCertificates(String alias, String host, int port) {
        return this.installServerCertificates(alias, host, port, false);
    }

    /*
     * Loose catch block
     */
    public SSLSocketFactory installServerCertificates(String alias, String host, int port, boolean sni_hack) {
        try {
            SSLSocketFactory sSLSocketFactory;
            Socket socket;
            block27: {
                this.this_mon.enter();
                if (port == -1) {
                    port = 443;
                }
                socket = null;
                TrustManager[] trustAllCerts = this.getAllTrustingTrustManager();
                SSLContext sc = SSLContext.getInstance("SSL");
                sc.init(null, trustAllCerts, RandomUtils.SECURE_RANDOM);
                SSLSocketFactory factory = sc.getSocketFactory();
                InetSocketAddress targetSockAddress = new InetSocketAddress(InetAddress.getByName(host), port);
                InetAddress bindIP = NetworkAdmin.getSingleton().getSingleHomedServiceBindAddress(targetSockAddress.getAddress() instanceof Inet6Address ? 2 : 1);
                if (sni_hack) {
                    Socket base_socket = new Socket();
                    if (bindIP != null) {
                        base_socket.bind(new InetSocketAddress(bindIP, 0));
                    }
                    base_socket.connect(targetSockAddress);
                    socket = (SSLSocket)factory.createSocket(base_socket, "", base_socket.getPort(), true);
                    ((SSLSocket)socket).setEnabledProtocols(new String[]{"TLSv1"});
                    ((SSLSocket)socket).setUseClientMode(true);
                } else {
                    socket = bindIP != null ? (SSLSocket)factory.createSocket(host, port, bindIP, 0) : (SSLSocket)factory.createSocket(host, port);
                }
                ((SSLSocket)socket).startHandshake();
                Certificate[] serverCerts = ((SSLSocket)socket).getSession().getPeerCertificates();
                SSLSocketFactory result = null;
                Certificate[] certificateArray = serverCerts;
                int n = serverCerts.length;
                int n2 = 0;
                while (n2 < n) {
                    X509Certificate x509_cert;
                    Certificate cert = certificateArray[n2];
                    if (cert instanceof X509Certificate) {
                        x509_cert = (X509Certificate)cert;
                    } else {
                        CertificateFactory cf = CertificateFactory.getInstance("X.509");
                        x509_cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(cert.getEncoded()));
                    }
                    result = this.addCertToTrustStore(alias, x509_cert, false);
                    ++n2;
                }
                sSLSocketFactory = result;
                if (socket == null) break block27;
                try {
                    socket.close();
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
            return sSLSocketFactory;
            catch (Throwable e) {
                block30: {
                    block28: {
                        SSLSocketFactory sSLSocketFactory2;
                        block29: {
                            if (!Debug.getNestedExceptionMessage(e).contains("unrecognized_name") || sni_hack) break block28;
                            sSLSocketFactory2 = this.installServerCertificates(alias, host, port, true);
                            if (socket == null) break block29;
                            try {
                                socket.close();
                            }
                            catch (Throwable e2) {
                                Debug.printStackTrace(e2);
                            }
                        }
                        this.this_mon.exit();
                        return sSLSocketFactory2;
                    }
                    Debug.out(e);
                    if (socket == null) break block30;
                    {
                        catch (Throwable throwable) {
                            if (socket != null) {
                                try {
                                    socket.close();
                                }
                                catch (Throwable e3) {
                                    Debug.printStackTrace(e3);
                                }
                            }
                            throw throwable;
                        }
                    }
                    try {
                        socket.close();
                    }
                    catch (Throwable e4) {
                        Debug.printStackTrace(e4);
                    }
                }
                this.this_mon.exit();
                return null;
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void addCertToKeyStore(String alias, Key public_key, Certificate[] certChain) throws Exception {
        try {
            this.this_mon.enter();
            KeyStore key_store = this.loadKeyStore();
            if (key_store.containsAlias(alias)) {
                key_store.deleteEntry(alias);
            }
            key_store.setKeyEntry(alias, public_key, "changeit".toCharArray(), certChain);
            FileOutputStream out = null;
            try {
                try {
                    out = new FileOutputStream(this.keystore_name);
                    key_store.store(out, "changeit".toCharArray());
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                    if (out != null) {
                        out.close();
                    }
                }
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected SSLSocketFactory addCertToTrustStore(String alias, Certificate cert, boolean update_https_factory) throws Exception {
        try {
            this.this_mon.enter();
            KeyStore keystore = this.getTrustStore();
            if (cert != null) {
                if (keystore.containsAlias(alias)) {
                    keystore.deleteEntry(alias);
                }
                keystore.setCertificateEntry(alias, cert);
                FileOutputStream out = null;
                try {
                    out = new FileOutputStream(this.truststore_name);
                    keystore.store(out, "changeit".toCharArray());
                }
                finally {
                    if (out != null) {
                        out.close();
                    }
                }
            }
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(keystore);
            SSLContext ctx = SSLContext.getInstance("SSL");
            ctx.init(null, tmf.getTrustManagers(), null);
            SSLSocketFactory factory = ctx.getSocketFactory();
            if (update_https_factory) {
                HttpsURLConnection.setDefaultSSLSocketFactory(factory);
            }
            SSLSocketFactory sSLSocketFactory = factory;
            return sSLSocketFactory;
        }
        finally {
            this.this_mon.exit();
        }
    }

    public PasswordAuthentication getPasswordAuthentication(String realm, URL tracker) {
        SEPasswordListener thread_listener = (SEPasswordListener)tls.get();
        if (thread_listener != null) {
            return thread_listener.getAuthentication(realm, tracker);
        }
        Object[] handler = (Object[])this.password_handlers.get(tracker.toString());
        if (handler != null) {
            try {
                return ((SEPasswordListener)handler[0]).getAuthentication(realm, (URL)handler[1]);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        Iterator it = this.password_listeners.iterator();
        while (it.hasNext()) {
            try {
                PasswordAuthentication res = ((SEPasswordListener)it.next()).getAuthentication(realm, tracker);
                if (res == null) continue;
                return res;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        return null;
    }

    public void setPasswordAuthenticationOutcome(String realm, URL tracker, boolean success) {
        SEPasswordListener thread_listener = (SEPasswordListener)tls.get();
        if (thread_listener != null) {
            thread_listener.setAuthenticationOutcome(realm, tracker, success);
        }
        Iterator it = this.password_listeners.iterator();
        while (it.hasNext()) {
            ((SEPasswordListener)it.next()).setAuthenticationOutcome(realm, tracker, success);
        }
    }

    public void addPasswordListener(SEPasswordListener l) {
        try {
            this.this_mon.enter();
            this.password_listeners.add(l);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void removePasswordListener(SEPasswordListener l) {
        try {
            this.this_mon.enter();
            this.password_listeners.remove(l);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void clearPasswords() {
        SEPasswordListener thread_listener = (SEPasswordListener)tls.get();
        if (thread_listener != null) {
            thread_listener.clearPasswords();
        }
        Iterator it = this.password_listeners.iterator();
        while (it.hasNext()) {
            try {
                ((SEPasswordListener)it.next()).clearPasswords();
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public void setThreadPasswordHandler(SEPasswordListener l) {
        tls.set(l);
    }

    public void unsetThreadPasswordHandler() {
        tls.set(null);
    }

    public void setPasswordHandler(URL url, SEPasswordListener l) {
        String url_s = String.valueOf(url.getProtocol()) + "://" + url.getHost() + ":" + url.getPort() + "/";
        if (l == null) {
            this.password_handlers.remove(url_s);
        } else {
            this.password_handlers.put(url_s, new Object[]{l, url});
        }
    }

    public void addCertificateListener(SECertificateListener l) {
        try {
            this.this_mon.enter();
            this.certificate_listeners.add(l);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void setCertificateHandler(URL url, SECertificateListener l) {
        String url_s = String.valueOf(url.getProtocol()) + "://" + url.getHost() + ":" + url.getPort() + "/";
        if (l == null) {
            this.certificate_handlers.remove(url_s);
        } else {
            this.certificate_handlers.put(url_s, new Object[]{l, url});
        }
    }

    public void removeCertificateListener(SECertificateListener l) {
        try {
            this.this_mon.enter();
            this.certificate_listeners.remove(l);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public Class[] getClassContext() {
        if (this.my_sec_man == null) {
            return new Class[0];
        }
        return this.my_sec_man.getClassContext();
    }

    public static void main(String[] args) {
        SESecurityManagerImpl man = SESecurityManagerImpl.getSingleton();
        man.initialise();
        try {
            man.createSelfSignedCertificate("SomeAlias", "CN=fred,OU=wap,O=wip,L=here,ST=there,C=GB", 1000);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    private final class AzureusSecurityManager
    extends SecurityManager {
        private final SecurityManager old_sec_man;

        private AzureusSecurityManager(SecurityManager _old_sec_man) {
            this.old_sec_man = _old_sec_man;
        }

        @Override
        public void checkAccept(String host, int port) {
        }

        @Override
        public void checkRead(String file) {
        }

        @Override
        public void checkWrite(String file) {
        }

        @Override
        public void checkConnect(String host, int port) {
        }

        @Override
        public void checkExit(int status) {
            String prop;
            if (this.old_sec_man != null) {
                this.old_sec_man.checkExit(status);
            }
            if (!SESecurityManagerImpl.this.exit_vm_permitted && (prop = System.getProperty("azureus.security.manager.permitexit", "0")).equals("0")) {
                throw new SecurityException("VM exit operation prohibited");
            }
        }

        @Override
        public void checkPermission(Permission perm) {
            this.checkPermission(perm, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void checkPermission(Permission perm, Object context2) {
            if (perm instanceof RuntimePermission) {
                String name = perm.getName();
                if (name.equals("stopThread")) {
                    List list = SESecurityManagerImpl.this.stoppable_threads;
                    synchronized (list) {
                        if (SESecurityManagerImpl.this.stoppable_threads.contains(Thread.currentThread())) {
                            return;
                        }
                    }
                    throw new SecurityException("Thread.stop operation prohibited");
                }
                if (name.equals("setSecurityManager")) {
                    throw new SecurityException("Permission Denied");
                }
            }
            if (this.old_sec_man != null) {
                if (context2 == null) {
                    this.old_sec_man.checkPermission(perm);
                } else {
                    this.old_sec_man.checkPermission(perm, context2);
                }
            }
        }

        public Class[] getClassContext() {
            Class<?>[] res = super.getClassContext();
            if (res.length <= 3) {
                return new Class[0];
            }
            Class[] trimmed = new Class[res.length - 3];
            System.arraycopy(res, 3, trimmed, 0, trimmed.length);
            return trimmed;
        }
    }
}

