/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.peer.impl.transport;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.gudy.azureus2.core3.peer.impl.transport.PEPeerTransportProtocol;

public class PEPeerTransportDebugger {
    protected final int piece_length;
    protected static final int BT_READING_LENGTH_AND_TYPE = 1234567;
    protected int state = -1;
    protected byte[] data_read = new byte[68];
    protected int data_read_pos;

    protected PEPeerTransportDebugger(PEPeerTransportProtocol transport) {
        this.piece_length = transport.getControl().getPieceLength(0);
    }

    public int write(SocketChannel chan, ByteBuffer buffer) throws IOException {
        int pos = buffer.position();
        int len = chan.write(buffer);
        if (len > 0) {
            buffer.position(pos);
            this.analyse(buffer, len);
        }
        return len;
    }

    public long write(SocketChannel chan, ByteBuffer[] buffers, int array_offset, int array_length) throws IOException {
        int[] pos = new int[buffers.length];
        int i = array_offset;
        while (i < array_offset + array_length) {
            pos[i] = buffers[i].position();
            ++i;
        }
        long len = chan.write(buffers, array_offset, array_length);
        int i2 = array_offset;
        while (i2 < array_offset + array_length) {
            ByteBuffer buffer = buffers[i2];
            int written = buffer.position() - pos[i2];
            if (written > 0) {
                buffer.position(pos[i2]);
                this.analyse(buffer, written);
            }
            ++i2;
        }
        return len;
    }

    protected void analyse(ByteBuffer buffer, int length) {
        byte[] data = new byte[length];
        buffer.get(data);
        int i = 0;
        while (i < data.length) {
            if (this.data_read_pos == this.data_read.length) {
                ByteBuffer bb;
                if (this.state == 1234567) {
                    bb = ByteBuffer.wrap(this.data_read);
                    int len = bb.getInt();
                    this.state = bb.get();
                    if (len == 1) {
                        this.state = 1234567;
                        this.data_read = new byte[5];
                    } else {
                        this.data_read = new byte[len - 1];
                    }
                } else {
                    if (this.state == 7) {
                        bb = ByteBuffer.wrap(this.data_read);
                        int piece_number = bb.getInt();
                        int piece_offset = bb.getInt();
                        long overall_offset = (long)piece_number * (long)this.piece_length + (long)piece_offset;
                        while (bb.hasRemaining()) {
                            byte v = bb.get();
                            if ((byte)overall_offset != v) {
                                System.out.println("piece: write is bad at " + overall_offset + ": expected = " + (byte)overall_offset + ", actual = " + v);
                                break;
                            }
                            ++overall_offset;
                        }
                    }
                    this.state = 1234567;
                    this.data_read = new byte[5];
                }
                this.data_read_pos = 0;
            }
            this.data_read[this.data_read_pos++] = data[i];
            ++i;
        }
    }
}

