/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.ipfilter.impl;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Random;
import org.gudy.azureus2.core3.ipfilter.IpFilterManagerFactory;
import org.gudy.azureus2.core3.ipfilter.IpRange;
import org.gudy.azureus2.core3.ipfilter.impl.IpRangeImpl;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.tracker.protocol.PRHelpers;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.UnresolvableHostManager;

public class IPAddressRangeManager {
    private static final LogIDs LOGID = LogIDs.CORE;
    protected final ArrayList entries = new ArrayList();
    protected long total_span;
    protected boolean rebuild_required;
    protected long last_rebuild_time;
    protected IpRange[] mergedRanges = new IpRange[0];
    protected final AEMonitor this_mon = new AEMonitor("IPAddressRangeManager");

    protected IPAddressRangeManager() {
    }

    public void addRange(IpRange range) {
        try {
            this.this_mon.enter();
            this.entries.add(range);
            this.rebuild_required = true;
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void removeRange(IpRange range) {
        try {
            this.this_mon.enter();
            this.entries.remove(range);
            this.rebuild_required = true;
        }
        finally {
            this.this_mon.exit();
        }
    }

    public Object isInRange(String ip) {
        if (this.entries.size() == 0) {
            return null;
        }
        try {
            Object res;
            this.this_mon.enter();
            long address_long = this.addressToInt(ip);
            if (address_long < 0L) {
                address_long += 0x100000000L;
            }
            Object object = res = this.isInRange(address_long);
            return object;
        }
        finally {
            this.this_mon.exit();
        }
    }

    public Object isInRange(InetAddress ip) {
        if (this.entries.size() == 0) {
            return null;
        }
        try {
            Object res;
            this.this_mon.enter();
            long address_long = this.addressToInt(ip);
            if (address_long < 0L) {
                address_long += 0x100000000L;
            }
            Object object = res = this.isInRange(address_long);
            return object;
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected Object isInRange(long address_long) {
        try {
            IpRange e;
            this.this_mon.enter();
            this.checkRebuild();
            if (this.mergedRanges.length == 0) {
                return null;
            }
            int bottom = 0;
            int top = this.mergedRanges.length - 1;
            int current = -1;
            while (top >= 0 && bottom < this.mergedRanges.length && bottom <= top) {
                current = (bottom + top) / 2;
                e = this.mergedRanges[current];
                long this_start = e.getStartIpLong();
                long this_end = e.getMergedEndLong();
                if (address_long == this_start) break;
                if (address_long > this_start) {
                    if (address_long <= this_end) break;
                    bottom = current + 1;
                    continue;
                }
                if (address_long == this_end || address_long >= this_start) break;
                top = current - 1;
            }
            if (top >= 0 && bottom < this.mergedRanges.length && bottom <= top) {
                e = this.mergedRanges[current];
                if (address_long <= e.getEndIpLong()) {
                    IpRange ipRange = e;
                    return ipRange;
                }
                IpRange[] merged = e.getMergedEntries();
                if (merged == null) {
                    Debug.out("IPAddressRangeManager: inconsistent merged details - no entries");
                    return null;
                }
                int i = 0;
                while (i < merged.length) {
                    IpRange me = merged[i];
                    if (me.getStartIpLong() <= address_long && me.getEndIpLong() >= address_long) {
                        IpRange ipRange = me;
                        return ipRange;
                    }
                    ++i;
                }
                Debug.out("IPAddressRangeManager: inconsistent merged details - entry not found");
            }
            return null;
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected int addressToInt(String address) {
        try {
            return PRHelpers.addressToInt(address);
        }
        catch (UnknownHostException e) {
            return UnresolvableHostManager.getPseudoAddress(address);
        }
    }

    protected int addressToInt(InetAddress address) {
        return PRHelpers.addressToInt(address);
    }

    protected void checkRebuild() {
        try {
            long now;
            long secs_since_last_build;
            this.this_mon.enter();
            if (this.rebuild_required && (secs_since_last_build = ((now = SystemTime.getCurrentTime()) - this.last_rebuild_time) / 1000L) > (long)(this.entries.size() / 2000)) {
                this.last_rebuild_time = now;
                this.rebuild_required = false;
                this.rebuild();
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void rebuild() {
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "IPAddressRangeManager: rebuilding " + this.entries.size() + " entries starts"));
        }
        IpRange[] ents = new IpRange[this.entries.size()];
        this.entries.toArray(ents);
        int i = 0;
        while (i < ents.length) {
            ents[i].resetMergeInfo();
            ++i;
        }
        Arrays.sort(ents, new Comparator<IpRange>(){

            @Override
            public int compare(IpRange e1, IpRange e2) {
                long diff = e1.getStartIpLong() - e2.getStartIpLong();
                if (diff == 0L) {
                    diff = e2.getEndIpLong() - e1.getEndIpLong();
                }
                return IPAddressRangeManager.this.signum(diff);
            }
        });
        ArrayList<IpRange> me = new ArrayList<IpRange>(ents.length);
        int i2 = 0;
        while (i2 < ents.length) {
            IpRange entry = ents[i2];
            if (!entry.getMerged()) {
                me.add(entry);
                int pos = i2 + 1;
                while (pos < ents.length) {
                    IpRange e2;
                    long end_pos = entry.getMergedEndLong();
                    if ((e2 = ents[pos++]).getMerged()) continue;
                    if (end_pos < e2.getStartIpLong()) break;
                    e2.setMerged();
                    if (e2.getEndIpLong() <= end_pos) continue;
                    entry.setMergedEnd(e2.getEndIpLong());
                    entry.addMergedEntry(e2);
                }
            }
            ++i2;
        }
        this.mergedRanges = new IpRange[me.size()];
        me.toArray(this.mergedRanges);
        this.total_span = 0L;
        i2 = 0;
        while (i2 < this.mergedRanges.length) {
            IpRange e = this.mergedRanges[i2];
            long span = e.getMergedEndLong() - e.getStartIpLong() + 1L;
            this.total_span += span;
            ++i2;
        }
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "IPAddressRangeManager: rebuilding " + this.entries.size() + " entries ends"));
        }
    }

    protected int signum(long diff) {
        if (diff > 0L) {
            return 1;
        }
        if (diff < 0L) {
            return -1;
        }
        return 0;
    }

    protected long getTotalSpan() {
        this.checkRebuild();
        return this.total_span;
    }

    public static void main(String[] args) {
        IPAddressRangeManager manager = new IPAddressRangeManager();
        Random r = new Random();
        int i = 0;
        while (i < 1000000) {
            int ip1 = r.nextInt(0xFFFFFFF);
            int ip2 = ip1 + r.nextInt(255);
            String start = PRHelpers.intToAddress(ip1);
            String end = PRHelpers.intToAddress(ip2);
            manager.addRange(new IpRangeImpl("test_" + i, start, end, true));
            ++i;
        }
        int num = 0;
        int hits = 0;
        while (true) {
            if (num % 1000 == 0) {
                System.out.println(String.valueOf(num) + "/" + hits);
            }
            ++num;
            int ip = r.nextInt();
            Object res = manager.isInRange(ip);
            if (res == null) continue;
            ++hits;
        }
    }

    public ArrayList getEntries() {
        return this.entries;
    }

    public void clearAllEntries() {
        try {
            this.this_mon.enter();
            this.entries.clear();
            IpFilterManagerFactory.getSingleton().deleteAllDescriptions();
            this.rebuild_required = true;
        }
        finally {
            this.this_mon.exit();
        }
    }
}

