/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.global.impl;

import com.aelitis.azureus.core.util.GeneralUtils;
import com.aelitis.azureus.core.util.average.MovingImmediateAverage;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.global.GlobalManagerStats;
import org.gudy.azureus2.core3.global.impl.GlobalManagerImpl;
import org.gudy.azureus2.core3.util.Average;
import org.gudy.azureus2.core3.util.SimpleTimer;

public class GlobalManagerStatsImpl
implements GlobalManagerStats,
SimpleTimer.TimerTickReceiver {
    private final GlobalManagerImpl manager;
    private long smooth_last_sent;
    private long smooth_last_received;
    private int current_smoothing_window = GeneralUtils.getSmoothUpdateWindow();
    private int current_smoothing_interval = GeneralUtils.getSmoothUpdateInterval();
    private MovingImmediateAverage smoothed_receive_rate = GeneralUtils.getSmoothAverage();
    private MovingImmediateAverage smoothed_send_rate = GeneralUtils.getSmoothAverage();
    private long total_data_bytes_received;
    private long total_protocol_bytes_received;
    private long totalDiscarded;
    private long total_data_bytes_sent;
    private long total_protocol_bytes_sent;
    private int data_send_speed_at_close;
    private final Average data_receive_speed = Average.getInstance(1000, 10);
    private final Average protocol_receive_speed = Average.getInstance(1000, 10);
    private final Average data_receive_speed_no_lan = Average.getInstance(1000, 10);
    private final Average protocol_receive_speed_no_lan = Average.getInstance(1000, 10);
    private final Average data_send_speed = Average.getInstance(1000, 10);
    private final Average protocol_send_speed = Average.getInstance(1000, 10);
    private final Average data_send_speed_no_lan = Average.getInstance(1000, 10);
    private final Average protocol_send_speed_no_lan = Average.getInstance(1000, 10);

    protected GlobalManagerStatsImpl(GlobalManagerImpl _manager) {
        this.manager = _manager;
        this.load();
        SimpleTimer.addTickReceiver(this);
    }

    protected void load() {
        this.data_send_speed_at_close = COConfigurationManager.getIntParameter("globalmanager.stats.send.speed.at.close", 0);
    }

    protected void save() {
        COConfigurationManager.setParameter("globalmanager.stats.send.speed.at.close", this.getDataSendRate());
    }

    @Override
    public int getDataSendRateAtClose() {
        return this.data_send_speed_at_close;
    }

    @Override
    public void discarded(int length) {
        this.totalDiscarded += (long)length;
    }

    @Override
    public void dataBytesReceived(int length, boolean LAN) {
        this.total_data_bytes_received += (long)length;
        if (!LAN) {
            this.data_receive_speed_no_lan.addValue(length);
        }
        this.data_receive_speed.addValue(length);
    }

    @Override
    public void protocolBytesReceived(int length, boolean LAN) {
        this.total_protocol_bytes_received += (long)length;
        if (!LAN) {
            this.protocol_receive_speed_no_lan.addValue(length);
        }
        this.protocol_receive_speed.addValue(length);
    }

    @Override
    public void dataBytesSent(int length, boolean LAN) {
        this.total_data_bytes_sent += (long)length;
        if (!LAN) {
            this.data_send_speed_no_lan.addValue(length);
        }
        this.data_send_speed.addValue(length);
    }

    @Override
    public void protocolBytesSent(int length, boolean LAN) {
        this.total_protocol_bytes_sent += (long)length;
        if (!LAN) {
            this.protocol_send_speed_no_lan.addValue(length);
        }
        this.protocol_send_speed.addValue(length);
    }

    @Override
    public int getDataReceiveRate() {
        return (int)this.data_receive_speed.getAverage();
    }

    @Override
    public int getDataReceiveRateNoLAN() {
        return (int)this.data_receive_speed_no_lan.getAverage();
    }

    @Override
    public int getDataReceiveRateNoLAN(int average_period) {
        return (int)(average_period <= 0 ? this.data_receive_speed_no_lan.getAverage() : this.data_receive_speed_no_lan.getAverage(average_period));
    }

    @Override
    public int getProtocolReceiveRate() {
        return (int)this.protocol_receive_speed.getAverage();
    }

    @Override
    public int getProtocolReceiveRateNoLAN() {
        return (int)this.protocol_receive_speed_no_lan.getAverage();
    }

    @Override
    public int getProtocolReceiveRateNoLAN(int average_period) {
        return (int)(average_period <= 0 ? this.protocol_receive_speed_no_lan.getAverage() : this.protocol_receive_speed_no_lan.getAverage(average_period));
    }

    @Override
    public int getDataAndProtocolReceiveRate() {
        return (int)(this.protocol_receive_speed.getAverage() + this.data_receive_speed.getAverage());
    }

    @Override
    public int getDataSendRate() {
        return (int)this.data_send_speed.getAverage();
    }

    @Override
    public int getDataSendRateNoLAN() {
        return (int)this.data_send_speed_no_lan.getAverage();
    }

    @Override
    public int getDataSendRateNoLAN(int average_period) {
        return (int)(average_period <= 0 ? this.data_send_speed_no_lan.getAverage() : this.data_send_speed_no_lan.getAverage(average_period));
    }

    @Override
    public int getProtocolSendRate() {
        return (int)this.protocol_send_speed.getAverage();
    }

    @Override
    public int getProtocolSendRateNoLAN() {
        return (int)this.protocol_send_speed_no_lan.getAverage();
    }

    @Override
    public int getProtocolSendRateNoLAN(int average_period) {
        return (int)(average_period <= 0 ? this.protocol_send_speed_no_lan.getAverage() : this.protocol_send_speed_no_lan.getAverage(average_period));
    }

    @Override
    public int getDataAndProtocolSendRate() {
        return (int)(this.protocol_send_speed.getAverage() + this.data_send_speed.getAverage());
    }

    @Override
    public long getTotalDataBytesSent() {
        return this.total_data_bytes_sent;
    }

    @Override
    public long getTotalProtocolBytesSent() {
        return this.total_protocol_bytes_sent;
    }

    @Override
    public long getTotalDataBytesReceived() {
        return this.total_data_bytes_received;
    }

    @Override
    public long getTotalProtocolBytesReceived() {
        return this.total_protocol_bytes_received;
    }

    public long getTotalDiscardedRaw() {
        return this.totalDiscarded;
    }

    @Override
    public long getTotalSwarmsPeerRate(boolean downloading, boolean seeding) {
        return this.manager.getTotalSwarmsPeerRate(downloading, seeding);
    }

    @Override
    public void tick(long mono_now, int tick_count) {
        if (tick_count % this.current_smoothing_interval == 0) {
            int current_window = GeneralUtils.getSmoothUpdateWindow();
            if (this.current_smoothing_window != current_window) {
                this.current_smoothing_window = current_window;
                this.current_smoothing_interval = GeneralUtils.getSmoothUpdateInterval();
                this.smoothed_receive_rate = GeneralUtils.getSmoothAverage();
                this.smoothed_send_rate = GeneralUtils.getSmoothAverage();
            }
            long up = this.total_data_bytes_sent + this.total_protocol_bytes_sent;
            long down = this.total_data_bytes_received + this.total_protocol_bytes_received;
            this.smoothed_send_rate.update(up - this.smooth_last_sent);
            this.smoothed_receive_rate.update(down - this.smooth_last_received);
            this.smooth_last_sent = up;
            this.smooth_last_received = down;
        }
    }

    @Override
    public long getSmoothedSendRate() {
        return (long)(this.smoothed_send_rate.getAverage() / (double)this.current_smoothing_interval);
    }

    @Override
    public long getSmoothedReceiveRate() {
        return (long)(this.smoothed_receive_rate.getAverage() / (double)this.current_smoothing_interval);
    }
}

