/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.download;

import java.io.File;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.download.DownloadManagerException;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.download.DownloadManagerStateAttributeListener;
import org.gudy.azureus2.core3.download.impl.DownloadManagerStateImpl;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;

public class DownloadManagerStateFactory {
    public static int MAX_FILES_FOR_INCOMPLETE_AND_DND_LINKAGE;

    static {
        COConfigurationManager.addAndFireParameterListener("Max File Links Supported", new ParameterListener(){

            @Override
            public void parameterChanged(String name) {
                MAX_FILES_FOR_INCOMPLETE_AND_DND_LINKAGE = COConfigurationManager.getIntParameter(name);
            }
        });
    }

    public static DownloadManagerState getDownloadState(TOTorrent torrent) throws TOTorrentException {
        return DownloadManagerStateImpl.getDownloadState(torrent);
    }

    public static void loadGlobalStateCache() {
        DownloadManagerStateImpl.loadGlobalStateCache();
    }

    public static void saveGlobalStateCache() {
        DownloadManagerStateImpl.saveGlobalStateCache();
    }

    public static void discardGlobalStateCache() {
        DownloadManagerStateImpl.discardGlobalStateCache();
    }

    public static void importDownloadState(File source_dir, byte[] download_hash) throws DownloadManagerException {
        DownloadManagerStateImpl.importDownloadState(source_dir, download_hash);
    }

    public static void deleteDownloadState(byte[] download_hash) throws DownloadManagerException {
        DownloadManagerStateImpl.deleteDownloadState(download_hash);
    }

    public static void deleteDownloadState(File source_dir, byte[] download_hash) throws DownloadManagerException {
        DownloadManagerStateImpl.deleteDownloadState(source_dir, download_hash);
    }

    public static void addGlobalListener(DownloadManagerStateAttributeListener l, String attribute, int event_type) {
        DownloadManagerStateImpl.addGlobalListener(l, attribute, event_type);
    }

    public void removeGlobalListener(DownloadManagerStateAttributeListener l, String attribute, int event_type) {
        DownloadManagerStateImpl.removeGlobalListener(l, attribute, event_type);
    }
}

