/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.disk.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.impl.DiskManagerHelper;
import org.gudy.azureus2.core3.disk.impl.DiskManagerRecheckInstance;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.RealTimeInfo;

public class DiskManagerRecheckScheduler {
    private static boolean friendly_hashing;
    private static boolean smallest_first;
    private final List instances = new ArrayList();
    private final AEMonitor instance_mon = new AEMonitor("DiskManagerRecheckScheduler");

    static {
        ParameterListener param_listener = new ParameterListener(){

            @Override
            public void parameterChanged(String str) {
                friendly_hashing = COConfigurationManager.getBooleanParameter("diskmanager.friendly.hashchecking");
                smallest_first = COConfigurationManager.getBooleanParameter("diskmanager.hashchecking.smallestfirst");
            }
        };
        COConfigurationManager.addAndFireParameterListeners(new String[]{"diskmanager.friendly.hashchecking", "diskmanager.hashchecking.smallestfirst"}, param_listener);
    }

    public DiskManagerRecheckInstance register(DiskManagerHelper helper, boolean low_priority) {
        try {
            this.instance_mon.enter();
            DiskManagerRecheckInstance res = new DiskManagerRecheckInstance(this, helper.getTorrent().getSize(), (int)helper.getTorrent().getPieceLength(), low_priority);
            this.instances.add(res);
            if (smallest_first) {
                Collections.sort(this.instances, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        long comp2 = ((DiskManagerRecheckInstance)o1).getMetric() - ((DiskManagerRecheckInstance)o2).getMetric();
                        if (comp2 < 0L) {
                            return -1;
                        }
                        if (comp2 == 0L) {
                            return 0;
                        }
                        return 1;
                    }
                });
            }
            DiskManagerRecheckInstance diskManagerRecheckInstance = res;
            return diskManagerRecheckInstance;
        }
        finally {
            this.instance_mon.exit();
        }
    }

    protected boolean getPermission(DiskManagerRecheckInstance instance) {
        boolean result = false;
        int delay = 250;
        try {
            this.instance_mon.enter();
            if (this.instances.get(0) == instance) {
                boolean low_priority = instance.isLowPriority();
                if (low_priority && RealTimeInfo.isRealTimeTaskActive()) {
                    result = false;
                } else {
                    if (friendly_hashing) {
                        delay = 0;
                    } else if (!low_priority) {
                        delay = 1;
                    } else {
                        delay = instance.getPieceLength() / 1024 / 10;
                        delay = Math.min(delay, 409);
                        delay = Math.max(delay, 12);
                    }
                    result = true;
                }
            }
        }
        finally {
            this.instance_mon.exit();
        }
        if (delay > 0) {
            try {
                Thread.sleep(delay);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return result;
    }

    protected void unregister(DiskManagerRecheckInstance instance) {
        try {
            this.instance_mon.enter();
            this.instances.remove(instance);
        }
        finally {
            this.instance_mon.exit();
        }
    }
}

