/*
 * Decompiled with CFR 0.152.
 */
package lbms.plugins.mldht.kad;

import java.util.Arrays;
import java.util.Comparator;

public class DBItem {
    protected byte[] item;
    private final long time_stamp = System.currentTimeMillis();
    public static final Comparator<DBItem> ageOrdering = new Comparator<DBItem>(){

        @Override
        public int compare(DBItem o1, DBItem o2) {
            return (int)(o1.time_stamp - o2.time_stamp);
        }
    };

    private DBItem() {
    }

    public DBItem(byte[] ip_port) {
        this();
        this.item = (byte[])ip_port.clone();
    }

    public boolean expired(long now) {
        return now - this.time_stamp >= 3600000L;
    }

    public byte[] getData() {
        return this.item;
    }

    public String toString() {
        return "DBItem length:" + this.item.length;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DBItem) {
            byte[] otherItem = ((DBItem)obj).item;
            return Arrays.equals(this.item, otherItem);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.item);
    }
}

