/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.plugins.rcmplugin;

import com.aelitis.azureus.core.content.RelatedContent;
import com.aelitis.azureus.ui.UserPrompterResultListener;
import com.aelitis.plugins.rcmplugin.RCMPatcher;
import com.aelitis.plugins.rcmplugin.RCM_JSONServer;
import com.aelitis.plugins.rcmplugin.RCM_SearchProvider;
import com.aelitis.plugins.rcmplugin.RelatedContentUI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.ByteArrayHashMap;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.PluginConfig;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.UnloadablePlugin;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.ipc.IPCException;
import org.gudy.azureus2.plugins.ui.UIInstance;
import org.gudy.azureus2.plugins.ui.UIManagerListener;
import org.gudy.azureus2.plugins.utils.LocaleUtilities;
import org.gudy.azureus2.plugins.utils.Utilities;
import org.gudy.azureus2.plugins.utils.search.SearchProvider;

public class RCMPlugin
implements UnloadablePlugin {
    protected static final int MIN_SEARCH_RANK_DEFAULT = 0;
    public static final String PARAM_SOURCES_LIST = "Plugin.aercm.sources.setlist";
    public static final String PARAM_SOURCES_ISDEFAULT = "Plugin.aercm.sources.isdefault";
    public static final String PARAM_FTUX_SHOWN = "rcm.ftux.shown2";
    public static final String POPULARITY_SEARCH_EXPR = "(.)";
    private PluginInterface plugin_interface;
    private RelatedContentUI ui;
    private SearchProvider search_provider;
    private boolean destroyed;
    List<String> source_map_defaults = new ArrayList<String>();
    private ByteArrayHashMap<Boolean> source_map;
    private boolean source_map_wildcard;
    private byte[] source_vhdn;
    private RCM_JSONServer json_rpc_server;

    static {
        COConfigurationManager.setParameter("rcm.persist", true);
        new RCMPatcher();
    }

    public RCMPlugin() {
        this.source_map_defaults.add("vhdn.vuze.com");
        this.source_map_defaults.add("tracker.vodo.net");
        this.source_map_defaults.add("bt.archive.org");
        this.source_map_defaults.add("tracker.legaltorrents.com");
        this.source_map_defaults.add("tracker.mininova.org");
        this.source_map_defaults.add("www.legaltorrents.com");
        this.source_map_defaults.add("torrent.ubuntu.com");
        this.source_map_defaults.add("torrents.freebsd.org");
        this.source_map_defaults.add("torrent.fedoraproject.org");
        this.source_map_defaults.add("tracker.opensuse.org");
        this.source_map_defaults.add("torrents.linuxmint.com");
        this.source_map_defaults.add("tracker.johncave.co.nz");
        this.source_map_defaults.add("academictorrents.com");
        this.source_map = new ByteArrayHashMap();
        this.source_vhdn = this.compressDomain("vhdn.vuze.com");
    }

    private byte[] compressDomain(String host) {
        String[] bits = host.split("\\.");
        int len = bits.length;
        if (len < 2) {
            bits = new String[]{bits[0], "com"};
        }
        String end = bits[len - 1];
        String dom = String.valueOf(bits[len - 2]) + "." + end;
        int hash = dom.hashCode();
        byte[] bytes = new byte[]{(byte)(hash >> 24), (byte)(hash >> 16), (byte)(hash >> 8), (byte)hash};
        return bytes;
    }

    @Override
    public void initialize(PluginInterface _plugin_interface) throws PluginException {
        this.plugin_interface = _plugin_interface;
        boolean isDefaultList = COConfigurationManager.getBooleanParameter(PARAM_SOURCES_ISDEFAULT, false);
        if (isDefaultList) {
            this.setToDefaultSourcesList();
        } else {
            List<String> list = this.getSourcesList();
            if (this.source_map_defaults.containsAll(list)) {
                this.setToDefaultSourcesList();
            }
        }
        COConfigurationManager.addAndFireParameterListener(PARAM_SOURCES_LIST, new ParameterListener(){

            @Override
            public void parameterChanged(String name) {
                RCMPlugin.this.updateSourcesList();
            }
        });
        LocaleUtilities loc_utils = this.plugin_interface.getUtilities().getLocaleUtilities();
        loc_utils.integrateLocalisedMessageBundle("com.aelitis.plugins.rcmplugin.internat.Messages");
        this.hookSearch();
        this.updatePluginInfo();
        this.plugin_interface.getUIManager().addUIListener(new UIManagerListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void UIAttached(UIInstance instance) {
                if (instance.getUIType() == 1) {
                    RCMPlugin rCMPlugin = RCMPlugin.this;
                    synchronized (rCMPlugin) {
                        if (RCMPlugin.this.destroyed) {
                            return;
                        }
                        try {
                            Class<?> cla = Class.forName("com.aelitis.plugins.rcmplugin.RelatedContentUISWT");
                            RCMPlugin.this.ui = (RelatedContentUI)cla.getMethod("getSingleton", PluginInterface.class, UIInstance.class, RCMPlugin.class).invoke(null, RCMPlugin.this.plugin_interface, instance, RCMPlugin.this);
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                }
            }

            @Override
            public void UIDetached(UIInstance instance) {
            }
        });
        this.json_rpc_server = new RCM_JSONServer(this);
        this.plugin_interface.getUtilities().registerJSONRPCServer(this.json_rpc_server);
    }

    protected void updatePluginInfo() {
        String plugin_info = !this.hasFTUXBeenShown() ? "f" : (this.isRCMEnabled() ? "e" : "d");
        PluginConfig pc = this.plugin_interface.getPluginconfig();
        if (!pc.getPluginStringParameter("plugin.info", "").equals(plugin_info)) {
            pc.setPluginParameter("plugin.info", plugin_info);
            COConfigurationManager.save();
        }
    }

    protected boolean isRCMEnabled() {
        return COConfigurationManager.getBooleanParameter("rcm.overall.enabled", true);
    }

    protected boolean setRCMEnabled(boolean enabled) {
        if (this.isRCMEnabled() != enabled) {
            COConfigurationManager.setParameter("rcm.overall.enabled", enabled);
            this.hookSearch();
            this.updatePluginInfo();
            return true;
        }
        return false;
    }

    protected boolean hasFTUXBeenShown() {
        return this.plugin_interface.getPluginconfig().getPluginBooleanParameter(PARAM_FTUX_SHOWN, false);
    }

    protected void setFTUXBeenShown(boolean b) {
        this.plugin_interface.getPluginconfig().setPluginParameter(PARAM_FTUX_SHOWN, b);
        this.hookSearch();
        this.updatePluginInfo();
    }

    protected boolean isUIEnabled() {
        return this.plugin_interface.getPluginconfig().getPluginBooleanParameter("rcm.ui.enable", false);
    }

    protected void setUIEnabled(boolean b) {
        this.plugin_interface.getPluginconfig().setPluginParameter("rcm.ui.enable", b);
    }

    protected boolean isSearchEnabled() {
        return this.plugin_interface.getPluginconfig().getPluginBooleanParameter("rcm.search.enable", false);
    }

    protected void setSearchEnabled(boolean b) {
        this.plugin_interface.getPluginconfig().setPluginParameter("rcm.search.enable", b);
    }

    protected int getMinuumSearchRank() {
        return this.plugin_interface.getPluginconfig().getPluginIntParameter("rcm.search.min_rank", 0);
    }

    public SearchProvider getSearchProvider() {
        return this.search_provider;
    }

    public PluginInterface getPluginInterface() {
        return this.plugin_interface;
    }

    protected void hookSearch() {
        boolean enable = this.isRCMEnabled() && this.isSearchEnabled() && this.hasFTUXBeenShown();
        try {
            Utilities utilities = this.plugin_interface.getUtilities();
            if (enable) {
                if (this.search_provider == null) {
                    this.search_provider = new RCM_SearchProvider(this);
                    utilities.registerSearchProvider(this.search_provider);
                }
            } else if (this.search_provider != null) {
                utilities.unregisterSearchProvider(this.search_provider);
                this.search_provider = null;
            }
        }
        catch (Throwable e) {
            Debug.out("Failed to register/unregister search provider", e);
        }
    }

    private void updateSourcesList() {
        List<String> list = this.getSourcesList();
        this.source_map.clear();
        this.source_map_wildcard = false;
        for (String host : list) {
            if (host.equals("*")) {
                this.source_map_wildcard = true;
                continue;
            }
            this.source_map.put(this.compressDomain(host), Boolean.TRUE);
        }
        boolean isDefaultList = list.size() == this.source_map_defaults.size() && list.containsAll(this.source_map_defaults);
        COConfigurationManager.setParameter(PARAM_SOURCES_ISDEFAULT, isDefaultList);
    }

    public List<String> getSourcesList() {
        List original_list = COConfigurationManager.getListParameter(PARAM_SOURCES_LIST, this.source_map_defaults);
        List list = BDecoder.decodeStrings(BEncoder.cloneList(original_list));
        return list;
    }

    public void setToDefaultSourcesList() {
        COConfigurationManager.setParameter(PARAM_SOURCES_LIST, this.source_map_defaults);
    }

    public void setToAllSources() {
        COConfigurationManager.setParameter(PARAM_SOURCES_LIST, Arrays.asList("*"));
    }

    public boolean isDefaultSourcesList() {
        return COConfigurationManager.getBooleanParameter(PARAM_SOURCES_ISDEFAULT, false);
    }

    public boolean isAllSources() {
        return this.source_map_wildcard;
    }

    public boolean isVisible(long cnet) {
        if (cnet == 3L) {
            return this.isVisible(this.source_vhdn);
        }
        return false;
    }

    public boolean isVisible(byte[] key_list) {
        if (this.source_map_wildcard) {
            return true;
        }
        if (key_list != null) {
            int i = 0;
            while (i < key_list.length) {
                Boolean b = this.source_map.get(key_list, i, 4);
                if (b != null && b.booleanValue()) {
                    return true;
                }
                i += 4;
            }
        }
        return false;
    }

    public boolean isVisible(RelatedContent related_content) {
        if (this.source_map_wildcard) {
            return true;
        }
        long cnet = related_content.getContentNetwork();
        byte[] tracker_keys = cnet == 3L ? this.source_vhdn : related_content.getTrackerKeys();
        if (this.isVisible(tracker_keys)) {
            return true;
        }
        byte[] ws_keys = related_content.getWebSeedKeys();
        return this.isVisible(ws_keys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unload() throws PluginException {
        RCMPlugin rCMPlugin = this;
        synchronized (rCMPlugin) {
            if (this.destroyed) {
                return;
            }
            this.destroyed = true;
        }
        if (this.ui != null) {
            this.ui.destroy();
            this.ui = null;
        }
        if (this.search_provider != null) {
            try {
                this.plugin_interface.getUtilities().unregisterSearchProvider(this.search_provider);
                this.search_provider = null;
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        if (this.json_rpc_server != null) {
            this.plugin_interface.getUtilities().unregisterJSONRPCServer(this.json_rpc_server);
            this.json_rpc_server.unload();
            this.json_rpc_server = null;
        }
    }

    public void lookupByDownload(final Download download) throws IPCException {
        RelatedContentUI current_ui = this.ui;
        if (current_ui == null) {
            throw new IPCException("UI not bound");
        }
        if (!this.hasFTUXBeenShown() || !this.isRCMEnabled()) {
            current_ui.showFTUX(new UserPrompterResultListener(){

                @Override
                public void prompterClosed(int result) {
                    RelatedContentUI current_ui;
                    if (RCMPlugin.this.isRCMEnabled() && (current_ui = RCMPlugin.this.ui) != null) {
                        current_ui.setUIEnabled(true);
                        current_ui.addSearch(download);
                    }
                }
            });
        } else {
            current_ui.setUIEnabled(true);
            current_ui.addSearch(download);
        }
    }

    public void lookupBySize(long size) throws IPCException {
        this.lookupBySize(size, new String[]{"Public"});
    }

    public void lookupBySize(final long size, final String[] networks) throws IPCException {
        RelatedContentUI current_ui = this.ui;
        if (current_ui == null) {
            throw new IPCException("UI not bound");
        }
        if (!this.hasFTUXBeenShown() || !this.isRCMEnabled()) {
            current_ui.showFTUX(new UserPrompterResultListener(){

                @Override
                public void prompterClosed(int result) {
                    RelatedContentUI current_ui;
                    if (RCMPlugin.this.isRCMEnabled() && (current_ui = RCMPlugin.this.ui) != null) {
                        current_ui.setUIEnabled(true);
                        current_ui.addSearch(size, networks);
                    }
                }
            });
        } else {
            current_ui.setUIEnabled(true);
            current_ui.addSearch(size, networks);
        }
    }

    public void lookupByExpression(String expression) throws IPCException {
        this.lookupByExpression(expression, new String[]{"Public"});
    }

    public void lookupByExpression(String expression, String[] networks) throws IPCException {
        this.lookupByExpression(expression, networks, new HashMap<String, Object>());
    }

    public void lookupByExpression(final String expression, final String[] networks, final Map<String, Object> options) throws IPCException {
        RelatedContentUI current_ui = this.ui;
        if (current_ui == null) {
            throw new IPCException("UI not bound");
        }
        final Runnable do_it = new Runnable(){

            @Override
            public void run() {
                if (RCMPlugin.this.isRCMEnabled()) {
                    boolean is_subscription;
                    Boolean b_is_subscription = (Boolean)options.get("Subscription");
                    boolean bl = is_subscription = b_is_subscription != null && b_is_subscription != false;
                    if (is_subscription) {
                        HashMap<String, Object> properties = new HashMap<String, Object>();
                        String name = (String)options.get("Name");
                        if (name == null) {
                            name = expression;
                        }
                        properties.put("t", name);
                        properties.put("s", expression);
                        properties.put("n", networks);
                        properties.put("_frequency_", 10);
                        try {
                            RCMPlugin.this.getPluginInterface().getUtilities().getSubscriptionManager().requestSubscription(RCMPlugin.this.getSearchProvider(), properties);
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    } else {
                        RelatedContentUI current_ui = RCMPlugin.this.ui;
                        if (current_ui != null) {
                            current_ui.setUIEnabled(true);
                            current_ui.addSearch(expression, networks);
                        }
                    }
                }
            }
        };
        if (!this.hasFTUXBeenShown() || !this.isRCMEnabled()) {
            current_ui.showFTUX(new UserPrompterResultListener(){

                @Override
                public void prompterClosed(int result) {
                    do_it.run();
                }
            });
        } else {
            do_it.run();
        }
    }

    public void lookupByHash(byte[] hash, String name) throws IPCException {
        this.lookupByHash(hash, new String[]{"Public"}, name);
    }

    public void lookupByHash(final byte[] hash, final String[] networks, final String name) throws IPCException {
        RelatedContentUI current_ui = this.ui;
        if (current_ui == null) {
            throw new IPCException("UI not bound");
        }
        if (!this.hasFTUXBeenShown() || !this.isRCMEnabled()) {
            current_ui.showFTUX(new UserPrompterResultListener(){

                @Override
                public void prompterClosed(int result) {
                    RelatedContentUI current_ui;
                    if (RCMPlugin.this.isRCMEnabled() && (current_ui = RCMPlugin.this.ui) != null) {
                        current_ui.setUIEnabled(true);
                        current_ui.addSearch(hash, networks, name);
                    }
                }
            });
        } else {
            current_ui.setUIEnabled(true);
            current_ui.addSearch(hash, networks, name);
        }
    }

    public static String getNetworkString(String[] networks) {
        if (networks == null || networks.length == 0) {
            return "";
        }
        if (networks.length == 1) {
            if (networks[0] != "Public") {
                return " [" + networks[0] + "]";
            }
            return "";
        }
        String str = "";
        String[] stringArray = networks;
        int n = networks.length;
        int n2 = 0;
        while (n2 < n) {
            String net = stringArray[n2];
            str = String.valueOf(str) + (str.length() == 0 ? "" : ",") + net;
            ++n2;
        }
        return " [" + str + "]";
    }

    public static String getMagnetURI(RelatedContent rc) {
        String uri = UrlUtils.getMagnetURI(rc.getHash(), rc.getTitle(), rc.getNetworks());
        String[] tags = rc.getTags();
        if (tags != null) {
            String[] stringArray = tags;
            int n = tags.length;
            int n2 = 0;
            while (n2 < n) {
                String tag = stringArray[n2];
                uri = String.valueOf(uri) + "&tag=" + UrlUtils.encode(tag);
                ++n2;
            }
        }
        return uri;
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }
}

