/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.upnpmediaserver;

import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminNetworkInterface;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminNetworkInterfaceAddress;
import com.aelitis.azureus.core.util.average.AverageFactory;
import com.aelitis.azureus.core.util.average.MovingImmediateAverage;
import com.aelitis.azureus.plugins.upnpmediaserver.UPnPMediaChannel;
import com.aelitis.azureus.plugins.upnpmediaserver.UPnPMediaRendererRemote;
import com.aelitis.azureus.plugins.upnpmediaserver.UPnPMediaServer;
import com.aelitis.azureus.plugins.upnpmediaserver.UPnPMediaServerContentDirectory;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import org.bouncycastle.util.encoders.Base64;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Average;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.ThreadPool;
import org.gudy.azureus2.core3.util.ThreadPoolTask;
import org.gudy.azureus2.core3.util.TimeFormatter;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.disk.DiskManagerChannel;
import org.gudy.azureus2.plugins.disk.DiskManagerEvent;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.disk.DiskManagerListener;
import org.gudy.azureus2.plugins.disk.DiskManagerRequest;
import org.gudy.azureus2.plugins.utils.PooledByteBuffer;

public class UPnPMediaServerContentServer {
    private static final String NL = "\r\n";
    private static final int MAX_CONNECTIONS_PER_ENDPOINT = 16;
    private UPnPMediaServer plugin;
    private int port;
    private InetAddress first_bind_ip;
    private ThreadPool thread_pool;
    private PluginInterface plugin_interface;
    private List<UPnPMediaChannel> close_queue = new ArrayList<UPnPMediaChannel>();
    private List<processor> active_processors = new ArrayList<processor>();
    private Map<Integer, processor> stream_map = new HashMap<Integer, processor>();
    private List<ServerSocket> server_sockets = new ArrayList<ServerSocket>();
    private volatile boolean destroyed;
    private static final int MAX_OMS = 8;
    private static final int OM_MAX_WRITES = 128;
    private static final int OM_TIMEOUT = 10000;
    private static final int OM_SLEEP_PERIOD = 25;
    private static final int OM_STATS_PERIOD = 1000;
    private static final int OM_STATS_TICKS = 40;
    private Map<String, overWriteMonitor> overwrite_monitors = new HashMap<String, overWriteMonitor>();
    private AEThread2 om_update_thread;

    protected UPnPMediaServerContentServer(UPnPMediaServer _plugin) throws IOException {
        InetAddress[] bind_ips;
        this.plugin = _plugin;
        this.plugin_interface = this.plugin.getPluginInterface();
        this.thread_pool = new ThreadPool("UPnPMediaServer:processor", 64);
        Random random = new Random();
        this.port = this.plugin.getContentPort();
        AbstractInterruptibleChannel ssc = null;
        if (this.port == 0) {
            this.port = random.nextInt(20000) + 40000;
        }
        InetAddress[] inetAddressArray = bind_ips = this.plugin.getApplyBindIPs() ? NetworkAdmin.getSingleton().getMultiHomedServiceBindAddresses(true) : new InetAddress[]{};
        if (bind_ips.length == 0 || bind_ips.length == 1 && bind_ips[0].isAnyLocalAddress()) {
            if (this.canBind(null)) {
                bind_ips = new Inet4Address[1];
            } else {
                bind_ips = this.getBindableAddresses();
                if (bind_ips.length == 0) {
                    bind_ips = new InetAddress[]{InetAddress.getByName("127.0.0.1")};
                }
            }
        }
        boolean warned = false;
        InetAddress selected_bind_ip = null;
        int i = 0;
        block12: while (i < 1024) {
            try {
                IOException fail = null;
                int j = 0;
                while (j < bind_ips.length) {
                    ssc = ServerSocketChannel.open();
                    try {
                        this.bind((ServerSocketChannel)ssc, bind_ips[j], this.port);
                        selected_bind_ip = bind_ips[j];
                        break block12;
                    }
                    catch (IOException e) {
                        fail = e;
                        ssc.close();
                        ssc = null;
                        ++j;
                    }
                }
                if (fail != null) {
                    throw fail;
                }
            }
            catch (Throwable e) {
                if (ssc != null) {
                    try {
                        ssc.close();
                    }
                    catch (Throwable f) {
                        Debug.printStackTrace(e);
                    }
                    ssc = null;
                }
                if (this.plugin.isUserSelectedContentPort() && !warned) {
                    this.plugin.logAlert("Unable to bind to user selected stream port " + this.port + "; reverting to random port");
                    warned = true;
                }
                this.port = random.nextInt(20000) + 40000;
            }
            ++i;
        }
        if (ssc == null) {
            IOException fail = null;
            int i2 = 0;
            while (i2 < bind_ips.length) {
                ssc = ServerSocketChannel.open();
                try {
                    this.bind((ServerSocketChannel)ssc, bind_ips[i2], 0);
                    selected_bind_ip = bind_ips[i2];
                    this.port = ((ServerSocketChannel)ssc).socket().getLocalPort();
                    fail = null;
                    break;
                }
                catch (IOException e) {
                    fail = e;
                    ssc.close();
                    ssc = null;
                    ++i2;
                }
            }
            if (fail != null) {
                throw fail;
            }
        }
        this.first_bind_ip = selected_bind_ip;
        i = 0;
        while (i < bind_ips.length) {
            block29: {
                ServerSocket ss;
                if (bind_ips[i] == selected_bind_ip) {
                    ss = ((ServerSocketChannel)ssc).socket();
                    this.plugin.setContentPort(this.port);
                } else {
                    ServerSocketChannel ssc2 = null;
                    try {
                        ssc2 = ServerSocketChannel.open();
                        this.bind(ssc2, bind_ips[i], this.port);
                        ss = ssc2.socket();
                    }
                    catch (Throwable e) {
                        if (ssc2 != null) {
                            try {
                                ssc2.close();
                            }
                            catch (Throwable throwable) {}
                        }
                        break block29;
                    }
                }
                ss.setReuseAddress(true);
                this.server_sockets.add(ss);
                final ServerSocket f_ss = ss;
                new AEThread2("UPnPMediaServer:accepter", true){

                    @Override
                    public void run() {
                        int processor_num = 0;
                        try {
                            long successfull_accepts = 0L;
                            long failed_accepts = 0L;
                            while (!UPnPMediaServerContentServer.this.destroyed) {
                                try {
                                    Socket socket = f_ss.accept();
                                    ++successfull_accepts;
                                    String ip = socket.getInetAddress().getHostAddress();
                                    processor proc = new processor(ip, socket, processor_num++);
                                    UPnPMediaServerContentServer.this.thread_pool.run(proc);
                                }
                                catch (Throwable e) {
                                    if (UPnPMediaServerContentServer.this.destroyed) continue;
                                    if (failed_accepts == 0L) {
                                        UPnPMediaServerContentServer.this.plugin.log("Accept failed", e);
                                    }
                                    UPnPMediaServerContentServer.this.plugin.log("listener failed on port " + UPnPMediaServerContentServer.this.getPort(), e);
                                    if (++failed_accepts <= 100L || successfull_accepts != 0L) continue;
                                    UPnPMediaServerContentServer.this.plugin.log("    too many listen fails, giving up");
                                    break;
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }.start();
            }
            ++i;
        }
        new AEThread2("UPnPMediaServer:closer", true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ArrayList pending = new ArrayList();
                while (!UPnPMediaServerContentServer.this.destroyed || UPnPMediaServerContentServer.this.active_processors.size() != 0) {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        break;
                    }
                    UPnPMediaServerContentServer.this.tidyOMS();
                    Iterator<Object> it = pending.iterator();
                    while (it.hasNext()) {
                        try {
                            ((UPnPMediaChannel)it.next()).close();
                        }
                        catch (Throwable e) {
                            it.remove();
                        }
                    }
                    List list = UPnPMediaServerContentServer.this.close_queue;
                    synchronized (list) {
                        pending.addAll(UPnPMediaServerContentServer.this.close_queue);
                        UPnPMediaServerContentServer.this.close_queue.clear();
                    }
                    list = UPnPMediaServerContentServer.this.active_processors;
                    synchronized (list) {
                        HashMap<String, ArrayList<processor>> conn_map = new HashMap<String, ArrayList<processor>>();
                        int i = 0;
                        while (i < UPnPMediaServerContentServer.this.active_processors.size()) {
                            processor proc = (processor)UPnPMediaServerContentServer.this.active_processors.get(i);
                            DiskManagerRequest req = proc.getActiveRequest();
                            if (req != null) {
                                UPnPMediaChannel channel2 = proc.getChannel();
                                if (channel2.isClosed()) {
                                    req.cancel();
                                } else {
                                    ArrayList<processor> conns = (ArrayList<processor>)conn_map.get(proc.getIP());
                                    if (conns == null) {
                                        conns = new ArrayList<processor>();
                                        conn_map.put(proc.getIP(), conns);
                                    }
                                    conns.add(proc);
                                }
                            }
                            ++i;
                        }
                        for (List conns : conn_map.values()) {
                            int i2 = 0;
                            while (i2 < conns.size() - 16) {
                                processor proc = (processor)conns.get(i2);
                                DiskManagerRequest req = proc.getActiveRequest();
                                if (req != null) {
                                    req.cancel();
                                }
                                ++i2;
                            }
                        }
                    }
                }
            }
        }.start();
    }

    protected void bind(ServerSocketChannel ssc, InetAddress address, int port) throws IOException {
        if (address == null) {
            ssc.socket().bind(new InetSocketAddress(port), 1024);
        } else {
            ssc.socket().bind(new InetSocketAddress(address, port), 1024);
        }
    }

    protected InetAddress[] getBindableAddresses() {
        NetworkAdminNetworkInterface[] interfaces;
        ArrayList<InetAddress> bindable = new ArrayList<InetAddress>();
        NetworkAdminNetworkInterface[] networkAdminNetworkInterfaceArray = interfaces = NetworkAdmin.getSingleton().getInterfaces();
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            NetworkAdminNetworkInterfaceAddress[] addresses;
            NetworkAdminNetworkInterface intf = networkAdminNetworkInterfaceArray[n2];
            NetworkAdminNetworkInterfaceAddress[] networkAdminNetworkInterfaceAddressArray = addresses = intf.getAddresses();
            int n3 = addresses.length;
            int n4 = 0;
            while (n4 < n3) {
                NetworkAdminNetworkInterfaceAddress address = networkAdminNetworkInterfaceAddressArray[n4];
                InetAddress a = address.getAddress();
                if (this.canBind(a)) {
                    bindable.add(a);
                }
                ++n4;
            }
            ++n2;
        }
        return bindable.toArray(new InetAddress[bindable.size()]);
    }

    protected boolean canBind(InetAddress bind_ip) {
        ServerSocketChannel ssc = null;
        try {
            ssc = ServerSocketChannel.open();
            ssc.socket().bind(bind_ip == null ? new InetSocketAddress(0) : new InetSocketAddress(bind_ip, 0), 1024);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
        finally {
            if (ssc != null) {
                try {
                    ssc.close();
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        }
    }

    protected void destroy() {
        this.destroyed = true;
        for (ServerSocket server_socket : this.server_sockets) {
            try {
                server_socket.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected streamInfo getStreamInfo(int stream_id) {
        List<processor> list = this.active_processors;
        synchronized (list) {
            return this.stream_map.get(new Integer(stream_id));
        }
    }

    protected int getPort() {
        return this.port;
    }

    protected InetAddress getBindIP() {
        return this.first_bind_ip;
    }

    protected int getConnectionCount() {
        return this.active_processors.size();
    }

    protected long[] parseRange(String ranges, long file_length) throws IOException {
        long request_length;
        long start;
        long end;
        if (!(ranges = ranges.toLowerCase(MessageText.LOCALE_ENGLISH)).startsWith("bytes=")) {
            throw new IOException("invalid range: " + ranges);
        }
        StringTokenizer tok = new StringTokenizer(ranges = ranges.substring(6), ",");
        if (tok.countTokens() != 1) {
            throw new IOException("invalid range - only single supported: " + ranges);
        }
        String range = tok.nextToken();
        int pos = range.indexOf(45);
        if (file_length >= 0L) {
            end = pos < range.length() - 1 ? Long.parseLong(range.substring(pos + 1)) : file_length - 1L;
            if (pos > 0) {
                start = Long.parseLong(range.substring(0, pos));
            } else {
                start = file_length - end;
                end = file_length - 1L;
            }
            request_length = end - start + 1L;
            if (request_length < 0L) {
                return null;
            }
        } else {
            end = pos < range.length() - 1 ? Long.parseLong(range.substring(pos + 1)) : -1L;
            if (pos <= 0) {
                return null;
            }
            start = Long.parseLong(range.substring(0, pos));
            if (end == -1L) {
                request_length = -1L;
            } else {
                request_length = end - start + 1L;
                if (request_length < 0L) {
                    return null;
                }
            }
        }
        return new long[]{start, end, request_length};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tidyOMS() {
        long now = SystemTime.getMonotonousTime();
        Map<String, overWriteMonitor> map = this.overwrite_monitors;
        synchronized (map) {
            Iterator<overWriteMonitor> it = this.overwrite_monitors.values().iterator();
            while (it.hasNext()) {
                overWriteMonitor om = it.next();
                if (om.isActive() || now - om.getLastUpdate() <= 10000L) continue;
                it.remove();
            }
        }
    }

    protected class overWriteMonitor {
        private UPnPMediaServerContentDirectory.contentItem item;
        private long last_update = SystemTime.getMonotonousTime();
        private writeEntry[] history = new writeEntry[32];
        private int history_pos = 0;
        private LinkedList<writeEntry> writes = new LinkedList();
        private Average write_speed = Average.getInstance(500, 3);
        private Average overlap_speed = Average.getInstance(500, 3);
        private MovingImmediateAverage percent_average = AverageFactory.MovingImmediateAverage(3);
        private int sample_count;
        private int stats_count;
        private int bytes_available = Integer.MAX_VALUE;
        private static final int BYTE_PERIODS = 40;
        private int bytes_per_sec = Integer.MAX_VALUE;
        private int bytes_per_period = 0;
        private int active_count;
        private boolean logged_error;

        protected overWriteMonitor(UPnPMediaServerContentDirectory.contentItem _item) {
            this.item = _item;
        }

        protected void addWrite(long this_start, int this_len) {
            this.addWrite(this_start, this_len, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void addWrite(long this_start, int this_len, boolean update_stats) {
            block19: {
                try {
                    long current_start = this_start;
                    int current_len = this_len;
                    long current_end = current_start + (long)current_len;
                    writeEntry current_entry = new writeEntry(current_start, current_len);
                    int total_overlap = 0;
                    overWriteMonitor overWriteMonitor2 = this;
                    synchronized (overWriteMonitor2) {
                        this.history[this.history_pos++ % this.history.length] = current_entry;
                        boolean added = false;
                        ListIterator<writeEntry> it = this.writes.listIterator();
                        while (it.hasNext()) {
                            writeEntry entry = (writeEntry)it.next();
                            long entry_start = entry.offset;
                            long entry_end = entry_start + (long)entry.length;
                            if (current_start > entry_end) continue;
                            if (current_end < entry_start) {
                                if (it.hasPrevious()) {
                                    it.previous();
                                    it.add(current_entry);
                                } else {
                                    this.writes.addFirst(current_entry);
                                }
                                added = true;
                                break;
                            }
                            if (current_start >= entry_start && current_end <= entry_end) {
                                total_overlap += current_len;
                                added = true;
                                break;
                            }
                            it.remove();
                            long overlap_start = Math.max(current_start, entry_start);
                            long overlap_end = Math.min(current_end, entry_end);
                            long overlap = overlap_end - overlap_start;
                            if (overlap < 0L) {
                                Debug.out("inconsistent");
                            } else {
                                total_overlap = (int)((long)total_overlap + overlap);
                            }
                            current_start = Math.min(current_start, entry_start);
                            current_end = Math.max(current_end, entry_end);
                            current_len = (int)(current_end - current_start);
                            if (current_len <= 0) {
                                Debug.out("inconsistent");
                            }
                            current_entry = new writeEntry(current_start, current_len);
                        }
                        if (!added) {
                            this.writes.add(current_entry);
                        }
                        if (this.writes.size() > 128) {
                            this.writes.removeFirst();
                        }
                    }
                    if (update_stats) {
                        ++this.sample_count;
                        this.last_update = SystemTime.getMonotonousTime();
                        this.write_speed.addValue(this_len);
                        if (total_overlap > 0) {
                            this.overlap_speed.addValue(total_overlap);
                        }
                        if (this.bytes_available < Integer.MAX_VALUE) {
                            this.bytes_available -= this_len;
                            if (this.bytes_available < 0) {
                                this.bytes_available = 0;
                            }
                        }
                    }
                }
                catch (Throwable e) {
                    if (this.logged_error) break block19;
                    this.logged_error = true;
                    Debug.out(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateStats(int tick_count) {
            if (tick_count % 40 == 0) {
                ++this.stats_count;
                long ws = this.write_speed.getAverage();
                long os = this.overlap_speed.getAverage();
                if (os > ws) {
                    os = ws;
                }
                long percent = os == 0L ? 0L : 100L * os / ws;
                long ave = (long)this.percent_average.update(percent);
                if (this.stats_count % 5 == 0) {
                    overWriteMonitor overWriteMonitor2 = this;
                    synchronized (overWriteMonitor2) {
                        this.writes.clear();
                        int pos = this.history_pos;
                        int i = 0;
                        while (i < this.history.length) {
                            writeEntry we;
                            if ((we = this.history[pos++ % this.history.length]) != null) {
                                this.addWrite(we.offset, we.length, false);
                            }
                            ++i;
                        }
                    }
                }
                if (ave > 50L && this.sample_count >= 5 && this.bytes_per_sec == Integer.MAX_VALUE) {
                    int mult;
                    int limit_bytes_per_sec = Integer.MAX_VALUE;
                    long average_bitrate = this.item.getAverageBitRate();
                    if (average_bitrate > 0L && (mult = UPnPMediaServerContentServer.this.plugin.getAverageBitRateMultiplier()) > 0) {
                        limit_bytes_per_sec = (int)(average_bitrate * (long)mult / 8L);
                    }
                    int min = UPnPMediaServerContentServer.this.plugin.getMinBytesPerSecond();
                    int max = UPnPMediaServerContentServer.this.plugin.getMaxBytesPerSecond();
                    if (max > 0) {
                        limit_bytes_per_sec = Math.min(max, limit_bytes_per_sec);
                    }
                    if (limit_bytes_per_sec == Integer.MAX_VALUE) {
                        UPnPMediaServerContentServer.this.plugin.log("Wasted bandwidth limit exceeded but no user-defined limits to use - please configure them");
                        limit_bytes_per_sec = 0x6400000;
                    } else {
                        if (limit_bytes_per_sec < min) {
                            limit_bytes_per_sec = min;
                        }
                        UPnPMediaServerContentServer.this.plugin.log("Wasted bandwidth threshold reached: limiting stream to " + DisplayFormatters.formatByteCountToKiBEtcPerSec(limit_bytes_per_sec));
                    }
                    this.bytes_per_sec = limit_bytes_per_sec;
                    this.bytes_per_period = limit_bytes_per_sec / 40;
                    this.bytes_available = 0;
                }
            }
            if (this.bytes_per_period > 0) {
                this.bytes_available += this.bytes_per_period;
                if (this.bytes_available > 2 * this.bytes_per_sec) {
                    this.bytes_available = 2 * this.bytes_per_sec;
                }
            } else {
                this.bytes_available = Integer.MAX_VALUE;
            }
        }

        public int getAvailableBytes() {
            int avail = this.bytes_available;
            return avail < 0 ? 0 : avail;
        }

        protected long getLastUpdate() {
            return this.last_update;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void addActive() {
            overWriteMonitor overWriteMonitor2 = this;
            synchronized (overWriteMonitor2) {
                ++this.active_count;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void removeActive() {
            overWriteMonitor overWriteMonitor2 = this;
            synchronized (overWriteMonitor2) {
                --this.active_count;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean isActive() {
            overWriteMonitor overWriteMonitor2 = this;
            synchronized (overWriteMonitor2) {
                return this.active_count > 0;
            }
        }
    }

    protected class processor
    extends ThreadPoolTask
    implements streamInfo {
        private String ip;
        private Socket socket;
        private UPnPMediaChannel channel;
        private int processor_num;
        private StringBuilder write_buffer = new StringBuilder(512);
        private long last_write_time;
        private long last_write_offset;
        private long last_blocked_offset;
        private int stream_id = -1;
        private boolean action_is_download;
        private volatile DiskManagerRequest active_request;
        private UPnPMediaRendererRemote remoteRenderer;

        protected processor(String _ip, Socket _socket, int _processor_num) {
            this.ip = _ip;
            this.socket = _socket;
            this.processor_num = _processor_num;
            this.last_write_time = UPnPMediaServerContentServer.this.plugin_interface.getUtilities().getCurrentSystemTime();
            this.remoteRenderer = UPnPMediaServerContentServer.this.plugin.findRendererByIP(this.ip);
        }

        protected String getIP() {
            return this.ip;
        }

        protected long getLastWriteTime() {
            return this.last_write_time;
        }

        protected long getLastWriteOffset() {
            return this.last_write_offset;
        }

        @Override
        public long getPosition() {
            return this.getLastWriteOffset();
        }

        @Override
        public long getAvailableBytes() {
            DiskManagerRequest request2 = this.active_request;
            if (request2 == null) {
                return -1L;
            }
            return request2.getAvailableBytes();
        }

        @Override
        public long getRemaining() {
            DiskManagerRequest request2 = this.active_request;
            if (request2 == null) {
                return -1L;
            }
            return request2.getRemaining();
        }

        protected int getStreamID() {
            return this.stream_id;
        }

        protected UPnPMediaChannel getChannel() {
            return this.channel;
        }

        protected DiskManagerRequest getActiveRequest() {
            return this.active_request;
        }

        protected void log(String str) {
            UPnPMediaServerContentServer.this.plugin.log("[" + this.processor_num + "] " + str);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void runSupport() {
            block45: {
                boolean close_now = false;
                try {
                    try {
                        List list = UPnPMediaServerContentServer.this.active_processors;
                        synchronized (list) {
                            if (UPnPMediaServerContentServer.this.active_processors.size() == 0) {
                                UPnPMediaChannel.setIdle(false);
                            }
                            UPnPMediaServerContentServer.this.active_processors.add(this);
                        }
                        this.setTaskState("entry");
                        this.channel = new UPnPMediaChannel(this.socket);
                        this.process();
                        Thread.sleep(100L);
                        close_now = true;
                    }
                    catch (Throwable e) {
                        close_now = true;
                        if (!(e instanceof SocketTimeoutException)) {
                            e.printStackTrace();
                        }
                        List list = UPnPMediaServerContentServer.this.active_processors;
                        synchronized (list) {
                            UPnPMediaServerContentServer.this.active_processors.remove(this);
                            if (UPnPMediaServerContentServer.this.active_processors.size() == 0) {
                                UPnPMediaChannel.setIdle(true);
                            }
                            if (this.stream_id != -1 && UPnPMediaServerContentServer.this.getStreamInfo(this.stream_id) == this) {
                                UPnPMediaServerContentServer.this.stream_map.remove(new Integer(this.stream_id));
                            }
                        }
                        if (close_now) {
                            try {
                                this.channel.close();
                            }
                            catch (Throwable throwable) {}
                            break block45;
                        }
                        list = UPnPMediaServerContentServer.this.close_queue;
                        synchronized (list) {
                            UPnPMediaServerContentServer.this.close_queue.add(this.channel);
                            break block45;
                        }
                    }
                }
                catch (Throwable throwable) {
                    List list = UPnPMediaServerContentServer.this.active_processors;
                    synchronized (list) {
                        UPnPMediaServerContentServer.this.active_processors.remove(this);
                        if (UPnPMediaServerContentServer.this.active_processors.size() == 0) {
                            UPnPMediaChannel.setIdle(true);
                        }
                        if (this.stream_id != -1 && UPnPMediaServerContentServer.this.getStreamInfo(this.stream_id) == this) {
                            UPnPMediaServerContentServer.this.stream_map.remove(new Integer(this.stream_id));
                        }
                    }
                    if (close_now) {
                        try {
                            this.channel.close();
                        }
                        catch (Throwable throwable2) {}
                    } else {
                        list = UPnPMediaServerContentServer.this.close_queue;
                        synchronized (list) {
                            UPnPMediaServerContentServer.this.close_queue.add(this.channel);
                        }
                    }
                    throw throwable;
                }
                List list = UPnPMediaServerContentServer.this.active_processors;
                synchronized (list) {
                    UPnPMediaServerContentServer.this.active_processors.remove(this);
                    if (UPnPMediaServerContentServer.this.active_processors.size() == 0) {
                        UPnPMediaChannel.setIdle(true);
                    }
                    if (this.stream_id != -1 && UPnPMediaServerContentServer.this.getStreamInfo(this.stream_id) == this) {
                        UPnPMediaServerContentServer.this.stream_map.remove(new Integer(this.stream_id));
                    }
                }
                if (close_now) {
                    try {
                        this.channel.close();
                    }
                    catch (Throwable throwable) {}
                } else {
                    list = UPnPMediaServerContentServer.this.close_queue;
                    synchronized (list) {
                        UPnPMediaServerContentServer.this.close_queue.add(this.channel);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void process() throws IOException {
            int loop_count = 0;
            boolean close_connection = false;
            while (!close_connection) {
                int pos;
                String url;
                String command = null;
                HashMap<String, String> headers = new HashMap<String, String>();
                try {
                    while (true) {
                        String line = "";
                        while (!line.endsWith(UPnPMediaServerContentServer.NL)) {
                            byte[] buffer = new byte[1];
                            this.channel.read(buffer);
                            line = String.valueOf(line) + new String(buffer);
                        }
                        if ((line = line.trim()).length() != 0) {
                            if (command == null) {
                                command = line;
                                continue;
                            }
                            int pos2 = line.indexOf(58);
                            if (pos2 == -1) {
                                return;
                            }
                            String lhs = line.substring(0, pos2).trim().toLowerCase(MessageText.LOCALE_ENGLISH);
                            String rhs = line.substring(pos2 + 1).trim();
                            headers.put(lhs, rhs);
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException e) {
                    return;
                }
                if (UPnPMediaServerContentServer.this.plugin.authContentPort(this.ip)) {
                    String auth = (String)headers.get("authorization");
                    boolean ok = false;
                    if (auth != null) {
                        int pos3 = auth.indexOf(32);
                        auth = auth.substring(pos3 + 1).trim();
                        String decoded = new String(Base64.decode(auth));
                        int cp = decoded.indexOf(58);
                        String user = decoded.substring(0, cp);
                        String pw = decoded.substring(cp + 1);
                        ok = UPnPMediaServerContentServer.this.plugin.doContentAuth(this.ip, user, pw);
                    }
                    if (!ok) {
                        this.writeb("HTTP/1.1 401 BAD\r\n");
                        this.writeb("WWW-Authenticate: Basic realm=\"Vuze Media Server\"\r\n");
                        this.writeb("Connection: close\r\n\r\n");
                        this.writeb("Access Denied\r\n");
                        this.writef();
                        close_connection = true;
                        continue;
                    }
                }
                String connection_header = (String)headers.get("connection");
                close_connection = command.endsWith("1.0") ? connection_header == null || !connection_header.equalsIgnoreCase("keep-alive") : connection_header != null && connection_header.equalsIgnoreCase("close");
                boolean head = false;
                if (command.startsWith("GET ")) {
                    url = command.substring(4);
                } else if (command.startsWith("HEAD ")) {
                    url = command.substring(5);
                    head = true;
                } else {
                    this.log("Unhandled HTTP request: " + command);
                    return;
                }
                if (url.startsWith("http")) {
                    url = url.replaceFirst("^http://[^/]+", "");
                }
                if ((pos = url.indexOf(32)) == -1) {
                    return;
                }
                String http_version = "HTTP/1.1";
                url = URLDecoder.decode(url.substring(0, pos), "ISO8859-1");
                UPnPMediaServerContentDirectory.contentItem item = null;
                this.action_is_download = false;
                if (url.startsWith("/Platform")) {
                    int q_pos = url.indexOf(63);
                    String content_id = null;
                    if (q_pos != -1) {
                        StringTokenizer tok = new StringTokenizer(url.substring(q_pos + 1), "&");
                        while (tok.hasMoreTokens()) {
                            String token = tok.nextToken();
                            int e_pos = token.indexOf(61);
                            if (e_pos == -1) continue;
                            String lhs = token.substring(0, e_pos);
                            String rhs = token.substring(e_pos + 1);
                            if (!lhs.equals("cid")) continue;
                            content_id = rhs;
                            break;
                        }
                    }
                    if (content_id != null) {
                        byte[] hash = Base32.decode(content_id);
                        item = UPnPMediaServerContentServer.this.plugin.getContentDirectory().getContentFromHash(hash);
                    }
                } else if (url.startsWith("/Content/")) {
                    String content2 = url.substring(9);
                    int q_pos = content2.indexOf(63);
                    if (q_pos != -1) {
                        String params = content2.substring(q_pos + 1);
                        content2 = content2.substring(0, q_pos);
                        StringTokenizer tok = new StringTokenizer(params, "&");
                        while (tok.hasMoreTokens()) {
                            String param = tok.nextToken();
                            int e_pos = param.indexOf(61);
                            if (e_pos == -1) continue;
                            String lhs = param.substring(0, e_pos);
                            String rhs = param.substring(e_pos + 1);
                            if (lhs.equals("sid")) {
                                try {
                                    this.stream_id = Integer.parseInt(rhs);
                                    List list = UPnPMediaServerContentServer.this.active_processors;
                                    synchronized (list) {
                                        UPnPMediaServerContentServer.this.stream_map.put(new Integer(this.stream_id), this);
                                    }
                                }
                                catch (Throwable throwable) {}
                                continue;
                            }
                            if (!lhs.equals("action") || !rhs.equals("download")) continue;
                            this.action_is_download = true;
                        }
                    }
                    item = UPnPMediaServerContentServer.this.plugin.getContentDirectory().getContentFromResourceID(content2);
                }
                if (item == null) {
                    UPnPMediaServerContentServer.this.plugin.log("Unknown content: " + url);
                    this.writeb(String.valueOf(http_version) + " 404 Not Found" + UPnPMediaServerContentServer.NL);
                    this.writeb("Connection: close\r\n\r\n");
                    this.writef();
                    close_connection = true;
                } else {
                    try {
                        if (!this.process(head, http_version, headers, item, close_connection)) {
                            return;
                        }
                    }
                    catch (Throwable e) {
                        if (!(e instanceof IOException)) {
                            e.printStackTrace();
                        }
                        return;
                    }
                }
                ++loop_count;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean process(boolean head, String http_version, Map<String, String> headers, UPnPMediaServerContentDirectory.contentItem content_item, boolean close_connection) throws Throwable {
            String user_agent = headers.get("user-agent");
            DiskManagerFileInfo file = content_item.getFile();
            DiskManagerChannel disk_channel = null;
            final long[] bytes_queued = new long[1];
            long bytes_delivered = 0L;
            boolean is_partial_req_to_end = false;
            try {
                long request_length;
                long request_start;
                String ranges = headers.get("range");
                long file_length = file.getLength();
                String originator = String.valueOf(user_agent) + "/" + this.ip;
                if (ranges == null) {
                    this.log("Streaming starts for " + content_item.getName() + "  [complete file] - " + originator);
                    this.writeb(String.valueOf(http_version) + " 200 OK" + UPnPMediaServerContentServer.NL);
                    this.writeBoilerPlate(content_item, true, close_connection);
                    if (file_length >= 0L) {
                        this.writeb("Content-Range: bytes 0-" + (file_length - 1L) + "/" + file_length + UPnPMediaServerContentServer.NL);
                        this.writeb("Content-Length: " + file_length + UPnPMediaServerContentServer.NL);
                    }
                    request_start = 0L;
                    request_length = file_length;
                } else {
                    String ua;
                    this.log("Streaming starts for " + content_item.getName() + "[" + ranges + "] - " + originator);
                    boolean tivo_eos_read = false;
                    if (!ranges.startsWith("bytes=0-") && (ua = headers.get("user-agent")) != null && ua.toLowerCase().indexOf("TvHttpClient".toLowerCase()) != -1) {
                        tivo_eos_read = true;
                    }
                    if (tivo_eos_read) {
                        this.log("    TiVo range request received - assuming eos");
                        is_partial_req_to_end = true;
                        this.writeb(String.valueOf(http_version) + " 206 Partial content" + UPnPMediaServerContentServer.NL);
                        this.writeBoilerPlate(content_item, false, close_connection);
                        this.writeb("Transfer-Encoding: chunked\r\n");
                        this.writeb(UPnPMediaServerContentServer.NL);
                        this.writeb("0\r\n");
                        this.writef();
                        return true;
                    }
                    long[] result = UPnPMediaServerContentServer.this.parseRange(ranges, file_length);
                    if (result == null) {
                        this.writeb(String.valueOf(http_version) + " 416 Requested Range Not Satisfiable" + UPnPMediaServerContentServer.NL);
                        this.writeb("Content-Range: bytes */" + (file_length < 0L ? "*" : Long.valueOf(file_length)) + UPnPMediaServerContentServer.NL);
                        this.writeBoilerPlate(null, true, close_connection);
                        this.writeb(UPnPMediaServerContentServer.NL);
                        this.writef();
                        return true;
                    }
                    request_start = result[0];
                    request_length = result[2];
                    long request_end = result[1];
                    is_partial_req_to_end = request_end == file_length - 1L;
                    this.writeb(String.valueOf(http_version) + " 206 Partial content" + UPnPMediaServerContentServer.NL);
                    this.writeBoilerPlate(content_item, true, close_connection);
                    if (request_length >= 0L) {
                        this.writeb("Content-Range: bytes " + request_start + "-" + request_end + "/" + (file_length < 0L ? "*" : Long.valueOf(file_length)) + UPnPMediaServerContentServer.NL);
                        this.writeb("Content-Length: " + request_length + UPnPMediaServerContentServer.NL);
                    }
                }
                this.writeb(UPnPMediaServerContentServer.NL);
                this.writef();
                if (head) {
                    return true;
                }
                final Throwable[] error = new Throwable[1];
                disk_channel = file.createChannel();
                final DiskManagerRequest request2 = disk_channel.createRequest();
                request2.setType(1);
                request2.setOffset(request_start);
                request2.setLength(request_length);
                if (request_length > 0L) {
                    request2.setMaximumReadChunkSize((int)Math.min(262144L, request_length));
                }
                this.last_write_offset = request_start;
                request2.setUserAgent(user_agent);
                final long piece_size = file.getPieceSize();
                request2.addListener(new DiskManagerListener(){
                    private Average write_speed = Average.getInstance(1000, 10);
                    private long start_time;
                    private long last_log;
                    private long total_written;
                    {
                        this.last_log = this.start_time = UPnPMediaServerContentServer.this.plugin_interface.getUtilities().getCurrentSystemTime();
                    }

                    @Override
                    public void eventOccurred(DiskManagerEvent event2) {
                        block10: {
                            long offset;
                            int type = event2.getType();
                            if (type == 2) {
                                error[0] = event2.getFailure();
                                processor.this.channel.close();
                            } else if (type == 1) {
                                PooledByteBuffer buffer = null;
                                try {
                                    buffer = event2.getBuffer();
                                    int length = event2.getLength();
                                    ByteBuffer bb = buffer.toByteBuffer();
                                    bb.position(0);
                                    processor.this.channel.write(event2.getOffset(), buffer);
                                    this.write_speed.addValue(length);
                                    if (this.total_written == 0L) {
                                        // empty if block
                                    }
                                    this.total_written += (long)length;
                                    bytes_queued[0] = bytes_queued[0] + (long)length;
                                    processor.this.last_write_time = UPnPMediaServerContentServer.this.plugin_interface.getUtilities().getCurrentSystemTime();
                                    processor.this.last_write_offset = event2.getOffset();
                                    if (processor.this.last_write_time - this.last_log > 5000L) {
                                        this.last_log = processor.this.last_write_time;
                                    }
                                    if (processor.this.stream_id == -1) break block10;
                                    if (processor.this.last_write_time - this.start_time < 1000L) {
                                        Thread.sleep(100L);
                                        break block10;
                                    }
                                    this.start_time = 0L;
                                }
                                catch (Throwable e) {
                                    request2.cancel();
                                    error[0] = e;
                                }
                            } else if (type == 3 && (offset = event2.getOffset()) != processor.this.last_blocked_offset) {
                                processor.this.last_blocked_offset = offset;
                                long piece_num = offset / piece_size;
                                long piece_offset = offset - piece_num * piece_size;
                                processor.this.log("Blocked reading data at piece " + piece_num + ", offset " + piece_offset);
                            }
                        }
                    }
                });
                int priority = Thread.currentThread().getPriority();
                overWriteMonitor om = null;
                if (is_partial_req_to_end) {
                    String key = String.valueOf(content_item.getID()) + ":" + originator;
                    Map map = UPnPMediaServerContentServer.this.overwrite_monitors;
                    synchronized (map) {
                        om = (overWriteMonitor)UPnPMediaServerContentServer.this.overwrite_monitors.get(key);
                        if (om == null) {
                            om = new overWriteMonitor(content_item);
                            UPnPMediaServerContentServer.this.overwrite_monitors.put(key, om);
                            if (UPnPMediaServerContentServer.this.overwrite_monitors.size() > 8) {
                                UPnPMediaServerContentServer.this.tidyOMS();
                            }
                        }
                        if (UPnPMediaServerContentServer.this.om_update_thread == null) {
                            UPnPMediaServerContentServer.this.om_update_thread = new AEThread2("OMUpdate", true){
                                private int tick_count;

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    while (true) {
                                        ++this.tick_count;
                                        Map map = UPnPMediaServerContentServer.this.overwrite_monitors;
                                        synchronized (map) {
                                            if (UPnPMediaServerContentServer.this.overwrite_monitors.size() == 0) {
                                                UPnPMediaServerContentServer.this.om_update_thread = null;
                                                break;
                                            }
                                            for (overWriteMonitor om : UPnPMediaServerContentServer.this.overwrite_monitors.values()) {
                                                om.updateStats(this.tick_count);
                                            }
                                        }
                                        try {
                                            Thread.sleep(25L);
                                        }
                                        catch (Throwable e) {
                                            Debug.out(e);
                                            break;
                                        }
                                    }
                                }
                            };
                            UPnPMediaServerContentServer.this.om_update_thread.start();
                        }
                    }
                    final overWriteMonitor f_om = om;
                    this.channel.setListener(new UPnPMediaChannel.channelListener(){
                        long last_update = 0L;
                        private int avail = 0;

                        @Override
                        public void wrote(long offset, int bytes) {
                            f_om.addWrite(offset, bytes);
                        }

                        @Override
                        public int getAvailableBytes() {
                            return f_om.getAvailableBytes();
                        }
                    });
                }
                long delivered_start = this.channel.getChannelUp();
                try {
                    if (om != null) {
                        om.addActive();
                    }
                    this.active_request = request2;
                    Thread.currentThread().setPriority(10);
                    request2.run();
                    this.channel.flush();
                }
                finally {
                    Thread.currentThread().setPriority(priority);
                    this.active_request = null;
                    if (om != null) {
                        om.removeActive();
                    }
                    bytes_delivered = this.channel.getChannelUp() - delivered_start;
                }
                if (error[0] != null) {
                    throw error[0];
                }
            }
            finally {
                this.log("Streaming ends for " + content_item.getName() + ": read " + DisplayFormatters.formatByteCountToKiBEtc(bytes_queued[0]) + ", delivered " + DisplayFormatters.formatByteCountToKiBEtc(bytes_delivered));
                if (disk_channel != null) {
                    disk_channel.destroy();
                }
            }
            return true;
        }

        protected void writeBoilerPlate(UPnPMediaServerContentDirectory.contentItem item, boolean does_ranges, boolean close_connection) {
            this.writeb("Server: Vuze Media Server 1.0\r\n");
            if (does_ranges) {
                this.writeb("Accept-Ranges: bytes\r\n");
            }
            this.writeb("Connection: " + (close_connection ? "Close" : "Keep-Alive") + UPnPMediaServerContentServer.NL);
            this.writeb("Cache-Control: no-cache\r\n");
            this.writeb("Expires: 0\r\n");
            if (item != null) {
                if (this.action_is_download) {
                    this.writeb("Content-Type: application/octet-stream\r\n");
                    this.writeb("Content-Transfer-Encoding: binary\r\n");
                    this.writeb("Content-Disposition: attachment; filename=\"" + item.getFile().getFile(true).getName() + "\"" + UPnPMediaServerContentServer.NL);
                    return;
                }
                String PN = item.getContentClass() == "object.item.imageItem.photo" ? "JPEG" : (item.getContentClass() == "object.item.audioItem.musicTrack" ? "MP3" : "MPEG_PS_NTSC");
                this.writeb("contentFeatures.dlna.org: DLNA.ORG_PN=" + PN + ";DLNA.ORG_OP=01;DLNA.ORG_CI=1;DLNA.ORG_FLAGS=01700000000000000000000000000000" + UPnPMediaServerContentServer.NL);
                this.writeb("transferMode.dlna.org: Streaming\r\n");
                String[] content_types = item.getContentTypes();
                String content_type = null;
                if (content_types.length > 1 && this.remoteRenderer != null) {
                    content_type = this.remoteRenderer.calculateContentType(content_types);
                }
                if (content_type == null) {
                    content_type = content_types[0];
                }
                this.writeb("Content-Type: " + content_type + UPnPMediaServerContentServer.NL);
                long date = item.getDateMillis();
                if (date > 0L) {
                    String str = TimeFormatter.getHTTPDate(date);
                    this.writeb("Date: " + str + UPnPMediaServerContentServer.NL);
                    this.writeb("Last-Modified: " + str + UPnPMediaServerContentServer.NL);
                }
            }
        }

        protected void writeb(String str) {
            this.write_buffer.append(str);
        }

        protected void writef() throws IOException {
            this.channel.write(-1L, this.write_buffer.toString().getBytes());
            this.write_buffer.setLength(0);
        }

        @Override
        public void interruptTask() {
        }
    }

    static interface streamInfo {
        public long getPosition();

        public long getAvailableBytes();

        public long getRemaining();
    }

    protected static class writeEntry {
        private long offset;
        private int length;

        protected writeEntry(long _offset, int _len) {
            this.offset = _offset;
            this.length = _len;
        }
    }
}

