/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.subs.impl;

import com.aelitis.azureus.core.metasearch.Result;
import com.aelitis.azureus.util.ImportExportUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class SubscriptionResultFilter {
    private String[] textFilters;
    private Pattern[] textFilterPatterns;
    private String[] excludeTextFilters;
    private Pattern[] excludeTextFilterPatterns;
    private String regexFilter;
    private long minSeeds = -1L;
    private long minSize = -1L;
    private long maxSize = -1L;
    private String categoryFilter = null;
    private static Pattern[] NO_PATTERNS = new Pattern[0];

    public String getString() {
        String res = this.addString("", "+", this.getString(this.textFilters));
        res = this.addString(res, "-", this.getString(this.excludeTextFilters));
        res = this.addString(res, "regex=", this.regexFilter);
        res = this.addString(res, "cat=", this.categoryFilter);
        return res;
    }

    private String addString(String existing, String key, String rest) {
        if (rest == null || rest.length() == 0) {
            return existing;
        }
        String str = String.valueOf(key) + rest;
        if (existing == null || existing.length() == 0) {
            return str;
        }
        return String.valueOf(existing) + "," + str;
    }

    private String getString(String[] strs) {
        String res = "";
        int i = 0;
        while (i < strs.length) {
            res = String.valueOf(res) + (i == 0 ? "" : "&") + strs[i];
            ++i;
        }
        return res;
    }

    public SubscriptionResultFilter(Map filters) {
        try {
            this.textFilters = this.importStrings(filters, "text_filter", " ");
            this.textFilterPatterns = this.getPatterns(this.textFilters);
            this.excludeTextFilters = this.importStrings(filters, "text_filter_out", " ");
            this.excludeTextFilterPatterns = this.getPatterns(this.excludeTextFilters);
            this.regexFilter = ImportExportUtils.importString(filters, "text_filter_regex");
            this.minSize = ImportExportUtils.importLong(filters, "min_size", -1L);
            this.maxSize = ImportExportUtils.importLong(filters, "max_size", -1L);
            this.minSeeds = ImportExportUtils.importLong(filters, "min_seeds", -1L);
            String rawCategory = ImportExportUtils.importString(filters, "category");
            if (rawCategory != null) {
                this.categoryFilter = rawCategory.toLowerCase();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Pattern[] getPatterns(String[] strs) {
        if (strs.length == 0) {
            return NO_PATTERNS;
        }
        Pattern[] pats = new Pattern[strs.length];
        int i = 0;
        while (i < strs.length) {
            try {
                pats[i] = Pattern.compile(strs[i].trim());
            }
            catch (Throwable e) {
                System.out.println("Failed to compile pattern '" + strs[i]);
            }
            ++i;
        }
        return pats;
    }

    private String[] importStrings(Map filters, String key, String separator) throws IOException {
        String rawStringFilter = ImportExportUtils.importString(filters, key);
        if (rawStringFilter != null) {
            StringTokenizer st = new StringTokenizer(rawStringFilter, separator);
            String[] stringFilter = new String[st.countTokens()];
            int i = 0;
            while (i < stringFilter.length) {
                stringFilter[i] = st.nextToken().toLowerCase();
                ++i;
            }
            return stringFilter;
        }
        return new String[0];
    }

    public Result[] filter(Result[] results) {
        ArrayList<Result> filteredResults = new ArrayList<Result>(results.length);
        int i = 0;
        while (i < results.length) {
            Result result = results[i];
            String name = result.getName();
            if (name != null) {
                Pattern p;
                name = name.toLowerCase();
                boolean valid = true;
                int j = 0;
                while (j < this.textFilters.length) {
                    if (!(name.contains(this.textFilters[j]) || (p = this.textFilterPatterns[j]) != null && p.matcher(name).find())) {
                        valid = false;
                        break;
                    }
                    ++j;
                }
                if (valid) {
                    j = 0;
                    while (j < this.excludeTextFilters.length) {
                        if (name.contains(this.excludeTextFilters[j])) {
                            valid = false;
                            break;
                        }
                        p = this.excludeTextFilterPatterns[j];
                        if (p != null && p.matcher(name).find()) {
                            valid = false;
                            break;
                        }
                        ++j;
                    }
                    if (valid) {
                        String category;
                        long size = result.getSize();
                        if (!(this.minSize > -1L && this.minSize > size || this.maxSize > -1L && this.maxSize < size || this.minSeeds > -1L && this.minSeeds < (long)result.getNbSeeds() || this.categoryFilter != null && ((category = result.getCategory()) == null || !category.equalsIgnoreCase(this.categoryFilter)))) {
                            filteredResults.add(result);
                        }
                    }
                }
            }
            ++i;
        }
        Result[] fResults = filteredResults.toArray(new Result[filteredResults.size()]);
        return fResults;
    }
}

