/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.proxy.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.proxy.AEProxyFactory;
import com.aelitis.azureus.core.proxy.AEProxySelectorFactory;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.core.util.CopyOnWriteSet;
import com.aelitis.azureus.plugins.dht.DHTPluginInterface;
import java.lang.ref.WeakReference;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.PluginAdapter;
import org.gudy.azureus2.plugins.PluginEvent;
import org.gudy.azureus2.plugins.PluginEventListener;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.ipc.IPCInterface;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;

public class AEPluginProxyHandler {
    private static final CopyOnWriteList<PluginInterface> plugins = new CopyOnWriteList();
    private static final int plugin_init_max_wait = 30000;
    private static final AESemaphore plugin_init_complete = new AESemaphore("init:waiter");
    private static boolean enable_plugin_proxies_with_socks;
    private static final Map<Proxy, WeakReference<PluginProxyImpl>> proxy_map;
    private static final CopyOnWriteSet<SocketAddress> proxy_list;

    static {
        try {
            PluginInterface[] plugins;
            COConfigurationManager.addAndFireParameterListener("Proxy.SOCKS.disable.plugin.proxies", new ParameterListener(){

                @Override
                public void parameterChanged(String parameterName) {
                    enable_plugin_proxies_with_socks = !COConfigurationManager.getBooleanParameter(parameterName);
                }
            });
            AzureusCore core = AzureusCoreFactory.getSingleton();
            PluginInterface default_pi = core.getPluginManager().getDefaultPluginInterface();
            default_pi.addEventListener(new PluginEventListener(){

                @Override
                public void handleEvent(PluginEvent ev) {
                    int type = ev.getType();
                    if (type == 8) {
                        AEPluginProxyHandler.pluginAdded((PluginInterface)ev.getValue());
                    }
                    if (type == 9) {
                        AEPluginProxyHandler.pluginRemoved((PluginInterface)ev.getValue());
                    }
                }
            });
            PluginInterface[] pluginInterfaceArray = plugins = default_pi.getPluginManager().getPlugins(true);
            int n = plugins.length;
            int n2 = 0;
            while (n2 < n) {
                PluginInterface pi = pluginInterfaceArray[n2];
                if (pi.getPluginState().isOperational()) {
                    AEPluginProxyHandler.pluginAdded(pi);
                }
                ++n2;
            }
            default_pi.addListener(new PluginAdapter(){

                @Override
                public void initializationComplete() {
                    plugin_init_complete.releaseForever();
                }
            });
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        proxy_map = new IdentityHashMap<Proxy, WeakReference<PluginProxyImpl>>();
        proxy_list = new CopyOnWriteSet(false);
    }

    private static void pluginAdded(PluginInterface pi) {
        String pid = pi.getPluginID();
        if (pid.equals("aznettor") || pid.equals("azneti2phelper")) {
            plugins.add(pi);
        }
    }

    private static void pluginRemoved(PluginInterface pi) {
        String pid = pi.getPluginID();
        if (pid.equals("aznettor") || pid.equals("azneti2phelper")) {
            plugins.remove(pi);
        }
    }

    private static boolean waitForPlugins(int max_wait) {
        if (PluginInitializer.isInitThread()) {
            Debug.out("Hmm, rework this");
        }
        return plugin_init_complete.reserve(max_wait);
    }

    public static boolean hasPluginProxyForNetwork(String network, boolean supports_data) {
        boolean wait_complete;
        boolean result;
        long start = SystemTime.getMonotonousTime();
        do {
            long rem;
            if ((rem = 30000L - (SystemTime.getMonotonousTime() - start)) <= 0L) {
                return false;
            }
            wait_complete = AEPluginProxyHandler.waitForPlugins(Math.min((int)rem, 1000));
            boolean bl = result = AEPluginProxyHandler.getPluginProxyForNetwork(network, supports_data) != null;
        } while (!result && !wait_complete);
        return result;
    }

    private static PluginInterface getPluginProxyForNetwork(String network, boolean supports_data) {
        for (PluginInterface pi : plugins) {
            String pid = pi.getPluginID();
            if (pid.equals("aznettor") && network == "Tor" && !supports_data) {
                return pi;
            }
            if (!pid.equals("azneti2phelper") || network != "I2P") continue;
            return pi;
        }
        return null;
    }

    public static boolean hasPluginProxy() {
        AEPluginProxyHandler.waitForPlugins(30000);
        for (PluginInterface pi : plugins) {
            try {
                IPCInterface ipc = pi.getIPC();
                if (!ipc.canInvoke("testHTTPPseudoProxy", new Object[]{TorrentUtils.getDecentralisedEmptyURL()})) continue;
                return true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    private static boolean isEnabled() {
        Proxy system_proxy = AEProxySelectorFactory.getSelector().getActiveProxy();
        if (system_proxy == null || system_proxy.equals(Proxy.NO_PROXY)) {
            return true;
        }
        return enable_plugin_proxies_with_socks;
    }

    public static PluginProxyImpl getPluginProxy(String reason, URL target) {
        return AEPluginProxyHandler.getPluginProxy(reason, target, null, false);
    }

    public static PluginProxyImpl getPluginProxy(String reason, URL target, Map<String, Object> properties, boolean can_wait) {
        String url_protocol;
        if (AEPluginProxyHandler.isEnabled() && ((url_protocol = target.getProtocol().toLowerCase()).startsWith("http") || url_protocol.equals("ftp"))) {
            if (can_wait) {
                AEPluginProxyHandler.waitForPlugins(0);
            }
            if (properties == null) {
                properties = new HashMap<String, Object>();
            }
            for (PluginInterface pi : plugins) {
                try {
                    IPCInterface ipc = pi.getIPC();
                    Object[] proxy_details = ipc.canInvoke("getProxy", new Object[]{reason, target, properties}) ? (Object[])ipc.invoke("getProxy", new Object[]{reason, target, properties}) : (Object[])ipc.invoke("getProxy", new Object[]{reason, target});
                    if (proxy_details == null) continue;
                    if (proxy_details.length == 2) {
                        proxy_details = new Object[]{proxy_details[0], proxy_details[1], target.getHost()};
                    }
                    return new PluginProxyImpl(target.toExternalForm(), reason, ipc, properties, proxy_details);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static PluginProxyImpl getPluginProxy(String reason, String host, int port, Map<String, Object> properties) {
        if (AEPluginProxyHandler.isEnabled()) {
            if (properties == null) {
                properties = new HashMap<String, Object>();
            }
            for (PluginInterface pi : plugins) {
                try {
                    IPCInterface ipc = pi.getIPC();
                    Object[] proxy_details = ipc.canInvoke("getProxy", new Object[]{reason, host, port, properties}) ? (Object[])ipc.invoke("getProxy", new Object[]{reason, host, port, properties}) : (Object[])ipc.invoke("getProxy", new Object[]{reason, host, port});
                    if (proxy_details == null) continue;
                    return new PluginProxyImpl(String.valueOf(host) + ":" + port, reason, ipc, properties, proxy_details);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AEProxyFactory.PluginProxy getPluginProxy(Proxy proxy) {
        if (proxy != null) {
            Map<Proxy, WeakReference<PluginProxyImpl>> map = proxy_map;
            synchronized (map) {
                WeakReference<PluginProxyImpl> ref = proxy_map.get(proxy);
                if (ref != null) {
                    return (AEProxyFactory.PluginProxy)ref.get();
                }
            }
        }
        return null;
    }

    public static boolean isPluginProxy(SocketAddress address) {
        return proxy_list.contains(address);
    }

    public static Boolean testPluginHTTPProxy(URL url, boolean can_wait) {
        if (AEPluginProxyHandler.isEnabled()) {
            String url_protocol = url.getProtocol().toLowerCase();
            if (url_protocol.startsWith("http")) {
                if (can_wait) {
                    AEPluginProxyHandler.waitForPlugins(0);
                }
                for (PluginInterface pi : plugins) {
                    try {
                        IPCInterface ipc = pi.getIPC();
                        return (Boolean)ipc.invoke("testHTTPPseudoProxy", new Object[]{url});
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            } else {
                Debug.out("Unsupported protocol: " + url_protocol);
            }
        }
        return null;
    }

    public static PluginHTTPProxyImpl getPluginHTTPProxy(String reason, URL url, boolean can_wait) {
        if (AEPluginProxyHandler.isEnabled()) {
            String url_protocol = url.getProtocol().toLowerCase();
            if (url_protocol.startsWith("http")) {
                if (can_wait) {
                    AEPluginProxyHandler.waitForPlugins(0);
                }
                for (PluginInterface pi : plugins) {
                    try {
                        IPCInterface ipc = pi.getIPC();
                        Proxy proxy = (Proxy)ipc.invoke("createHTTPPseudoProxy", new Object[]{reason, url});
                        if (proxy == null) continue;
                        return new PluginHTTPProxyImpl(reason, ipc, proxy);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            } else {
                Debug.out("Unsupported protocol: " + url_protocol);
            }
        }
        return null;
    }

    public static List<PluginInterface> getPluginHTTPProxyProviders(boolean can_wait) {
        if (can_wait) {
            AEPluginProxyHandler.waitForPlugins(0);
        }
        List<PluginInterface> pis = AzureusCoreFactory.getSingleton().getPluginManager().getPluginsWithMethod("createHTTPPseudoProxy", new Class[]{String.class, URL.class});
        return pis;
    }

    public static Map<String, Object> getPluginServerProxy(String reason, String network, String server_uid, Map<String, Object> options) {
        AEPluginProxyHandler.waitForPlugins(30000);
        PluginInterface pi = AEPluginProxyHandler.getPluginProxyForNetwork(network, false);
        if (pi == null) {
            return null;
        }
        options = new HashMap<String, Object>(options);
        options.put("id", server_uid);
        try {
            IPCInterface ipc = pi.getIPC();
            Map reply = (Map)ipc.invoke("getProxyServer", new Object[]{reason, options});
            return reply;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static DHTPluginInterface getPluginDHTProxy(String reason, String network, Map<String, Object> options) {
        AEPluginProxyHandler.waitForPlugins(30000);
        PluginInterface pi = AEPluginProxyHandler.getPluginProxyForNetwork(network, false);
        if (pi == null) {
            return null;
        }
        try {
            IPCInterface ipc = pi.getIPC();
            DHTPluginInterface reply = (DHTPluginInterface)ipc.invoke("getProxyDHT", new Object[]{reason, options});
            return reply;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static class PluginHTTPProxyImpl
    implements AEProxyFactory.PluginHTTPProxy {
        private final String reason;
        private final IPCInterface ipc;
        private final Proxy proxy;

        private PluginHTTPProxyImpl(String _reason, IPCInterface _ipc, Proxy _proxy) {
            this.reason = _reason;
            this.ipc = _ipc;
            this.proxy = _proxy;
        }

        @Override
        public Proxy getProxy() {
            return this.proxy;
        }

        @Override
        public String proxifyURL(String url) {
            try {
                URL _url = new URL(url);
                InetSocketAddress pa = (InetSocketAddress)this.proxy.address();
                _url = UrlUtils.setHost(_url, pa.getAddress().getHostAddress());
                _url = UrlUtils.setPort(_url, pa.getPort());
                url = _url.toExternalForm();
                url = String.valueOf(url) + (url.indexOf(63) == -1 ? "?" : "&") + "_azpproxy=1";
                return url;
            }
            catch (Throwable e) {
                Debug.out("Failed to proxify URL: " + url, e);
                return url;
            }
        }

        @Override
        public void destroy() {
            try {
                this.ipc.invoke("destroyHTTPPseudoProxy", new Object[]{this.proxy});
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    private static class PluginProxyImpl
    implements AEProxyFactory.PluginProxy {
        private final long create_time = SystemTime.getMonotonousTime();
        private final String target;
        private final String reason;
        private final IPCInterface ipc;
        private final Map<String, Object> proxy_options;
        private final Object[] proxy_details;
        private final List<PluginProxyImpl> children = new ArrayList<PluginProxyImpl>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private PluginProxyImpl(String _target, String _reason, IPCInterface _ipc, Map<String, Object> _proxy_options, Object[] _proxy_details) {
            this.target = _target;
            this.reason = _reason;
            this.ipc = _ipc;
            this.proxy_options = _proxy_options;
            this.proxy_details = _proxy_details;
            WeakReference<PluginProxyImpl> my_ref = new WeakReference<PluginProxyImpl>(this);
            ArrayList<PluginProxyImpl> removed = new ArrayList<PluginProxyImpl>();
            Map map = proxy_map;
            synchronized (map) {
                Proxy proxy = this.getProxy();
                SocketAddress address = proxy.address();
                if (!proxy_list.contains(address)) {
                    proxy_list.add(address);
                }
                proxy_map.put(proxy, my_ref);
                if (proxy_map.size() > 1024) {
                    long now = SystemTime.getMonotonousTime();
                    Iterator it = proxy_map.values().iterator();
                    while (it.hasNext()) {
                        WeakReference ref = (WeakReference)it.next();
                        PluginProxyImpl pp = (PluginProxyImpl)ref.get();
                        if (pp == null) {
                            it.remove();
                            continue;
                        }
                        if (now - pp.create_time <= 300000L) continue;
                        removed.add(pp);
                        it.remove();
                    }
                }
            }
            for (PluginProxyImpl pp : removed) {
                pp.setOK(false);
            }
        }

        @Override
        public String getTarget() {
            return this.target;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AEProxyFactory.PluginProxy getChildProxy(String child_reason, URL url) {
            PluginProxyImpl child = AEPluginProxyHandler.getPluginProxy(String.valueOf(this.reason) + " - " + child_reason, url, this.proxy_options, false);
            if (child != null) {
                List<PluginProxyImpl> list = this.children;
                synchronized (list) {
                    this.children.add(child);
                }
            }
            return child;
        }

        @Override
        public Proxy getProxy() {
            return (Proxy)this.proxy_details[0];
        }

        @Override
        public URL getURL() {
            return (URL)this.proxy_details[1];
        }

        @Override
        public String getURLHostRewrite() {
            return (String)this.proxy_details[2];
        }

        @Override
        public String getHost() {
            return (String)this.proxy_details[1];
        }

        @Override
        public int getPort() {
            return (Integer)this.proxy_details[2];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setOK(boolean good) {
            ArrayList<PluginProxyImpl> kids;
            try {
                this.ipc.invoke("setProxyStatus", new Object[]{this.proxy_details[0], good});
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Object object = this.children;
            synchronized (object) {
                kids = new ArrayList<PluginProxyImpl>(this.children);
                this.children.clear();
            }
            for (PluginProxyImpl child : kids) {
                child.setOK(good);
            }
            object = proxy_map;
            synchronized (object) {
                proxy_map.remove(this.getProxy());
            }
        }
    }
}

