/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.utils;

import com.aelitis.azureus.core.networkmanager.OutgoingMessageQueue;
import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTPiece;
import com.aelitis.azureus.core.peermanager.utils.OutgoingBTPieceMessageHandlerAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequest;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequestListener;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.DirectByteBuffer;

public class OutgoingBTPieceMessageHandler {
    private final PEPeer peer;
    private final OutgoingMessageQueue outgoing_message_queue;
    private byte piece_version;
    private final LinkedList<DiskManagerReadRequest> requests = new LinkedList();
    private final ArrayList<DiskManagerReadRequest> loading_messages = new ArrayList();
    private final HashMap<BTPiece, DiskManagerReadRequest> queued_messages = new HashMap();
    private final AEMonitor lock_mon = new AEMonitor("OutgoingBTPieceMessageHandler:lock");
    private boolean destroyed = false;
    private int request_read_ahead = 2;
    final OutgoingBTPieceMessageHandlerAdapter adapter;
    private final DiskManagerReadRequestListener read_req_listener = new DiskManagerReadRequestListener(){

        @Override
        public void readCompleted(DiskManagerReadRequest request2, DirectByteBuffer data) {
            try {
                OutgoingBTPieceMessageHandler.this.lock_mon.enter();
                if (!OutgoingBTPieceMessageHandler.this.loading_messages.contains(request2) || OutgoingBTPieceMessageHandler.this.destroyed) {
                    data.returnToPool();
                    return;
                }
                OutgoingBTPieceMessageHandler.this.loading_messages.remove(request2);
                BTPiece msg = new BTPiece(request2.getPieceNumber(), request2.getOffset(), data, OutgoingBTPieceMessageHandler.this.piece_version);
                OutgoingBTPieceMessageHandler.this.queued_messages.put(msg, request2);
                OutgoingBTPieceMessageHandler.this.outgoing_message_queue.addMessage(msg, true);
            }
            finally {
                OutgoingBTPieceMessageHandler.this.lock_mon.exit();
            }
            OutgoingBTPieceMessageHandler.this.outgoing_message_queue.doListenerNotifications();
        }

        @Override
        public void readFailed(DiskManagerReadRequest request2, Throwable cause) {
            try {
                OutgoingBTPieceMessageHandler.this.lock_mon.enter();
                if (!OutgoingBTPieceMessageHandler.this.loading_messages.contains(request2) || OutgoingBTPieceMessageHandler.this.destroyed) {
                    return;
                }
                OutgoingBTPieceMessageHandler.this.loading_messages.remove(request2);
            }
            finally {
                OutgoingBTPieceMessageHandler.this.lock_mon.exit();
            }
            OutgoingBTPieceMessageHandler.this.peer.sendRejectRequest(request2);
        }

        @Override
        public int getPriority() {
            return -1;
        }

        @Override
        public void requestExecuted(long bytes) {
            OutgoingBTPieceMessageHandler.this.adapter.diskRequestCompleted(bytes);
        }
    };
    private final OutgoingMessageQueue.MessageQueueListener sent_message_listener = new OutgoingMessageQueue.MessageQueueListener(){

        @Override
        public boolean messageAdded(Message message) {
            return true;
        }

        @Override
        public void messageSent(Message message) {
            if (message.getID().equals("BT_PIECE")) {
                try {
                    OutgoingBTPieceMessageHandler.this.lock_mon.enter();
                    OutgoingBTPieceMessageHandler.this.queued_messages.remove(message);
                }
                finally {
                    OutgoingBTPieceMessageHandler.this.lock_mon.exit();
                }
                OutgoingBTPieceMessageHandler.this.doReadAheadLoads();
            }
        }

        @Override
        public void messageQueued(Message message) {
        }

        @Override
        public void messageRemoved(Message message) {
        }

        @Override
        public void protocolBytesSent(int byte_count) {
        }

        @Override
        public void dataBytesSent(int byte_count) {
        }

        @Override
        public void flush() {
        }
    };

    public OutgoingBTPieceMessageHandler(PEPeer _peer, OutgoingMessageQueue _outgoing_message_q, OutgoingBTPieceMessageHandlerAdapter _adapter, byte _piece_version) {
        this.peer = _peer;
        this.outgoing_message_queue = _outgoing_message_q;
        this.adapter = _adapter;
        this.piece_version = _piece_version;
        this.outgoing_message_queue.registerQueueListener(this.sent_message_listener);
    }

    public void setPieceVersion(byte version) {
        this.piece_version = version;
    }

    public boolean addPieceRequest(int piece_number, int piece_offset, int length) {
        if (this.destroyed) {
            return false;
        }
        DiskManagerReadRequest dmr = this.peer.getManager().getDiskManager().createReadRequest(piece_number, piece_offset, length);
        try {
            this.lock_mon.enter();
            this.requests.addLast(dmr);
        }
        finally {
            this.lock_mon.exit();
        }
        this.doReadAheadLoads();
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removePieceRequest(int piece_number, int piece_offset, int length) {
        if (this.destroyed) {
            return;
        }
        DiskManagerReadRequest dmr = this.peer.getManager().getDiskManager().createReadRequest(piece_number, piece_offset, length);
        boolean inform_rejected = false;
        try {
            this.lock_mon.enter();
            if (this.requests.contains(dmr)) {
                this.requests.remove(dmr);
                inform_rejected = true;
                return;
            }
            if (this.loading_messages.contains(dmr)) {
                this.loading_messages.remove(dmr);
                inform_rejected = true;
                return;
            }
            Iterator<Map.Entry<BTPiece, DiskManagerReadRequest>> i = this.queued_messages.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<BTPiece, DiskManagerReadRequest> entry = i.next();
                if (!((Object)entry.getValue()).equals(dmr)) continue;
                BTPiece msg = entry.getKey();
                if (this.outgoing_message_queue.removeMessage(msg, true)) {
                    inform_rejected = true;
                    i.remove();
                }
                break;
            }
        }
        finally {
            this.lock_mon.exit();
            if (inform_rejected) {
                this.peer.sendRejectRequest(dmr);
            }
        }
        this.outgoing_message_queue.doListenerNotifications();
    }

    public void removeAllPieceRequests() {
        if (this.destroyed) {
            return;
        }
        ArrayList<DiskManagerReadRequest> removed = new ArrayList<DiskManagerReadRequest>();
        try {
            this.lock_mon.enter();
            for (BTPiece msg : this.queued_messages.keySet()) {
                if (!this.outgoing_message_queue.removeMessage(msg, true)) continue;
                removed.add(this.queued_messages.get(msg));
            }
            this.queued_messages.clear();
            removed.addAll(this.requests);
            this.requests.clear();
            removed.addAll(this.loading_messages);
            this.loading_messages.clear();
        }
        finally {
            this.lock_mon.exit();
        }
        for (DiskManagerReadRequest request2 : removed) {
            this.peer.sendRejectRequest(request2);
        }
        this.outgoing_message_queue.doListenerNotifications();
    }

    public void setRequestReadAhead(int num_to_read_ahead) {
        this.request_read_ahead = num_to_read_ahead;
    }

    public void destroy() {
        try {
            this.lock_mon.enter();
            this.removeAllPieceRequests();
            this.queued_messages.clear();
            this.destroyed = true;
            this.outgoing_message_queue.cancelQueueListener(this.sent_message_listener);
        }
        finally {
            this.lock_mon.exit();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doReadAheadLoads() {
        ArrayList<DiskManagerReadRequest> to_submit = null;
        try {
            this.lock_mon.enter();
            while (this.loading_messages.size() + this.queued_messages.size() < this.request_read_ahead && !this.requests.isEmpty() && !this.destroyed) {
                DiskManagerReadRequest dmr = this.requests.removeFirst();
                this.loading_messages.add(dmr);
                if (to_submit == null) {
                    to_submit = new ArrayList<DiskManagerReadRequest>();
                }
                to_submit.add(dmr);
            }
        }
        finally {
            this.lock_mon.exit();
        }
        if (to_submit != null) {
            int i = 0;
            while (i < to_submit.size()) {
                this.peer.getManager().getAdapter().enqueueReadRequest(this.peer, (DiskManagerReadRequest)to_submit.get(i), this.read_req_listener);
                ++i;
            }
        }
    }

    public int[] getRequestedPieceNumbers() {
        int[] pieceNumbers;
        if (this.destroyed) {
            return new int[0];
        }
        int iLastNumber = -1;
        int pos = 0;
        try {
            this.lock_mon.enter();
            pieceNumbers = new int[this.queued_messages.size() + this.loading_messages.size() + this.requests.size()];
            for (BTPiece msg : this.queued_messages.keySet()) {
                if (iLastNumber == msg.getPieceNumber()) continue;
                iLastNumber = msg.getPieceNumber();
                pieceNumbers[pos++] = iLastNumber;
            }
            for (DiskManagerReadRequest dmr : this.loading_messages) {
                if (iLastNumber == dmr.getPieceNumber()) continue;
                iLastNumber = dmr.getPieceNumber();
                pieceNumbers[pos++] = iLastNumber;
            }
            for (DiskManagerReadRequest dmr : this.requests) {
                if (iLastNumber == dmr.getPieceNumber()) continue;
                iLastNumber = dmr.getPieceNumber();
                pieceNumbers[pos++] = iLastNumber;
            }
        }
        finally {
            this.lock_mon.exit();
        }
        int[] trimmed = new int[pos];
        System.arraycopy(pieceNumbers, 0, trimmed, 0, pos);
        return trimmed;
    }

    public int getRequestCount() {
        return this.queued_messages.size() + this.loading_messages.size() + this.requests.size();
    }

    public boolean isStalledPendingLoad() {
        return this.queued_messages.size() == 0 && this.loading_messages.size() > 0;
    }
}

