/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.utils;

import com.aelitis.azureus.core.peermanager.utils.BTPeerIDByteDecoder;
import com.aelitis.azureus.core.peermanager.utils.BTPeerIDByteDecoderUtils;
import java.util.ArrayList;
import java.util.HashMap;
import org.gudy.azureus2.core3.internat.MessageText;

public class BTPeerIDByteDecoderDefinitions {
    private static final HashMap az_style_code_map = new HashMap();
    private static final HashMap az_client_version_map = new HashMap();
    private static final HashMap shadow_style_code_map = new HashMap();
    private static final HashMap shadow_client_version_map = new HashMap();
    private static final HashMap mainline_style_code_map = new HashMap();
    private static final ArrayList custom_style_client_list = new ArrayList();
    static final String VER_AZ_THREE_DIGITS = "1.2.3";
    static final String VER_AZ_THREE_DIGITS_PLUS_MNEMONIC = "1.2.3 [4]";
    static final String VER_AZ_ONE_MAJ_TWO_MIN_PLUS_MNEMONIC = "1.23 [4]";
    static final String VER_AZ_FOUR_DIGITS = "1.2.3.4";
    static final String VER_AZ_V_FOUR_DIGITS = "v1.2.3.4";
    static final String VER_AZ_TWO_MAJ_TWO_MIN = "12.34";
    static final String VER_AZ_SKIP_FIRST_ONE_MAJ_TWO_MIN = "2.34";
    static final String VER_AZ_KTORRENT_STYLE = "1.2.3=[RD].4";
    static final String VER_AZ_TRANSMISSION_STYLE = "transmission";
    static final String VER_AZ_LAST_THREE_DIGITS = "2.3.4";
    static final String VER_AZ_THREE_ALPHANUMERIC_DIGITS = "2.33.4";
    static final String VER_BLOCK = "abcde";
    static final String VER_DOTTED_BLOCK = "a.b.c.d.e";
    static final String VER_BYTE_BLOCK_DOTTED_CHAR = "abcde -> a.b.c.d.e";
    static final String VER_TWOBYTE_BLOCK_DOTTED_CHAR = "abcde -> ab.cd";
    static final String VER_BITS_ON_WHEELS = "BOW-STYLE";
    static final String VER_TWO_BYTE_THREE_PART = "ab -> a . b/10 . b%10";
    static final String NO_VERSION = "NO_VERSION";
    static final String VER_BYTE_UM_STYLE = "abcd -> a.b.cd";
    static final String VER_BITLORD = "abcdef -> a.b.c-edf";

    static {
        BTPeerIDByteDecoderDefinitions.addAzStyle("AZ", "Vuze", VER_AZ_FOUR_DIGITS);
        BTPeerIDByteDecoderDefinitions.addAzStyle("A~", "Ares", VER_AZ_THREE_DIGITS);
        BTPeerIDByteDecoderDefinitions.addAzStyle("AG", "Ares", VER_AZ_THREE_DIGITS);
        BTPeerIDByteDecoderDefinitions.addAzStyle("AN", "Ares", VER_AZ_FOUR_DIGITS);
        BTPeerIDByteDecoderDefinitions.addAzStyle("AR", "Ares");
        BTPeerIDByteDecoderDefinitions.addAzStyle("AV", "Avicora");
        BTPeerIDByteDecoderDefinitions.addAzStyle("AX", "BitPump", VER_AZ_TWO_MAJ_TWO_MIN);
        BTPeerIDByteDecoderDefinitions.addAzStyle("AT", "Artemis");
        BTPeerIDByteDecoderDefinitions.addAzStyle("BB", "BitBuddy", "1.234");
        BTPeerIDByteDecoderDefinitions.addAzStyle("BC", "BitComet", VER_AZ_SKIP_FIRST_ONE_MAJ_TWO_MIN);
        BTPeerIDByteDecoderDefinitions.addAzStyle("BE", "BitTorrent SDK");
        BTPeerIDByteDecoderDefinitions.addAzStyle("BF", "BitFlu", NO_VERSION);
        BTPeerIDByteDecoderDefinitions.addAzStyle("BG", "BTG", VER_AZ_FOUR_DIGITS);
        BTPeerIDByteDecoderDefinitions.addAzStyle("bk", "BitKitten (libtorrent)");
        BTPeerIDByteDecoderDefinitions.addAzStyle("BR", "BitRocket", "1.2(34)");
        BTPeerIDByteDecoderDefinitions.addAzStyle("BS", "BTSlave");
        BTPeerIDByteDecoderDefinitions.addAzStyle("BW", "BitWombat");
        BTPeerIDByteDecoderDefinitions.addAzStyle("BX", "BittorrentX");
        BTPeerIDByteDecoderDefinitions.addAzStyle("CB", "Shareaza Plus");
        BTPeerIDByteDecoderDefinitions.addAzStyle("CD", "Enhanced CTorrent", VER_AZ_TWO_MAJ_TWO_MIN);
        BTPeerIDByteDecoderDefinitions.addAzStyle("CT", "CTorrent", "1.2.34");
        BTPeerIDByteDecoderDefinitions.addAzStyle("DP", "Propogate Data Client");
        BTPeerIDByteDecoderDefinitions.addAzStyle("DE", "Deluge", VER_AZ_FOUR_DIGITS);
        BTPeerIDByteDecoderDefinitions.addAzStyle("EB", "EBit");
        BTPeerIDByteDecoderDefinitions.addAzStyle("ES", "Electric Sheep", VER_AZ_THREE_DIGITS);
        BTPeerIDByteDecoderDefinitions.addAzStyle("eM", "eMule", NO_VERSION);
        BTPeerIDByteDecoderDefinitions.addAzStyle("FC", "FileCroc");
        BTPeerIDByteDecoderDefinitions.addAzStyle("FG", "FlashGet", VER_AZ_SKIP_FIRST_ONE_MAJ_TWO_MIN);
        BTPeerIDByteDecoderDefinitions.addAzStyle("FT", "FoxTorrent/RedSwoosh");
        BTPeerIDByteDecoderDefinitions.addAzStyle("GR", "GetRight", "1.2");
        BTPeerIDByteDecoderDefinitions.addAzStyle("GS", "GSTorrent");
        BTPeerIDByteDecoderDefinitions.addAzStyle("HL", "Halite", VER_AZ_THREE_DIGITS);
        BTPeerIDByteDecoderDefinitions.addAzStyle("IL", "iLivid", VER_AZ_THREE_DIGITS);
        BTPeerIDByteDecoderDefinitions.addAzStyle("HN", "Hydranode");
        BTPeerIDByteDecoderDefinitions.addAzStyle("KG", "KGet");
        BTPeerIDByteDecoderDefinitions.addAzStyle("KT", "KTorrent", VER_AZ_KTORRENT_STYLE);
        BTPeerIDByteDecoderDefinitions.addAzStyle("LC", "LeechCraft");
        BTPeerIDByteDecoderDefinitions.addAzStyle("LH", "LH-ABC");
        BTPeerIDByteDecoderDefinitions.addAzStyle("LK", "linkage", VER_AZ_THREE_DIGITS);
        BTPeerIDByteDecoderDefinitions.addAzStyle("LP", "Lphant", VER_AZ_TWO_MAJ_TWO_MIN);
        BTPeerIDByteDecoderDefinitions.addAzStyle("LT", "libtorrent (Rasterbar)", VER_AZ_THREE_ALPHANUMERIC_DIGITS);
        BTPeerIDByteDecoderDefinitions.addAzStyle("lt", "libTorrent (Rakshasa)", VER_AZ_THREE_ALPHANUMERIC_DIGITS);
        BTPeerIDByteDecoderDefinitions.addAzStyle("LW", "LimeWire", NO_VERSION);
        BTPeerIDByteDecoderDefinitions.addAzStyle("MO", "MonoTorrent");
        BTPeerIDByteDecoderDefinitions.addAzStyle("MP", "MooPolice", VER_AZ_THREE_DIGITS);
        BTPeerIDByteDecoderDefinitions.addAzStyle("MR", "Miro");
        BTPeerIDByteDecoderDefinitions.addAzStyle("MT", "MoonlightTorrent");
        BTPeerIDByteDecoderDefinitions.addAzStyle("NE", "BT Next Evolution", VER_AZ_THREE_DIGITS);
        BTPeerIDByteDecoderDefinitions.addAzStyle("NX", "Net Transport");
        BTPeerIDByteDecoderDefinitions.addAzStyle("OS", "OneSwarm", VER_AZ_FOUR_DIGITS);
        BTPeerIDByteDecoderDefinitions.addAzStyle("OT", "OmegaTorrent");
        BTPeerIDByteDecoderDefinitions.addAzStyle("PC", "CacheLogic", "12.3-4");
        BTPeerIDByteDecoderDefinitions.addAzStyle("PD", "Pando");
        BTPeerIDByteDecoderDefinitions.addAzStyle("PE", "PeerProject");
        BTPeerIDByteDecoderDefinitions.addAzStyle("pX", "pHoeniX");
        BTPeerIDByteDecoderDefinitions.addAzStyle("qB", "qBittorrent", VER_AZ_THREE_ALPHANUMERIC_DIGITS);
        BTPeerIDByteDecoderDefinitions.addAzStyle("QD", "qqdownload");
        BTPeerIDByteDecoderDefinitions.addAzStyle("RT", "Retriever");
        BTPeerIDByteDecoderDefinitions.addAzStyle("RZ", "RezTorrent");
        BTPeerIDByteDecoderDefinitions.addAzStyle("S~", "Shareaza alpha/beta");
        BTPeerIDByteDecoderDefinitions.addAzStyle("SB", "SwiftBit");
        BTPeerIDByteDecoderDefinitions.addAzStyle("SD", "\u8fc5\u96f7\u5728\u7ebf (Xunlei)");
        BTPeerIDByteDecoderDefinitions.addAzStyle("SG", "GS Torrent", VER_AZ_FOUR_DIGITS);
        BTPeerIDByteDecoderDefinitions.addAzStyle("SN", "ShareNET");
        BTPeerIDByteDecoderDefinitions.addAzStyle("SP", "BitSpirit");
        BTPeerIDByteDecoderDefinitions.addAzStyle("SS", "SwarmScope");
        BTPeerIDByteDecoderDefinitions.addAzStyle("ST", "SymTorrent", VER_AZ_SKIP_FIRST_ONE_MAJ_TWO_MIN);
        BTPeerIDByteDecoderDefinitions.addAzStyle("st", "SharkTorrent");
        BTPeerIDByteDecoderDefinitions.addAzStyle("SZ", "Shareaza");
        BTPeerIDByteDecoderDefinitions.addAzStyle("TB", "Torch");
        BTPeerIDByteDecoderDefinitions.addAzStyle("TN", "Torrent.NET");
        BTPeerIDByteDecoderDefinitions.addAzStyle("TR", "Transmission", VER_AZ_TRANSMISSION_STYLE);
        BTPeerIDByteDecoderDefinitions.addAzStyle("TS", "TorrentStorm");
        BTPeerIDByteDecoderDefinitions.addAzStyle("TT", "TuoTu", VER_AZ_THREE_DIGITS);
        BTPeerIDByteDecoderDefinitions.addAzStyle("tT", "tTorrent", VER_AZ_V_FOUR_DIGITS);
        BTPeerIDByteDecoderDefinitions.addAzStyle("TX", "Tixati");
        BTPeerIDByteDecoderDefinitions.addAzStyle("UL", "uLeecher!");
        BTPeerIDByteDecoderDefinitions.addAzStyle("UT", "\u00b5Torrent", VER_AZ_THREE_DIGITS_PLUS_MNEMONIC);
        BTPeerIDByteDecoderDefinitions.addAzStyle("UM", "\u00b5Torrent Mac", VER_AZ_THREE_DIGITS_PLUS_MNEMONIC);
        BTPeerIDByteDecoderDefinitions.addAzStyle("WT", "Bitlet");
        BTPeerIDByteDecoderDefinitions.addAzStyle("WW", "WebTorrent");
        BTPeerIDByteDecoderDefinitions.addAzStyle("WY", "FireTorrent");
        BTPeerIDByteDecoderDefinitions.addAzStyle("VG", "\u54c7\u560e (Vagaa)", VER_AZ_FOUR_DIGITS);
        BTPeerIDByteDecoderDefinitions.addAzStyle("XF", "Xfplay", VER_AZ_FOUR_DIGITS);
        BTPeerIDByteDecoderDefinitions.addAzStyle("XL", "\u8fc5\u96f7\u5728\u7ebf (Xunlei)");
        BTPeerIDByteDecoderDefinitions.addAzStyle("XT", "XanTorrent");
        BTPeerIDByteDecoderDefinitions.addAzStyle("XX", "XTorrent", "1.2.34");
        BTPeerIDByteDecoderDefinitions.addAzStyle("XC", "XTorrent", "1.2.34");
        BTPeerIDByteDecoderDefinitions.addAzStyle("ZT", "ZipTorrent");
        BTPeerIDByteDecoderDefinitions.addAzStyle("7T", "aTorrent");
        BTPeerIDByteDecoderDefinitions.addAzStyle("#@", "Invalid PeerID");
        BTPeerIDByteDecoderDefinitions.addShadowStyle('A', "ABC");
        BTPeerIDByteDecoderDefinitions.addShadowStyle('O', "Osprey Permaseed");
        BTPeerIDByteDecoderDefinitions.addShadowStyle('Q', "BTQueue");
        BTPeerIDByteDecoderDefinitions.addShadowStyle('R', "Tribler");
        BTPeerIDByteDecoderDefinitions.addShadowStyle('S', "Shad0w");
        BTPeerIDByteDecoderDefinitions.addShadowStyle('T', "BitTornado");
        BTPeerIDByteDecoderDefinitions.addShadowStyle('U', "UPnP NAT");
        BTPeerIDByteDecoderDefinitions.addMainlineStyle('M', "Mainline");
        BTPeerIDByteDecoderDefinitions.addMainlineStyle('Q', "Queen Bee");
        BTPeerIDByteDecoderDefinitions.addSimpleClient("\u00b5Torrent 1.7.0 RC", "-UT170-");
        BTPeerIDByteDecoderDefinitions.addSimpleClient("Azureus 1", "Azureus");
        BTPeerIDByteDecoderDefinitions.addSimpleClient("Azureus 2.0.3.2", "Azureus", 5);
        BTPeerIDByteDecoderDefinitions.addSimpleClient("Aria 2", "-aria2-");
        BTPeerIDByteDecoderDefinitions.addSimpleClient("BitTorrent Plus! II", "PRC.P---");
        BTPeerIDByteDecoderDefinitions.addSimpleClient("BitTorrent Plus!", "P87.P---");
        BTPeerIDByteDecoderDefinitions.addSimpleClient("BitTorrent Plus!", "S587Plus");
        BTPeerIDByteDecoderDefinitions.addSimpleClient("BitTyrant (Azureus Mod)", "AZ2500BT");
        BTPeerIDByteDecoderDefinitions.addSimpleClient("Blizzard Downloader", "BLZ");
        BTPeerIDByteDecoderDefinitions.addSimpleClient("BTGetit", "BG", 10);
        BTPeerIDByteDecoderDefinitions.addSimpleClient("BTugaXP", "btuga");
        BTPeerIDByteDecoderDefinitions.addSimpleClient("BTugaXP", "BTuga", 5);
        BTPeerIDByteDecoderDefinitions.addSimpleClient("BTugaXP", "oernu");
        BTPeerIDByteDecoderDefinitions.addSimpleClient("Deadman Walking", "BTDWV-");
        BTPeerIDByteDecoderDefinitions.addSimpleClient("Deadman", "Deadman Walking-");
        BTPeerIDByteDecoderDefinitions.addSimpleClient("External Webseed", "Ext");
        BTPeerIDByteDecoderDefinitions.addSimpleClient("G3 Torrent", "-G3");
        BTPeerIDByteDecoderDefinitions.addSimpleClient("GreedBT 2.7.1", "271-");
        BTPeerIDByteDecoderDefinitions.addSimpleClient("Hurricane Electric", "arclight");
        BTPeerIDByteDecoderDefinitions.addSimpleClient("HTTP Seed", "-WS");
        BTPeerIDByteDecoderDefinitions.addSimpleClient("JVtorrent", "10-------");
        BTPeerIDByteDecoderDefinitions.addSimpleClient("Limewire", "LIME");
        BTPeerIDByteDecoderDefinitions.addSimpleClient("Martini Man", "martini");
        BTPeerIDByteDecoderDefinitions.addSimpleClient("Pando", "Pando");
        BTPeerIDByteDecoderDefinitions.addSimpleClient("PeerApp", "PEERAPP");
        BTPeerIDByteDecoderDefinitions.addSimpleClient("SimpleBT", "btfans", 4);
        BTPeerIDByteDecoderDefinitions.addSimpleClient("Swarmy", "a00---0");
        BTPeerIDByteDecoderDefinitions.addSimpleClient("Swarmy", "a02---0");
        BTPeerIDByteDecoderDefinitions.addSimpleClient("Teeweety", "T00---0");
        BTPeerIDByteDecoderDefinitions.addSimpleClient("TorrentTopia", "346-");
        BTPeerIDByteDecoderDefinitions.addSimpleClient("XanTorrent", "DansClient");
        BTPeerIDByteDecoderDefinitions.addSimpleClient("MediaGet", "-MG1");
        BTPeerIDByteDecoderDefinitions.addSimpleClient("MediaGet2 2.1", "-MG21");
        BTPeerIDByteDecoderDefinitions.addSimpleClient("Amazon AWS S3", "S3-");
        ClientData client = null;
        client = BTPeerIDByteDecoderDefinitions.addSimpleClient("BitTorrent DNA", "DNA");
        BTPeerIDByteDecoderDefinitions.addVersionedClient(client, VER_BYTE_BLOCK_DOTTED_CHAR, 2, 4);
        client = BTPeerIDByteDecoderDefinitions.addSimpleClient("Opera", "OP");
        BTPeerIDByteDecoderDefinitions.addVersionedClient(client, VER_BLOCK, 4, " (Build %s)");
        client = BTPeerIDByteDecoderDefinitions.addSimpleClient("Opera", "O");
        BTPeerIDByteDecoderDefinitions.addVersionedClient(client, VER_BLOCK, 5, " (Build %s)");
        client = BTPeerIDByteDecoderDefinitions.addSimpleClient("Burst!", "Mbrst");
        BTPeerIDByteDecoderDefinitions.addVersionedClient(client, VER_DOTTED_BLOCK, 5);
        client = BTPeerIDByteDecoderDefinitions.addSimpleClient("TurboBT", "turbobt");
        BTPeerIDByteDecoderDefinitions.addVersionedClient(client, VER_BLOCK, 5);
        client = BTPeerIDByteDecoderDefinitions.addSimpleClient("BT Protocol Daemon", "btpd");
        BTPeerIDByteDecoderDefinitions.addVersionedClient(client, VER_BLOCK, 3, 5);
        client = BTPeerIDByteDecoderDefinitions.addSimpleClient("Plus!", "Plus");
        BTPeerIDByteDecoderDefinitions.addVersionedClient(client, VER_BYTE_BLOCK_DOTTED_CHAR, 3);
        client = BTPeerIDByteDecoderDefinitions.addSimpleClient("XBT", "XBT");
        BTPeerIDByteDecoderDefinitions.addVersionedClient(client, VER_BYTE_BLOCK_DOTTED_CHAR, 3);
        client = BTPeerIDByteDecoderDefinitions.addSimpleClient("BitsOnWheels", "-BOW");
        BTPeerIDByteDecoderDefinitions.addVersionedClient(client, VER_BITS_ON_WHEELS, 3);
        client = BTPeerIDByteDecoderDefinitions.addSimpleClient("eXeem", "eX");
        BTPeerIDByteDecoderDefinitions.addVersionedClient(client, VER_BLOCK, 18, " [%s]");
        client = BTPeerIDByteDecoderDefinitions.addSimpleClient("MLdonkey", "-ML");
        BTPeerIDByteDecoderDefinitions.addVersionedClient(client, VER_DOTTED_BLOCK, 5);
        client = BTPeerIDByteDecoderDefinitions.addSimpleClient("Bitlet", "BitLet");
        BTPeerIDByteDecoderDefinitions.addVersionedClient(client, VER_BYTE_BLOCK_DOTTED_CHAR, 2);
        client = BTPeerIDByteDecoderDefinitions.addSimpleClient("AllPeers", "AP");
        BTPeerIDByteDecoderDefinitions.addVersionedClient(client, VER_BLOCK, -1);
        client = BTPeerIDByteDecoderDefinitions.addSimpleClient("BTuga Revolution", "BTM");
        BTPeerIDByteDecoderDefinitions.addVersionedClient(client, VER_BYTE_BLOCK_DOTTED_CHAR, 2);
        client = BTPeerIDByteDecoderDefinitions.addSimpleClient("Rufus", "RS", 2);
        BTPeerIDByteDecoderDefinitions.addVersionedClient(client, VER_TWO_BYTE_THREE_PART, 2, 0);
        client = BTPeerIDByteDecoderDefinitions.addSimpleClient("BitMagnet", "BM", 2);
        BTPeerIDByteDecoderDefinitions.addVersionedClient(client, VER_TWO_BYTE_THREE_PART, 2, 0);
        client = BTPeerIDByteDecoderDefinitions.addSimpleClient("QVOD", "QVOD");
        BTPeerIDByteDecoderDefinitions.addVersionedClient(client, VER_BLOCK, 4, " (Build %s)");
        client = BTPeerIDByteDecoderDefinitions.addSimpleClient("Top-BT", "TB");
        BTPeerIDByteDecoderDefinitions.addVersionedClient(client, VER_BYTE_BLOCK_DOTTED_CHAR, 3);
        client = BTPeerIDByteDecoderDefinitions.addSimpleClient("Tixati", "TIX");
        BTPeerIDByteDecoderDefinitions.addVersionedClient(client, VER_TWOBYTE_BLOCK_DOTTED_CHAR, 4);
        client = BTPeerIDByteDecoderDefinitions.addSimpleClient("folx", "-FL");
        BTPeerIDByteDecoderDefinitions.addVersionedClient(client, VER_BYTE_BLOCK_DOTTED_CHAR, 2);
        client = BTPeerIDByteDecoderDefinitions.addSimpleClient("\u00b5Torrent Mac", "-UM");
        BTPeerIDByteDecoderDefinitions.addVersionedClient(client, VER_BYTE_UM_STYLE, 4);
        client = BTPeerIDByteDecoderDefinitions.addSimpleClient("\u00b5Torrent", "-UT");
        BTPeerIDByteDecoderDefinitions.addVersionedClient(client, VER_BYTE_BLOCK_DOTTED_CHAR, 3);
        client = BTPeerIDByteDecoderDefinitions.addSimpleClient("BitTorrent", "-BT");
        BTPeerIDByteDecoderDefinitions.addVersionedClient(client, VER_BYTE_BLOCK_DOTTED_CHAR, 3);
        client = BTPeerIDByteDecoderDefinitions.addSimpleClient("BitLord", "-BL");
        BTPeerIDByteDecoderDefinitions.addVersionedClient(client, VER_BITLORD, 6, 3);
    }

    private static void addAzStyle(String id, String client) {
        BTPeerIDByteDecoderDefinitions.addAzStyle(id, client, VER_AZ_FOUR_DIGITS);
    }

    private static void addAzStyle(String id, String client, String version_style) {
        if (id.length() != 2) {
            throw new RuntimeException("not two chars long - " + id);
        }
        az_style_code_map.put(id, client);
        az_client_version_map.put(client, version_style);
    }

    private static void addShadowStyle(char id, String client) {
        BTPeerIDByteDecoderDefinitions.addShadowStyle(id, client, VER_AZ_THREE_DIGITS);
    }

    private static void addShadowStyle(char id, String client, String version_style) {
        shadow_style_code_map.put("" + id, client);
        shadow_client_version_map.put(client, version_style);
    }

    private static void addMainlineStyle(char id, String client) {
        mainline_style_code_map.put("" + id, client);
    }

    private static ClientData addSimpleClient(String client_name, String identifier) {
        return BTPeerIDByteDecoderDefinitions.addSimpleClient(client_name, identifier, 0);
    }

    private static ClientData addSimpleClient(String client_name, String identifier, int position) {
        ClientData result = new ClientData(client_name, identifier, position);
        custom_style_client_list.add(result);
        return result;
    }

    private static void addVersionedClient(ClientData client, String version_type, int length) {
        BTPeerIDByteDecoderDefinitions.addVersionedClient(client, version_type, length, null);
    }

    private static void addVersionedClient(ClientData client, String version_type, int length, String format) {
        BTPeerIDByteDecoderDefinitions.addVersionedClient(client, version_type, length, format, client.simple_string.length() + client.simple_string_pos);
    }

    private static void addVersionedClient(ClientData client, String version_type, int length, int version_pos) {
        BTPeerIDByteDecoderDefinitions.addVersionedClient(client, version_type, length, null, version_pos);
    }

    private static void addVersionedClient(ClientData client, String version_type, int length, String format, int version_pos) {
        client.version_data = new VersionNumberData(version_type, length, format, version_pos);
    }

    public static String getAzStyleClientName(String peer_id) {
        return (String)az_style_code_map.get(peer_id.substring(1, 3));
    }

    public static String getShadowStyleClientName(String peer_id) {
        return (String)shadow_style_code_map.get(peer_id.substring(0, 1));
    }

    public static String getMainlineStyleClientName(String peer_id) {
        return (String)mainline_style_code_map.get(peer_id.substring(0, 1));
    }

    public static String getAzStyleClientVersion(String client_name, String peer_id) {
        String version_scheme = (String)az_client_version_map.get(client_name);
        if (version_scheme == NO_VERSION) {
            return null;
        }
        try {
            return String.valueOf(client_name) + " " + BTPeerIDByteDecoderUtils.decodeAzStyleVersionNumber(peer_id.substring(3, 7), version_scheme);
        }
        catch (Exception e) {
            BTPeerIDByteDecoder.logUnknownClient(peer_id);
            return null;
        }
    }

    public static ClientData getSubstringStyleClient(String peer_id) {
        ClientData cd = null;
        int i = 0;
        while (i < custom_style_client_list.size()) {
            cd = (ClientData)custom_style_client_list.get(i);
            if (peer_id.startsWith(cd.simple_string, cd.simple_string_pos)) {
                return cd;
            }
            ++i;
        }
        return null;
    }

    public static String getSubstringStyleClientVersion(ClientData client_data, String peer_id, byte[] peer_id_bytes) {
        VersionNumberData verdata = client_data.version_data;
        if (verdata == null) {
            return null;
        }
        String version_scheme = verdata.type;
        String version_string = null;
        try {
            if (version_scheme == VER_TWO_BYTE_THREE_PART) {
                int start_byte_index = verdata.pos;
                version_string = BTPeerIDByteDecoderUtils.getTwoByteThreePartVersion(peer_id_bytes[start_byte_index], peer_id_bytes[start_byte_index + 1]);
            } else {
                version_string = version_scheme == VER_BLOCK && verdata.length == -1 ? BTPeerIDByteDecoderUtils.extractReadableVersionSubstringFromPeerID(peer_id.substring(verdata.pos, peer_id.length())) : BTPeerIDByteDecoderUtils.decodeCustomVersionNumber(peer_id.substring(verdata.pos, verdata.pos + verdata.length), version_scheme);
            }
            if (verdata.fmt == null) {
                return String.valueOf(client_data.client_name) + " " + version_string;
            }
            return String.valueOf(client_data.client_name) + verdata.fmt.replaceFirst("%s", version_string);
        }
        catch (Exception e) {
            BTPeerIDByteDecoder.logUnknownClient(peer_id);
            return null;
        }
    }

    public static String formatUnknownAzStyleClient(String peer_id) {
        String version_string = peer_id.substring(3, 7);
        try {
            version_string = BTPeerIDByteDecoderUtils.decodeAzStyleVersionNumber(version_string, VER_AZ_FOUR_DIGITS);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return MessageText.getString("PeerSocket.unknown_az_style", new String[]{peer_id.substring(1, 3), version_string});
    }

    public static String formatUnknownShadowStyleClient(String peer_id) {
        String version_string = BTPeerIDByteDecoderUtils.getShadowStyleVersionNumber(peer_id);
        return MessageText.getString("PeerSocket.unknown_shadow_style", new String[]{peer_id.substring(0, 1), version_string});
    }

    static class ClientData {
        final String client_name;
        private final int simple_string_pos;
        private final String simple_string;
        private VersionNumberData version_data;

        ClientData(String client_name, String simple_string, int simple_string_pos) {
            this.simple_string_pos = simple_string_pos;
            this.simple_string = simple_string;
            this.client_name = client_name;
            this.version_data = null;
        }
    }

    static class VersionNumberData {
        final String type;
        final int pos;
        final String fmt;
        final int length;

        VersionNumberData(String type, int length, String formatter, int position) {
            this.type = type;
            this.pos = position;
            this.fmt = formatter;
            this.length = length;
        }
    }
}

