/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.peerdb;

import com.aelitis.azureus.core.peermanager.peerdb.PeerExchangerItem;
import com.aelitis.azureus.core.peermanager.peerdb.PeerItem;
import com.aelitis.azureus.core.util.bloom.BloomFilter;
import com.aelitis.azureus.core.util.bloom.BloomFilterFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.gudy.azureus2.core3.peer.util.PeerUtils;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.SystemTime;

public class PeerDatabase {
    private static final int STARTUP_MIN_REBUILD_WAIT_TIME = 10000;
    private static final int STARTUP_MILLIS = 120000;
    private static final int MIN_REBUILD_WAIT_TIME = 60000;
    private static final int MAX_DISCOVERED_PEERS = 500;
    private static final int BLOOM_ROTATION_PERIOD = 420000;
    private static final int BLOOM_FILTER_SIZE = 10000;
    private final long start_time = SystemTime.getMonotonousTime();
    private final HashMap peer_connections = new HashMap();
    private final TreeSet<PeerItem> discovered_peers = new TreeSet<PeerItem>(new Comparator<PeerItem>(){

        @Override
        public int compare(PeerItem o1, PeerItem o2) {
            long res = o2.getPriority() - o1.getPriority();
            if (res == 0L) {
                res = o1.compareTo(o2);
            }
            return res < 0L ? -1 : (res > 0L ? 1 : 0);
        }
    });
    private final TreeSet<PeerItem> discovered_peers_non_pub = new TreeSet<PeerItem>(new Comparator<PeerItem>(){

        @Override
        public int compare(PeerItem o1, PeerItem o2) {
            long res = o2.getPriority() - o1.getPriority();
            if (res == 0L) {
                res = o1.compareTo(o2);
            }
            return res < 0L ? -1 : (res > 0L ? 1 : 0);
        }
    });
    private final AEMonitor map_mon = new AEMonitor("PeerDatabase");
    private PeerItem[] cached_peer_popularities = null;
    private int popularity_pos = 0;
    private int popularity_pos_non_pub = 0;
    private long last_rebuild_time = Integer.MIN_VALUE;
    private long last_rotation_time = Integer.MIN_VALUE;
    private PeerItem self_peer;
    private BloomFilter filter_one = null;
    private BloomFilter filter_two = BloomFilterFactory.createAddOnly(10000);
    private long pex_count_last_time;
    private int pex_count_last;
    private int pex_used_count;
    private int total_peers_returned;

    protected PeerDatabase() {
    }

    public PeerExchangerItem registerPeerConnection(PeerItem base_peer_item, PeerExchangerItem.Helper helper) {
        try {
            this.map_mon.enter();
            PeerExchangerItem new_connection = new PeerExchangerItem(this, base_peer_item, helper);
            for (Map.Entry entry : this.peer_connections.entrySet()) {
                PeerItem old_key = (PeerItem)entry.getKey();
                PeerExchangerItem old_connection = (PeerExchangerItem)entry.getValue();
                if (old_connection.getHelper().isSeed() && new_connection.getHelper().isSeed()) continue;
                old_connection.notifyAdded(base_peer_item);
                new_connection.notifyAdded(old_key);
            }
            this.peer_connections.put(base_peer_item, new_connection);
            PeerExchangerItem peerExchangerItem = new_connection;
            return peerExchangerItem;
        }
        finally {
            this.map_mon.exit();
        }
    }

    protected void deregisterPeerConnection(PeerItem base_peer_key) {
        try {
            this.map_mon.enter();
            this.peer_connections.remove(base_peer_key);
            for (PeerExchangerItem old_connection : this.peer_connections.values()) {
                old_connection.notifyDropped(base_peer_key);
            }
        }
        finally {
            this.map_mon.exit();
        }
    }

    public void seedStatusChanged(PeerExchangerItem item) {
        if (item.getHelper().isSeed()) {
            try {
                this.map_mon.enter();
                for (PeerExchangerItem connection : this.peer_connections.values()) {
                    if (connection == item || !connection.getHelper().isSeed()) continue;
                    connection.notifyDropped(item.getBasePeer());
                    item.notifyDropped(connection.getBasePeer());
                }
            }
            finally {
                this.map_mon.exit();
            }
        }
    }

    public void addDiscoveredPeer(PeerItem peer) {
        try {
            this.map_mon.enter();
            for (PeerExchangerItem connection : this.peer_connections.values()) {
                if (!connection.isConnectedToPeer(peer)) continue;
                return;
            }
            if (!this.discovered_peers.contains(peer)) {
                Iterator<PeerItem> it;
                this.discovered_peers.add(peer);
                int max_cache_size = PeerUtils.MAX_CONNECTIONS_PER_TORRENT * 2;
                if (max_cache_size < 1 || max_cache_size > 500) {
                    max_cache_size = 500;
                }
                while (this.discovered_peers.size() > max_cache_size) {
                    it = this.discovered_peers.iterator();
                    it.next();
                    it.remove();
                }
                if (peer.getNetwork() != "Public") {
                    this.discovered_peers_non_pub.add(peer);
                    while (this.discovered_peers_non_pub.size() > max_cache_size) {
                        it = this.discovered_peers_non_pub.iterator();
                        it.next();
                        it.remove();
                    }
                }
            }
        }
        finally {
            this.map_mon.exit();
        }
    }

    public void setSelfPeer(PeerItem self) {
        this.self_peer = self;
    }

    public PeerItem getSelfPeer() {
        return this.self_peer;
    }

    public PeerItem[] getDiscoveredPeers() {
        try {
            this.map_mon.enter();
            PeerItem[] peerItemArray = this.discovered_peers.toArray(new PeerItem[this.discovered_peers.size()]);
            return peerItemArray;
        }
        finally {
            this.map_mon.exit();
        }
    }

    public PeerItem[] getDiscoveredPeers(String address) {
        ArrayList<PeerItem> result = null;
        try {
            this.map_mon.enter();
            for (PeerItem peer : this.discovered_peers) {
                if (!peer.getIP().equals(address)) continue;
                if (result == null) {
                    result = new ArrayList<PeerItem>();
                }
                result.add(peer);
            }
        }
        finally {
            this.map_mon.exit();
        }
        if (result == null) {
            return new PeerItem[0];
        }
        return result.toArray(new PeerItem[result.size()]);
    }

    public int getDiscoveredPeerCount() {
        try {
            this.map_mon.enter();
            int n = this.discovered_peers.size();
            return n;
        }
        finally {
            this.map_mon.exit();
        }
    }

    public PeerItem getNextOptimisticConnectPeer(boolean non_public) {
        PeerItem item = this.getNextOptimisticConnectPeer(non_public, 0);
        return item;
    }

    private PeerItem getNextOptimisticConnectPeer(boolean non_public, int recursion_count) {
        long now = SystemTime.getMonotonousTime();
        boolean starting_up = now - this.start_time <= 120000L;
        PeerItem peer = null;
        boolean discovered_peer = false;
        boolean tried_pex = false;
        if (starting_up && this.total_peers_returned % 5 == 0) {
            peer = this.getPeerFromPEX(now, starting_up, non_public);
            tried_pex = true;
        }
        if (peer == null) {
            try {
                this.map_mon.enter();
                if (!this.discovered_peers.isEmpty()) {
                    Iterator<PeerItem> it;
                    if (non_public) {
                        if (!this.discovered_peers_non_pub.isEmpty()) {
                            it = this.discovered_peers_non_pub.iterator();
                            peer = it.next();
                            it.remove();
                            discovered_peer = true;
                            this.discovered_peers.remove(peer);
                        }
                    } else {
                        it = this.discovered_peers.iterator();
                        peer = it.next();
                        it.remove();
                        discovered_peer = true;
                        if (peer.getNetwork() != "Public") {
                            this.discovered_peers_non_pub.remove(peer);
                        }
                    }
                }
            }
            finally {
                this.map_mon.exit();
            }
        }
        if (peer == null && !tried_pex) {
            peer = this.getPeerFromPEX(now, starting_up, non_public);
        }
        if (peer != null) {
            PeerItem next_peer;
            long diff = now - this.last_rotation_time;
            if (diff > 420000L) {
                this.filter_one = this.filter_two;
                this.filter_two = BloomFilterFactory.createAddOnly(10000);
                this.last_rotation_time = now;
            }
            boolean already_recorded = false;
            byte[] peer_serialisation = peer.getSerialization();
            if (this.filter_one.contains(peer_serialisation) && recursion_count < 100 && (next_peer = this.getNextOptimisticConnectPeer(non_public, recursion_count + 1)) != null) {
                if (discovered_peer) {
                    try {
                        this.map_mon.enter();
                        this.discovered_peers.add(peer);
                        if (peer.getNetwork() != "Public") {
                            this.discovered_peers_non_pub.add(peer);
                        }
                    }
                    finally {
                        this.map_mon.exit();
                    }
                }
                peer = next_peer;
                already_recorded = true;
            }
            if (!already_recorded) {
                this.filter_one.add(peer_serialisation);
                this.filter_two.add(peer_serialisation);
            }
        }
        if (recursion_count == 0 && peer != null) {
            ++this.total_peers_returned;
        }
        return peer;
    }

    private PeerItem getPeerFromPEX(long now, boolean starting_up, boolean non_public) {
        PeerItem peer;
        if (this.cached_peer_popularities == null || this.popularity_pos == this.cached_peer_popularities.length) {
            this.cached_peer_popularities = null;
            long time_since_rebuild = now - this.last_rebuild_time;
            if (time_since_rebuild > (long)(starting_up ? 10000 : 60000)) {
                this.cached_peer_popularities = this.getExchangedPeersSortedByLeastPopularFirst();
                this.popularity_pos = 0;
                this.popularity_pos_non_pub = 0;
                this.last_rebuild_time = now;
            }
        }
        if (this.cached_peer_popularities != null && this.cached_peer_popularities.length > 0) {
            if (non_public) {
                peer = null;
                while (this.popularity_pos_non_pub < this.cached_peer_popularities.length) {
                    PeerItem temp = this.cached_peer_popularities[this.popularity_pos_non_pub];
                    ++this.popularity_pos_non_pub;
                    if (temp.getNetwork() == "Public") continue;
                    peer = temp;
                    break;
                }
            } else {
                peer = this.cached_peer_popularities[this.popularity_pos];
                ++this.popularity_pos;
                if (peer.getNetwork() != "Public") {
                    this.popularity_pos_non_pub = this.popularity_pos;
                }
                ++this.pex_used_count;
                this.last_rebuild_time = now;
            }
        } else {
            peer = null;
        }
        return peer;
    }

    public int getExchangedPeerCount() {
        long now = SystemTime.getMonotonousTime();
        if (now - this.pex_count_last_time >= 10000L) {
            PeerItem[] peers = this.getExchangedPeersSortedByLeastPopularFirst();
            this.pex_count_last = peers == null ? 0 : peers.length;
            this.pex_count_last_time = now;
        }
        return Math.max(0, this.pex_count_last - this.popularity_pos);
    }

    public int getExchangedPeersUsed() {
        return this.pex_used_count;
    }

    private PeerItem[] getExchangedPeersSortedByLeastPopularFirst() {
        HashMap<PeerItem, Integer> popularity_counts = new HashMap<PeerItem, Integer>();
        try {
            this.map_mon.enter();
            for (PeerExchangerItem connection : this.peer_connections.values()) {
                PeerItem[] peers = connection.getConnectedPeers();
                int i = 0;
                while (i < peers.length) {
                    PeerItem peer = peers[i];
                    Integer count = (Integer)popularity_counts.get(peer);
                    count = count == null ? new Integer(1) : new Integer(count + 1);
                    popularity_counts.put(peer, count);
                    ++i;
                }
            }
        }
        finally {
            this.map_mon.exit();
        }
        if (popularity_counts.isEmpty()) {
            return null;
        }
        Map.Entry[] sorted_entries = new Map.Entry[popularity_counts.size()];
        popularity_counts.entrySet().toArray(sorted_entries);
        Arrays.sort(sorted_entries, new Comparator(){

            public int compare(Object obj1, Object obj2) {
                Map.Entry en1 = (Map.Entry)obj1;
                Map.Entry en2 = (Map.Entry)obj2;
                return ((Integer)en1.getValue()).compareTo((Integer)en2.getValue());
            }
        });
        PeerItem[] sorted_peers = new PeerItem[sorted_entries.length];
        int i = 0;
        while (i < sorted_entries.length) {
            Map.Entry entry = sorted_entries[i];
            sorted_peers[i] = (PeerItem)entry.getKey();
            ++i;
        }
        return sorted_peers;
    }

    public String getString() {
        return "pc=" + this.peer_connections.size() + ",dp=" + this.discovered_peers.size() + "/" + this.discovered_peers_non_pub.size();
    }
}

