/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.messaging.bittorrent.ltep;

import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.MessageException;
import com.aelitis.azureus.core.peermanager.messaging.MessageManager;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTMessageDecoder;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.ltep.LTMessage;
import com.aelitis.azureus.core.util.CopyOnWriteMap;
import org.gudy.azureus2.core3.util.DirectByteBuffer;

public class LTMessageDecoder
extends BTMessageDecoder {
    private static final CopyOnWriteMap<Byte, byte[]> default_entension_handlers = new CopyOnWriteMap();
    private final CopyOnWriteMap<Byte, byte[]> extension_handlers = new CopyOnWriteMap();

    public static void addDefaultExtensionHandler(long id, byte[] message_id) {
        default_entension_handlers.put((byte)id, message_id);
    }

    public static void removeDefaultExtensionHandler(long id) {
        default_entension_handlers.remove((byte)id);
    }

    public LTMessageDecoder() {
        if (default_entension_handlers.size() > 0) {
            this.extension_handlers.putAll(default_entension_handlers);
        }
    }

    @Override
    protected Message createMessage(DirectByteBuffer ref_buff) throws MessageException {
        int old_position = ref_buff.position((byte)11);
        byte id = ref_buff.get((byte)11);
        if (id != 20) {
            ref_buff.position((byte)11, old_position);
            return super.createMessage(ref_buff);
        }
        id = ref_buff.get((byte)11);
        switch (id) {
            case 0: {
                return MessageManager.getSingleton().createMessage(LTMessage.ID_LT_HANDSHAKE_BYTES, ref_buff, (byte)1);
            }
            case 1: {
                return MessageManager.getSingleton().createMessage(LTMessage.ID_UT_PEX_BYTES, ref_buff, (byte)1);
            }
            case 3: {
                return MessageManager.getSingleton().createMessage(LTMessage.ID_UT_METADATA_BYTES, ref_buff, (byte)1);
            }
            case 4: {
                return MessageManager.getSingleton().createMessage(LTMessage.ID_UT_UPLOAD_ONLY_BYTES, ref_buff, (byte)1);
            }
        }
        byte[] message_id = this.extension_handlers.get(id);
        if (message_id != null) {
            return MessageManager.getSingleton().createMessage(message_id, ref_buff, (byte)1);
        }
        System.out.println("Unknown LTEP message id [" + id + "]");
        throw new MessageException("Unknown LTEP message id [" + id + "]");
    }

    public void addExtensionHandler(byte id, byte[] message_id) {
        this.extension_handlers.put(id, message_id);
    }

    public void removeExtensionHandler(byte id) {
        this.extension_handlers.remove(id);
    }
}

