/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.messaging.azureus;

import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.MessageException;
import com.aelitis.azureus.core.peermanager.messaging.MessagingUtil;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZMessage;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.util.DirectByteBuffer;

public class AZBadPiece
implements AZMessage {
    private final byte version;
    private DirectByteBuffer buffer = null;
    private final int piece_number;

    public AZBadPiece(int _piece_number, byte _version) {
        this.piece_number = _piece_number;
        this.version = _version;
    }

    @Override
    public String getID() {
        return "AZ_BAD_PIECE";
    }

    @Override
    public byte[] getIDBytes() {
        return AZMessage.ID_AZ_BAD_PIECE_BYTES;
    }

    @Override
    public String getFeatureID() {
        return "AZ1";
    }

    @Override
    public int getFeatureSubID() {
        return 5;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public byte getVersion() {
        return this.version;
    }

    @Override
    public String getDescription() {
        return String.valueOf(this.getID()) + " " + this.piece_number;
    }

    public int getPieceNumber() {
        return this.piece_number;
    }

    @Override
    public DirectByteBuffer[] getData() {
        if (this.buffer == null) {
            HashMap<String, Long> map = new HashMap<String, Long>();
            map.put("piece", new Long(this.piece_number));
            this.buffer = MessagingUtil.convertPayloadToBencodedByteStream(map, (byte)12);
        }
        return new DirectByteBuffer[]{this.buffer};
    }

    @Override
    public Message deserialize(DirectByteBuffer data, byte version) throws MessageException {
        Map payload = MessagingUtil.convertBencodedByteStreamToPayload(data, 1, this.getID());
        int piece_number = ((Long)payload.get("piece")).intValue();
        AZBadPiece message = new AZBadPiece(piece_number, version);
        return message;
    }

    @Override
    public void destroy() {
        if (this.buffer != null) {
            this.buffer.returnToPool();
        }
    }
}

