/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.control.impl;

import com.aelitis.azureus.core.peermanager.control.PeerControlInstance;
import com.aelitis.azureus.core.peermanager.control.SpeedTokenDispenser;
import com.aelitis.azureus.core.peermanager.control.impl.PeerControlSchedulerImpl;
import com.aelitis.azureus.core.peermanager.control.impl.SpeedTokenDispenserPrioritised;
import com.aelitis.azureus.core.stats.AzureusCoreStatsProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class PeerControlSchedulerPrioritised
extends PeerControlSchedulerImpl
implements AzureusCoreStatsProvider {
    private Map instance_map = new HashMap();
    final List pending_registrations = new ArrayList();
    private volatile boolean registrations_changed;
    private volatile long latest_time;
    protected final AEMonitor this_mon = new AEMonitor("PeerControlSchedulerPrioritised");
    private final SpeedTokenDispenserPrioritised tokenDispenser = new SpeedTokenDispenserPrioritised();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void schedule() {
        this.latest_time = SystemTime.getMonotonousTime();
        SystemTime.registerMonotonousConsumer(new SystemTime.TickConsumer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void consume(long time) {
                PeerControlSchedulerPrioritised peerControlSchedulerPrioritised = PeerControlSchedulerPrioritised.this;
                synchronized (peerControlSchedulerPrioritised) {
                    PeerControlSchedulerPrioritised.this.latest_time = time;
                    if (PeerControlSchedulerPrioritised.this.instance_map.size() > 0 || PeerControlSchedulerPrioritised.this.pending_registrations.size() > 0) {
                        PeerControlSchedulerPrioritised.this.notify();
                    }
                }
            }
        });
        ArrayList instances = new ArrayList();
        long latest_time_used = 0L;
        int scheduledNext = 0;
        long currentScheduleStart = this.latest_time;
        long last_stats_time = this.latest_time;
        while (true) {
            if (this.registrations_changed) {
                try {
                    this.this_mon.enter();
                    Iterator it = instances.iterator();
                    while (it.hasNext()) {
                        if (!((instanceWrapper)it.next()).isUnregistered()) continue;
                        it.remove();
                    }
                    int i = 0;
                    while (i < this.pending_registrations.size()) {
                        instances.add(this.pending_registrations.get(i));
                        ++i;
                    }
                    this.pending_registrations.clear();
                    Collections.sort(instances);
                    if (instances.size() > 0) {
                        i = 0;
                        while (i < instances.size()) {
                            ((instanceWrapper)instances.get(i)).setScheduleOffset(SCHEDULE_PERIOD_MILLIS * i / instances.size());
                            ++i;
                        }
                    }
                    scheduledNext = 0;
                    currentScheduleStart = this.latest_time;
                    this.registrations_changed = false;
                }
                finally {
                    this.this_mon.exit();
                }
            }
            this.tokenDispenser.update(this.latest_time);
            int i22 = scheduledNext;
            while (i22 < instances.size()) {
                instanceWrapper inst = (instanceWrapper)instances.get(i22);
                if (currentScheduleStart + inst.getScheduleOffset() > latest_time_used) break;
                if (i22 == 0 || !this.useWeights) {
                    this.tokenDispenser.refill();
                }
                inst.schedule();
                ++this.schedule_count;
                if (++scheduledNext >= instances.size()) {
                    scheduledNext = 0;
                    if (latest_time_used - (currentScheduleStart += (long)SCHEDULE_PERIOD_MILLIS) > (long)SCHEDULE_PERIOD_MAX_CATCHUP) {
                        currentScheduleStart = latest_time_used + (long)SCHEDULE_PERIOD_MILLIS;
                    }
                }
                ++i22;
            }
            PeerControlSchedulerPrioritised i22 = this;
            synchronized (i22) {
                if (this.latest_time == latest_time_used) {
                    ++this.wait_count;
                    try {
                        long wait_start = SystemTime.getHighPrecisionCounter();
                        this.wait(5000L);
                        long wait_time = SystemTime.getHighPrecisionCounter() - wait_start;
                        this.total_wait_time += wait_time;
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                } else {
                    ++this.yield_count;
                    Thread.yield();
                }
                latest_time_used = this.latest_time;
            }
            long stats_diff = latest_time_used - last_stats_time;
            if (stats_diff <= 10000L) continue;
            last_stats_time = latest_time_used;
        }
    }

    @Override
    public void register(PeerControlInstance instance) {
        instanceWrapper wrapper2 = new instanceWrapper(instance);
        try {
            this.this_mon.enter();
            HashMap<PeerControlInstance, instanceWrapper> new_map = new HashMap<PeerControlInstance, instanceWrapper>(this.instance_map);
            new_map.put(instance, wrapper2);
            this.instance_map = new_map;
            this.pending_registrations.add(wrapper2);
            this.registrations_changed = true;
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void unregister(PeerControlInstance instance) {
        try {
            this.this_mon.enter();
            HashMap new_map = new HashMap(this.instance_map);
            instanceWrapper wrapper2 = (instanceWrapper)new_map.remove(instance);
            if (wrapper2 == null) {
                Debug.out("instance wrapper not found");
                return;
            }
            wrapper2.unregister();
            this.instance_map = new_map;
            this.registrations_changed = true;
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public SpeedTokenDispenser getSpeedTokenDispenser() {
        return this.tokenDispenser;
    }

    @Override
    public void updateScheduleOrdering() {
        this.registrations_changed = true;
    }

    protected static class instanceWrapper
    implements Comparable {
        private final PeerControlInstance instance;
        private boolean unregistered;
        private long offset;

        protected instanceWrapper(PeerControlInstance _instance) {
            this.instance = _instance;
        }

        protected void unregister() {
            this.unregistered = true;
        }

        protected boolean isUnregistered() {
            return this.unregistered;
        }

        protected void setScheduleOffset(long t) {
            this.offset = t;
        }

        protected long getScheduleOffset() {
            return this.offset;
        }

        protected PeerControlInstance getInstance() {
            return this.instance;
        }

        protected void schedule() {
            try {
                this.instance.schedule();
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }

        public int compareTo(Object o) {
            return this.instance.getSchedulePriority() - ((instanceWrapper)o).instance.getSchedulePriority();
        }
    }
}

