/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.utp;

import com.aelitis.azureus.core.networkmanager.NetworkConnection;
import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.Transport;
import com.aelitis.azureus.core.networkmanager.TransportEndpoint;
import com.aelitis.azureus.core.networkmanager.impl.ProtocolDecoder;
import com.aelitis.azureus.core.networkmanager.impl.TransportCryptoManager;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelperFilter;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelperFilterTransparent;
import com.aelitis.azureus.core.networkmanager.impl.TransportImpl;
import com.aelitis.azureus.core.networkmanager.impl.utp.ProtocolEndpointUTP;
import com.aelitis.azureus.core.networkmanager.impl.utp.TransportEndpointUTP;
import com.aelitis.azureus.core.networkmanager.impl.utp.UTPConnectionManager;
import com.aelitis.azureus.core.networkmanager.impl.utp.UTPNetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.utp.UTPTransportHelper;
import java.nio.ByteBuffer;
import java.util.List;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.impl.PEPeerControl;
import org.gudy.azureus2.core3.util.AEGenericCallback;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.Debug;

public class UTPTransport
extends TransportImpl {
    private static final LogIDs LOGID = LogIDs.NET;
    private static AsyncDispatcher dispatcher = new AsyncDispatcher("utp:condisp");
    private UTPConnectionManager manager;
    private ProtocolEndpointUTP endpoint;
    private boolean connect_with_crypto;
    private boolean fallback_allowed;
    private byte[][] shared_secrets;
    private int fallback_count;
    private int transport_mode = 0;
    private boolean connected;
    private boolean cp_pending;
    private ByteBuffer cp_initial_data;
    private Transport.ConnectListener cp_listener;
    private volatile boolean closed;

    protected UTPTransport(UTPConnectionManager _manager, ProtocolEndpointUTP _endpoint, boolean _use_crypto, boolean _allow_fallback, byte[][] _shared_secrets) {
        this.manager = _manager;
        this.endpoint = _endpoint;
        this.connect_with_crypto = _use_crypto;
        this.shared_secrets = _shared_secrets;
        this.fallback_allowed = _allow_fallback;
    }

    protected UTPTransport(UTPConnectionManager _manager, ProtocolEndpointUTP _endpoint, TransportHelperFilter _filter) {
        this.manager = _manager;
        this.endpoint = _endpoint;
        this.setFilter(_filter);
    }

    @Override
    public boolean isTCP() {
        return false;
    }

    @Override
    public String getProtocol() {
        return "uTP";
    }

    @Override
    public TransportEndpoint getTransportEndpoint() {
        return new TransportEndpointUTP(this.endpoint);
    }

    @Override
    public int getMssSize() {
        return UTPNetworkManager.getUdpMssSize();
    }

    @Override
    public String getDescription() {
        return this.endpoint.getAddress().toString();
    }

    @Override
    public void setTransportMode(int mode) {
        this.transport_mode = mode;
    }

    @Override
    public int getTransportMode() {
        return this.transport_mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectOutbound(final ByteBuffer initial_data, final Transport.ConnectListener listener, final int priority) {
        block13: {
            if (this.closed) {
                listener.connectFailure(new Throwable("Connection already closed"));
                return;
            }
            if (this.getFilter() != null) {
                listener.connectFailure(new Throwable("Already connected"));
                return;
            }
            if (COConfigurationManager.getBooleanParameter("Proxy.Data.Enable")) {
                listener.connectFailure(new Throwable("uTP proxy connection not supported"));
                return;
            }
            int time = listener.connectAttemptStarted(-1);
            if (time != -1) {
                Debug.out("uTP connect time override not supported");
            }
            UTPTransportHelper helper = null;
            try {
                final UTPTransportHelper f_helper = helper = new UTPTransportHelper(this.manager, this.endpoint.getAddress(), this);
                if (this.connect_with_crypto) {
                    TransportCryptoManager.getSingleton().manageCrypto(helper, this.shared_secrets, false, initial_data, new TransportCryptoManager.HandshakeListener(){

                        @Override
                        public void handshakeSuccess(ProtocolDecoder decoder, ByteBuffer remaining_initial_data) {
                            TransportHelperFilter filter2 = decoder.getFilter();
                            UTPTransport.this.setFilter(filter2);
                            UTPTransport.this.connectedOutbound(remaining_initial_data, listener);
                        }

                        @Override
                        public void handshakeFailure(Throwable failure_msg) {
                            if (UTPTransport.this.fallback_allowed && NetworkManager.OUTGOING_HANDSHAKE_FALLBACK_ALLOWED && !UTPTransport.this.closed) {
                                if (Logger.isEnabled()) {
                                    Logger.log(new LogEvent(LOGID, "crypto handshake failure [" + failure_msg.getMessage() + "], attempting non-crypto fallback."));
                                }
                                UTPTransport uTPTransport = UTPTransport.this;
                                uTPTransport.fallback_count = uTPTransport.fallback_count + 1;
                                UTPTransport.this.connect_with_crypto = false;
                                UTPTransport.this.close(f_helper, "Handshake failure and retry");
                                UTPTransport.this.closed = false;
                                if (initial_data != null) {
                                    initial_data.position(0);
                                }
                                UTPTransport.this.connectOutbound(initial_data, listener, priority);
                            } else {
                                UTPTransport.this.close(f_helper, "Handshake failure");
                                listener.connectFailure(failure_msg);
                            }
                        }

                        @Override
                        public void gotSecret(byte[] session_secret) {
                        }

                        @Override
                        public int getMaximumPlainHeaderLength() {
                            throw new RuntimeException();
                        }

                        @Override
                        public int matchPlainHeader(ByteBuffer buffer) {
                            throw new RuntimeException();
                        }
                    });
                    break block13;
                }
                this.setFilter(new TransportHelperFilterTransparent(helper, false));
                boolean already_connected = true;
                UTPTransport uTPTransport = this;
                synchronized (uTPTransport) {
                    already_connected = this.connected;
                    if (!already_connected) {
                        this.cp_pending = true;
                        this.cp_initial_data = initial_data;
                        this.cp_listener = listener;
                    }
                }
                if (already_connected) {
                    this.connectedOutbound(initial_data, listener);
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                if (helper != null) {
                    helper.close(Debug.getNestedExceptionMessage(e));
                }
                listener.connectFailure(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connected() {
        Transport.ConnectListener listener;
        ByteBuffer initial_data;
        UTPTransport uTPTransport = this;
        synchronized (uTPTransport) {
            this.connected = true;
            if (!this.cp_pending) {
                return;
            }
            initial_data = this.cp_initial_data;
            listener = this.cp_listener;
            this.cp_pending = false;
            this.cp_initial_data = null;
            this.cp_listener = null;
        }
        dispatcher.dispatch(new AERunnable(){

            @Override
            public void runSupport() {
                UTPTransport.this.connectedOutbound(initial_data, listener);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closed() {
        Transport.ConnectListener listener;
        UTPTransport uTPTransport = this;
        synchronized (uTPTransport) {
            if (!this.cp_pending) {
                return;
            }
            this.cp_pending = false;
            listener = this.cp_listener;
            this.cp_listener = null;
        }
        if (listener != null) {
            dispatcher.dispatch(new AERunnable(){

                @Override
                public void runSupport() {
                    listener.connectFailure(new Throwable("Connection closed"));
                }
            });
        }
    }

    protected void connectedOutbound(ByteBuffer remaining_initial_data, Transport.ConnectListener listener) {
        TransportHelperFilter filter2 = this.getFilter();
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "Outgoing uTP stream to " + this.endpoint.getAddress() + " established, type = " + (filter2 == null ? "<unknown>" : filter2.getName(false))));
        }
        if (this.closed) {
            if (filter2 != null) {
                filter2.getHelper().close("Connection closed");
                this.setFilter(null);
            }
            listener.connectFailure(new Throwable("Connection closed"));
        } else {
            this.connectedOutbound();
            listener.connectSuccess(this, remaining_initial_data);
        }
    }

    private void close(UTPTransportHelper helper, String reason) {
        helper.close(reason);
        this.close(reason);
    }

    @Override
    public void close(String reason) {
        this.closed = true;
        this.readyForRead(false);
        this.readyForWrite(false);
        TransportHelperFilter filter2 = this.getFilter();
        if (filter2 != null) {
            filter2.getHelper().close(reason);
            this.setFilter(null);
        }
        this.closed();
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void bindConnection(NetworkConnection connection) {
        if (this.manager.preferUTP()) {
            Object[] existing;
            existing = new Object[]{connection.setUserData("RoutedCallback", new AEGenericCallback(){

                @Override
                public Object invoke(Object arg) {
                    try {
                        PEPeerControl control = (PEPeerControl)arg;
                        List<PEPeer> peers = control.getPeers(UTPTransport.this.endpoint.getAddress().getAddress().getHostAddress());
                        for (PEPeer peer : peers) {
                            if (peer.isIncoming() || peer.getTCPListenPort() != UTPTransport.this.endpoint.getAddress().getPort()) continue;
                            UTPTransport.this.manager.log("Overriding existing connection to " + UTPTransport.this.endpoint.getAddress());
                            control.removePeer(peer, "Replacing outgoing with incoming uTP connection");
                        }
                        return null;
                    }
                    finally {
                        if (existing[0] instanceof AEGenericCallback) {
                            ((AEGenericCallback)existing[0]).invoke(arg);
                        }
                    }
                }
            })};
        }
    }
}

