/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.LimitedRateGroup;
import com.aelitis.azureus.core.networkmanager.NetworkConnectionBase;
import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.RateHandler;
import com.aelitis.azureus.core.networkmanager.impl.ByteBucket;
import com.aelitis.azureus.core.networkmanager.impl.ByteBucketMT;
import com.aelitis.azureus.core.networkmanager.impl.ByteBucketST;
import com.aelitis.azureus.core.networkmanager.impl.EntityHandler;
import com.aelitis.azureus.core.networkmanager.impl.NetworkManagerUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;

public class TransferProcessor {
    private static final boolean RATE_LIMIT_LAN_TOO = false;
    private static boolean RATE_LIMIT_UP_INCLUDES_PROTOCOL = false;
    private static boolean RATE_LIMIT_DOWN_INCLUDES_PROTOCOL = false;
    public static final int TYPE_UPLOAD = 0;
    public static final int TYPE_DOWNLOAD = 1;
    private final int processor_type;
    private final LimitedRateGroup max_rate;
    private final RateHandler main_rate_handler;
    private final ByteBucket main_bucket;
    private final EntityHandler main_controller;
    private final HashMap<LimitedRateGroup, GroupData> group_buckets = new HashMap();
    private final HashMap<NetworkConnectionBase, ConnectionData> connections = new HashMap();
    private final AEMonitor connections_mon;
    private final boolean multi_threaded;

    static {
        COConfigurationManager.addAndFireParameterListeners(new String[]{"Up Rate Limits Include Protocol", "Down Rate Limits Include Protocol"}, new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                RATE_LIMIT_UP_INCLUDES_PROTOCOL = COConfigurationManager.getBooleanParameter("Up Rate Limits Include Protocol");
                RATE_LIMIT_DOWN_INCLUDES_PROTOCOL = COConfigurationManager.getBooleanParameter("Down Rate Limits Include Protocol");
            }
        });
    }

    public TransferProcessor(int _processor_type, LimitedRateGroup max_rate_limit, boolean multi_threaded) {
        this.processor_type = _processor_type;
        this.max_rate = max_rate_limit;
        this.multi_threaded = multi_threaded;
        this.connections_mon = new AEMonitor("TransferProcessor:" + this.processor_type);
        this.main_bucket = this.createBucket(this.max_rate.getRateLimitBytesPerSecond());
        this.main_rate_handler = new RateHandler(_processor_type){
            final int pt;
            {
                this.pt = n;
            }

            @Override
            public int[] getCurrentNumBytesAllowed() {
                if (TransferProcessor.this.main_bucket.getRate() != TransferProcessor.this.max_rate.getRateLimitBytesPerSecond()) {
                    TransferProcessor.this.main_bucket.setRate(TransferProcessor.this.max_rate.getRateLimitBytesPerSecond());
                }
                int special = this.pt == 0 ? (RATE_LIMIT_UP_INCLUDES_PROTOCOL ? 0 : Integer.MAX_VALUE) : (RATE_LIMIT_DOWN_INCLUDES_PROTOCOL ? 0 : Integer.MAX_VALUE);
                return new int[]{TransferProcessor.this.main_bucket.getAvailableByteCount(), special};
            }

            @Override
            public void bytesProcessed(int data_bytes, int protocol_bytes) {
                int num_bytes_written = this.pt == 0 ? (RATE_LIMIT_UP_INCLUDES_PROTOCOL ? data_bytes + protocol_bytes : data_bytes) : (RATE_LIMIT_DOWN_INCLUDES_PROTOCOL ? data_bytes + protocol_bytes : data_bytes);
                TransferProcessor.this.main_bucket.setBytesUsed(num_bytes_written);
                TransferProcessor.this.max_rate.updateBytesUsed(num_bytes_written);
            }
        };
        this.main_controller = new EntityHandler(this.processor_type, this.main_rate_handler);
    }

    public void registerPeerConnection(NetworkConnectionBase connection, boolean upload) {
        ConnectionData conn_data = new ConnectionData();
        try {
            this.connections_mon.enter();
            LimitedRateGroup[] groups = connection.getRateLimiters(upload);
            GroupData[] group_datas = new GroupData[groups.length];
            int i = 0;
            while (i < groups.length) {
                LimitedRateGroup group = groups[i];
                GroupData group_data = this.group_buckets.get(group);
                if (group_data == null) {
                    int limit = NetworkManagerUtilities.getGroupRateLimit(group);
                    group_data = new GroupData(this.createBucket(limit));
                    this.group_buckets.put(group, group_data);
                }
                GroupData groupData = group_data;
                groupData.group_size = groupData.group_size + 1;
                group_datas[i] = group_data;
                ++i;
            }
            conn_data.groups = groups;
            conn_data.group_datas = group_datas;
            conn_data.state = 0;
            this.connections.put(connection, conn_data);
        }
        finally {
            this.connections_mon.exit();
        }
        this.main_controller.registerPeerConnection(connection);
    }

    public List<NetworkConnectionBase> getConnections() {
        try {
            this.connections_mon.enter();
            ArrayList<NetworkConnectionBase> arrayList = new ArrayList<NetworkConnectionBase>(this.connections.keySet());
            return arrayList;
        }
        finally {
            this.connections_mon.exit();
        }
    }

    public boolean isRegistered(NetworkConnectionBase connection) {
        try {
            this.connections_mon.enter();
            boolean bl = this.connections.containsKey(connection);
            return bl;
        }
        finally {
            this.connections_mon.exit();
        }
    }

    public void deregisterPeerConnection(NetworkConnectionBase connection) {
        try {
            this.connections_mon.enter();
            ConnectionData conn_data = this.connections.remove(connection);
            if (conn_data != null) {
                GroupData[] group_datas = conn_data.group_datas;
                int i = 0;
                while (i < group_datas.length) {
                    GroupData group_data = group_datas[i];
                    if (group_data.group_size == 1) {
                        this.group_buckets.remove(conn_data.groups[i]);
                    } else {
                        GroupData groupData = group_data;
                        groupData.group_size = groupData.group_size - 1;
                    }
                    ++i;
                }
            }
        }
        finally {
            this.connections_mon.exit();
        }
        this.main_controller.cancelPeerConnection(connection);
    }

    public void setRateLimiterFreezeState(boolean frozen) {
        this.main_bucket.setFrozen(frozen);
    }

    public void addRateLimiter(NetworkConnectionBase connection, LimitedRateGroup group) {
        try {
            this.connections_mon.enter();
            ConnectionData conn_data = this.connections.get(connection);
            if (conn_data != null) {
                LimitedRateGroup[] groups = conn_data.groups;
                int i = 0;
                while (i < groups.length) {
                    if (groups[i] == group) {
                        return;
                    }
                    ++i;
                }
                GroupData group_data = this.group_buckets.get(group);
                if (group_data == null) {
                    int limit = NetworkManagerUtilities.getGroupRateLimit(group);
                    group_data = new GroupData(this.createBucket(limit));
                    this.group_buckets.put(group, group_data);
                }
                GroupData groupData = group_data;
                groupData.group_size = groupData.group_size + 1;
                GroupData[] group_datas = conn_data.group_datas;
                int len = groups.length;
                LimitedRateGroup[] new_groups = new LimitedRateGroup[len + 1];
                System.arraycopy(groups, 0, new_groups, 0, len);
                new_groups[len] = group;
                conn_data.groups = new_groups;
                GroupData[] new_group_datas = new GroupData[len + 1];
                System.arraycopy(group_datas, 0, new_group_datas, 0, len);
                new_group_datas[len] = group_data;
                conn_data.group_datas = new_group_datas;
            }
        }
        finally {
            this.connections_mon.exit();
        }
    }

    public void removeRateLimiter(NetworkConnectionBase connection, LimitedRateGroup group) {
        try {
            this.connections_mon.enter();
            ConnectionData conn_data = this.connections.get(connection);
            if (conn_data != null) {
                LimitedRateGroup[] groups = conn_data.groups;
                GroupData[] group_datas = conn_data.group_datas;
                int len = groups.length;
                if (len == 0) {
                    return;
                }
                LimitedRateGroup[] new_groups = new LimitedRateGroup[len - 1];
                GroupData[] new_group_datas = new GroupData[len - 1];
                int pos = 0;
                int i = 0;
                while (i < groups.length) {
                    if (groups[i] == group) {
                        GroupData group_data = conn_data.group_datas[i];
                        if (group_data.group_size == 1) {
                            this.group_buckets.remove(conn_data.groups[i]);
                        } else {
                            GroupData groupData = group_data;
                            groupData.group_size = groupData.group_size - 1;
                        }
                    } else {
                        if (pos == new_groups.length) {
                            return;
                        }
                        new_groups[pos] = groups[i];
                        new_group_datas[pos] = group_datas[i];
                        ++pos;
                    }
                    ++i;
                }
                conn_data.groups = new_groups;
                conn_data.group_datas = new_group_datas;
            }
        }
        finally {
            this.connections_mon.exit();
        }
    }

    public void upgradePeerConnection(final NetworkConnectionBase connection, int partition_id) {
        ConnectionData connection_data = null;
        try {
            this.connections_mon.enter();
            connection_data = this.connections.get(connection);
        }
        finally {
            this.connections_mon.exit();
        }
        if (connection_data != null && connection_data.state == 0) {
            final ConnectionData conn_data = connection_data;
            this.main_controller.upgradePeerConnection(connection, new RateHandler(){
                final int pt;
                {
                    this.pt = TransferProcessor.this.processor_type;
                }

                @Override
                public int[] getCurrentNumBytesAllowed() {
                    int allowed;
                    int special;
                    block13: {
                        special = this.pt == 0 ? (RATE_LIMIT_UP_INCLUDES_PROTOCOL ? 0 : Integer.MAX_VALUE) : (RATE_LIMIT_DOWN_INCLUDES_PROTOCOL ? 0 : Integer.MAX_VALUE);
                        if (TransferProcessor.this.main_bucket.getRate() != TransferProcessor.this.max_rate.getRateLimitBytesPerSecond()) {
                            TransferProcessor.this.main_bucket.setRate(TransferProcessor.this.max_rate.getRateLimitBytesPerSecond());
                        }
                        allowed = TransferProcessor.this.main_bucket.getAvailableByteCount();
                        if ((allowed -= connection.getMssSize()) < 0) {
                            allowed = 0;
                        }
                        if (!connection.isLANLocal() || !NetworkManager.isLANRateEnabled()) {
                            GroupData[] group_datas;
                            LimitedRateGroup[] groups = conn_data.groups;
                            if (groups.length != (group_datas = conn_data.group_datas).length) {
                                try {
                                    TransferProcessor.this.connections_mon.enter();
                                    groups = conn_data.groups;
                                    group_datas = conn_data.group_datas;
                                }
                                finally {
                                    TransferProcessor.this.connections_mon.exit();
                                }
                            }
                            try {
                                int i = 0;
                                while (i < group_datas.length) {
                                    int group_allowed;
                                    int group_rate = NetworkManagerUtilities.getGroupRateLimit(groups[i]);
                                    ByteBucket group_bucket = group_datas[i].bucket;
                                    if (group_bucket.getRate() != group_rate) {
                                        group_bucket.setRate(group_rate);
                                    }
                                    if ((group_allowed = group_bucket.getAvailableByteCount()) < allowed) {
                                        allowed = group_allowed;
                                    }
                                    ++i;
                                }
                            }
                            catch (Throwable e) {
                                if (e instanceof IndexOutOfBoundsException) break block13;
                                Debug.printStackTrace(e);
                            }
                        }
                    }
                    return new int[]{allowed, special};
                }

                @Override
                public void bytesProcessed(int data_bytes, int protocol_bytes) {
                    int num_bytes_written;
                    if (this.pt == 0) {
                        num_bytes_written = RATE_LIMIT_UP_INCLUDES_PROTOCOL ? data_bytes + protocol_bytes : data_bytes;
                    } else {
                        int n = num_bytes_written = RATE_LIMIT_DOWN_INCLUDES_PROTOCOL ? data_bytes + protocol_bytes : data_bytes;
                    }
                    if (!connection.isLANLocal() || !NetworkManager.isLANRateEnabled()) {
                        GroupData[] group_datas;
                        LimitedRateGroup[] groups = conn_data.groups;
                        if (groups.length != (group_datas = conn_data.group_datas).length) {
                            try {
                                TransferProcessor.this.connections_mon.enter();
                                groups = conn_data.groups;
                                group_datas = conn_data.group_datas;
                            }
                            finally {
                                TransferProcessor.this.connections_mon.exit();
                            }
                        }
                        int i = 0;
                        while (i < group_datas.length) {
                            group_datas[i].bucket.setBytesUsed(num_bytes_written);
                            groups[i].updateBytesUsed(num_bytes_written);
                            ++i;
                        }
                    }
                    TransferProcessor.this.main_bucket.setBytesUsed(num_bytes_written);
                }
            }, partition_id);
            conn_data.state = 1;
        }
    }

    public void downgradePeerConnection(NetworkConnectionBase connection) {
        ConnectionData conn_data = null;
        try {
            this.connections_mon.enter();
            conn_data = this.connections.get(connection);
        }
        finally {
            this.connections_mon.exit();
        }
        if (conn_data != null && conn_data.state == 1) {
            this.main_controller.downgradePeerConnection(connection);
            conn_data.state = 0;
        }
    }

    public RateHandler getRateHandler() {
        return this.main_rate_handler;
    }

    public RateHandler getRateHandler(NetworkConnectionBase connection) {
        return this.main_controller.getRateHandler(connection);
    }

    private ByteBucket createBucket(int bytes_per_sec) {
        if (this.multi_threaded) {
            return new ByteBucketMT(bytes_per_sec);
        }
        return new ByteBucketST(bytes_per_sec);
    }

    private static class ConnectionData {
        private static final int STATE_NORMAL = 0;
        private static final int STATE_UPGRADED = 1;
        private int state;
        private LimitedRateGroup[] groups;
        private GroupData[] group_datas;

        private ConnectionData() {
        }
    }

    private static class GroupData {
        private final ByteBucket bucket;
        private int group_size = 0;

        private GroupData(ByteBucket bucket) {
            this.bucket = bucket;
        }
    }
}

