/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.metasearch.impl.plugin;

import com.aelitis.azureus.core.metasearch.Result;
import com.aelitis.azureus.core.metasearch.impl.plugin.PluginEngine;
import java.util.Date;
import java.util.Map;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.plugins.utils.search.SearchResult;

public class PluginResult
extends Result {
    private static final Object NULL_OBJECT = PluginResult.class;
    private SearchResult result;
    private String search_term;
    private Map property_cache = new LightHashMap();

    protected PluginResult(PluginEngine _engine, SearchResult _result, String _search_term) {
        super(_engine);
        this.result = _result;
        this.search_term = _search_term;
    }

    @Override
    public Date getPublishedDate() {
        return (Date)this.getResultProperty(2);
    }

    @Override
    public String getCategory() {
        return this.getStringProperty(7);
    }

    @Override
    public void setCategory(String category) {
    }

    @Override
    public String getContentType() {
        String ct = this.getStringProperty(10);
        if (ct == null || ct.length() == 0) {
            ct = this.guessContentTypeFromCategory(this.getCategory());
        }
        return ct;
    }

    @Override
    public void setContentType(String contentType) {
    }

    @Override
    public String getName() {
        return this.getStringProperty(1);
    }

    @Override
    public long getSize() {
        return this.getLongProperty(3);
    }

    @Override
    public int getNbPeers() {
        return this.getIntProperty(4);
    }

    @Override
    public int getNbSeeds() {
        return this.getIntProperty(5);
    }

    @Override
    public int getNbSuperSeeds() {
        return this.getIntProperty(6);
    }

    @Override
    public int getComments() {
        return this.getIntProperty(8);
    }

    @Override
    public int getVotes() {
        return this.getIntProperty(9);
    }

    @Override
    public int getVotesDown() {
        return this.getIntProperty(19);
    }

    @Override
    public boolean isPrivate() {
        return this.getBooleanProperty(14);
    }

    @Override
    public String getDRMKey() {
        return this.getStringProperty(15);
    }

    @Override
    public String getDownloadLink() {
        return PluginResult.adjustLink(this.getStringProperty(12));
    }

    @Override
    public String getDownloadButtonLink() {
        return PluginResult.adjustLink(this.getStringProperty(16));
    }

    @Override
    public String getCDPLink() {
        return PluginResult.adjustLink(this.getStringProperty(11));
    }

    @Override
    public String getPlayLink() {
        return PluginResult.adjustLink(this.getStringProperty(13));
    }

    @Override
    public String getUID() {
        return this.getStringProperty(20);
    }

    @Override
    public String getHash() {
        byte[] hash = this.getByteArrayProperty(21);
        if (hash == null) {
            return null;
        }
        return Base32.encode(hash);
    }

    @Override
    public float getRank() {
        if (((PluginEngine)this.getEngine()).useAccuracyForRank()) {
            return this.applyRankBias(this.getAccuracy());
        }
        long l_rank = this.getLongProperty(17);
        if (this.getLongProperty(5) >= 0L && this.getLongProperty(4) >= 0L) {
            l_rank = Long.MIN_VALUE;
        }
        if (l_rank == Long.MIN_VALUE) {
            return super.getRank();
        }
        float rank = l_rank;
        if (rank > 100.0f) {
            rank = 100.0f;
        } else if (rank < 0.0f) {
            rank = 0.0f;
        }
        return this.applyRankBias(rank / 100.0f);
    }

    @Override
    public float getAccuracy() {
        long l_accuracy = this.getLongProperty(18);
        if (l_accuracy == Long.MIN_VALUE) {
            return -1.0f;
        }
        float accuracy = l_accuracy;
        if (accuracy > 100.0f) {
            accuracy = 100.0f;
        } else if (accuracy < 0.0f) {
            accuracy = 0.0f;
        }
        return accuracy / 100.0f;
    }

    @Override
    public String getSearchQuery() {
        return this.search_term;
    }

    protected int getIntProperty(int name) {
        return (int)this.getLongProperty(name);
    }

    protected long getLongProperty(int name) {
        return this.getLongProperty(name, Long.MIN_VALUE);
    }

    protected long getLongProperty(int name, long def) {
        try {
            Long l = (Long)this.getResultProperty(name);
            if (l == null) {
                return def;
            }
            return l;
        }
        catch (Throwable e) {
            Debug.out("Invalid value returned for Long property " + name);
            return def;
        }
    }

    protected boolean getBooleanProperty(int name) {
        return this.getBooleanProperty(name, false);
    }

    protected boolean getBooleanProperty(int name, boolean def) {
        try {
            Boolean b = (Boolean)this.getResultProperty(name);
            if (b == null) {
                return def;
            }
            return b;
        }
        catch (Throwable e) {
            Debug.out("Invalid value returned for Boolean property " + name);
            return def;
        }
    }

    protected String getStringProperty(int name) {
        return this.getStringProperty(name, "");
    }

    protected String getStringProperty(int name, String def) {
        try {
            String l = (String)this.getResultProperty(name);
            if (l == null) {
                return def;
            }
            return PluginResult.unescapeEntities(PluginResult.removeHTMLTags(l));
        }
        catch (Throwable e) {
            Debug.out("Invalid value returned for String property " + name);
            return def;
        }
    }

    protected byte[] getByteArrayProperty(int name) {
        try {
            return (byte[])this.getResultProperty(name);
        }
        catch (Throwable e) {
            Debug.out("Invalid value returned for byte[] property " + name);
            return null;
        }
    }

    protected synchronized Object getResultProperty(int prop) {
        Integer i_prop = new Integer(prop);
        Object res = this.property_cache.get(i_prop);
        if (res == null) {
            res = this.result.getProperty(prop);
            if (res == null) {
                res = NULL_OBJECT;
            }
            this.property_cache.put(i_prop, res);
        }
        if (res == NULL_OBJECT) {
            return null;
        }
        return res;
    }
}

