/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.diskmanager.file.impl;

import com.aelitis.azureus.core.diskmanager.file.FMFileManagerException;
import com.aelitis.azureus.core.diskmanager.file.impl.FMFileAccess;
import com.aelitis.azureus.core.diskmanager.file.impl.FMFileImpl;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SystemTime;

public class FMFileAccessPieceReorderer
implements FMFileAccess {
    private static final boolean TRACE = false;
    private static final int MIN_PIECES_REORDERABLE = 3;
    private static final byte SS_FILE = 4;
    private static final int DIRT_CLEAN = 0;
    private static final int DIRT_DIRTY = 1;
    private static final int DIRT_NEVER_WRITTEN = 2;
    private static final long DIRT_FLUSH_MILLIS = 30000L;
    private final FMFileAccess delegate;
    private final File control_dir;
    private final String control_file;
    private final int storage_type;
    private int piece_size;
    private int first_piece_length;
    private int first_piece_number;
    private int last_piece_length;
    private int num_pieces;
    private int previous_storage_type = -1;
    private long current_length;
    private int[] piece_map;
    private int[] piece_reverse_map;
    private int next_piece_index;
    private int dirt_state;
    private long dirt_time = -1L;

    protected FMFileAccessPieceReorderer(TOTorrentFile _torrent_file, File _control_dir, String _control_file, int _storage_type, FMFileAccess _delegate) throws FMFileManagerException {
        this.delegate = _delegate;
        this.control_dir = _control_dir;
        this.control_file = _control_file;
        this.storage_type = _storage_type;
        try {
            this.first_piece_number = _torrent_file.getFirstPieceNumber();
            this.num_pieces = _torrent_file.getLastPieceNumber() - this.first_piece_number + 1;
            if (this.num_pieces >= 3) {
                this.piece_size = (int)_torrent_file.getTorrent().getPieceLength();
                TOTorrent torrent = _torrent_file.getTorrent();
                long file_length = _torrent_file.getLength();
                long file_offset_in_torrent = 0L;
                TOTorrentFile[] files = torrent.getFiles();
                int i = 0;
                while (i < files.length) {
                    TOTorrentFile f = files[i];
                    if (f == _torrent_file) break;
                    file_offset_in_torrent += f.getLength();
                    ++i;
                }
                int first_piece_offset = (int)(file_offset_in_torrent % (long)this.piece_size);
                this.first_piece_length = this.piece_size - first_piece_offset;
                long file_end = file_offset_in_torrent + file_length;
                this.last_piece_length = (int)(file_end - file_end / (long)this.piece_size * (long)this.piece_size);
                if (this.last_piece_length == 0) {
                    this.last_piece_length = this.piece_size;
                }
            }
            this.dirt_state = new File(this.control_dir, this.control_file).exists() ? 0 : 2;
        }
        catch (Throwable e) {
            throw new FMFileManagerException("Piece-reorder file init fail", e);
        }
    }

    @Override
    public void aboutToOpen() throws FMFileManagerException {
        if (this.dirt_state == 2) {
            this.writeConfig();
        }
    }

    @Override
    public long getLength(RandomAccessFile raf) throws FMFileManagerException {
        if (this.num_pieces >= 3) {
            if (this.piece_map == null) {
                this.readConfig();
            }
            try {
                long physical_length;
                boolean attempt_recovery = false;
                long max_length = (long)this.first_piece_length + (long)(this.num_pieces - 2) * (long)this.piece_size + (long)this.last_piece_length;
                if (this.current_length == 0L && this.next_piece_index == 1) {
                    attempt_recovery = true;
                } else if (this.storage_type == 3 && this.previous_storage_type == 4 && this.current_length == max_length && (physical_length = raf.length()) == this.current_length) {
                    this.current_length = 0L;
                    attempt_recovery = true;
                }
                if (attempt_recovery && (physical_length = raf.length()) > this.current_length && (physical_length = Math.min(physical_length, max_length)) > this.current_length) {
                    this.current_length = physical_length;
                    int piece_count = (int)((this.current_length + (long)this.piece_size - 1L) / (long)this.piece_size) + 1;
                    if (piece_count > this.num_pieces) {
                        piece_count = this.num_pieces;
                    }
                    int i = 1;
                    while (i < piece_count) {
                        this.piece_map[i] = i;
                        this.piece_reverse_map[i] = i;
                        ++i;
                    }
                    this.next_piece_index = piece_count;
                    this.setDirty();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return this.current_length;
        }
        return this.delegate.getLength(raf);
    }

    @Override
    public void setLength(RandomAccessFile raf, long length) throws FMFileManagerException {
        if (this.num_pieces >= 3) {
            if (this.piece_map == null) {
                this.readConfig();
            }
            if (this.current_length != length) {
                this.current_length = length;
                this.setDirty();
            }
        } else {
            this.delegate.setLength(raf, length);
        }
    }

    protected long getPieceOffset(RandomAccessFile raf, int piece_number, boolean allocate_if_needed) throws FMFileManagerException {
        int index;
        if (this.piece_map == null) {
            this.readConfig();
        }
        if ((index = this.getPieceIndex(raf, piece_number, allocate_if_needed)) < 0) {
            return index;
        }
        if (index == 0) {
            return 0L;
        }
        if (index == 1) {
            return this.first_piece_length;
        }
        return (long)this.first_piece_length + (long)(index - 1) * (long)this.piece_size;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int readWritePiece(RandomAccessFile raf, DirectByteBuffer[] buffers, int piece_number, int piece_offset, boolean is_read) throws FMFileManagerException {
        v0 = str = is_read != false ? "read" : "write";
        if (piece_number >= this.num_pieces) {
            throw new FMFileManagerException("Attempt to " + str + " piece " + piece_number + ": last=" + this.num_pieces);
        }
        this_piece_size = piece_number == 0 ? this.first_piece_length : (piece_number == this.num_pieces - 1 ? this.last_piece_length : this.piece_size);
        piece_space = this_piece_size - piece_offset;
        if (piece_space <= 0) {
            throw new FMFileManagerException("Attempt to " + str + " piece " + piece_number + ", offset " + piece_offset + " - no space in piece");
        }
        rem_space = piece_space;
        limits = new int[buffers.length];
        i = 0;
        while (i < buffers.length) {
            buffer = buffers[i];
            limits[i] = buffer.limit((byte)4);
            rem = buffer.remaining((byte)4);
            if (rem > rem_space) {
                buffer.limit((byte)4, buffer.position((byte)4) + rem_space);
                rem_space = 0;
            } else {
                rem_space -= rem;
            }
            ++i;
        }
        try {
            piece_start = this.getPieceOffset(raf, piece_number, is_read == false);
            if (piece_start == -1L) {
            }
            piece_io_position = piece_start + (long)piece_offset;
            if (is_read) {
                this.delegate.read(raf, buffers, piece_io_position);
            } else {
                this.delegate.write(raf, buffers, piece_io_position);
            }
            var16_19 = piece_space - rem_space;
            return var16_19;
        }
        finally {
            i = 0;
            ** while (i < buffers.length)
        }
lbl-1000:
        // 1 sources

        {
            buffers[i].limit((byte)4, limits[i]);
            ++i;
            continue;
        }
lbl39:
        // 1 sources

        return 0;
    }

    protected void readWrite(RandomAccessFile raf, DirectByteBuffer[] buffers, long position, boolean is_read) throws FMFileManagerException {
        long total_length = 0L;
        DirectByteBuffer[] directByteBufferArray = buffers;
        int n = buffers.length;
        int n2 = 0;
        while (n2 < n) {
            DirectByteBuffer buffer = directByteBufferArray[n2];
            total_length += (long)buffer.remaining((byte)4);
            ++n2;
        }
        if (!is_read && position + total_length > this.current_length) {
            this.current_length = position + total_length;
            this.setDirty();
        }
        long current_position = position;
        while (total_length > 0L) {
            int piece_offset;
            int piece_number;
            if (current_position < (long)this.first_piece_length) {
                piece_number = 0;
                piece_offset = (int)current_position;
            } else {
                long offset = current_position - (long)this.first_piece_length;
                piece_number = (int)(offset / (long)this.piece_size) + 1;
                piece_offset = (int)(offset % (long)this.piece_size);
            }
            int count = this.readWritePiece(raf, buffers, piece_number, piece_offset, is_read);
            if (count == 0) {
                if (is_read) {
                    DirectByteBuffer[] directByteBufferArray2 = buffers;
                    int n3 = buffers.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        DirectByteBuffer buffer = directByteBufferArray2[n4];
                        ByteBuffer bb = buffer.getBuffer((byte)4);
                        int rem = bb.remaining();
                        if (rem > 0) {
                            bb.put(new byte[rem]);
                            buffer.setFlag((byte)1);
                        }
                        ++n4;
                    }
                } else {
                    throw new FMFileManagerException("partial write operation");
                }
                return;
            }
            total_length -= (long)count;
            current_position += (long)count;
        }
    }

    @Override
    public void read(RandomAccessFile raf, DirectByteBuffer[] buffers, long position) throws FMFileManagerException {
        if (this.num_pieces >= 3) {
            this.readWrite(raf, buffers, position, true);
        } else {
            this.delegate.read(raf, buffers, position);
        }
    }

    @Override
    public void write(RandomAccessFile raf, DirectByteBuffer[] buffers, long position) throws FMFileManagerException {
        if (this.num_pieces >= 3) {
            this.readWrite(raf, buffers, position, false);
        } else {
            this.delegate.write(raf, buffers, position);
        }
    }

    @Override
    public void flush() throws FMFileManagerException {
        if (this.num_pieces >= 3) {
            if (this.dirt_state != 0) {
                this.writeConfig();
            }
        } else {
            this.delegate.flush();
        }
    }

    @Override
    public boolean isPieceCompleteProcessingNeeded(int piece_number) {
        if (this.num_pieces >= 3) {
            if ((piece_number -= this.first_piece_number) >= this.next_piece_index) {
                return false;
            }
            int store_index = this.piece_map[piece_number];
            if (store_index == -1) {
                return true;
            }
            return piece_number != store_index;
        }
        return this.delegate.isPieceCompleteProcessingNeeded(piece_number);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setPieceComplete(RandomAccessFile raf, int piece_number, DirectByteBuffer piece_data) throws FMFileManagerException {
        if (this.num_pieces >= 3) {
            if ((piece_number -= this.first_piece_number) >= this.next_piece_index) {
                return;
            }
            int store_index = this.getPieceIndex(raf, piece_number, false);
            if (store_index == -1) {
                throw new FMFileManagerException("piece marked as complete but not yet allocated");
            }
            if (piece_number == store_index) {
                return;
            }
            int swap_piece_number = this.piece_reverse_map[piece_number];
            if (swap_piece_number < 1) {
                throw new FMFileManagerException("Inconsistent: failed to find piece to swap");
            }
            DirectByteBuffer temp_buffer = DirectByteBufferPool.getBuffer((byte)4, this.piece_size);
            DirectByteBuffer[] temp_buffers = new DirectByteBuffer[]{temp_buffer};
            try {
                long store_offset = (long)this.first_piece_length + (long)(store_index - 1) * (long)this.piece_size;
                long swap_offset = (long)this.first_piece_length + (long)(piece_number - 1) * (long)this.piece_size;
                this.delegate.read(raf, temp_buffers, swap_offset);
                piece_data.position((byte)4, 0);
                this.delegate.write(raf, new DirectByteBuffer[]{piece_data}, swap_offset);
                temp_buffer.position((byte)4, 0);
                this.delegate.write(raf, temp_buffers, store_offset);
                this.piece_map[piece_number] = piece_number;
                this.piece_reverse_map[piece_number] = piece_number;
                this.piece_map[swap_piece_number] = store_index;
                this.piece_reverse_map[store_index] = swap_piece_number;
                this.setDirty();
                if (piece_number != this.num_pieces - 1) return;
                long file_length = swap_offset + (long)this.last_piece_length;
                if (this.delegate.getLength(raf) <= file_length) return;
                this.delegate.setLength(raf, file_length);
                return;
            }
            finally {
                temp_buffer.returnToPool();
            }
        } else {
            this.delegate.setPieceComplete(raf, piece_number, piece_data);
        }
    }

    protected int getPieceIndex(RandomAccessFile raf, int piece_number, boolean allocate_if_needed) throws FMFileManagerException {
        int store_index = this.piece_map[piece_number];
        if (store_index == -1 && allocate_if_needed) {
            int swap_index;
            this.piece_map[piece_number] = store_index = this.next_piece_index++;
            this.piece_reverse_map[store_index] = piece_number;
            if (piece_number != store_index && (swap_index = this.piece_map[store_index]) > 0) {
                DirectByteBuffer temp_buffer = DirectByteBufferPool.getBuffer((byte)4, this.piece_size);
                DirectByteBuffer[] temp_buffers = new DirectByteBuffer[]{temp_buffer};
                try {
                    long store_offset = (long)this.first_piece_length + (long)(store_index - 1) * (long)this.piece_size;
                    long swap_offset = (long)this.first_piece_length + (long)(swap_index - 1) * (long)this.piece_size;
                    this.delegate.read(raf, temp_buffers, swap_offset);
                    temp_buffer.position((byte)4, 0);
                    this.delegate.write(raf, temp_buffers, store_offset);
                    this.piece_map[store_index] = store_index;
                    this.piece_reverse_map[store_index] = store_index;
                    this.piece_map[piece_number] = swap_index;
                    this.piece_reverse_map[swap_index] = piece_number;
                    if (store_index == this.num_pieces - 1) {
                        long file_length = store_offset + (long)this.last_piece_length;
                        if (this.delegate.getLength(raf) > file_length) {
                            this.delegate.setLength(raf, file_length);
                        }
                    }
                    store_index = swap_index;
                }
                finally {
                    temp_buffer.returnToPool();
                }
            }
            this.setDirty();
        }
        return store_index;
    }

    private void readConfig() throws FMFileManagerException {
        this.piece_map = new int[this.num_pieces];
        this.piece_reverse_map = new int[this.num_pieces];
        if (this.dirt_state == 2) {
            Arrays.fill(this.piece_map, -1);
            this.piece_map[0] = 0;
            this.piece_reverse_map[0] = 0;
            this.next_piece_index = 1;
            this.current_length = 0L;
        } else {
            Map map = FileUtil.readResilientFile(this.control_dir, this.control_file, false);
            Long l_st = (Long)map.get("st");
            if (l_st != null) {
                this.previous_storage_type = l_st.intValue();
            }
            Long l_len = (Long)map.get("len");
            Long l_next = (Long)map.get("next");
            byte[] piece_bytes = (byte[])map.get("pieces");
            if (l_len == null || l_next == null || piece_bytes == null) {
                this.configBorked("Failed to read control file " + new File(this.control_dir, this.control_file).getAbsolutePath() + ": map invalid - " + map);
                return;
            }
            this.current_length = l_len;
            this.next_piece_index = l_next.intValue();
            if (piece_bytes.length != this.num_pieces * 4) {
                this.configBorked("Failed to read control file " + new File(this.control_dir, this.control_file).getAbsolutePath() + ": piece bytes invalid");
                return;
            }
            int pos = 0;
            int i = 0;
            while (i < this.num_pieces) {
                int index;
                this.piece_map[i] = index = (piece_bytes[pos++] << 24) + ((piece_bytes[pos++] & 0xFF) << 16) + ((piece_bytes[pos++] & 0xFF) << 8) + (piece_bytes[pos++] & 0xFF);
                if (index != -1) {
                    this.piece_reverse_map[index] = i;
                }
                ++i;
            }
        }
    }

    private void configBorked(String error) throws FMFileManagerException {
        this.piece_map = new int[this.num_pieces];
        this.piece_reverse_map = new int[this.num_pieces];
        Arrays.fill(this.piece_map, -1);
        this.piece_map[0] = 0;
        this.piece_reverse_map[0] = 0;
        this.current_length = this.getFile().getLinkedFile().length();
        int piece_count = (int)((this.current_length + (long)this.piece_size - 1L) / (long)this.piece_size) + 1;
        if (piece_count > this.num_pieces) {
            piece_count = this.num_pieces;
        }
        int i = 1;
        while (i < piece_count) {
            this.piece_map[i] = i;
            this.piece_reverse_map[i] = i;
            ++i;
        }
        this.next_piece_index = piece_count;
        this.writeConfig();
        FMFileManagerException e = new FMFileManagerException(error);
        e.setRecoverable(false);
        throw e;
    }

    protected void setDirty() throws FMFileManagerException {
        if (this.dirt_state == 2) {
            Debug.out("shouldn't get here");
            this.writeConfig();
        } else {
            long now = SystemTime.getMonotonousTime();
            if (this.dirt_state == 0) {
                this.dirt_state = 1;
                this.dirt_time = now;
            } else if (this.dirt_time >= 0L && now - this.dirt_time >= 30000L) {
                this.writeConfig();
            }
        }
    }

    private static Map encodeConfig(int storage_type, long current_length, long next_piece_index, int[] piece_map) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("st", new Long(storage_type));
        map.put("len", new Long(current_length));
        map.put("next", new Long(next_piece_index));
        byte[] pieces_bytes = new byte[piece_map.length * 4];
        int pos = 0;
        int i = 0;
        while (i < piece_map.length) {
            int value = piece_map[i];
            if (value == -1) {
                int n = pos++;
                int n2 = pos++;
                int n3 = pos++;
                pieces_bytes[pos++] = -1;
                pieces_bytes[n3] = -1;
                pieces_bytes[n2] = -1;
                pieces_bytes[n] = -1;
            } else {
                pieces_bytes[pos++] = (byte)(value >> 24);
                pieces_bytes[pos++] = (byte)(value >> 16);
                pieces_bytes[pos++] = (byte)(value >> 8);
                pieces_bytes[pos++] = (byte)value;
            }
            ++i;
        }
        map.put("pieces", pieces_bytes);
        return map;
    }

    protected static void recoverConfig(TOTorrentFile torrent_file, File data_file, File config_file, int storage_type) throws FMFileManagerException {
        int first_piece_number = torrent_file.getFirstPieceNumber();
        int num_pieces = torrent_file.getLastPieceNumber() - first_piece_number + 1;
        int piece_size = (int)torrent_file.getTorrent().getPieceLength();
        int[] piece_map = new int[num_pieces];
        Arrays.fill(piece_map, -1);
        piece_map[0] = 0;
        long current_length = data_file.length();
        int piece_count = (int)((current_length + (long)piece_size - 1L) / (long)piece_size) + 1;
        if (piece_count > num_pieces) {
            piece_count = num_pieces;
        }
        int i = 1;
        while (i < piece_count) {
            piece_map[i] = i;
            ++i;
        }
        int next_piece_index = piece_count;
        Map map = FMFileAccessPieceReorderer.encodeConfig(storage_type, current_length, next_piece_index, piece_map);
        File control_dir = config_file.getParentFile();
        if (!control_dir.exists()) {
            control_dir.mkdirs();
        }
        if (!FileUtil.writeResilientFileWithResult(control_dir, config_file.getName(), map)) {
            throw new FMFileManagerException("Failed to write control file " + config_file.getAbsolutePath());
        }
    }

    private void writeConfig() throws FMFileManagerException {
        if (this.piece_map == null) {
            this.readConfig();
        }
        Map map = FMFileAccessPieceReorderer.encodeConfig(this.storage_type, this.current_length, this.next_piece_index, this.piece_map);
        if (!this.control_dir.exists()) {
            this.control_dir.mkdirs();
        }
        if (!FileUtil.writeResilientFileWithResult(this.control_dir, this.control_file, map)) {
            throw new FMFileManagerException("Failed to write control file " + new File(this.control_dir, this.control_file).getAbsolutePath());
        }
        this.dirt_state = 0;
        this.dirt_time = -1L;
    }

    @Override
    public FMFileImpl getFile() {
        return this.delegate.getFile();
    }

    @Override
    public String getString() {
        return "reorderer";
    }
}

