/*
 * Decompiled with CFR 0.152.
 */
package org.pf.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.pf.file.FileUtil;
import org.pf.text.StringUtil;

public class FileLocator {
    private static final boolean DEBUG = false;
    private static final String FILE_PROTOCOL_INDICATOR = "file:" + File.separator;
    private static final String ARCHIVE_INDICATOR = "!" + File.separator;
    private FileLocator parent = null;
    private File file = null;
    private ZipFile zipFile = null;
    private boolean exists = true;
    private Exception exception = null;

    protected FileLocator getParent() {
        return this.parent;
    }

    protected void setParent(FileLocator newValue) {
        this.parent = newValue;
    }

    protected File getFile() {
        return this.file;
    }

    protected void setFile(File newValue) {
        this.file = newValue;
    }

    protected ZipFile getZipFile() {
        return this.zipFile;
    }

    protected void setZipFile(ZipFile newValue) {
        this.zipFile = newValue;
    }

    protected boolean getExists() {
        return this.exists;
    }

    protected void setExists(boolean newValue) {
        this.exists = newValue;
    }

    protected Exception getException() {
        return this.exception;
    }

    protected void setException(Exception newValue) {
        this.exception = newValue;
    }

    public static FileLocator create(File file) {
        FileLocator locator = new FileLocator();
        return locator.createFrom(file);
    }

    public static FileLocator create(String filename) {
        return FileLocator.create(new File(filename));
    }

    private static FileLocator newWith(FileLocator aParent, String[] pathElements) throws Exception {
        FileLocator locator = new FileLocator();
        return locator.createFrom(aParent, pathElements);
    }

    private FileLocator() {
    }

    public File realFile() {
        File aFile;
        try {
            aFile = this.fileRef();
        }
        catch (Exception e) {
            aFile = null;
        }
        return aFile;
    }

    public boolean exists() {
        return this.getExists();
    }

    public boolean isFile() {
        try {
            if (this.exists()) {
                return this.isFileElement(this.getFile());
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isDirectory() {
        try {
            if (this.exists()) {
                return !this.isFileElement(this.getFile());
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public long size() {
        try {
            if (this.isInArchive()) {
                ZipEntry entry = this.archiveEntry();
                return entry.getSize();
            }
            return this.getFile().length();
        }
        catch (Exception ex) {
            return 0L;
        }
    }

    public long lastModified() {
        try {
            if (this.isInArchive()) {
                ZipEntry entry = this.archiveEntry();
                return entry.getTime();
            }
            return this.getFile().lastModified();
        }
        catch (Exception ex) {
            return 0L;
        }
    }

    public InputStream getInputStream() throws Exception {
        if (this.isInArchive()) {
            ZipEntry entry = this.archiveEntry();
            return this.container().getInputStream(entry);
        }
        return new FileInputStream(this.getFile());
    }

    public boolean isInArchive() {
        return this.getParent() != null;
    }

    public String getPath() {
        return this.fullFilePath(false).getPath();
    }

    public String getAbsolutePath() {
        return this.fullFilePath(true).getPath();
    }

    public String getStandardizedPath() {
        return this.fileUtil().standardize(this.getPath());
    }

    public String getStandardizedAbsolutePath() {
        return this.fileUtil().standardize(this.getAbsolutePath());
    }

    public Exception exception() {
        return this.getException();
    }

    public URL toURL() throws MalformedURLException {
        StringBuffer buffer = new StringBuffer(128);
        this.urlPath(buffer);
        return new URL(buffer.toString());
    }

    protected FileLocator createFrom(File filePath) {
        FileLocator locator = null;
        String[] parts = null;
        File path = filePath;
        if (path.getPath().startsWith(FILE_PROTOCOL_INDICATOR)) {
            path = this.convertFromURLSyntax(path);
        }
        parts = this.str().parts(path.getPath(), File.separator);
        try {
            locator = this.initFromPath(parts, path.getPath().startsWith(File.separator));
        }
        catch (Exception ex) {
            this.setException(ex);
            this.doesNotExist(path);
            locator = this;
        }
        return locator;
    }

    private FileLocator createFrom(FileLocator aParent, String[] pathElements) throws Exception {
        this.setParent(aParent);
        return this.initFromPath(pathElements, false);
    }

    protected FileLocator initFromPath(String[] parts, boolean startsFromRoot) throws Exception {
        FileLocator locator = this;
        File pathElement = null;
        String[] rest = null;
        boolean elementExists = false;
        if (startsFromRoot) {
            pathElement = new File(File.separator);
        }
        int i = 0;
        while (i < parts.length) {
            elementExists = this.doesElementExist(pathElement = pathElement == null ? new File(parts[i]) : new File(pathElement, parts[i]));
            if (elementExists) {
                this.setFile(pathElement);
                if (this.isFileElement(pathElement)) {
                    if (i >= parts.length - 1) break;
                    rest = this.str().copyFrom(parts, i + 1);
                    locator = FileLocator.newWith(this, rest);
                    break;
                }
            } else if (this.isInArchive()) {
                if (i >= parts.length - 1) {
                    throw new Exception("\"" + pathElement.getPath() + "\" does not exist");
                }
            } else {
                throw new Exception("\"" + pathElement.getPath() + "\" does not exist");
            }
            ++i;
        }
        return locator;
    }

    protected boolean doesElementExist(File element) throws Exception {
        if (this.isInArchive()) {
            return this.doesElementExistInArchive(element.getPath());
        }
        return element.exists();
    }

    protected boolean isFileElement(File element) throws Exception {
        if (this.isInArchive()) {
            return this.isFileInArchive(element.getPath());
        }
        return element.isFile();
    }

    protected boolean doesElementExistInArchive(String elementName) throws Exception {
        ZipEntry entry = this.entryFromArchive(elementName);
        return entry != null;
    }

    protected boolean isFileInArchive(String elementName) throws Exception {
        ZipEntry entry = this.entryFromArchive(elementName);
        return entry != null && entry.getSize() > 0L;
    }

    protected ZipEntry entryFromArchive(String elementName) throws Exception {
        String name = this.str().replaceAll(elementName, "\\", "/");
        ZipFile archive = this.container();
        ZipEntry entry = archive.getEntry(name);
        return entry;
    }

    protected ZipEntry archiveEntry() throws Exception {
        return this.entryFromArchive(this.getFile().getPath());
    }

    protected void doesNotExist(File file) {
        this.setExists(false);
        this.setFile(file);
    }

    protected File fullFilePath(boolean absolute) {
        File full = this.isInArchive() ? new File(this.getParent().fullFilePath(absolute), this.getFile().getPath()) : (absolute ? this.getFile().getAbsoluteFile() : this.getFile());
        return full;
    }

    protected void urlPath(StringBuffer buffer) {
        if (this.isInArchive()) {
            this.getParent().urlPath(buffer);
            buffer.append(ARCHIVE_INDICATOR);
        } else {
            buffer.append(FILE_PROTOCOL_INDICATOR);
        }
        buffer.append(this.getFile().getPath());
    }

    protected File fileRef() throws Exception {
        if (this.isInArchive()) {
            ZipEntry entry = this.archiveEntry();
            InputStream archiveStream = this.container().getInputStream(entry);
            File tempFile = File.createTempFile("FLOC_", ".xtr");
            tempFile.deleteOnExit();
            FileOutputStream fileStream = new FileOutputStream(tempFile);
            this.fileUtil().copyStream(archiveStream, fileStream);
            return tempFile;
        }
        return this.getFile();
    }

    protected ZipFile archive() throws Exception {
        if (this.getZipFile() == null) {
            this.setZipFile(new ZipFile(this.fileRef()));
        }
        return this.getZipFile();
    }

    protected ZipFile container() throws Exception {
        if (this.isInArchive()) {
            return this.getParent().archive();
        }
        return null;
    }

    protected File convertFromURLSyntax(File file) {
        String newStr = file.getPath().substring(FILE_PROTOCOL_INDICATOR.length());
        newStr = this.str().replaceAll(newStr, ARCHIVE_INDICATOR, File.separator);
        return new File(newStr);
    }

    protected StringUtil str() {
        return StringUtil.current();
    }

    protected FileUtil fileUtil() {
        return FileUtil.current();
    }
}

