/*
 * Decompiled with CFR 0.152.
 */
package org.json.simple;

import java.util.Iterator;
import java.util.Map;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.json.simple.ItemList;
import org.json.simple.JSONArray;

public class JSONObject
extends LightHashMap<String, Object> {
    public JSONObject() {
    }

    public JSONObject(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public JSONObject(int initialCapacity) {
        super(initialCapacity);
    }

    public JSONObject(Map<String, Object> arg0) {
        super(arg0);
    }

    @Override
    public String toString() {
        ItemList list = new ItemList();
        for (Map.Entry entry : this.entrySet()) {
            list.add(JSONObject.toString(((String)entry.getKey()).toString(), entry.getValue()));
        }
        return "{" + list.toString() + "}";
    }

    public void toString(StringBuilder sb) {
        sb.append("{");
        Iterator iter = this.entrySet().iterator();
        boolean first = true;
        while (iter.hasNext()) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            Map.Entry entry = (Map.Entry)iter.next();
            JSONObject.toString(sb, entry.getKey().toString(), entry.getValue());
        }
        sb.append("}");
    }

    public static String toString(String key, Object value) {
        StringBuffer sb = new StringBuffer();
        sb.append("\"");
        sb.append(JSONObject.escape(key));
        sb.append("\":");
        if (value == null) {
            sb.append("null");
            return sb.toString();
        }
        if (value instanceof String) {
            sb.append("\"");
            sb.append(JSONObject.escape((String)value));
            sb.append("\"");
        } else {
            sb.append(value);
        }
        return sb.toString();
    }

    public static void toString(StringBuilder sb, String key, Object value) {
        sb.append("\"");
        JSONObject.escape(sb, key);
        sb.append("\":");
        if (value == null) {
            sb.append("null");
            return;
        }
        if (value instanceof String) {
            sb.append("\"");
            JSONObject.escape(sb, (String)value);
            sb.append("\"");
        } else if (value instanceof JSONObject) {
            ((JSONObject)value).toString(sb);
        } else if (value instanceof JSONArray) {
            ((JSONArray)value).toString(sb);
        } else {
            sb.append(String.valueOf(value));
        }
    }

    public static String escape(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\"': {
                    sb.append("\\\"");
                    break;
                }
                case '\\': {
                    sb.append("\\\\");
                    break;
                }
                case '\b': {
                    sb.append("\\b");
                    break;
                }
                case '\f': {
                    sb.append("\\f");
                    break;
                }
                case '\n': {
                    sb.append("\\n");
                    break;
                }
                case '\r': {
                    sb.append("\\r");
                    break;
                }
                case '\t': {
                    sb.append("\\t");
                    break;
                }
                case '/': {
                    sb.append("\\/");
                    break;
                }
                default: {
                    if (ch >= '\u0000' && ch <= '\u001f') {
                        String ss = Integer.toHexString(ch);
                        sb.append("\\u");
                        int k = 0;
                        while (k < 4 - ss.length()) {
                            sb.append('0');
                            ++k;
                        }
                        sb.append(ss.toUpperCase());
                        break;
                    }
                    sb.append(ch);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static void escape(StringBuilder sb, String s) {
        if (s == null) {
            sb.append((String)null);
        } else {
            int i = 0;
            while (i < s.length()) {
                char ch = s.charAt(i);
                switch (ch) {
                    case '\"': {
                        sb.append("\\\"");
                        break;
                    }
                    case '\\': {
                        sb.append("\\\\");
                        break;
                    }
                    case '\b': {
                        sb.append("\\b");
                        break;
                    }
                    case '\f': {
                        sb.append("\\f");
                        break;
                    }
                    case '\n': {
                        sb.append("\\n");
                        break;
                    }
                    case '\r': {
                        sb.append("\\r");
                        break;
                    }
                    case '\t': {
                        sb.append("\\t");
                        break;
                    }
                    case '/': {
                        sb.append("\\/");
                        break;
                    }
                    default: {
                        if (ch >= '\u0000' && ch <= '\u001f') {
                            String ss = Integer.toHexString(ch);
                            sb.append("\\u");
                            int k = 0;
                            while (k < 4 - ss.length()) {
                                sb.append('0');
                                ++k;
                            }
                            sb.append(ss.toUpperCase());
                            break;
                        }
                        sb.append(ch);
                    }
                }
                ++i;
            }
        }
    }
}

