/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.platform.macosx.access.cocoa;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.platform.macosx.NativeInvocationBridge;

public final class CocoaJavaBridge
extends NativeInvocationBridge {
    protected static final String CLASS_PATH = "/system/library/java";
    private static final String REVEAL_SCRIPT_FORMAT = "tell application \"System Events\"\ntell application \"{0}\"\nactivate\nreveal (posix file \"{1}\" as alias)\nend tell\nend tell";
    private static final String DEL_SCRIPT_FORMAT = "tell application \"Finder\" to move (posix file \"{0}\" as alias) to the trash";
    private int mainPool;
    protected AEMonitor classMon = new AEMonitor("CocoaJavaBridge:C");
    private AEMonitor scriptMon = new AEMonitor("CocoaJavaBridge:S");
    protected boolean isDisposed = false;
    protected RunnableDispatcher scriptDispatcher;
    private Class claNSAppleEventDescriptor;
    private Class<?> claNSAutoreleasePool;
    private Method methPush;
    private Method methPop;
    private Method methNSAppleEventDescriptor_descriptorWithBoolean;
    private Class<?> claNSAppleScript;
    private Class<?> claNSMutableDictionary;
    private Method methNSAppleScript_execute;
    private String NSAppleScript_AppleScriptErrorMessage;
    private Method methNSMutableDictionary_objectForKey;

    public CocoaJavaBridge() throws Throwable {
        try {
            this.classMon.enter();
            this.claNSMutableDictionary = Class.forName("com.apple.cocoa.foundation.NSMutableDictionary");
            this.methNSMutableDictionary_objectForKey = this.claNSMutableDictionary.getMethod("objectForKey", Object.class);
            this.claNSAppleEventDescriptor = Class.forName("com.apple.cocoa.foundation.NSAppleEventDescriptor");
            this.methNSAppleEventDescriptor_descriptorWithBoolean = this.claNSAppleEventDescriptor.getMethod("descriptorWithBoolean", Boolean.TYPE);
            this.claNSAutoreleasePool = Class.forName("com.apple.cocoa.foundation.NSAutoreleasePool");
            this.methPush = this.claNSAutoreleasePool.getMethod("push", new Class[0]);
            this.methPop = this.claNSAutoreleasePool.getMethod("pop", Integer.TYPE);
            this.claNSAppleScript = Class.forName("com.apple.cocoa.foundation.NSAppleScript");
            this.methNSAppleScript_execute = this.claNSAppleScript.getMethod("execute", this.claNSMutableDictionary);
            this.NSAppleScript_AppleScriptErrorMessage = (String)this.claNSAppleScript.getField("AppleScriptErrorMessage").get(null);
            this.mainPool = this.NSAutoreleasePool_push();
            this.scriptDispatcher = new RunnableDispatcher();
        }
        finally {
            this.classMon.exit();
        }
    }

    private int NSAutoreleasePool_push() throws Throwable {
        return ((Number)this.methPush.invoke(null, new Object[0])).intValue();
    }

    private void NSAutoreleasePool_pop(int i) throws Throwable {
        this.methPop.invoke(null, i);
    }

    private Object new_NSAppleScript(String s) throws Throwable {
        return this.claNSAppleScript.getConstructor(String.class).newInstance(s);
    }

    private Object NSAppleScript_execute(Object NSAppleScript, Object NSMutableDictionary) throws Throwable {
        return this.methNSAppleScript_execute.invoke(NSAppleScript, NSMutableDictionary);
    }

    private Object new_NSMutableDictionary() throws Throwable {
        return this.claNSMutableDictionary.newInstance();
    }

    private Object NSMutableDictionary_objectForKey(Object NSMutableDictionary, String s) throws Throwable {
        return this.methNSMutableDictionary_objectForKey.invoke(NSMutableDictionary, s);
    }

    @Override
    protected boolean performRecoverableFileDelete(File path) {
        Object result;
        if (!path.exists()) {
            return false;
        }
        try {
            result = this.executeScriptWithAsync(DEL_SCRIPT_FORMAT, new Object[]{path.getAbsolutePath()});
        }
        catch (Throwable t) {
            Debug.out(t);
            return false;
        }
        if (result != null) {
            int sleep = 25;
            int sleep_to_go = 2500;
            while (path.exists()) {
                if (sleep_to_go <= 0) break;
                try {
                    Thread.sleep(25L);
                    sleep_to_go -= 25;
                }
                catch (Throwable e) {
                    break;
                }
            }
            if (path.exists()) {
                Debug.outNoStack("Gave up waiting for delete to complete for " + path);
            }
        }
        return result != null;
    }

    @Override
    protected boolean showInFinder(File path, String fileBrowserApp) {
        if (!path.exists()) {
            return false;
        }
        Object result = null;
        try {
            int pool = this.NSAutoreleasePool_push();
            try {
                result = this.executeScriptWithAsync(REVEAL_SCRIPT_FORMAT, new Object[]{fileBrowserApp, path.getAbsolutePath()});
            }
            finally {
                this.NSAutoreleasePool_pop(pool);
            }
        }
        catch (Throwable t) {
            return false;
        }
        return result != null;
    }

    @Override
    protected boolean isEnabled() {
        return this.claNSAutoreleasePool != null;
    }

    protected final Object executeScript(String scriptFormat, Object[] params) throws Throwable {
        try {
            this.scriptMon.enter();
            int pool = this.NSAutoreleasePool_push();
            long start = System.currentTimeMillis();
            String src = params == null || params.length == 0 ? scriptFormat : MessageFormat.format(scriptFormat, params);
            Debug.outNoStack("Executing: \n" + src);
            Object scp = this.new_NSAppleScript(src);
            Object result = this.NSAppleScript_execute(scp, this.new_NSMutableDictionary());
            Debug.outNoStack(MessageFormat.format("Elapsed time: {0}ms\n", new Long(System.currentTimeMillis() - start)));
            this.NSAutoreleasePool_pop(pool);
            Object object = result;
            return object;
        }
        finally {
            this.scriptMon.exit();
        }
    }

    protected final Object executeScriptWithNewThread(final String scriptFormat, final Object[] params) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        AEThread worker = new AEThread("ScriptObject", true){

            @Override
            public void runSupport() {
                try {
                    int pool = CocoaJavaBridge.this.NSAutoreleasePool_push();
                    long start = System.currentTimeMillis();
                    String src = params == null || params.length == 0 ? scriptFormat : MessageFormat.format(scriptFormat, params);
                    Debug.outNoStack("Executing: \n" + src);
                    Object errorInfo = CocoaJavaBridge.this.new_NSMutableDictionary();
                    if (CocoaJavaBridge.this.NSAppleScript_execute(CocoaJavaBridge.this.new_NSAppleScript(src), errorInfo) == null) {
                        Debug.out(String.valueOf(CocoaJavaBridge.this.NSMutableDictionary_objectForKey(errorInfo, CocoaJavaBridge.this.NSAppleScript_AppleScriptErrorMessage)));
                    }
                    Debug.outNoStack(MessageFormat.format("Elapsed time: {0}ms\n", new Long(System.currentTimeMillis() - start)));
                    CocoaJavaBridge.this.NSAutoreleasePool_pop(pool);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        };
        worker.setPriority(4);
        worker.start();
        return this.methNSAppleEventDescriptor_descriptorWithBoolean.invoke(null, true);
    }

    protected final Object executeScriptWithAsync(final String scriptFormat, final Object[] params) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        final AERunnable worker = new AERunnable(){

            @Override
            public void runSupport() {
                try {
                    int pool = CocoaJavaBridge.this.NSAutoreleasePool_push();
                    long start = System.currentTimeMillis();
                    String src = params == null || params.length == 0 ? scriptFormat : MessageFormat.format(scriptFormat, params);
                    Debug.outNoStack("Executing: \n" + src);
                    Object errorInfo = CocoaJavaBridge.this.new_NSMutableDictionary();
                    if (CocoaJavaBridge.this.NSAppleScript_execute(CocoaJavaBridge.this.new_NSAppleScript(src), errorInfo) == null) {
                        Debug.out(String.valueOf(CocoaJavaBridge.this.NSMutableDictionary_objectForKey(errorInfo, CocoaJavaBridge.this.NSAppleScript_AppleScriptErrorMessage)));
                    }
                    Debug.outNoStack(MessageFormat.format("Elapsed time: {0}ms\n", new Long(System.currentTimeMillis() - start)));
                    CocoaJavaBridge.this.NSAutoreleasePool_pop(pool);
                }
                catch (Throwable t) {
                    Debug.out(t);
                }
            }
        };
        AEThread t = new AEThread("ScriptObject", true){

            @Override
            public void runSupport() {
                CocoaJavaBridge.this.scriptDispatcher.exec(worker);
            }
        };
        t.setPriority(4);
        t.start();
        return this.methNSAppleEventDescriptor_descriptorWithBoolean.invoke(null, true);
    }

    private void logWarning(String message) {
        try {
            this.classMon.enter();
            Logger.log(new LogAlert(false, 1, message));
        }
        finally {
            this.classMon.exit();
        }
    }

    @Override
    protected void dispose() {
        block5: {
            try {
                this.classMon.enter();
                if (this.isDisposed) break block5;
                Debug.outNoStack("Disposing Native PlatformManager...");
                try {
                    this.NSAutoreleasePool_pop(this.mainPool);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.isDisposed = true;
                Debug.outNoStack("Done");
            }
            finally {
                this.classMon.exit();
            }
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    private static class RunnableDispatcher {
        private RunnableDispatcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void exec(Runnable runnable) {
            RunnableDispatcher runnableDispatcher = this;
            synchronized (runnableDispatcher) {
                runnable.run();
            }
        }
    }
}

