/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.ConcurrentHasherRequest;
import org.gudy.azureus2.core3.util.ConcurrentHasherRequestListener;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SHA1Hasher;
import org.gudy.azureus2.core3.util.ThreadPool;

public class ConcurrentHasher {
    protected static ConcurrentHasher singleton = new ConcurrentHasher();
    protected int processor_num;
    protected List<ConcurrentHasherRequest> requests = new LinkedList<ConcurrentHasherRequest>();
    protected List<SHA1Hasher> hashers = new ArrayList<SHA1Hasher>();
    protected AESemaphore request_sem = new AESemaphore("ConcHashReqQ");
    protected AESemaphore scheduler_sem = new AESemaphore("ConcHashSched");
    protected AEMonitor requests_mon = new AEMonitor("ConcurrentHasher:R");
    private static boolean friendly_hashing = COConfigurationManager.getBooleanParameter("diskmanager.friendly.hashchecking");

    static {
        COConfigurationManager.addParameterListener("diskmanager.friendly.hashchecking", new ParameterListener(){

            @Override
            public void parameterChanged(String str) {
                friendly_hashing = COConfigurationManager.getBooleanParameter("diskmanager.friendly.hashchecking");
            }
        });
    }

    public static ConcurrentHasher getSingleton() {
        return singleton;
    }

    public static boolean concurrentHashingAvailable() {
        return ConcurrentHasher.getSingleton().processor_num > 1;
    }

    protected ConcurrentHasher() {
        this.processor_num = Runtime.getRuntime().availableProcessors();
        if (this.processor_num <= 0) {
            this.processor_num = 1;
        }
        int i = 0;
        while (i < this.processor_num + 1) {
            this.scheduler_sem.release();
            ++i;
        }
        final ThreadPool pool = new ThreadPool("ConcurrentHasher", 64);
        new AEThread2("ConcurrentHasher:scheduler", true){

            @Override
            public void run() {
                while (true) {
                    SHA1Hasher hasher;
                    ConcurrentHasherRequest req;
                    ConcurrentHasher.this.request_sem.reserve();
                    try {
                        ConcurrentHasher.this.requests_mon.enter();
                        req = ConcurrentHasher.this.requests.remove(0);
                        hasher = ConcurrentHasher.this.hashers.size() == 0 ? new SHA1Hasher() : ConcurrentHasher.this.hashers.remove(ConcurrentHasher.this.hashers.size() - 1);
                    }
                    finally {
                        ConcurrentHasher.this.requests_mon.exit();
                    }
                    pool.run(new AERunnable(){

                        @Override
                        public void runSupport() {
                            try {
                                req.run(hasher);
                            }
                            finally {
                                try {
                                    (this).ConcurrentHasher.this.requests_mon.enter();
                                    (this).ConcurrentHasher.this.hashers.add(hasher);
                                }
                                finally {
                                    (this).ConcurrentHasher.this.requests_mon.exit();
                                }
                                if (friendly_hashing && req.isLowPriority()) {
                                    try {
                                        int size = req.getSize();
                                        int max = 250;
                                        int min = 50;
                                        size /= 1024;
                                        size /= 8;
                                        size = Math.min(size, 250);
                                        size = Math.max(size, 50);
                                        Thread.sleep(size);
                                    }
                                    catch (Throwable e) {
                                        Debug.printStackTrace(e);
                                    }
                                }
                                (this).ConcurrentHasher.this.scheduler_sem.release();
                            }
                        }
                    });
                }
            }
        }.start();
    }

    public ConcurrentHasherRequest addRequest(ByteBuffer buffer) {
        return this.addRequest(buffer, null, false);
    }

    public ConcurrentHasherRequest addRequest(ByteBuffer buffer, ConcurrentHasherRequestListener listener, boolean low_priorty) {
        ConcurrentHasherRequest req = new ConcurrentHasherRequest(this, buffer, listener, low_priorty);
        this.scheduler_sem.reserve();
        try {
            this.requests_mon.enter();
            this.requests.add(req);
        }
        finally {
            this.requests_mon.exit();
        }
        this.request_sem.release();
        return req;
    }

    public static void main(String[] args) {
    }
}

