/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.ipfilter.impl;

import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.ipfilter.IpRange;
import org.gudy.azureus2.core3.ipfilter.impl.IpFilterImpl;
import org.gudy.azureus2.core3.ipfilter.impl.IpRangeImpl;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderAdapter;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderFactoryImpl;

public class IpFilterAutoLoaderImpl {
    private static final LogIDs LOGID = LogIDs.CORE;
    public static final String CFG_AUTOLOAD_LAST = "Ip Filter Autoload Last Date";
    public static final String CFG_AUTOLOAD_FILE = "Ip Filter Autoload File";
    private static AEMonitor class_mon = new AEMonitor("IpFilterAutoLoaderImpl:class");
    private Object timerEventFilterReload;
    private final IpFilterImpl ipFilter;

    public IpFilterAutoLoaderImpl(IpFilterImpl ipFilter) {
        this.ipFilter = ipFilter;
        COConfigurationManager.setLongDefault(CFG_AUTOLOAD_LAST, 0L);
        COConfigurationManager.setStringDefault(CFG_AUTOLOAD_FILE, "");
    }

    /*
     * Unable to fully structure code
     */
    private void loadDATFilters(InputStream fin) {
        block46: {
            try {
                block45: {
                    IpFilterAutoLoaderImpl.class_mon.enter();
                    new_ipRanges = new ArrayList<IpRangeImpl>(1024);
                    streamReader = null;
                    reader = null;
                    try {
                        try {
                            pattern = Pattern.compile("^(.*):([0-9\\.]+)[^0-9]+([0-9\\.]+).*");
                            parseMode = -1;
                            streamReader = new InputStreamReader(fin, "utf8");
                            reader = new BufferedReader(streamReader);
                            numConsecutiveUnknowns = 0;
                            while (numConsecutiveUnknowns < 1000) {
                                line = reader.readLine();
                                if (line == null) break block45;
                                if ((line = line.trim()).startsWith("#") || line.length() == 0) continue;
                                description = "";
                                startIp = null;
                                endIp = null;
                                level = 0;
                                if (parseMode <= 0 || parseMode == 1) {
                                    matcher = pattern.matcher(line);
                                    if (matcher.find()) {
                                        if (parseMode != 1) {
                                            parseMode = 1;
                                        }
                                        description = matcher.group(1);
                                        startIp = matcher.group(2);
                                        endIp = matcher.group(3);
                                    } else {
                                        Logger.log(new LogEvent(IpFilterAutoLoaderImpl.LOGID, 1, "unrecognized line while reading ip filter: " + line));
                                    }
                                }
                                if (parseMode != 1) {
                                    if (parseMode != 2) {
                                        parseMode = 2;
                                    }
                                    if ((sections = line.split(" *[-,] *", 4)).length >= 2 && (sections[0].indexOf(46) < 0 || sections[1].indexOf(46) < 0 || sections[0].length() > 15 || sections[1].length() > 15 || sections[0].length() < 7 || sections[1].length() < 7)) {
                                        ++numConsecutiveUnknowns;
                                        continue;
                                    }
                                    if (sections.length >= 4) {
                                        startIp = sections[0];
                                        endIp = sections[1];
                                        description = sections[3];
                                        try {
                                            level = Integer.parseInt(sections[2]);
                                        }
                                        catch (NumberFormatException e) {
                                            description = String.valueOf(sections[2]) + " " + description;
                                        }
                                        i = 4;
                                        while (i < sections.length) {
                                            description = String.valueOf(description) + " " + sections[i];
                                            ++i;
                                        }
                                        numConsecutiveUnknowns = 0;
                                    } else if (sections.length == 3) {
                                        startIp = sections[0];
                                        endIp = sections[1];
                                        description = sections[2];
                                        numConsecutiveUnknowns = 0;
                                    } else if (sections.length == 2) {
                                        startIp = sections[0];
                                        endIp = sections[1];
                                        numConsecutiveUnknowns = 0;
                                    } else {
                                        ++numConsecutiveUnknowns;
                                        continue;
                                    }
                                    if (level >= 128) continue;
                                }
                                if (startIp == null || endIp == null) continue;
                                ipRange = new IpRangeImpl(description, startIp, endIp, true);
                                ipRange.setAddedToRangeList(true);
                                new_ipRanges.add(ipRange);
                            }
                            break block45;
                        }
                        catch (IOException e) {
                            Debug.out(e);
                            if (reader != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable var16_17) {
                                    // empty catch block
                                }
                            }
                            if (streamReader != null) {
                                try {
                                    streamReader.close();
                                }
                                catch (Throwable var16_18) {
                                    // empty catch block
                                }
                            }
                            it = new_ipRanges.iterator();
                            ** while (it.hasNext())
                        }
                    }
                    catch (Throwable var15_26) {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable it) {
                                // empty catch block
                            }
                        }
                        if (streamReader != null) {
                            try {
                                streamReader.close();
                            }
                            catch (Throwable it) {
                                // empty catch block
                            }
                        }
                        it = new_ipRanges.iterator();
                        ** while (it.hasNext())
                    }
lbl-1000:
                    // 1 sources

                    {
                        ((IpRange)it.next()).checkValid();
                        continue;
                    }
lbl92:
                    // 1 sources

                    this.ipFilter.markAsUpToDate();
                    break block46;
lbl-1000:
                    // 1 sources

                    {
                        ((IpRange)it.next()).checkValid();
                        continue;
                    }
lbl111:
                    // 1 sources

                    this.ipFilter.markAsUpToDate();
                    throw var15_26;
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable it) {
                        // empty catch block
                    }
                }
                if (streamReader != null) {
                    try {
                        streamReader.close();
                    }
                    catch (Throwable it) {
                        // empty catch block
                    }
                }
                it = new_ipRanges.iterator();
                while (it.hasNext()) {
                    ((IpRange)it.next()).checkValid();
                }
                this.ipFilter.markAsUpToDate();
            }
            finally {
                IpFilterAutoLoaderImpl.class_mon.exit();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getP2BFileVersion(InputStream is) {
        try {
            int i = 0;
            while (i < 4) {
                int byteRead = is.read();
                if (byteRead != 255) {
                    return -1;
                }
                ++i;
            }
            byte[] MAGIC = new byte[]{80, 50, 66};
            int i2 = 0;
            while (i2 < MAGIC.length) {
                byte b = MAGIC[i2];
                if (b != is.read()) {
                    return -1;
                }
                ++i2;
            }
            int p2bVersion = is.read();
            Logger.log(new LogEvent(LOGID, "Log Filter: loading p2b version " + p2bVersion));
            return p2bVersion;
        }
        catch (IOException e) {
            Debug.out(e);
            return -1;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void loadOtherFilters(boolean allowAsyncDownloading, boolean loadOldWhileAsyncDownloading) {
        p2bVersion = -1;
        try {
            block124: {
                block121: {
                    block126: {
                        block125: {
                            block123: {
                                block122: {
                                    IpFilterAutoLoaderImpl.class_mon.enter();
                                    new_ipRanges = new ArrayList<IpRangeImpl>(1024);
                                    fin = null;
                                    bin = null;
                                    isURL = false;
                                    try {
                                        block130: {
                                            file = COConfigurationManager.getStringParameter("Ip Filter Autoload File");
                                            Logger.log(new LogEvent(IpFilterAutoLoaderImpl.LOGID, "IP Filter file: " + file));
                                            filtersFile = new File(file);
                                            if (!filtersFile.exists()) break block130;
                                            isURL = false;
                                            ** GOTO lbl-1000
                                        }
                                        if (!UrlUtils.isURL(file)) {
                                        }
                                        ** GOTO lbl-1000
                                    }
                                    catch (IOException e) {
                                        Debug.out(e);
                                        if (bin != null) {
                                            try {
                                                bin.close();
                                            }
                                            catch (Throwable it) {
                                                // empty catch block
                                            }
                                        }
                                        if (fin != null) {
                                            try {
                                                fin.close();
                                            }
                                            catch (Throwable it) {
                                                // empty catch block
                                            }
                                        }
                                        it = new_ipRanges.iterator();
                                    }
                                    while (true) {
                                        if (!it.hasNext()) {
                                            this.ipFilter.markAsUpToDate();
                                            if (isURL != false) return;
                                            this.setFileReloadTimer();
                                            return;
                                        }
                                        ((IpRange)it.next()).checkValid();
                                    }
                                    catch (Throwable var24_65) {
                                        if (bin != null) {
                                            try {
                                                bin.close();
                                            }
                                            catch (Throwable it) {
                                                // empty catch block
                                            }
                                        }
                                        if (fin != null) {
                                            try {
                                                fin.close();
                                            }
                                            catch (Throwable it) {
                                                // empty catch block
                                            }
                                        }
                                        it = new_ipRanges.iterator();
                                        break block121;
                                    }
lbl57:
                                    // 2 sources

                                    while (true) {
                                        if (bin != null) {
                                            try {
                                                bin.close();
                                            }
                                            catch (Throwable var25_11) {
                                                // empty catch block
                                            }
                                        }
                                        if (fin != null) {
                                            try {
                                                fin.close();
                                            }
                                            catch (Throwable var25_12) {
                                                // empty catch block
                                            }
                                        }
                                        it = new_ipRanges.iterator();
                                        while (it.hasNext()) {
                                            ((IpRange)it.next()).checkValid();
                                        }
                                        this.ipFilter.markAsUpToDate();
                                        if (isURL != false) return;
                                        this.setFileReloadTimer();
                                        return;
                                    }
lbl-1000:
                                    // 1 sources

                                    {
                                        block131: {
                                            isURL = true;
                                            filtersFile = FileUtil.getUserFile("ipfilter.dl");
                                            if (!filtersFile.exists()) break block131;
                                            if (allowAsyncDownloading) {
                                                Logger.log(new LogEvent(IpFilterAutoLoaderImpl.LOGID, "Downloading " + file + "  async"));
                                                this.downloadFiltersAsync(new URL(file));
                                                if (!loadOldWhileAsyncDownloading) {
                                                    ** continue;
                                                }
                                            }
                                            ** GOTO lbl-1000
                                        }
                                        Logger.log(new LogEvent(IpFilterAutoLoaderImpl.LOGID, "sync Downloading " + file));
                                        try {
                                            rd = ResourceDownloaderFactoryImpl.getSingleton().create(new URL(file));
                                            fin = rd.download();
                                            FileUtil.copyFile(fin, filtersFile);
                                            this.setNextAutoDownload(true);
                                            ** GOTO lbl-1000
                                        }
                                        catch (ResourceDownloaderException e) {
                                            if (bin != null) {
                                                try {
                                                    bin.close();
                                                }
                                                catch (Throwable it) {
                                                    // empty catch block
                                                }
                                            }
                                            if (fin != null) {
                                                try {
                                                    fin.close();
                                                }
                                                catch (Throwable it) {
                                                    // empty catch block
                                                }
                                            }
                                            it = new_ipRanges.iterator();
                                            ** while (it.hasNext())
                                        }
                                    }
lbl-1000:
                                    // 1 sources

                                    {
                                        ((IpRange)it.next()).checkValid();
                                        continue;
                                    }
lbl112:
                                    // 1 sources

                                    this.ipFilter.markAsUpToDate();
                                    if (isURL != false) return;
                                    this.setFileReloadTimer();
                                    return;
lbl-1000:
                                    // 3 sources

                                    {
                                        block132: {
                                            fin = new FileInputStream(filtersFile);
                                            bin = new BufferedInputStream(fin, 16384);
                                            headerBytes = new byte[2];
                                            bin.mark(3);
                                            bin.read(headerBytes, 0, 2);
                                            bin.reset();
                                            if (headerBytes[1] != -117 || headerBytes[0] != 31) break block132;
                                            gzip = new GZIPInputStream(bin);
                                            filtersFile = FileUtil.getUserFile("ipfilter.ext");
                                            FileUtil.copyFile((InputStream)gzip, filtersFile);
                                            fin = new FileInputStream(filtersFile);
                                            bin = new BufferedInputStream(fin, 16384);
                                            ** GOTO lbl163
                                        }
                                        if (headerBytes[0] != 80 || headerBytes[1] != 75) ** GOTO lbl163
                                        zip = new ZipInputStream(bin);
                                        zipEntry = zip.getNextEntry();
                                        while (zipEntry != null && zipEntry.getSize() < 0x100000L) {
                                            zipEntry = zip.getNextEntry();
                                        }
                                        if (zipEntry != null) ** GOTO lbl-1000
                                        if (bin == null) break block122;
                                    }
                                    try {
                                        bin.close();
                                    }
                                    catch (Throwable it) {
                                        // empty catch block
                                    }
                                }
                                if (fin != null) {
                                    try {
                                        fin.close();
                                    }
                                    catch (Throwable it) {
                                        // empty catch block
                                    }
                                }
                                it = new_ipRanges.iterator();
                                while (it.hasNext()) {
                                    ((IpRange)it.next()).checkValid();
                                }
                                this.ipFilter.markAsUpToDate();
                                if (isURL != false) return;
                                this.setFileReloadTimer();
                                return;
lbl-1000:
                                // 1 sources

                                {
                                    filtersFile = FileUtil.getUserFile("ipfilter.ext");
                                    FileUtil.copyFile((InputStream)zip, filtersFile);
                                    fin = new FileInputStream(filtersFile);
                                    bin = new BufferedInputStream(fin, 16384);
lbl163:
                                    // 3 sources

                                    bin.mark(8);
                                    p2bVersion = this.getP2BFileVersion(bin);
                                    if (p2bVersion >= 1 && p2bVersion <= 3) ** GOTO lbl-1000
                                    bin.reset();
                                    this.loadDATFilters(bin);
                                    if (bin == null) break block123;
                                }
                                try {
                                    bin.close();
                                }
                                catch (Throwable it) {
                                    // empty catch block
                                }
                            }
                            if (fin != null) {
                                try {
                                    fin.close();
                                }
                                catch (Throwable it) {
                                    // empty catch block
                                }
                            }
                            it = new_ipRanges.iterator();
                            while (it.hasNext()) {
                                ((IpRange)it.next()).checkValid();
                            }
                            this.ipFilter.markAsUpToDate();
                            if (isURL != false) return;
                            this.setFileReloadTimer();
                            return;
lbl-1000:
                            // 1 sources

                            {
                                descBytes = new byte[255];
                                ipBytes = new byte[4];
                                v0 = encoding = p2bVersion == 1 ? "ISO-8859-1" : "UTF-8";
                                if (p2bVersion == 1 || p2bVersion == 2) {
                                    while (true) {
                                        description = this.readString(bin, descBytes, encoding);
                                        read = bin.read(ipBytes);
                                        if (read >= 4) {
                                            startIp = ByteFormatter.byteArrayToInt(ipBytes);
                                            read = bin.read(ipBytes);
                                            if (read >= 4) {
                                                endIp = ByteFormatter.byteArrayToInt(ipBytes);
                                                ipRange = new IpRangeImpl(description, startIp, endIp, true);
                                                ipRange.setAddedToRangeList(true);
                                                new_ipRanges.add(ipRange);
                                                continue;
                                            }
                                        }
                                        break block124;
                                        break;
                                    }
                                }
                                read = bin.read(ipBytes);
                                if (read >= 4) ** GOTO lbl-1000
                                if (bin == null) break block125;
                            }
                            try {
                                bin.close();
                            }
                            catch (Throwable it) {
                                // empty catch block
                            }
                        }
                        if (fin != null) {
                            try {
                                fin.close();
                            }
                            catch (Throwable it) {
                                // empty catch block
                            }
                        }
                        it = new_ipRanges.iterator();
                        while (it.hasNext()) {
                            ((IpRange)it.next()).checkValid();
                        }
                        this.ipFilter.markAsUpToDate();
                        if (isURL != false) return;
                        this.setFileReloadTimer();
                        return;
lbl-1000:
                        // 1 sources

                        {
                            numDescs = ByteFormatter.byteArrayToInt(ipBytes);
                            descs = new String[numDescs];
                            i = 0;
                            while (i < numDescs) {
                                descs[i] = this.readString(bin, descBytes, encoding);
                                ++i;
                            }
                            read = bin.read(ipBytes);
                            if (read >= 4) ** GOTO lbl-1000
                            if (bin == null) break block126;
                        }
                        try {
                            bin.close();
                        }
                        catch (Throwable it) {
                            // empty catch block
                        }
                    }
                    if (fin != null) {
                        try {
                            fin.close();
                        }
                        catch (Throwable it) {
                            // empty catch block
                        }
                    }
                    it = new_ipRanges.iterator();
                    while (it.hasNext()) {
                        ((IpRange)it.next()).checkValid();
                    }
                    this.ipFilter.markAsUpToDate();
                    if (isURL != false) return;
                    this.setFileReloadTimer();
                    return;
lbl-1000:
                    // 1 sources

                    {
                        numRanges = ByteFormatter.byteArrayToInt(ipBytes);
                        i = 0;
                        while (i < numRanges) {
                            read = bin.read(ipBytes);
                            if (read >= 4) ** GOTO lbl-1000
                            if (bin == null) break block127;
                        }
                        break block124;
                    }
                    {
                        block129: {
                            block128: {
                                block127: {
                                    try {
                                        bin.close();
                                    }
                                    catch (Throwable it) {
                                        // empty catch block
                                    }
                                }
                                if (fin != null) {
                                    try {
                                        fin.close();
                                    }
                                    catch (Throwable it) {
                                        // empty catch block
                                    }
                                }
                                it = new_ipRanges.iterator();
                                while (true) {
                                    if (!it.hasNext()) {
                                        this.ipFilter.markAsUpToDate();
                                        if (isURL != false) return;
                                        this.setFileReloadTimer();
                                        return;
                                    }
                                    ((IpRange)it.next()).checkValid();
                                }
lbl-1000:
                                // 1 sources

                                {
                                    descIdx = ByteFormatter.byteArrayToInt(ipBytes);
                                    read = bin.read(ipBytes);
                                    if (read >= 4) ** GOTO lbl-1000
                                    if (bin == null) break block128;
                                }
                                try {
                                    bin.close();
                                }
                                catch (Throwable it) {
                                    // empty catch block
                                }
                            }
                            if (fin != null) {
                                try {
                                    fin.close();
                                }
                                catch (Throwable it) {
                                    // empty catch block
                                }
                            }
                            it = new_ipRanges.iterator();
                            while (true) {
                                if (!it.hasNext()) {
                                    this.ipFilter.markAsUpToDate();
                                    if (isURL != false) return;
                                    this.setFileReloadTimer();
                                    return;
                                }
                                ((IpRange)it.next()).checkValid();
                            }
lbl-1000:
                            // 1 sources

                            {
                                startIp = ByteFormatter.byteArrayToInt(ipBytes);
                                read = bin.read(ipBytes);
                                if (read >= 4) ** GOTO lbl-1000
                                if (bin == null) break block129;
                            }
                            try {
                                bin.close();
                            }
                            catch (Throwable it) {
                                // empty catch block
                            }
                        }
                        if (fin != null) {
                            try {
                                fin.close();
                            }
                            catch (Throwable it) {
                                // empty catch block
                            }
                        }
                        it = new_ipRanges.iterator();
                        while (true) {
                            if (!it.hasNext()) {
                                this.ipFilter.markAsUpToDate();
                                if (isURL != false) return;
                                this.setFileReloadTimer();
                                return;
                            }
                            ((IpRange)it.next()).checkValid();
                        }
lbl-1000:
                        // 1 sources

                        {
                            endIp = ByteFormatter.byteArrayToInt(ipBytes);
                            description = descIdx < descs.length && descIdx >= 0 ? descs[descIdx] : "";
                            ipRange = new IpRangeImpl(description, startIp, endIp, true);
                            ipRange.setAddedToRangeList(true);
                            new_ipRanges.add(ipRange);
                            ++i;
                            continue;
                            break;
                        }
                    }
                }
                while (true) {
                    if (!it.hasNext()) {
                        this.ipFilter.markAsUpToDate();
                        if (isURL != false) throw var24_65;
                        this.setFileReloadTimer();
                        throw var24_65;
                    }
                    ((IpRange)it.next()).checkValid();
                }
            }
            if (bin != null) {
                try {
                    bin.close();
                }
                catch (Throwable it) {
                    // empty catch block
                }
            }
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (Throwable it) {
                    // empty catch block
                }
            }
            it = new_ipRanges.iterator();
            while (true) {
                if (!it.hasNext()) {
                    this.ipFilter.markAsUpToDate();
                    if (isURL != false) return;
                    this.setFileReloadTimer();
                    return;
                }
                ((IpRange)it.next()).checkValid();
            }
        }
        finally {
            IpFilterAutoLoaderImpl.class_mon.exit();
        }
    }

    private void setFileReloadTimer() {
        if (this.timerEventFilterReload instanceof TimerEvent) {
            ((TimerEvent)this.timerEventFilterReload).cancel();
        } else if (this.timerEventFilterReload instanceof TimerEventPeriodic) {
            ((TimerEventPeriodic)this.timerEventFilterReload).cancel();
        }
        this.timerEventFilterReload = SimpleTimer.addPeriodicEvent("IP Filter download", 60000L, new TimerEventPerformer(){
            long lastFileModified;

            @Override
            public void perform(TimerEvent event2) {
                event2.cancel();
                String file = COConfigurationManager.getStringParameter(IpFilterAutoLoaderImpl.CFG_AUTOLOAD_FILE);
                File filtersFile = new File(file);
                if (!filtersFile.exists()) {
                    return;
                }
                long fileModified = filtersFile.lastModified();
                if (this.lastFileModified == 0L) {
                    this.lastFileModified = fileModified;
                } else if (this.lastFileModified != fileModified) {
                    try {
                        IpFilterAutoLoaderImpl.this.ipFilter.reload();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
    }

    private void downloadFiltersAsync(URL url) {
        ResourceDownloader rd = ResourceDownloaderFactoryImpl.getSingleton().create(url);
        rd.addListener(new ResourceDownloaderAdapter(){

            @Override
            public void reportPercentComplete(ResourceDownloader downloader, int percentage) {
            }

            @Override
            public boolean completed(ResourceDownloader downloader, InputStream data) {
                try {
                    IpFilterAutoLoaderImpl.this.setNextAutoDownload(true);
                    Logger.log(new LogEvent(LOGID, "downloaded..waiting"));
                    class_mon.enter();
                    Logger.log(new LogEvent(LOGID, "downloaded.. copying"));
                    try {
                        FileUtil.copyFile(data, FileUtil.getUserFile("ipfilter.dl"));
                        AEThread thread = new AEThread("reload ipfilters", true){

                            @Override
                            public void runSupport() {
                                try {
                                    UIFunctions uif = UIFunctionsManager.getUIFunctions();
                                    if (uif != null) {
                                        uif.setStatusText("Reloading Filters..");
                                    }
                                    IpFilterAutoLoaderImpl.this.ipFilter.reload(false);
                                    if (uif != null) {
                                        uif.setStatusText(null);
                                    }
                                }
                                catch (Exception e) {
                                    Debug.out(e);
                                }
                            }
                        };
                        thread.setPriority(4);
                        thread.start();
                    }
                    catch (Exception e) {
                        Debug.out(e);
                    }
                }
                finally {
                    class_mon.exit();
                }
                return true;
            }
        });
        rd.asyncDownload();
    }

    public void setNextAutoDownload(boolean updateLastDownloadedDate) {
        long lastDL;
        long now = SystemTime.getCurrentTime();
        if (updateLastDownloadedDate) {
            COConfigurationManager.setParameter(CFG_AUTOLOAD_LAST, now);
            lastDL = now;
        } else {
            lastDL = COConfigurationManager.getLongParameter(CFG_AUTOLOAD_LAST);
            if (lastDL > now) {
                lastDL = now;
                COConfigurationManager.setParameter(CFG_AUTOLOAD_LAST, now);
            }
        }
        long nextDL = lastDL + 604800000L;
        if (this.timerEventFilterReload instanceof TimerEvent) {
            ((TimerEvent)this.timerEventFilterReload).cancel();
        } else if (this.timerEventFilterReload instanceof TimerEventPeriodic) {
            ((TimerEventPeriodic)this.timerEventFilterReload).cancel();
        }
        this.timerEventFilterReload = SimpleTimer.addEvent("IP Filter download", nextDL, new TimerEventPerformer(){

            @Override
            public void perform(TimerEvent event2) {
                String file = COConfigurationManager.getStringParameter(IpFilterAutoLoaderImpl.CFG_AUTOLOAD_FILE);
                try {
                    IpFilterAutoLoaderImpl.this.downloadFiltersAsync(new URL(file));
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        });
    }

    private String readString(BufferedInputStream bin, byte[] descBytes, String encoding) {
        int pos = 0;
        try {
            int byteRead;
            while ((byteRead = bin.read()) >= 0) {
                if (pos < descBytes.length) {
                    descBytes[pos] = (byte)byteRead;
                    ++pos;
                }
                if (byteRead != 0) continue;
                break;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (pos > 1) {
            try {
                return new String(descBytes, 0, pos - 1, encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return "";
    }
}

